var EntryScapeRegistry;
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./app/registry/config/config.js":
/*!***************************************!*\
  !*** ./app/registry/config/config.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   getApplicationConfigs: () => (/* binding */ getApplicationConfigs),
/* harmony export */   getInstanceConfigs: () => (/* binding */ getInstanceConfigs)
/* harmony export */ });
/* harmony import */ var admin_config_config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! admin/config/config */ "./modules/admin/config/config.js");
/* harmony import */ var catalog_config_config__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! catalog/config/config */ "./modules/catalog/config/config.js");
/* harmony import */ var commons_config__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/config */ "./modules/commons/config.js");
/* harmony import */ var status_config_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! status/config/config */ "./modules/status/config/config.js");
/* harmony import */ var workbench_config_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! workbench/config/config */ "./modules/workbench/config/config.js");
/* harmony import */ var commons_util_ConfigStore__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/util/ConfigStore */ "./modules/commons/util/ConfigStore.js");
/* harmony import */ var search_config_config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! search/config/config */ "./modules/search/config/config.js");
/* harmony import */ var harvest_config_config__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! harvest/config/config */ "./modules/harvest/config/config.js");
/* eslint-disable max-len */



// import harvestConfig from 'harvest/config/config';

// import toolkitConfig from 'toolkit/config/config';





/**
 * Customer config - can override other configs
 */
const instanceConfigs = [window.__entryscape_config, window.__entryscape_config_dev || {}];
const applicationConfigs = [commons_config__WEBPACK_IMPORTED_MODULE_2__["default"], admin_config_config__WEBPACK_IMPORTED_MODULE_0__["default"], catalog_config_config__WEBPACK_IMPORTED_MODULE_1__["default"], workbench_config_config__WEBPACK_IMPORTED_MODULE_4__["default"],
//  harvestConfig,
status_config_config__WEBPACK_IMPORTED_MODULE_3__["default"],
//  toolkitConfig,
search_config_config__WEBPACK_IMPORTED_MODULE_6__["default"], {
  /**
   * App theme
   *
   * @type {object}
   */
  theme: {
    /**
     * App name
     *
     * @type {string}
     * @memberof theme
     */
    appName: 'Registry',
    /**
     * Toggles the module name's visibility in the header
     *
     * @type {boolean}
     * @memberof theme
     */
    showModuleNameInHeader: true,
    /**
     * The start banner consists of a header, an icon, some clarifying text,
     * and a button to view the Getting Started guide.
     *
     * @typedef {{en: string, sv: string, de: string}} TranslationObj
     * @typedef {{buttonLabel: TranslationObj, header: TranslationObj, path: string}} DetailsObj
     * @typedef {{header: TranslationObj, text: TranslationObj, icon: string, details: DetailsObj}} StartObj
     * @type {StartObj}
     * @memberof theme
     */
    startBanner: {
      header: {
        en: 'EntryScape Registry',
        sv: 'EntryScape Registry',
        de: 'EntryScape Registry'
      },
      text: {
        en: 'EntryScape Registry provides the technical foundation for data portals and offers tools to support publication processes.',
        sv: 'EntryScape Registry utgör den tekniska grunden för dataportaler och tillhandahåller verktyg för att stödja publiceringsprocesser.',
        de: 'EntryScape Registry bildet die technische Grundlage für Dataportale und stellt Werkzeuge bereit um Veröffentlichungsprozesse zu unterstützen.'
      },
      icon: '',
      details: {
        buttonLabel: {
          en: 'Get started',
          sv: 'Kom igång',
          de: 'Anfangen'
        },
        header: {
          en: 'Getting started guide',
          sv: 'Kom-igång guide',
          de: 'Erste Schritte'
        },
        path: '/theme/assets/gettingstarted'
      }
    },
    expandReportsFilter: true
  },
  registry: {
    /**
     * @typedef {{name: string, label: {en: string}}} ProfileObj
     * @type {ProfileObj[]}
     * @memberof registry
     */
    validationProfiles: [{
      name: 'dcat_ap_se',
      label: {
        en: 'Swedish DCAT-AP profile'
      }
    }, {
      name: 'dcat_ap_dk',
      label: {
        en: 'Danish DCAT-AP profile'
      }
    }],
    /**
     * @type {string[]}
     * @memberof registry
     */
    validationTypes: ['dcat:Catalog', 'dcat:Dataset', 'dcat:Distribution', 'vcard:Kind', 'vcard:Individual', 'vcard:Organization', 'foaf:Agent'],
    /**
     * @type {string[]}
     * @memberof registry
     */
    mandatoryValidationTypes: ['dcat:Catalog', 'dcat:Dataset'],
    defaultRecipe: 'dcat-recipe',
    /**
     * @type {string[]}
     * @memberof registry
     */
    recipes: [{
      id: 'dcat-recipe',
      transforms: [{
        type: 'empty'
      }, {
        type: 'check',
        args: {
          source: ''
        }
      }, {
        type: 'fetch',
        args: {
          source: {
            value: '',
            required: true,
            visible: true,
            label: {
              en: 'Harvesting source',
              sv: 'Skördningskälla',
              de: 'Harvestingquelle'
            },
            helperText: {
              en: 'Web address of the DCAT file, e.g. https://my.org/dcat.rdf',
              sv: 'Webbadress till DCAT-filen, t.ex. https://my.org/dcat.rdf',
              de: 'Webadresse der DCAT-Datei, z.B. https://my.org/dcat.rdf'
            },
            pattern: {
              value: '^https?://.+$',
              error: {
                en: 'Must be a valid URL',
                sv: 'Måste vara en giltig URL',
                de: 'Muss eine gültige Webadresse sein'
              }
            }
          }
        }
      }, {
        type: 'validate',
        args: {
          profile: 'dcat_ap_se'
        }
      }, {
        type: 'merge',
        args: {}
      }]
    }],
    /**
     * @type {boolean}
     * @memberof registry
     */
    includeLinkCheckReport: false,
    /**
     * Determines whether or which filters are visible in registry. Using a boolean
     * shows/hides all filters, while an array containing the names of the filters
     * to exclude can also be provided.
     *
     * @type {boolean|string[]}
     */
    excludeFilters: false,
    /**
     * Path to an rdf file containing the example for Toolkit's catalog. Must not start with a slash.
     * If empty defaults to the standard `toolkitExample.rdf` from static.
     */
    toolkitExamplePath: ''
  },
  catalog: {
    /**
     * @type {number}
     * @memberof catalog
     */
    catalogLimit: 1,
    /**
     * @type {number}
     * @memberof catalog
     */
    datasetLimit: 3,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    fileuploadDistribution: false,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    catalogCollaboration: false,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    excludeEmptyCatalogsInSearch: true
  },
  entitytypes: [{
    name: 'distribution',
    module: null,
    // don't restrict to 'catalog' module in registry
    overview: null // no overviews in registry (apart from orgs/pipelines)
  }, {
    name: 'dataset',
    module: null,
    overview: null
  }, {
    name: 'datasetSeries',
    module: null,
    overview: null
  }, {
    name: 'catalog',
    module: null,
    overview: null
  }, {
    name: 'contactPoint',
    module: null,
    overview: null
  }, {
    name: 'publisher',
    module: null,
    overview: null
  }, {
    name: 'datasetDocument',
    module: null,
    overview: null
  }, {
    name: 'dataService',
    module: null,
    overview: null
  }, {
    name: 'pipeline',
    label: {
      en: 'Pipeline'
    },
    rdfType: 'http://entrystore.org/terms/Pipeline',
    matchSource: 'entry',
    // default is to try matching on the metadata instead
    module: ['register'],
    overview: harvest_config_config__WEBPACK_IMPORTED_MODULE_7__.SOURCE_OVERVIEW_NAME
  }],
  contentviewers: [{
    /**
     * @type {string}
     * @memberof contentviewers
     */
    name: 'answerview',
    /**
     * @type {string}
     * @memberof contentviewers
     */
    class: 'LinkedEntriesView',
    // TODO

    /**
     * @typedef {{en: string, sv: string}} LabelObj
     * @type {LabelObj}
     * @memberof contentviewers
     */
    label: {
      en: 'Answer',
      sv: 'Answer'
    }
  }]
}];
const getInstanceConfigs = () => {
  return instanceConfigs;
};
const getApplicationConfigs = () => {
  return applicationConfigs;
};
const config = new commons_util_ConfigStore__WEBPACK_IMPORTED_MODULE_5__["default"]();
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (config);

/***/ }),

/***/ "./app/registry/config/site.js":
/*!*************************************!*\
  !*** ./app/registry/config/site.js ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var admin_config_site__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! admin/config/site */ "./modules/admin/config/site.js");
/* harmony import */ var catalog_config_site__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! catalog/config/site */ "./modules/catalog/config/site.js");
/* harmony import */ var commons_merge__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/merge */ "./modules/commons/merge.js");
/* harmony import */ var commons_auth_Signin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/auth/Signin */ "./modules/commons/auth/Signin/index.js");
/* harmony import */ var commons_auth_Signup__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/auth/Signup */ "./modules/commons/auth/Signup/index.js");
/* harmony import */ var commons_version__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/version */ "./modules/commons/version/index.js");
/* harmony import */ var harvest_config_site__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! harvest/config/site */ "./modules/harvest/config/site.js");
/* harmony import */ var commons_start__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/start */ "./modules/commons/start/index.js");
/* harmony import */ var status_config_site__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! status/config/site */ "./modules/status/config/site.js");
/* harmony import */ var toolkit_config_site__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! toolkit/config/site */ "./modules/toolkit/config/site.js");
/* harmony import */ var workbench_config_site__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! workbench/config/site */ "./modules/workbench/config/site.js");
/* harmony import */ var search_config_site__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! search/config/site */ "./modules/search/config/site.js");
/* harmony import */ var commons_Layout__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/Layout */ "./modules/commons/Layout/index.js");













const siteConfigs = (0,commons_merge__WEBPACK_IMPORTED_MODULE_2__["default"])(admin_config_site__WEBPACK_IMPORTED_MODULE_0__["default"], catalog_config_site__WEBPACK_IMPORTED_MODULE_1__["default"], workbench_config_site__WEBPACK_IMPORTED_MODULE_10__["default"], status_config_site__WEBPACK_IMPORTED_MODULE_8__["default"], toolkit_config_site__WEBPACK_IMPORTED_MODULE_9__["default"], harvest_config_site__WEBPACK_IMPORTED_MODULE_6__["default"], search_config_site__WEBPACK_IMPORTED_MODULE_11__["default"], {
  signinView: 'signin',
  permissionView: 'permission',
  startView: 'start',
  signupView: 'signup',
  sidebar: {
    wide: false,
    always: true,
    replaceTabs: true
  },
  moduleList: ['status', 'search', 'register', 'toolkit', 'admin'],
  modules: [{
    name: 'search',
    productName: {
      en: 'Browse',
      sv: 'Bläddra',
      de: 'Durchsuchen'
    },
    startView: 'catalog__search',
    title: {
      en: 'Dataset search',
      sv: 'Datamängds\u00ADsök',
      de: 'Datensatz\u00ADsuche'
    },
    sidebar: true,
    text: {
      sv: 'Sök fram och utforska de datamängder som framgångsrikt skördats',
      en: 'Search and view the datasets that have been successfully harvested',
      de: 'Suchen und anzeigen von erfolgreich geharvesteten Datensätzen'
    }
  }, {
    // @todo needed? should be imported by adminConfig
    name: 'admin',
    productName: {
      en: 'Admin',
      sv: 'Admin',
      de: 'Admin'
    },
    title: {
      en: 'Admini\u00ADstration',
      sv: 'Admini\u00ADstrera',
      de: 'Verwaltung'
    },
    faClass: 'cogs',
    startView: 'admin__users',
    sidebar: true,
    restrictTo: 'admin',
    text: {
      sv: 'Administrera projekt, användare och grupper',
      en: 'Manage projects, users and groups',
      de: 'Verwaltung von Projekten, Benutzern und Gruppen'
    }
  }],
  views: [{
    name: 'start',
    class: commons_start__WEBPACK_IMPORTED_MODULE_7__["default"],
    title: {
      en: 'Start',
      sv: 'Start',
      da: 'Start',
      de: 'Start'
    },
    route: '/start',
    public: true
  }, {
    name: 'signin',
    title: {
      en: 'Sign in',
      sv: 'Logga in',
      da: 'Login',
      de: 'Anmelden'
    },
    class: commons_auth_Signin__WEBPACK_IMPORTED_MODULE_3__["default"],
    route: '/signin',
    layout: commons_Layout__WEBPACK_IMPORTED_MODULE_12__.SINGLE_COLUMN_LAYOUT,
    public: true
  }, {
    name: 'signup',
    title: {
      en: 'Create account',
      sv: 'Skapa konto',
      de: 'Konto erstellen'
    },
    class: commons_auth_Signup__WEBPACK_IMPORTED_MODULE_4__["default"],
    route: '/signup',
    layout: commons_Layout__WEBPACK_IMPORTED_MODULE_12__.SINGLE_COLUMN_LAYOUT,
    public: true
  }, {
    name: 'version',
    title: {
      en: 'version'
    },
    class: commons_version__WEBPACK_IMPORTED_MODULE_5__["default"],
    route: '/version',
    restrictTo: 'admin'
  }]
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_merge__WEBPACK_IMPORTED_MODULE_2__["default"])(siteConfigs, __entryscape_config.site || {}));

/***/ }),

/***/ "./app/registry/defaults.js":
/*!**********************************!*\
  !*** ./app/registry/defaults.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var admin_defaults__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! admin/defaults */ "./modules/admin/defaults.js");
/* harmony import */ var catalog_defaults__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! catalog/defaults */ "./modules/catalog/defaults.js");
/* harmony import */ var commons_defaults__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/defaults */ "./modules/commons/defaults.js");
/* harmony import */ var _config_site__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./config/site */ "./app/registry/config/site.js");

 // init catalog
 // init catalog
 // TODO HACK this needs to be before '../config/site' in order for namespaces to be set in registry

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (async () => {
  await (0,commons_defaults__WEBPACK_IMPORTED_MODULE_3__["default"])(_config_site__WEBPACK_IMPORTED_MODULE_4__["default"]);
  (0,catalog_defaults__WEBPACK_IMPORTED_MODULE_2__["default"])();
  (0,admin_defaults__WEBPACK_IMPORTED_MODULE_1__["default"])();
});

/***/ }),

/***/ "./modules/admin/config/config.js":
/*!****************************************!*\
  !*** ./modules/admin/config/config.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  // TODO what do these do? add descriptions to them
  admin: {
    /**
     * @type {boolean}
     */
    showContextName: false,
    /**
     * @type {boolean}
     */
    showGroupName: false,
    /**
     * @type {boolean}
     */
    showContextTypeControl: false,
    /**
     * @type {boolean}
     */
    setGroupNameAsEntryIdOnCreate: false,
    /**
     * @type {boolean}
     */
    setContextNameAsEntryIdOnCreate: false,
    /**
     * @type {boolean}
     */
    advancedAdminVisibleForAdminGroup: true,
    /**
     * Enable the migrate entity types button.
     *
     * @type {boolean}
     */
    enableTypeStoreMigration: false,
    /**
     * Decide whether personal projects should be included when creating a new user.
     *
     * @type {boolean}
     */
    includePersonalProject: false
  }
});

/***/ }),

/***/ "./modules/admin/config/site.js":
/*!**************************************!*\
  !*** ./modules/admin/config/site.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var admin_users_UsersView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! admin/users/UsersView */ "./modules/admin/users/UsersView/index.js");
/* harmony import */ var admin_groups_GroupsView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! admin/groups/GroupsView */ "./modules/admin/groups/GroupsView/index.js");
/* harmony import */ var admin_projects_ProjectsView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! admin/projects/ProjectsView */ "./modules/admin/projects/ProjectsView/index.js");
/* harmony import */ var admin_configs_entitytypes_EntityTypeView__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! admin/configs/entitytypes/EntityTypeView */ "./modules/admin/configs/entitytypes/EntityTypeView/index.js");
/* harmony import */ var admin_configs_projecttypes_ProjectTypeView__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! admin/configs/projecttypes/ProjectTypeView */ "./modules/admin/configs/projecttypes/ProjectTypeView/index.js");
/* harmony import */ var admin_users_UserOverview__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! admin/users/UserOverview */ "./modules/admin/users/UserOverview/index.js");
/* harmony import */ var admin_groups_GroupOverview__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! admin/groups/GroupOverview */ "./modules/admin/groups/GroupOverview/index.js");
/* harmony import */ var admin_projects_ProjectOverview__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! admin/projects/ProjectOverview */ "./modules/admin/projects/ProjectOverview/index.js");
/* harmony import */ var admin_configs_projecttypes_ProjectTypeOverview__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! admin/configs/projecttypes/ProjectTypeOverview */ "./modules/admin/configs/projecttypes/ProjectTypeOverview/index.js");
/* harmony import */ var admin_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! admin/utils */ "./modules/admin/utils/index.js");










/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  modules: [{
    name: 'admin',
    productName: {
      en: 'Admin',
      sv: 'Admin',
      de: 'Admin'
    },
    faClass: 'cogs',
    restrictTo: 'admin',
    startView: 'admin__users',
    sidebar: true,
    getLayoutProps: admin_utils__WEBPACK_IMPORTED_MODULE_9__.getSecondaryNavViewsForAdmin,
    checkPermission: admin_utils__WEBPACK_IMPORTED_MODULE_9__.checkPermission
  }],
  views: [{
    name: 'admin__users',
    class: admin_users_UsersView__WEBPACK_IMPORTED_MODULE_0__["default"],
    faClass: 'user',
    title: {
      en: 'Users',
      sv: 'Användare',
      de: 'Benutzer'
    },
    route: '/admin/users',
    parent: 'admin',
    module: 'admin'
  }, {
    name: 'admin__users__user',
    class: admin_users_UserOverview__WEBPACK_IMPORTED_MODULE_5__["default"],
    title: {
      en: 'User',
      sv: 'Användare',
      de: 'Benutzer'
    },
    route: '/admin/:contextId/users/:entryId/overview',
    parent: 'admin_overview',
    matchRoute: '/admin/users',
    module: 'admin'
  }, {
    name: 'admin__groups',
    class: admin_groups_GroupsView__WEBPACK_IMPORTED_MODULE_1__["default"],
    faClass: 'users',
    title: {
      en: 'Groups',
      sv: 'Grupper',
      de: 'Gruppen'
    },
    route: '/admin/groups',
    parent: 'admin',
    module: 'admin',
    restrictTo: 'advancedAdmin'
  }, {
    name: 'admin__groups__group',
    class: admin_groups_GroupOverview__WEBPACK_IMPORTED_MODULE_6__["default"],
    title: {
      en: 'Group',
      sv: 'Grupp',
      de: 'Gruppe'
    },
    route: '/admin/:contextId/groups/:entryId/overview',
    parent: 'admin_overview',
    matchRoute: '/admin/groups',
    module: 'admin'
  }, {
    name: 'admin__projects',
    class: admin_projects_ProjectsView__WEBPACK_IMPORTED_MODULE_2__["default"],
    faClass: 'building',
    title: {
      en: 'Projects',
      sv: 'Projekt',
      de: 'Projekte'
    },
    route: '/admin/projects',
    parent: 'admin',
    module: 'admin',
    restrictTo: 'advancedAdmin'
  }, {
    name: 'admin__projects__project',
    class: admin_projects_ProjectOverview__WEBPACK_IMPORTED_MODULE_7__["default"],
    title: {
      en: 'Project',
      sv: 'Projekt',
      de: 'Projekt'
    },
    route: '/admin/:contextId/projects/:entryId/overview',
    parent: 'admin_overview',
    matchRoute: '/admin/projects',
    module: 'admin'
  }, {
    name: 'admin__entitytypes',
    class: admin_configs_entitytypes_EntityTypeView__WEBPACK_IMPORTED_MODULE_3__["default"],
    faClass: 'building',
    title: {
      en: 'Entity types',
      sv: 'Entitetstyper',
      de: 'Objekttypen'
    },
    route: '/admin/entitytypes',
    parent: 'admin',
    module: 'admin',
    restrictTo: 'advancedAdmin'
  }, {
    name: 'admin__projecttypes',
    class: admin_configs_projecttypes_ProjectTypeView__WEBPACK_IMPORTED_MODULE_4__["default"],
    faClass: 'building',
    title: {
      en: 'Project types',
      sv: 'Projekttyper',
      de: 'Projekttypen'
    },
    route: '/admin/projecttypes',
    parent: 'admin',
    module: 'admin',
    restrictTo: 'advancedAdmin',
    navbar: false
  }, {
    name: 'admin__projecttypes__projecttype',
    class: admin_configs_projecttypes_ProjectTypeOverview__WEBPACK_IMPORTED_MODULE_8__["default"],
    title: {
      en: 'Project type',
      sv: 'Projekttyp',
      de: 'Projekttyp'
    },
    route: '/admin/:contextId/projecttypes/:entryId/overview',
    matchRoute: '/admin/projecttypes',
    parent: 'admin_overview',
    module: 'admin'
  }]
});

/***/ }),

/***/ "./modules/admin/configs/editors/ConstraintEditor/ConstraintEditor.js":
/*!****************************************************************************!*\
  !*** ./modules/admin/configs/editors/ConstraintEditor/ConstraintEditor.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConstraintEditor: () => (/* binding */ ConstraintEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var _mui_icons_material_ArrowDownward__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/icons-material/ArrowDownward */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/ArrowDownward.js");
/* harmony import */ var _mui_icons_material_ArrowUpward__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/icons-material/ArrowUpward */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/ArrowUpward.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Grid/Grid.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var models_utils_ns__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! models/utils/ns */ "./modules/models/utils/ns.js");
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! admin/nls/esadType.nls */ "./modules/admin/nls/esadType.nls");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/nls/escoForms.nls */ "./modules/commons/nls/escoForms.nls");
/* harmony import */ var commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var models_utils_constraint__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! models/utils/constraint */ "./modules/models/utils/constraint.js");
/* harmony import */ var models_utils_namespaceChoices__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! models/utils/namespaceChoices */ "./modules/models/utils/namespaceChoices.js");
/* harmony import */ var _ConstraintEditor_scss__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./ConstraintEditor.scss */ "./modules/admin/configs/editors/ConstraintEditor/ConstraintEditor.scss");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");

const _excluded = ["property", "blankNodeId", "graph", "onChange", "dispatch", "size", "error", "helperText"],
  _excluded2 = ["property", "blankNodeId", "onChange", "graph", "dispatch", "size", "error", "helperText"];


function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }















const ConstraintValuesEdit = _ref => {
  let {
      property,
      blankNodeId,
      graph,
      onChange,
      dispatch,
      size,
      error,
      helperText
    } = _ref,
    fieldsProps = _objectWithoutProperties(_ref, _excluded);
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_9__.useTranslation)([(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_12___default()), (commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_13___default())]);
  const {
    addField,
    fieldGroup,
    labelId,
    removeField,
    moveField,
    updateValue
  } = (0,commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.useOrderedFieldsEdit)({
    name: fieldsProps.name,
    property: models_utils_ns__WEBPACK_IMPORTED_MODULE_10__.RDF_PROPERTY_CONSTRAINT_VALUE,
    resourceURI: blankNodeId,
    graph,
    dispatch,
    nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.URI,
    orderProperty: models_utils_ns__WEBPACK_IMPORTED_MODULE_10__.RDF_PROPERTY_ORDER
  });
  const fields = fieldGroup.getFields();
  const update = (field, value) => {
    updateValue(field, value);
    onChange();
  };
  const remove = field => {
    removeField(field);
    onChange();
  };
  return /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.Fields, _extends({
    labelId: labelId,
    addField: addField
  }, fieldsProps, {
    label: t('constraintObjectLabel')
  }), fields.map((field, index) => {
    const hasError = error || field.hasError();
    const fieldErrorText = field.hasError() && t(field.getError());
    const errorText = helperText || fieldErrorText;
    return /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.Field, {
      key: field.getId(),
      size: fields.length,
      onRemove: () => remove(field),
      onClear: () => update(field, '')
    }, /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.TextField, {
      xs: 8,
      size: size,
      onChange: _ref2 => {
        let {
          target
        } = _ref2;
        return update(field, target.value);
      },
      value: field.getValue(),
      label: "",
      error: hasError,
      helperText: hasError ? errorText : ''
    }), /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], {
      size: {
        xs: 4
      }
    }, field.getOrder() > 1 ? /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.FieldControlButton, {
      marginLeft: "0",
      tooltip: t('moveUpTooltip'),
      onClick: () => moveField(field, index, index - 1)
    }, /*#__PURE__*/React.createElement(_mui_icons_material_ArrowUpward__WEBPACK_IMPORTED_MODULE_7__["default"], null)) : null, field.getOrder() < fields.length ? /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.FieldControlButton, {
      marginLeft: "0",
      tooltip: t('moveDownTooltip'),
      onClick: () => moveField(field, index, index + 1)
    }, /*#__PURE__*/React.createElement(_mui_icons_material_ArrowDownward__WEBPACK_IMPORTED_MODULE_6__["default"], null)) : null));
  }));
};
ConstraintValuesEdit.propTypes = {
  size: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  graph: commons_util_entry__WEBPACK_IMPORTED_MODULE_5__.graphPropType,
  blankNodeId: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  dispatch: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  property: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  error: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};
const ConstraintPropertyEdit = _ref3 => {
  let {
      property,
      blankNodeId,
      onChange,
      graph,
      dispatch,
      size,
      error,
      helperText
    } = _ref3,
    fieldsProps = _objectWithoutProperties(_ref3, _excluded2);
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_9__.useTranslation)((admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_12___default()));
  const {
    fields,
    labelId,
    updateValue
  } = (0,commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.useFieldsEdit)({
    name: fieldsProps.name,
    property,
    graph,
    resourceURI: blankNodeId,
    nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.URI,
    dispatch
  });
  const [[namespaceKey, namespaceValue], setNamespace] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)((0,models_utils_namespaceChoices__WEBPACK_IMPORTED_MODULE_15__.getNamespace)(fields[0]));
  const namespaceKeyError = error && !namespaceKey;
  const namespaceValueError = error && !namespaceValue;
  const [namespaceKeyErrorText, namespaceValueErrorText] = (0,models_utils_constraint__WEBPACK_IMPORTED_MODULE_14__.getErrorTexts)(helperText, [namespaceKeyError, namespaceValueError]);
  const updateNamespaceKey = _ref4 => {
    let {
      target
    } = _ref4;
    const {
      value: newNamespaceKey
    } = target;
    setNamespace(_ref5 => {
      let [, currentNamespaceValue] = _ref5;
      return [newNamespaceKey, currentNamespaceValue];
    });
    updateValue(fields[0], (0,models_utils_namespaceChoices__WEBPACK_IMPORTED_MODULE_15__.getFullURI)(newNamespaceKey, namespaceValue));
    onChange();
  };
  const updateNamespaceValue = _ref6 => {
    let {
      target
    } = _ref6;
    const {
      value: newNamespaceValue
    } = target;
    setNamespace(_ref7 => {
      let [currentNamespaceKey] = _ref7;
      return [currentNamespaceKey, newNamespaceValue];
    });
    updateValue(fields[0], (0,models_utils_namespaceChoices__WEBPACK_IMPORTED_MODULE_15__.getFullURI)(namespaceKey, newNamespaceValue));
    onChange();
  };
  const clear = () => {
    setNamespace(['', '']);
    updateValue(fields[0], '');
    onChange();
  };
  return /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.Fields, _extends({
    max: 1,
    labelId: labelId,
    label: t('constraintPropertyLabel')
  }, fieldsProps), /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.Field, {
    size: 1,
    onClear: clear,
    spacing: 2
  }, /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.Select, {
    xs: 3,
    labelId: `namespace-edit-${property}`,
    value: namespaceKey,
    choices: (0,models_utils_namespaceChoices__WEBPACK_IMPORTED_MODULE_15__.getNamespaceChoices)(),
    onChange: updateNamespaceKey,
    size: size,
    label: t('namespaceLabel'),
    error: namespaceKeyError,
    helperText: namespaceKeyErrorText
  }), /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.TextField, {
    xs: 5,
    size: size,
    onChange: updateNamespaceValue,
    value: namespaceValue,
    label: t('localNameLabel'),
    error: namespaceValueError,
    helperText: namespaceValueErrorText
  })));
};
ConstraintPropertyEdit.propTypes = {
  size: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  graph: commons_util_entry__WEBPACK_IMPORTED_MODULE_5__.graphPropType,
  blankNodeId: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  onChange: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  dispatch: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  property: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  error: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  helperText: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};
const ConstraintEditor = _ref8 => {
  let {
    name,
    size,
    property,
    graph,
    resourceURI,
    dispatch
  } = _ref8;
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_9__.useTranslation)([(commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_13___default()), (admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_12___default())]);
  const {
    fieldGroup,
    labelId,
    addField
  } = (0,commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.useBlankEdit)({
    name,
    property,
    graph,
    resourceURI,
    dispatch,
    rdfType: models_utils_ns__WEBPACK_IMPORTED_MODULE_10__.RDF_TYPE_CONSTRAINT,
    validate: models_utils_constraint__WEBPACK_IMPORTED_MODULE_14__.validateConstraint
  });
  const fields = fieldGroup.getFields();
  const handleChange = field => {
    const [prop, value] = (0,models_utils_constraint__WEBPACK_IMPORTED_MODULE_14__.findConstraint)(graph, field);
    if (!prop && !value && field.isAsserted()) {
      field.setAsserted(false);
    }
    if ((prop || value) && !field.isAsserted()) {
      field.setAsserted(true);
    }
    if (field.getStatus() !== 'initial') {
      field.validate();
    }
  };
  return /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.Fields, {
    labelId: labelId,
    label: t('constraintsLabel'),
    addField: addField
  }, fields.map(field => {
    return /*#__PURE__*/React.createElement("div", {
      key: field.getId(),
      className: "esadConstraintEditor"
    }, /*#__PURE__*/React.createElement(ConstraintPropertyEdit, {
      property: models_utils_ns__WEBPACK_IMPORTED_MODULE_10__.RDF_PROPERTY_CONSTRAINT_PROPERTY,
      blankNodeId: field.getBlankNodeId(),
      graph: graph,
      size: size,
      onChange: () => handleChange(field),
      dispatch: dispatch,
      error: field.getError() === models_utils_constraint__WEBPACK_IMPORTED_MODULE_14__.MISSING_PROPERTY,
      helperText: field.getError() === models_utils_constraint__WEBPACK_IMPORTED_MODULE_14__.MISSING_PROPERTY ? t(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.MISSING_VALUE) : ''
    }), /*#__PURE__*/React.createElement(ConstraintValuesEdit, {
      property: models_utils_ns__WEBPACK_IMPORTED_MODULE_10__.RDF_PROPERTY_CONSTRAINT_VALUE,
      graph: graph,
      blankNodeId: field.getBlankNodeId(),
      size: size,
      onChange: () => handleChange(field),
      dispatch: dispatch,
      error: field.getError() === commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.MISSING_VALUE,
      helperText: field.getError() === commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.MISSING_VALUE ? t(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_11__.MISSING_VALUE) : ''
    }));
  }));
};
ConstraintEditor.propTypes = {
  name: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  size: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  graph: commons_util_entry__WEBPACK_IMPORTED_MODULE_5__.graphPropType,
  resourceURI: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  dispatch: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
  property: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./modules/admin/configs/editors/ConstraintEditor/ConstraintEditor.scss":
/*!******************************************************************************!*\
  !*** ./modules/admin/configs/editors/ConstraintEditor/ConstraintEditor.scss ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_ConstraintEditor_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../../node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!../../../../../node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./ConstraintEditor.scss */ "./node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!./node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./modules/admin/configs/editors/ConstraintEditor/ConstraintEditor.scss");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_ConstraintEditor_scss__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_ConstraintEditor_scss__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_ConstraintEditor_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_ConstraintEditor_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./modules/admin/configs/editors/ConstraintEditor/index.js":
/*!*****************************************************************!*\
  !*** ./modules/admin/configs/editors/ConstraintEditor/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ConstraintEditor: () => (/* reexport safe */ _ConstraintEditor__WEBPACK_IMPORTED_MODULE_0__.ConstraintEditor)
/* harmony export */ });
/* harmony import */ var _ConstraintEditor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ConstraintEditor */ "./modules/admin/configs/editors/ConstraintEditor/ConstraintEditor.js");


/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeCreateDialog/EntityTypeCreateDialog.js":
/*!********************************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeCreateDialog/EntityTypeCreateDialog.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var admin_configs_types_TypeCreateDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! admin/configs/types/TypeCreateDialog */ "./modules/admin/configs/types/TypeCreateDialog/index.js");
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! admin/nls/esadType.nls */ "./modules/admin/nls/esadType.nls");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! admin/nls/esadEntityType.nls */ "./modules/admin/nls/esadEntityType.nls");
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var admin_configs_utils_configQuery__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! admin/configs/utils/configQuery */ "./modules/admin/configs/utils/configQuery.js");
/* harmony import */ var _EntityTypeForm__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../EntityTypeForm */ "./modules/admin/configs/entitytypes/EntityTypeForm/index.js");
/* harmony import */ var _utils_editorFields__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../utils/editorFields */ "./modules/admin/configs/entitytypes/utils/editorFields.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");












const NLS_BUNDLES = [(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_6___default()), (admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_7___default())];
const CreateEntityTypeDialog = _ref => {
  let {
    closeDialog,
    entityTypeEntries
  } = _ref;
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_5__.useTranslation)(NLS_BUNDLES);
  const context = (0,admin_configs_utils_configQuery__WEBPACK_IMPORTED_MODULE_9__.getConfigContext)();
  const prototypeEntry = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
    return context.newEntry();
  }, [context]);
  return /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_2__.EditorProvider, {
    entry: prototypeEntry
  }, /*#__PURE__*/React.createElement(admin_configs_types_TypeCreateDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    title: t('createHeader'),
    closeDialog: closeDialog,
    rdfTypes: [admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_8__.RDF_CLASS_ENTITY_TYPE, admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_8__.RDF_CLASS_CUSTOM_ENTITY_TYPE],
    nlsBundles: NLS_BUNDLES,
    fields: _utils_editorFields__WEBPACK_IMPORTED_MODULE_11__.editorFields
  }, /*#__PURE__*/React.createElement(_EntityTypeForm__WEBPACK_IMPORTED_MODULE_10__["default"], {
    entityTypeEntries: entityTypeEntries,
    nlsBundles: NLS_BUNDLES
  })));
};
CreateEntityTypeDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().func).isRequired,
  entityTypeEntries: prop_types__WEBPACK_IMPORTED_MODULE_0___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_0___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__.Entry))
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CreateEntityTypeDialog);

/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeCreateDialog/index.js":
/*!***************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeCreateDialog/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _EntityTypeCreateDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _EntityTypeCreateDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EntityTypeCreateDialog */ "./modules/admin/configs/entitytypes/EntityTypeCreateDialog/EntityTypeCreateDialog.js");


/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeEditDialog/EntityTypeEditDialog.js":
/*!****************************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeEditDialog/EntityTypeEditDialog.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var admin_configs_types_TypeEditDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! admin/configs/types/TypeEditDialog */ "./modules/admin/configs/types/TypeEditDialog/index.js");
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var _EntityTypeForm__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../EntityTypeForm */ "./modules/admin/configs/entitytypes/EntityTypeForm/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");







const EntityTypeEditDialog = _ref => {
  let {
    closeDialog,
    entry,
    entityTypeEntries,
    onEdit
  } = _ref;
  const {
    nlsBundles
  } = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_5__.useListView)();
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_4__.useTranslation)(nlsBundles);
  return /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_2__.EditorProvider, {
    entry: entry
  }, /*#__PURE__*/React.createElement(admin_configs_types_TypeEditDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    title: t('editHeader'),
    closeDialog: closeDialog,
    nlsBundles: nlsBundles,
    onEdit: onEdit
  }, /*#__PURE__*/React.createElement(_EntityTypeForm__WEBPACK_IMPORTED_MODULE_6__["default"], {
    entityTypeEntries: entityTypeEntries,
    nlsBundles: nlsBundles
  })));
};
EntityTypeEditDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().func).isRequired,
  onEdit: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().func),
  entry: prop_types__WEBPACK_IMPORTED_MODULE_0___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_3__.Entry),
  entityTypeEntries: prop_types__WEBPACK_IMPORTED_MODULE_0___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_0___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_3__.Entry))
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EntityTypeEditDialog);

/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeEditDialog/index.js":
/*!*************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeEditDialog/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _EntityTypeEditDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _EntityTypeEditDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EntityTypeEditDialog */ "./modules/admin/configs/entitytypes/EntityTypeEditDialog/EntityTypeEditDialog.js");


/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeEntryList/EntityTypeEntryList.js":
/*!**************************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeEntryList/EntityTypeEntryList.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.string.search.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.search.js");
/* harmony import */ var core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_actions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/actions */ "./modules/commons/actions/index.js");
/* harmony import */ var commons_components_common_SegmentedControlTabs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/components/common/SegmentedControlTabs */ "./modules/commons/components/common/SegmentedControlTabs/index.js");
/* harmony import */ var _mui_icons_material_Settings__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @mui/icons-material/Settings */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Settings.js");
/* harmony import */ var _mui_icons_material_Widgets__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @mui/icons-material/Widgets */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Widgets.js");
/* harmony import */ var _mui_icons_material_Info__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @mui/icons-material/Info */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Info.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! admin/nls/esadEntityType.nls */ "./modules/admin/nls/esadEntityType.nls");
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! admin/nls/esadType.nls */ "./modules/admin/nls/esadType.nls");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var commons_util_metadata__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/util/metadata */ "./modules/commons/util/metadata.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var _utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../utils/entityTypeQuery */ "./modules/admin/configs/entitytypes/utils/entityTypeQuery.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./actions */ "./modules/admin/configs/entitytypes/EntityTypeEntryList/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
const _excluded = ["typeConfigToGraph"],
  _excluded2 = ["nlsKeyLabel"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }
























const NLS_BUNDLES = [(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_16___default()), (admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_17___default()), (admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_18___default())];
const SEARCH_FIELDS = ['label'];
const EntityTypeEntryList = _ref => {
  let {
    entityTypeEntries,
    status,
    listProps
  } = _ref;
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_15__.useTranslation)(NLS_BUNDLES);
  const [{
    search
  }, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.useListModel)();
  const [selectedFilterTab, setSelectedFilterTab] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_19__.ENTITY_TYPE_CUSTOM);
  const filteredEntityTypes = (0,react__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => {
    return status === commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_21__.RESOLVED ? (0,_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_22__.getEntityTypesByFilter)(entityTypeEntries, selectedFilterTab) : null;
  }, [entityTypeEntries, selectedFilterTab, status]);
  const {
    result: entityTypes,
    size
  } = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.useListQuery)({
    items: filteredEntityTypes,
    searchFields: SEARCH_FIELDS
  });
  const filterTabs = [{
    label: t('customFilterLabel'),
    value: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_19__.ENTITY_TYPE_CUSTOM
  }, {
    label: t('builtinFilterLabel'),
    value: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_19__.ENTITY_TYPE_BUILTIN
  }];
  const handleSelectTab = selectedTab => {
    setSelectedFilterTab(selectedTab);
    if (selectedTab === admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_19__.ENTITY_TYPE_BUILTIN) {
      dispatch({
        type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.SORT,
        value: {
          field: 'label',
          order: 'desc'
        }
      });
      return;
    }
    dispatch({
      type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.SORT,
      value: {
        field: 'modified',
        order: 'desc'
      }
    });
  };
  const defaultActions = [{
    id: commons_actions__WEBPACK_IMPORTED_MODULE_10__.ACTION_CREATE_ID,
    element: /*#__PURE__*/React.createElement(_actions__WEBPACK_IMPORTED_MODULE_23__.CreateEntryButton, {
      status: status,
      entityTypeEntries: entityTypeEntries,
      key: commons_actions__WEBPACK_IMPORTED_MODULE_10__.ACTION_CREATE_ID
    })
  }];
  const listActions = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.useFilterListActions)({
    listActions: defaultActions,
    listActionsProps: {},
    excludeActions: listProps.excludeActions,
    nlsBundles: NLS_BUNDLES
  });
  return /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListView, {
    status: status,
    search: search,
    size: size,
    nlsBundles: NLS_BUNDLES
  }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListActions, null, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListSearch, null), /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.RefreshButton, null), listActions.map(_ref2 => {
    let {
      element
    } = _ref2;
    return element;
  })), status !== 'pending' ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(commons_components_common_SegmentedControlTabs__WEBPACK_IMPORTED_MODULE_11__["default"], {
    items: filterTabs,
    selected: selectedFilterTab,
    onSelect: handleSelectTab
  }), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListHeader, null, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListHeaderItemText, {
    xs: 1,
    text: ""
  }), selectedFilterTab === admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_19__.ENTITY_TYPE_BUILTIN ? /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListHeaderItemSort, {
    xs: 7,
    sortBy: "label",
    text: t('labelListHeader')
  }) : /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListHeaderItemText, {
    xs: 7
  }), selectedFilterTab === admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_19__.ENTITY_TYPE_CUSTOM ? /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListHeaderItemSort, {
    sortBy: "modified",
    text: t('modifiedListHeader')
  }) : null)) : null, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.List, null, entityTypes.map(entityType => {
    const {
      id,
      label,
      type,
      entry
    } = entityType;
    const isBuiltin = type === admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_19__.ENTITY_TYPE_BUILTIN;
    const {
        typeConfigToGraph
      } = _actions__WEBPACK_IMPORTED_MODULE_23__.presenterAction,
      infoProps = _objectWithoutProperties(_actions__WEBPACK_IMPORTED_MODULE_23__.presenterAction, _excluded);
    const typeInfoAction = _objectSpread(_objectSpread({}, infoProps), {}, {
      entry: entityType.entry,
      title: t(infoProps.nlsKeyLabel),
      nlsBundles: NLS_BUNDLES
    }, typeConfigToGraph({
      entry,
      config: entityType.config
    }));
    const actionsMenuItems = _actions__WEBPACK_IMPORTED_MODULE_23__.rowActions.filter(_ref3 => {
      let {
        isVisible
      } = _ref3;
      return isVisible(entityType);
    }).map(_ref4 => {
      let {
          nlsKeyLabel
        } = _ref4,
        action = _objectWithoutProperties(_ref4, _excluded2);
      return {
        label: t(nlsKeyLabel),
        icon: (0,commons_actions__WEBPACK_IMPORTED_MODULE_10__.getIconFromActionId)(action.id),
        action: _objectSpread(_objectSpread({}, action), {}, {
          entry,
          entityTypeEntries
        })
      };
    });
    return /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListItem, {
      key: id
    }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListItemIcon, {
      Icon: isBuiltin ? _mui_icons_material_Settings__WEBPACK_IMPORTED_MODULE_12__["default"] : _mui_icons_material_Widgets__WEBPACK_IMPORTED_MODULE_13__["default"],
      tooltip: isBuiltin ? t('builtinLabel') : t('customLabel')
    }), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListItemText, {
      xs: isBuiltin ? 9 : 7,
      primary: label
    }), !isBuiltin ? /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListItemText, {
      secondary: (0,commons_util_metadata__WEBPACK_IMPORTED_MODULE_20__.getShortModifiedDate)(entry),
      xs: 2
    }) : null, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListItemActionIconButton, {
      title: t(_actions__WEBPACK_IMPORTED_MODULE_23__.presenterAction.nlsKeyLabel),
      action: typeInfoAction,
      xs: 1
    }, /*#__PURE__*/React.createElement(_mui_icons_material_Info__WEBPACK_IMPORTED_MODULE_14__["default"], null)), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListItemOpenMenuButton, null), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ActionsMenu, {
      items: actionsMenuItems
    }));
  })), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.ListPagination, null));
};
EntityTypeEntryList.propTypes = {
  entityTypeEntries: prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_6___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_7__.Entry)),
  status: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
  listProps: commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.listPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EntityTypeEntryList);

/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeEntryList/actions.js":
/*!**************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeEntryList/actions.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CreateEntryButton: () => (/* binding */ CreateEntryButton),
/* harmony export */   presenterAction: () => (/* binding */ presenterAction),
/* harmony export */   rowActions: () => (/* binding */ rowActions)
/* harmony export */ });
/* harmony import */ var _mui_icons_material_Add__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @mui/icons-material/Add */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Add.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! admin/nls/esadEntityType.nls */ "./modules/admin/nls/esadEntityType.nls");
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var commons_actions_actionIds__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/actions/actionIds */ "./modules/commons/actions/actionIds.js");
/* harmony import */ var commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/FieldsLinkedDataBrowserDialog */ "./modules/commons/components/FieldsLinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_components_buttons_ActionButton__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/buttons/ActionButton */ "./modules/commons/components/buttons/ActionButton/index.js");
/* harmony import */ var _utils_entityTypePresenters__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/entityTypePresenters */ "./modules/admin/configs/entitytypes/utils/entityTypePresenters.js");
/* harmony import */ var _EntityTypeCreateDialog__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../EntityTypeCreateDialog */ "./modules/admin/configs/entitytypes/EntityTypeCreateDialog/index.js");
/* harmony import */ var _EntityTypeEditDialog__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../EntityTypeEditDialog */ "./modules/admin/configs/entitytypes/EntityTypeEditDialog/index.js");
/* harmony import */ var _EntityTypeRemoveDialog_EntityTypeRemoveDialog__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../EntityTypeRemoveDialog/EntityTypeRemoveDialog */ "./modules/admin/configs/entitytypes/EntityTypeRemoveDialog/EntityTypeRemoveDialog.js");
/* harmony import */ var _utils_exporters__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../utils/exporters */ "./modules/admin/configs/utils/exporters.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");















const presenterAction = {
  Dialog: commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_8__["default"],
  fields: _utils_entityTypePresenters__WEBPACK_IMPORTED_MODULE_10__.fieldPresenters,
  typeConfigToGraph: _ref => {
    let {
      entry,
      config
    } = _ref;
    return (0,_utils_exporters__WEBPACK_IMPORTED_MODULE_14__.typeConfigToGraph)({
      entry,
      typeConfig: config,
      idPrefix: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_6__.ENTITY_TYPE_ID_PREFIX,
      fields: _utils_entityTypePresenters__WEBPACK_IMPORTED_MODULE_10__.fieldPresenters
    });
  },
  nlsKeyLabel: 'typeInfoDialogTitle'
};
const rowActions = [{
  id: commons_actions_actionIds__WEBPACK_IMPORTED_MODULE_7__.ACTION_EDIT_ID,
  Dialog: (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_1__.withListRerender)(_EntityTypeEditDialog__WEBPACK_IMPORTED_MODULE_12__["default"], 'onEdit'),
  isVisible: _ref2 => {
    let {
      type
    } = _ref2;
    return type === admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_6__.ENTITY_TYPE_CUSTOM;
  },
  nlsKeyLabel: 'editEntry'
}, {
  id: commons_actions_actionIds__WEBPACK_IMPORTED_MODULE_7__.ACTION_REMOVE_ID,
  Dialog: _EntityTypeRemoveDialog_EntityTypeRemoveDialog__WEBPACK_IMPORTED_MODULE_13__["default"],
  isVisible: _ref3 => {
    let {
      type
    } = _ref3;
    return type === admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_6__.ENTITY_TYPE_CUSTOM;
  },
  nlsKeyLabel: 'removeEntryLabel'
}];
const CreateEntryButton = _ref4 => {
  let {
    entityTypeEntries,
    status
  } = _ref4;
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_2__.useTranslation)((admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_3___default()));
  if (status === 'resolved') {
    return /*#__PURE__*/React.createElement(commons_components_buttons_ActionButton__WEBPACK_IMPORTED_MODULE_9__["default"], {
      label: t('addLabel'),
      tooltip: t('addTooltip'),
      icon: /*#__PURE__*/React.createElement(_mui_icons_material_Add__WEBPACK_IMPORTED_MODULE_0__["default"], null),
      action: {
        Dialog: _EntityTypeCreateDialog__WEBPACK_IMPORTED_MODULE_11__["default"],
        entityTypeEntries
      }
    });
  }
  return null;
};
CreateEntryButton.propTypes = {
  entityTypeEntries: prop_types__WEBPACK_IMPORTED_MODULE_4___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_4___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_5__.Entry)),
  status: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string)
};

/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeEntryList/index.js":
/*!************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeEntryList/index.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _EntityTypeEntryList__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _EntityTypeEntryList__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EntityTypeEntryList */ "./modules/admin/configs/entitytypes/EntityTypeEntryList/EntityTypeEntryList.js");


/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeForm/EntityTypeForm.js":
/*!****************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeForm/EntityTypeForm.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Divider/Divider.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Box/Box.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Button/Button.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Collapse/Collapse.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var _utils_editorFields__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../utils/editorFields */ "./modules/admin/configs/entitytypes/utils/editorFields.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");









const EntityTypeForm = _ref => {
  let {
    entityTypeEntries,
    nlsBundles
  } = _ref;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__.useTranslation)(nlsBundles);
  const [showAdvanced, setShowAdvanced] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_4__.Form, {
    fields: _utils_editorFields__WEBPACK_IMPORTED_MODULE_11__.editorFields,
    size: "small",
    nlsBundles: nlsBundles
  }), /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_5__["default"], {
    sx: {
      width: '100%',
      marginTop: '48px',
      marginBottom: '8px'
    }
  }), /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_6__["default"], {
    sx: {
      marginBottom: '8px'
    }
  }, /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], {
    variant: "text",
    sx: {
      paddingLeft: 0
    },
    onClick: () => setShowAdvanced(!showAdvanced)
  }, showAdvanced ? translate('hideAdvancedLabel') : translate('showAdvancedLabel'))), /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], {
    in: showAdvanced,
    timeout: "auto",
    unmountOnExit: true
  }, /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_4__.Form, {
    fields: _utils_editorFields__WEBPACK_IMPORTED_MODULE_11__.advancedEditorFields,
    size: "small",
    entityTypeEntries: entityTypeEntries,
    nlsBundles: nlsBundles
  })));
};
EntityTypeForm.propTypes = {
  entityTypeEntries: prop_types__WEBPACK_IMPORTED_MODULE_3___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_3___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_9__.Entry)),
  nlsBundles: commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__.nlsBundlesPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EntityTypeForm);

/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeForm/index.js":
/*!*******************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeForm/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _EntityTypeForm__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _EntityTypeForm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EntityTypeForm */ "./modules/admin/configs/entitytypes/EntityTypeForm/EntityTypeForm.js");


/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeInstanceList/EntityTypeInstanceList.js":
/*!********************************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeInstanceList/EntityTypeInstanceList.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.string.search.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.search.js");
/* harmony import */ var core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_actions_actionIds__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/actions/actionIds */ "./modules/commons/actions/actionIds.js");
/* harmony import */ var _mui_icons_material_Settings__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/icons-material/Settings */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Settings.js");
/* harmony import */ var _mui_icons_material_Widgets__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/icons-material/Widgets */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Widgets.js");
/* harmony import */ var _mui_icons_material_CloudUpload__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @mui/icons-material/CloudUpload */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/CloudUpload.js");
/* harmony import */ var _mui_icons_material_Info__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @mui/icons-material/Info */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Info.js");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! admin/nls/esadEntityType.nls */ "./modules/admin/nls/esadEntityType.nls");
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! admin/nls/esadType.nls */ "./modules/admin/nls/esadType.nls");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var config__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! config */ "./app/registry/config/config.js");
/* harmony import */ var commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/components/FieldsLinkedDataBrowserDialog */ "./modules/commons/components/FieldsLinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_components_buttons_Button__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! commons/components/buttons/Button */ "./modules/commons/components/buttons/Button/index.js");
/* harmony import */ var _utils_entityTypePresenters__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../utils/entityTypePresenters */ "./modules/admin/configs/entitytypes/utils/entityTypePresenters.js");
/* harmony import */ var _utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../utils/entityTypeQuery */ "./modules/admin/configs/entitytypes/utils/entityTypeQuery.js");
/* harmony import */ var _utils_exporters__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../utils/exporters */ "./modules/admin/configs/utils/exporters.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }





/* eslint-disable react/jsx-props-no-spreading */




















const nlsBundles = [(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_13___default()), (admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_14___default()), (admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_15___default())];
const SEARCH_FIELDS = ['label'];
const MigrateEntityTypesButton = onMigrate => {
  const {
    runAsync
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_17__["default"])();
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_16__.useTranslation)(nlsBundles);
  if (!config__WEBPACK_IMPORTED_MODULE_19__["default"].get('admin.enableTypeStoreMigration')) return null;
  return /*#__PURE__*/React.createElement(commons_components_buttons_Button__WEBPACK_IMPORTED_MODULE_21__["default"], {
    label: t('migrateToStoreLabel'),
    icon: /*#__PURE__*/React.createElement(_mui_icons_material_CloudUpload__WEBPACK_IMPORTED_MODULE_11__["default"], null),
    onClick: () => runAsync((0,_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_23__.migrateEntityTypesToStore)().then(() => onMigrate())),
    isVisible: true
  });
};
const EntityTypeInstanceList = _ref => {
  let {
    onMigrate,
    listProps
  } = _ref;
  const [{
    search
  }] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.useListModel)();
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_16__.useTranslation)(nlsBundles);
  const {
    status
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_17__["default"])();
  const [selectedEntityType, setSelectedEntityType] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const instanceAndBuiltinEntityTypes = (0,react__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => {
    return (0,_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_23__.getInstanceAndBuiltinEntityTypes)();
  }, []);
  const {
    result: entityTypes,
    size
  } = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.useListQuery)({
    items: instanceAndBuiltinEntityTypes,
    searchFields: SEARCH_FIELDS
  });
  const defaultActions = [{
    id: commons_actions_actionIds__WEBPACK_IMPORTED_MODULE_8__.ACTION_MIGRATE_ID,
    element: /*#__PURE__*/React.createElement(MigrateEntityTypesButton, {
      key: commons_actions_actionIds__WEBPACK_IMPORTED_MODULE_8__.ACTION_MIGRATE_ID,
      onMigrate: onMigrate
    })
  }];
  const listActions = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.useFilterListActions)({
    listActions: defaultActions,
    listActionsProps: {},
    excludeActions: listProps.excludeActions,
    nlsBundles
  });
  return /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListView, {
    status: status,
    search: search,
    size: size,
    nlsBundles: nlsBundles
  }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListActions, null, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListSearch, null), listActions.map(_ref2 => {
    let {
      element
    } = _ref2;
    return element;
  })), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListHeader, null, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListHeaderItemText, {
    xs: 1,
    text: ""
  }), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListHeaderItemSort, {
    xs: 11,
    sortBy: "label",
    text: t('labelListHeader')
  })), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.List, null, entityTypes.map(entityType => {
    const {
      id,
      label,
      type
    } = entityType;
    const isBuiltin = type === admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_18__.ENTITY_TYPE_BUILTIN;
    return /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListItem, {
      key: id
    }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListItemIcon, {
      Icon: isBuiltin ? _mui_icons_material_Settings__WEBPACK_IMPORTED_MODULE_9__["default"] : _mui_icons_material_Widgets__WEBPACK_IMPORTED_MODULE_10__["default"],
      tooltip: isBuiltin ? t('builtinFilterLabel') : t('customFilterLabel')
    }), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListItemText, {
      xs: 9,
      primary: label
    }), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListItemIconButton, {
      icon: /*#__PURE__*/React.createElement(_mui_icons_material_Info__WEBPACK_IMPORTED_MODULE_12__["default"], null),
      xs: 2,
      justifyContent: "flex-end",
      onClick: () => setSelectedEntityType(entityType),
      title: t('showTypeInfoDialogTitle')
    }));
  })), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListPagination, null), selectedEntityType ? /*#__PURE__*/React.createElement(commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_20__["default"], _extends({
    fields: _utils_entityTypePresenters__WEBPACK_IMPORTED_MODULE_22__.fieldPresenters,
    title: t('typeInfoDialogTitle'),
    closeDialog: () => setSelectedEntityType(null),
    nlsBundles: nlsBundles
  }, (0,_utils_exporters__WEBPACK_IMPORTED_MODULE_24__.typeConfigToGraph)({
    entry: selectedEntityType.entry,
    typeConfig: selectedEntityType.config,
    idPrefix: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_18__.ENTITY_TYPE_ID_PREFIX,
    fields: _utils_entityTypePresenters__WEBPACK_IMPORTED_MODULE_22__.fieldPresenters
  }))) : null);
};
EntityTypeInstanceList.propTypes = {
  onMigrate: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func),
  listProps: commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.listPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.withListModelProvider)(EntityTypeInstanceList, () => ({
  sort: {
    field: 'label',
    order: 'asc'
  }
})));

/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeInstanceList/index.js":
/*!***************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeInstanceList/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _EntityTypeInstanceList__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _EntityTypeInstanceList__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EntityTypeInstanceList */ "./modules/admin/configs/entitytypes/EntityTypeInstanceList/EntityTypeInstanceList.js");


/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeRemoveDialog/EntityTypeRemoveDialog.js":
/*!********************************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeRemoveDialog/EntityTypeRemoveDialog.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_EntryListView_dialogs_ListRemoveEntryDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/EntryListView/dialogs/ListRemoveEntryDialog */ "./modules/commons/components/EntryListView/dialogs/ListRemoveEntryDialog/index.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");





const EntityTypeRemoveDialog = _ref => {
  let {
    entry,
    closeDialog
  } = _ref;
  const {
    nlsBundles
  } = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_4__.useListView)();
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_3__.useTranslation)(nlsBundles);
  return /*#__PURE__*/React.createElement(commons_components_EntryListView_dialogs_ListRemoveEntryDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    nlsBundles: nlsBundles,
    entry: entry,
    closeDialog: closeDialog,
    removeSuccessMessage: t('removeCustomEntityTypeSuccess'),
    removeFailMessage: t('removeCustomEntityTypeFail')
  });
};
EntityTypeRemoveDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_0___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_2__.Entry),
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EntityTypeRemoveDialog);

/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeSelectEditor/EntityTypeChooser/EntityTypeChooser.js":
/*!*********************************************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeSelectEditor/EntityTypeChooser/EntityTypeChooser.js ***!
  \*********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.string.search.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.search.js");
/* harmony import */ var core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Box/Box.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Button/Button.js");
/* harmony import */ var _mui_icons_material_Info__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/icons-material/Info */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Info.js");
/* harmony import */ var _mui_icons_material_Settings__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/icons-material/Settings */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Settings.js");
/* harmony import */ var _mui_icons_material_Widgets__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @mui/icons-material/Widgets */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Widgets.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/components/FieldsLinkedDataBrowserDialog */ "./modules/commons/components/FieldsLinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! admin/nls/esadEntityType.nls */ "./modules/admin/nls/esadEntityType.nls");
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! admin/nls/esadType.nls */ "./modules/admin/nls/esadType.nls");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var commons_components_EntryListView_lists_UsersList_actions__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! commons/components/EntryListView/lists/UsersList/actions */ "./modules/commons/components/EntryListView/lists/UsersList/actions.js");
/* harmony import */ var _utils_exporters__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../../utils/exporters */ "./modules/admin/configs/utils/exporters.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }





/* eslint-disable react/jsx-props-no-spreading */

















const NLS_BUNDLES = [(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_17___default()), (admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_18___default()), (admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_19___default())];
const SEARCH_FIELDS = ['label'];
const EntityTypeChooser = _ref => {
  let {
    onSelect,
    entityTypes,
    closeDialog,
    presenters
  } = _ref;
  const [entityTypeInfo, setEntityTypeInfo] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(null);
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_12__.useTranslation)(NLS_BUNDLES);
  const [{
    search
  }] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.useListModel)();
  const {
    result: entityTypeListItems,
    size
  } = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.useListQuery)({
    items: entityTypes,
    searchFields: SEARCH_FIELDS
  });
  const handleSelectEntityType = id => {
    onSelect(id);
    closeDialog();
  };
  return /*#__PURE__*/React.createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_16__["default"], {
    id: "select-entitytype-chooser",
    closeDialog: closeDialog,
    closeDialogButtonLabel: t('close'),
    title: t('selectEntityTypeTitle'),
    fixedHeight: true
  }, /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], {
    maxWidth: "924px"
  }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListView, {
    status: "resolved",
    search: search,
    size: size,
    nlsBundles: NLS_BUNDLES
  }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListActions, null, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListSearch, null), /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_14__.RefreshButton, null)), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListHeader, null, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListHeaderItemText, {
    xs: 1,
    text: ""
  }), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListHeaderItemSort, {
    xs: 11,
    sortBy: "label",
    text: t('labelListHeader')
  })), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.List, null, entityTypeListItems.map(entityTypeListItem => {
    const {
      id,
      label,
      type
    } = entityTypeListItem;
    const isBuiltin = type === admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_20__.ENTITY_TYPE_BUILTIN;
    return /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListItem, {
      key: id
    }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListItemIcon, {
      Icon: isBuiltin ? _mui_icons_material_Settings__WEBPACK_IMPORTED_MODULE_10__["default"] : _mui_icons_material_Widgets__WEBPACK_IMPORTED_MODULE_11__["default"],
      tooltip: isBuiltin ? t('builtinLabel') : t('customLabel')
    }), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListItemText, {
      xs: 8,
      primary: label
    }), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListItemAction, {
      xs: 2
    }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListItemIconButton, {
      onClick: () => setEntityTypeInfo(entityTypeListItem),
      title: t('showTypeInfoDialogTitle')
    }, /*#__PURE__*/React.createElement(_mui_icons_material_Info__WEBPACK_IMPORTED_MODULE_9__["default"], null))), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListItemAction, null, /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], {
      variant: "text",
      onClick: () => handleSelectEntityType(id)
    }, t('selectEntityTypeLabel'))));
  })), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.ListPagination, null), entityTypeInfo ? /*#__PURE__*/React.createElement(commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_15__["default"], _extends({
    entry: entityTypeInfo.entry,
    fields: presenters,
    title: t('typeInfoDialogTitle'),
    closeDialog: () => setEntityTypeInfo(null),
    nlsBundles: commons_components_EntryListView_lists_UsersList_actions__WEBPACK_IMPORTED_MODULE_21__.nlsBundles
  }, (0,_utils_exporters__WEBPACK_IMPORTED_MODULE_22__.typeConfigToGraph)({
    entry: entityTypeInfo.entry,
    typeConfig: entityTypeInfo.config,
    idPrefix: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_20__.ENTITY_TYPE_ID_PREFIX,
    fields: presenters
  }))) : null)));
};
EntityTypeChooser.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func).isRequired,
  onSelect: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().func).isRequired,
  entityTypes: prop_types__WEBPACK_IMPORTED_MODULE_6___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape({
    id: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    label: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string),
    type: (prop_types__WEBPACK_IMPORTED_MODULE_6___default().string)
  })),
  presenters: prop_types__WEBPACK_IMPORTED_MODULE_6___default().shape({})
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.withListModelProvider)(EntityTypeChooser, () => ({
  sort: {
    field: 'label',
    order: 'asc'
  }
})));

/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeSelectEditor/EntityTypeChooser/index.js":
/*!*********************************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeSelectEditor/EntityTypeChooser/index.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _EntityTypeChooser__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _EntityTypeChooser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EntityTypeChooser */ "./modules/admin/configs/entitytypes/EntityTypeSelectEditor/EntityTypeChooser/EntityTypeChooser.js");


/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeSelectEditor/EntityTypeSelectEditor.js":
/*!********************************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeSelectEditor/EntityTypeSelectEditor.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EntityTypeSelectEditor: () => (/* binding */ EntityTypeSelectEditor)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Grid/Grid.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! admin/nls/esadEntityType.nls */ "./modules/admin/nls/esadEntityType.nls");
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/types/utils/uri */ "./modules/commons/types/utils/uri.js");
/* harmony import */ var admin_configs_entitytypes_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! admin/configs/entitytypes/utils/entityTypeQuery */ "./modules/admin/configs/entitytypes/utils/entityTypeQuery.js");
/* harmony import */ var _EntityTypeChooser__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./EntityTypeChooser */ "./modules/admin/configs/entitytypes/EntityTypeSelectEditor/EntityTypeChooser/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }















const EntityTypeSelectEditor = _ref => {
  let {
    graph,
    resourceURI,
    property,
    label,
    mandatory,
    entityTypeEntries,
    dialogProps
  } = _ref;
  const entityTypes = (0,react__WEBPACK_IMPORTED_MODULE_5__.useMemo)(() => {
    return (0,admin_configs_entitytypes_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_13__.getEntityTypesByFilter)(entityTypeEntries);
  }, [entityTypeEntries]);
  const [selectedEntityType, setSelectedEntityType] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(entityTypes.find(entityType => (0,commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_12__.nameToURI)(entityType.id, admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_11__.CONFIG_CONTEXT) === graph.findFirstValue(resourceURI, property)));
  const [showEntityTypeChooser, setShowEntityTypeChooser] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__.useTranslation)((admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_9___default()));
  const onSelect = entityTypeId => {
    graph.findAndRemove(resourceURI, property);
    graph.add(resourceURI, property, (0,commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_12__.nameToURI)(entityTypeId, admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_11__.CONFIG_CONTEXT));
    setSelectedEntityType(entityTypes.find(entityType => entityType.id === entityTypeId));
  };
  const onClear = () => {
    graph.findAndRemove(resourceURI, property);
    setSelectedEntityType('');
  };
  return /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_10__.Fields, {
    required: mandatory,
    labelId: "select-entitytype-editor",
    label: label,
    max: 1
  }, /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_10__.Field, {
    size: 1,
    disabled: !selectedEntityType,
    onClear: onClear
  }, /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_10__.TextField, {
    disabled: true,
    required: mandatory,
    xs: 8,
    inputProps: {
      'aria-labelledby': 'select-entitytype-editor'
    },
    size: "small",
    value: selectedEntityType ? selectedEntityType.label : ''
  }), /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_6__["default"], {
    size: {
      xs: 4
    }
  }, /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_10__.SearchButton, {
    tooltip: t('selectEntityTypeTooltip'),
    onClick: () => setShowEntityTypeChooser(true)
  }))), showEntityTypeChooser ? /*#__PURE__*/React.createElement(_EntityTypeChooser__WEBPACK_IMPORTED_MODULE_14__["default"], _extends({
    closeDialog: () => {
      setShowEntityTypeChooser(false);
    },
    onSelect: onSelect,
    entityTypes: entityTypes
  }, dialogProps)) : null);
};
EntityTypeSelectEditor.propTypes = {
  graph: commons_util_entry__WEBPACK_IMPORTED_MODULE_4__.graphPropType,
  resourceURI: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  property: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  mandatory: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  entityTypeEntries: prop_types__WEBPACK_IMPORTED_MODULE_3___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_3___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_7__.Entry)),
  dialogProps: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({})
};

/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeSelectEditor/index.js":
/*!***************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeSelectEditor/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EntityTypeSelectEditor: () => (/* reexport safe */ _EntityTypeSelectEditor__WEBPACK_IMPORTED_MODULE_0__.EntityTypeSelectEditor)
/* harmony export */ });
/* harmony import */ var _EntityTypeSelectEditor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EntityTypeSelectEditor */ "./modules/admin/configs/entitytypes/EntityTypeSelectEditor/EntityTypeSelectEditor.js");


/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeView/EntityTypeView.js":
/*!****************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeView/EntityTypeView.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! config */ "./app/registry/config/config.js");
/* harmony import */ var commons_components_Loader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/components/Loader */ "./modules/commons/components/Loader/index.js");
/* harmony import */ var _EntityTypeInstanceList__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../EntityTypeInstanceList */ "./modules/admin/configs/entitytypes/EntityTypeInstanceList/index.js");
/* harmony import */ var _EntityTypeEntryList__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../EntityTypeEntryList */ "./modules/admin/configs/entitytypes/EntityTypeEntryList/index.js");
/* harmony import */ var _utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../utils/entityTypeQuery */ "./modules/admin/configs/entitytypes/utils/entityTypeQuery.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");









// By default entity type entries are shown.
// Instance entity types are shown if defined and there are no entity type entries.
const EntityTypeListView = _ref => {
  let {
    listProps
  } = _ref;
  const [{
    refreshCount
  }, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_2__.useListModel)();
  const {
    entries: entityTypeEntries,
    status,
    isLoading
  } = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_2__.useFetchEntries)({
    fetchEntries: _utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_7__.getEntityTypeEntries,
    refreshCount
  });
  if (isLoading) return /*#__PURE__*/React.createElement(commons_components_Loader__WEBPACK_IMPORTED_MODULE_4__["default"], null);
  if (!(entityTypeEntries !== null && entityTypeEntries !== void 0 && entityTypeEntries.length) || config__WEBPACK_IMPORTED_MODULE_3__["default"].get('admin.enableEntrystoreConfigurations') === false) return /*#__PURE__*/React.createElement(_EntityTypeInstanceList__WEBPACK_IMPORTED_MODULE_5__["default"], {
    onMigrate: () => dispatch({
      type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_2__.REFRESH
    }),
    listProps: listProps
  });
  return /*#__PURE__*/React.createElement(_EntityTypeEntryList__WEBPACK_IMPORTED_MODULE_6__["default"], {
    entityTypeEntries: entityTypeEntries,
    status: status,
    listProps: listProps
  });
};
EntityTypeListView.propTypes = {
  listProps: commons_components_ListView__WEBPACK_IMPORTED_MODULE_2__.listPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_2__.withListModelProvider)(EntityTypeListView));

/***/ }),

/***/ "./modules/admin/configs/entitytypes/EntityTypeView/index.js":
/*!*******************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/EntityTypeView/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _EntityTypeView__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _EntityTypeView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EntityTypeView */ "./modules/admin/configs/entitytypes/EntityTypeView/EntityTypeView.js");


/***/ }),

/***/ "./modules/admin/configs/entitytypes/utils/editorFields.js":
/*!*****************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/utils/editorFields.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   advancedEditorFields: () => (/* binding */ advancedEditorFields),
/* harmony export */   editorFields: () => (/* binding */ editorFields)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var _editors_ConstraintEditor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../editors/ConstraintEditor */ "./modules/admin/configs/editors/ConstraintEditor/index.js");
/* harmony import */ var _EntityTypeSelectEditor__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../EntityTypeSelectEditor */ "./modules/admin/configs/entitytypes/EntityTypeSelectEditor/index.js");
/* harmony import */ var _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./fieldDefinitions */ "./modules/admin/configs/entitytypes/utils/fieldDefinitions.js");
/* harmony import */ var _entityTypePresenters__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./entityTypePresenters */ "./modules/admin/configs/entitytypes/utils/entityTypePresenters.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }





const editorFields = [_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.label), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.description), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.template), _objectSpread(_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.constraints), {}, {
  Editor: _editors_ConstraintEditor__WEBPACK_IMPORTED_MODULE_2__.ConstraintEditor
}), _objectSpread(_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.createOptions), {}, {
  editors: [_fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.includeInternal, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.inlineCreation, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.includeFile, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.includeLink]
})];
const advancedEditorFields = [_objectSpread(_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.module), {}, {
  Editor: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__.SelectEditor
}), _objectSpread(_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.templateLevel), {}, {
  Editor: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__.RadioEditor
}), _objectSpread(_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.useWith), {}, {
  Editor: _EntityTypeSelectEditor__WEBPACK_IMPORTED_MODULE_3__.EntityTypeSelectEditor,
  dialogProps: {
    presenters: _entityTypePresenters__WEBPACK_IMPORTED_MODULE_5__.fieldPresenters
  }
}), _objectSpread(_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.refines), {}, {
  Editor: _EntityTypeSelectEditor__WEBPACK_IMPORTED_MODULE_3__.EntityTypeSelectEditor,
  dialogProps: {
    presenters: _entityTypePresenters__WEBPACK_IMPORTED_MODULE_5__.fieldPresenters
  }
}), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.context), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.restrictTo), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.allContexts), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.publishControl), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.global), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.main), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.uriPattern), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.iconId), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.searchProps), _objectSpread(_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_4__.storeConfig), {}, {
  editors: [{
    nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__.LANGUAGE_LITERAL,
    property: 'dcterms:title',
    labelNlsKey: 'labelLabel'
  }, {
    nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__.URI,
    property: 'dcterms:source',
    max: 1,
    labelNlsKey: 'endpointLabel'
  }]
})];

/***/ }),

/***/ "./modules/admin/configs/entitytypes/utils/entityTypePresenters.js":
/*!*************************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/utils/entityTypePresenters.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fieldPresenters: () => (/* binding */ fieldPresenters)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _types_presenters_Constraints__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../types/presenters/Constraints */ "./modules/admin/configs/types/presenters/Constraints/index.js");
/* harmony import */ var _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./fieldDefinitions */ "./modules/admin/configs/entitytypes/utils/fieldDefinitions.js");
/* harmony import */ var _types_presenters_StoreConfigPresenter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../types/presenters/StoreConfigPresenter */ "./modules/admin/configs/types/presenters/StoreConfigPresenter/index.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



const fieldPresenters = [_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.label), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.template), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.description), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.rdfType), _objectSpread(_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.constraints), {}, {
  Presenter: _types_presenters_Constraints__WEBPACK_IMPORTED_MODULE_1__.Constraints
}), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.module), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.includeInternal), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.inlineCreation), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.includeFile), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.includeLink), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.iconId), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.useWith), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.refines), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.templateLevel), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.publishControl), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.searchProps), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.allContexts), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.context), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.uriPattern), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.restrictTo), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.global), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.main), _objectSpread(_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.storeConfig), {}, {
  Presenter: _types_presenters_StoreConfigPresenter__WEBPACK_IMPORTED_MODULE_3__.StoreConfigPresenter
})];

/***/ }),

/***/ "./modules/admin/configs/entitytypes/utils/entityTypeQuery.js":
/*!********************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/utils/entityTypeQuery.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getEntityTypeEntries: () => (/* binding */ getEntityTypeEntries),
/* harmony export */   getEntityTypesByFilter: () => (/* binding */ getEntityTypesByFilter),
/* harmony export */   getInstanceAndBuiltinEntityTypes: () => (/* binding */ getInstanceAndBuiltinEntityTypes),
/* harmony export */   getInstanceEntityTypes: () => (/* binding */ getInstanceEntityTypes),
/* harmony export */   getOverriddenBuiltinEntityTypes: () => (/* binding */ getOverriddenBuiltinEntityTypes),
/* harmony export */   hasInstanceEntityTypes: () => (/* binding */ hasInstanceEntityTypes),
/* harmony export */   migrateEntityTypesToStore: () => (/* binding */ migrateEntityTypesToStore)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_registry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/registry */ "./modules/commons/registry.js");
/* harmony import */ var config__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! config */ "./app/registry/config/config.js");
/* harmony import */ var commons_locale__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/locale */ "./modules/commons/locale/index.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var admin_configs_utils_configQuery__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! admin/configs/utils/configQuery */ "./modules/admin/configs/utils/configQuery.js");
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var commons_types_utils_entityType__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/types/utils/entityType */ "./modules/commons/types/utils/entityType.js");
/* harmony import */ var _fieldDefinitions__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./fieldDefinitions */ "./modules/admin/configs/entitytypes/utils/fieldDefinitions.js");














/**
 * Get entity types defined in instance config
 *
 * @returns {object[]}
 */
const getInstanceEntityTypes = () => {
  return commons_registry__WEBPACK_IMPORTED_MODULE_5__["default"].getInstanceConfig().entitytypes || [];
};

/**
 * Checks for entity types defined in instance config.
 *
 * @returns {boolean}
 */
const hasInstanceEntityTypes = () => {
  return Boolean(getInstanceEntityTypes().length);
};

/**
 * Merges entity types defined in instance and application config. A type
 * prop is added.
 *
 * @returns {object[]}
 */
const getInstanceAndBuiltinEntityTypes = () => {
  const systemEntityTypeIds = commons_registry__WEBPACK_IMPORTED_MODULE_5__["default"].getApplicationConfig().entitytypes.map(_ref => {
    let {
      name
    } = _ref;
    return name;
  });
  const entityTypes = config__WEBPACK_IMPORTED_MODULE_6__["default"].get('entitytypes');
  return entityTypes.map(entityType => {
    return {
      id: entityType.name,
      label: (0,commons_locale__WEBPACK_IMPORTED_MODULE_7__.localize)(entityType.label),
      type: systemEntityTypeIds.includes(entityType.name) ? admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.ENTITY_TYPE_BUILTIN : admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.ENTITY_TYPE_CUSTOM,
      config: entityType
    };
  });
};

/**
 * Finds overridden builtin entity types, by comparing instance and
 * builtin entity types. An builtin entity type is overridden if there's
 * an instance entity type with matching name.
 *
 * @returns {object[]}
 */
const getOverriddenBuiltinEntityTypes = () => {
  const instanceEntityTypes = commons_registry__WEBPACK_IMPORTED_MODULE_5__["default"].getInstanceConfig().entitytypes || [];
  const builtinEntityTypeNames = (0,commons_types_utils_entityType__WEBPACK_IMPORTED_MODULE_11__.getBuiltinEntityTypeNames)();
  return instanceEntityTypes.filter(instanceEntityType => {
    return builtinEntityTypeNames.includes(instanceEntityType.name);
  });
};

/**
 * Finds custom entity types, by comparing instance and builtin entity
 * types. It's a custom instance entity type if there's no builtin entity
 * type with matching name.
 *
 * @returns {object[]}
 */
const getCustomInstanceEntityTypes = () => {
  const builtinEntityTypeNames = (0,commons_types_utils_entityType__WEBPACK_IMPORTED_MODULE_11__.getBuiltinEntityTypeNames)();
  const instanceEntityTypes = commons_registry__WEBPACK_IMPORTED_MODULE_5__["default"].getInstanceConfig().entitytypes || [];
  return instanceEntityTypes.filter(instanceEntityType => {
    return !builtinEntityTypeNames.includes(instanceEntityType.name);
  });
};

/**
 * Migrates overridden builtin entity types and custom entity types from
 * instance config. Only overridden values for builtin entity types are
 * migrated.
 *
 * @returns {Entry[]}
 */
const migrateEntityTypesToStore = async () => {
  const overriddenEntityTypes = getOverriddenBuiltinEntityTypes();
  const customInstanceEntityTypes = getCustomInstanceEntityTypes();
  const entityTypeEntries = await (0,admin_configs_utils_configQuery__WEBPACK_IMPORTED_MODULE_9__.migrateTypesToStore)({
    types: [...overriddenEntityTypes, ...customInstanceEntityTypes],
    idPrefix: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.ENTITY_TYPE_ID_PREFIX,
    fieldDefinitions: _fieldDefinitions__WEBPACK_IMPORTED_MODULE_12__,
    rdfType: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.RDF_CLASS_ENTITY_TYPE
  });
  return entityTypeEntries;
};

/**
 * @returns {Promise<object[]>}
 */
const getEntityTypeEntries = () => {
  return (0,admin_configs_utils_configQuery__WEBPACK_IMPORTED_MODULE_9__.getConfigEntries)({
    rdfType: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.RDF_CLASS_ENTITY_TYPE
  });
};

/**
 * Extracts builtin entity types. If an builtin entity type has a
 * matching entry it means it's overridden.
 *
 * @param {Entry[]} entityTypeEntries
 * @returns {object[]}
 */
const getBuiltinEntityTypes = entityTypeEntries => {
  const builtinEntityTypeConfigs = commons_registry__WEBPACK_IMPORTED_MODULE_5__["default"].getApplicationConfig().entitytypes;
  const builtinEntityTypes = builtinEntityTypeConfigs.map(builtinEntityTypeConfig => {
    const {
      name,
      label
    } = builtinEntityTypeConfig;
    const id = `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.ENTITY_TYPE_ID_PREFIX}-${name}`;
    const builtinEntityTypeEntry = entityTypeEntries.find(entityTypeEntry => entityTypeEntry.getId() === id);
    if (builtinEntityTypeEntry) {
      return {
        id,
        label: (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_8__.getLabel)(builtinEntityTypeEntry) || (0,commons_locale__WEBPACK_IMPORTED_MODULE_7__.localize)(label),
        entry: builtinEntityTypeEntry,
        type: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.ENTITY_TYPE_BUILTIN,
        config: builtinEntityTypeConfig
      };
    }
    return {
      id,
      label: (0,commons_locale__WEBPACK_IMPORTED_MODULE_7__.localize)(label),
      type: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.ENTITY_TYPE_BUILTIN,
      config: builtinEntityTypeConfig
    };
  });
  return builtinEntityTypes;
};

/**
 * Extracts custom entity types from array of entity type entries. If there's no
 * matching builtin entity type, it's a custom entity type.
 *
 * @param {Entry[]} entityTypeEntries
 * @returns {object[]}
 */
const getCustomEntityTypes = entityTypeEntries => {
  // exlude builtin entity types
  const builtinEntityTypeConfigs = commons_registry__WEBPACK_IMPORTED_MODULE_5__["default"].getApplicationConfig().entitytypes;
  const customEntityTypesEntries = entityTypeEntries.filter(entityTypeEntry => !builtinEntityTypeConfigs.find(_ref2 => {
    let {
      name
    } = _ref2;
    return entityTypeEntry.getId() === `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.ENTITY_TYPE_ID_PREFIX}-${name}`;
  }));
  return customEntityTypesEntries.map(customEntityTypeEntry => ({
    id: customEntityTypeEntry.getId(),
    label: (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_8__.getLabel)(customEntityTypeEntry),
    type: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.ENTITY_TYPE_CUSTOM,
    entry: customEntityTypeEntry
  }));
};

/**
 * Filters entity types on type
 *
 * @param {Entry[]} entityTypeEntries
 * @param {string} typeOfEntityType
 * @returns {Entry[]}
 */
const getEntityTypesByFilter = (entityTypeEntries, typeOfEntityType) => {
  if (!entityTypeEntries) return [];
  if (typeOfEntityType === admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.ENTITY_TYPE_BUILTIN) return getBuiltinEntityTypes(entityTypeEntries);
  if (typeOfEntityType === admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_10__.ENTITY_TYPE_CUSTOM) return getCustomEntityTypes(entityTypeEntries);
  return [...getBuiltinEntityTypes(entityTypeEntries), ...getCustomEntityTypes(entityTypeEntries)];
};

/***/ }),

/***/ "./modules/admin/configs/entitytypes/utils/fieldDefinitions.js":
/*!*********************************************************************!*\
  !*** ./modules/admin/configs/entitytypes/utils/fieldDefinitions.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   allContexts: () => (/* binding */ allContexts),
/* harmony export */   constraints: () => (/* binding */ constraints),
/* harmony export */   context: () => (/* binding */ context),
/* harmony export */   createOptions: () => (/* binding */ createOptions),
/* harmony export */   description: () => (/* binding */ description),
/* harmony export */   faClass: () => (/* binding */ faClass),
/* harmony export */   global: () => (/* binding */ global),
/* harmony export */   iconId: () => (/* binding */ iconId),
/* harmony export */   includeFile: () => (/* binding */ includeFile),
/* harmony export */   includeInternal: () => (/* binding */ includeInternal),
/* harmony export */   includeLink: () => (/* binding */ includeLink),
/* harmony export */   inlineCreation: () => (/* binding */ inlineCreation),
/* harmony export */   label: () => (/* binding */ label),
/* harmony export */   main: () => (/* binding */ main),
/* harmony export */   module: () => (/* binding */ module),
/* harmony export */   publishControl: () => (/* binding */ publishControl),
/* harmony export */   rdfType: () => (/* binding */ rdfType),
/* harmony export */   refines: () => (/* binding */ refines),
/* harmony export */   restrictTo: () => (/* binding */ restrictTo),
/* harmony export */   searchProps: () => (/* binding */ searchProps),
/* harmony export */   storeConfig: () => (/* binding */ storeConfig),
/* harmony export */   template: () => (/* binding */ template),
/* harmony export */   templateLevel: () => (/* binding */ templateLevel),
/* harmony export */   uriPattern: () => (/* binding */ uriPattern),
/* harmony export */   useWith: () => (/* binding */ useWith)
/* harmony export */ });
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var admin_configs_utils_exporters__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! admin/configs/utils/exporters */ "./modules/admin/configs/utils/exporters.js");
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");



const template = {
  name: 'template',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.LITERAL,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:template`,
  labelNlsKey: 'templateLabel',
  mandatory: true,
  max: 1
};
const label = {
  name: 'label',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.LANGUAGE_LITERAL,
  property: 'dcterms:title',
  labelNlsKey: 'labelLabel',
  mandatory: true
};
const rdfType = {
  name: 'rdfType',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.BLANK,
  property: `rfs:constraint`,
  toGraph: admin_configs_utils_exporters__WEBPACK_IMPORTED_MODULE_1__.addConstraintFromRdfType,
  labelNlsKey: 'rdfTypeLabel',
  hidden: true
};
const constraints = {
  name: 'constraints',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.BLANK,
  property: `rfs:constraint`,
  toGraph: admin_configs_utils_exporters__WEBPACK_IMPORTED_MODULE_1__.addConstraints,
  labelNlsKey: 'constraintsLabel',
  max: 1
};
const description = {
  name: 'description',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.LANGUAGE_LITERAL,
  property: 'dcterms:description',
  labelNlsKey: 'descriptionLabel'
};
const module = {
  name: 'module',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.LITERAL,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:module`,
  choices: [{
    value: 'catalog',
    label: {
      en: 'Catalog'
    }
  }, {
    value: 'workbench',
    label: {
      en: 'Workbench'
    }
  }, {
    value: 'toolkit',
    label: {
      en: 'Toolkit'
    }
  }, {
    value: 'terms',
    label: {
      en: 'Terms'
    }
  }, {
    value: 'admin',
    label: {
      en: 'Admin'
    }
  }, {
    value: 'models',
    label: {
      en: 'Models'
    }
  }],
  labelNlsKey: 'moduleLabel'
};
const includeInternal = {
  name: 'includeInternal',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.DATATYPE_LITERAL,
  datatype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.XSD_BOOLEAN,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:includeInternal`,
  labelNlsKey: 'includeInternalLabel'
};
const inlineCreation = {
  name: 'inlineCreation',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.DATATYPE_LITERAL,
  datatype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.XSD_BOOLEAN,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:inlineCreation`,
  labelNlsKey: 'inlineCreationLabel'
};
const includeFile = {
  name: 'includeFile',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.DATATYPE_LITERAL,
  datatype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.XSD_BOOLEAN,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:includeFile`,
  labelNlsKey: 'includeFileLabel'
};
const includeLink = {
  name: 'includeLink',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.DATATYPE_LITERAL,
  datatype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.XSD_BOOLEAN,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:includeLink`,
  labelNlsKey: 'includeLinkLabel'
};
const createOptions = {
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.GROUP,
  property: 'createOptions',
  direction: 'row',
  labelNlsKey: 'createOptionsLabel',
  max: 1
};

// faClass is renamed to iconId
const faClass = {
  name: 'faClass',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.LITERAL,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:iconId`,
  max: 1
};
const iconId = {
  name: 'iconId',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.LITERAL,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:iconId`,
  labelNlsKey: 'iconIdLabel',
  max: 1
};
const useWith = {
  name: 'useWidth',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.URI,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:useWith`,
  toGraph: admin_configs_utils_exporters__WEBPACK_IMPORTED_MODULE_1__.addURIFromName,
  labelNlsKey: 'useWithLabel',
  max: 1
};
const refines = {
  name: 'refines',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.URI,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:refines`,
  toGraph: admin_configs_utils_exporters__WEBPACK_IMPORTED_MODULE_1__.addURIFromName,
  labelNlsKey: 'refinesLabel',
  max: 1
};
const templateLevel = {
  name: 'templateLevel',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.LITERAL,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:templateLevel`,
  labelNlsKey: 'templateLevelLabel',
  choices: [{
    value: 'mandatory',
    label: {
      en: 'Mandatory'
    }
  }, {
    value: 'recommended',
    label: {
      en: 'Recommended'
    }
  }, {
    value: 'optional',
    label: {
      en: 'Optional'
    }
  }],
  row: true,
  max: 1
};
const publishControl = {
  name: 'publishControl',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.DATATYPE_LITERAL,
  datatype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.XSD_BOOLEAN,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:publishControl`,
  labelNlsKey: 'publishControlLabel'
};
const searchProps = {
  name: 'searchProps',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.URI,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:searchProps`,
  labelNlsKey: 'searchPropsLabel'
};
const allContexts = {
  name: 'allContexts',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.DATATYPE_LITERAL,
  datatype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.XSD_BOOLEAN,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:allContexts`,
  labelNlsKey: 'allContextsLabel',
  max: 1
};
const context = {
  name: 'context',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.URI,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:context`,
  labelNlsKey: 'contextLabel'
};
const uriPattern = {
  name: 'uriPattern',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.LITERAL,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:uriPattern`,
  labelNlsKey: 'uriPatternLabel',
  max: 1
};
const restrictTo = {
  name: 'restrictTo',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.URI,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:restrictTo`,
  labelNlsKey: 'restrictToLabel',
  max: 1
};
const global = {
  name: 'global',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.DATATYPE_LITERAL,
  datatype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.XSD_BOOLEAN,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:global`,
  labelNlsKey: 'globalLabel'
};
const main = {
  name: 'main',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.DATATYPE_LITERAL,
  datatype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.XSD_BOOLEAN,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:main`,
  labelNlsKey: 'mainLabel',
  max: 1
};
const storeConfig = {
  name: 'storeConfig',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.BLANK,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:storeConfig`,
  labelNlsKey: 'storeConfigLabel',
  toGraph: admin_configs_utils_exporters__WEBPACK_IMPORTED_MODULE_1__.addStoreConfig,
  max: 1
};

/***/ }),

/***/ "./modules/admin/configs/projecttypes/EntityTypeSelectDialog/EntityTypeSelectDialog.js":
/*!*********************************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/EntityTypeSelectDialog/EntityTypeSelectDialog.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.string.search.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.search.js");
/* harmony import */ var core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_search_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_components_filters_utils_filter__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/filters/utils/filter */ "./modules/commons/components/filters/utils/filter.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Button/Button.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Box/Box.js");
/* harmony import */ var _mui_icons_material_Settings__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @mui/icons-material/Settings */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Settings.js");
/* harmony import */ var _mui_icons_material_Widgets__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @mui/icons-material/Widgets */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Widgets.js");
/* harmony import */ var _mui_icons_material_Info__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @mui/icons-material/Info */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Info.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/components/FieldsLinkedDataBrowserDialog */ "./modules/commons/components/FieldsLinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! admin/nls/esadType.nls */ "./modules/admin/nls/esadType.nls");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var admin_nls_esadEntityTypeSelect_nls__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! admin/nls/esadEntityTypeSelect.nls */ "./modules/admin/nls/esadEntityTypeSelect.nls");
/* harmony import */ var admin_nls_esadEntityTypeSelect_nls__WEBPACK_IMPORTED_MODULE_20___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadEntityTypeSelect_nls__WEBPACK_IMPORTED_MODULE_20__);
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! admin/nls/esadEntityType.nls */ "./modules/admin/nls/esadEntityType.nls");
/* harmony import */ var admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_21___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_21__);
/* harmony import */ var admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! admin/nls/esadProjectType.nls */ "./modules/admin/nls/esadProjectType.nls");
/* harmony import */ var admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_22___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_22__);
/* harmony import */ var admin_configs_entitytypes_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! admin/configs/entitytypes/utils/entityTypeQuery */ "./modules/admin/configs/entitytypes/utils/entityTypeQuery.js");
/* harmony import */ var admin_configs_entitytypes_utils_entityTypePresenters__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! admin/configs/entitytypes/utils/entityTypePresenters */ "./modules/admin/configs/entitytypes/utils/entityTypePresenters.js");
/* harmony import */ var admin_configs_utils_exporters__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! admin/configs/utils/exporters */ "./modules/admin/configs/utils/exporters.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

























const nlsBundles = [(admin_nls_esadEntityTypeSelect_nls__WEBPACK_IMPORTED_MODULE_20___default()), (admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_19___default()), (admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_22___default()), (admin_nls_esadEntityType_nls__WEBPACK_IMPORTED_MODULE_21___default())];
const SEARCH_FIELDS = ['label'];
const EntityTypeSelectDialog = _ref => {
  let {
    selection,
    closeDialog,
    onSelect,
    isDisabled
  } = _ref;
  const [selectedEntityTypes, setSelectedEntityTypes] = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(selection);
  const [showAllEntityTypes, setShowAllEntityTypes] = (0,react__WEBPACK_IMPORTED_MODULE_14__.useState)(true);
  const [{
    search,
    refreshCount
  }, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.useListModel)();
  const {
    entries: entityTypeEntries,
    status
  } = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.useFetchEntries)({
    fetchEntries: admin_configs_entitytypes_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_23__.getEntityTypeEntries,
    refreshCount
  });
  const instanceAndBuiltinEntityTypes = (0,react__WEBPACK_IMPORTED_MODULE_14__.useMemo)(() => {
    return (0,admin_configs_entitytypes_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_23__.getEntityTypesByFilter)(entityTypeEntries);
  }, [entityTypeEntries]);
  const {
    result: entityTypes,
    size
  } = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.useListQuery)({
    items: showAllEntityTypes ? instanceAndBuiltinEntityTypes : selectedEntityTypes,
    searchFields: SEARCH_FIELDS
  });
  const _onChange = (event, entityType) => {
    const {
      checked
    } = event.target;
    if (checked) {
      setSelectedEntityTypes([...selectedEntityTypes, entityType]);
    } else {
      setSelectedEntityTypes(selectedEntityTypes.filter(item => item.id !== entityType.id));
    }
  };
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_18__.useTranslation)(nlsBundles);
  const presenterAction = {
    Dialog: commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_17__["default"],
    idPrefix: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_15__.ENTITY_TYPE_ID_PREFIX,
    fields: admin_configs_entitytypes_utils_entityTypePresenters__WEBPACK_IMPORTED_MODULE_24__.fieldPresenters,
    nlsKeyLabel: 'typeInfoDialogTitle',
    nlsBundles
  };
  const selectAction = /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_9__["default"], {
    onClick: () => onSelect(selectedEntityTypes)
  }, translate('entityTypeSelectDialogButtonLabel'));
  const onShowAllToggle = () => {
    setShowAllEntityTypes(!showAllEntityTypes);
    dispatch({
      type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.PAGINATE,
      value: 0
    });
  };
  return /*#__PURE__*/React.createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_6__["default"], {
    title: translate('entityTypeSelectDialogTitle'),
    maxWidth: "lg",
    fixedHeight: true,
    closeDialog: closeDialog,
    actions: selectAction
  }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListView, {
    search: search,
    size: size,
    nlsBundles: nlsBundles,
    status: size === 0 && status === 'resolved' ? 'idle' : status
  }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListActions, null, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListSearch, null), /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_16__.RefreshButton, null), /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_10__["default"], {
    sx: {
      marginLeft: 'auto'
    }
  }, /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_9__["default"], {
    disabled: showAllEntityTypes && !selectedEntityTypes.length,
    variant: "text",
    onClick: onShowAllToggle
  }, showAllEntityTypes ? translate('showSelectedLabel') : translate('showAllLabel')))), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.List, {
    renderPlaceholder: Placeholder => /*#__PURE__*/React.createElement(Placeholder, {
      label: translate((0,commons_components_filters_utils_filter__WEBPACK_IMPORTED_MODULE_8__.getNoResultsNLS)(Boolean(search), !showAllEntityTypes), search)
    })
  }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListHeader, null, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListHeaderItemText, {
    xs: 1,
    text: ""
  }), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListHeaderItemSort, {
    xs: 11,
    sortBy: "label",
    text: translate('labelListHeader')
  })), entityTypes.map(entityType => {
    const {
      id,
      label,
      type,
      entry
    } = entityType;
    const disabled = isDisabled(id);
    const isBuiltin = type === admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_15__.ENTITY_TYPE_BUILTIN;
    const title = translate(presenterAction.nlsKeyLabel);
    const typeInfoAction = _objectSpread(_objectSpread({}, presenterAction), {}, {
      entry,
      title
    }, (0,admin_configs_utils_exporters__WEBPACK_IMPORTED_MODULE_25__.typeConfigToGraph)({
      entry,
      typeConfig: entityType.config,
      idPrefix: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_15__.ENTITY_TYPE_ID_PREFIX,
      fields: admin_configs_entitytypes_utils_entityTypePresenters__WEBPACK_IMPORTED_MODULE_24__.fieldPresenters
    }));
    return /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListItem, {
      key: id
    }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListItemIcon, {
      Icon: isBuiltin ? _mui_icons_material_Settings__WEBPACK_IMPORTED_MODULE_11__["default"] : _mui_icons_material_Widgets__WEBPACK_IMPORTED_MODULE_12__["default"],
      tooltip: isBuiltin ? translate('builtinLabel') : translate('customLabel')
    }), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListItemText, {
      xs: 8,
      primary: label
    }), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListItemActionIconButton, {
      title: translate(presenterAction.nlsKeyLabel),
      action: typeInfoAction,
      xs: 2
    }, /*#__PURE__*/React.createElement(_mui_icons_material_Info__WEBPACK_IMPORTED_MODULE_13__["default"], null)), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListItemCheckbox, {
      ariaLabel: label,
      checked: Boolean(selectedEntityTypes.find(item => item.id === entityType.id)),
      disabled: disabled,
      onChange: event => _onChange(event, entityType),
      tooltip: disabled ? translate('disabledSelectionTooltip') : null
    }));
  })), /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.ListPagination, null)));
};
EntityTypeSelectDialog.propTypes = {
  selection: prop_types__WEBPACK_IMPORTED_MODULE_5___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape({})).isRequired,
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  onSelect: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  isDisabled: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.withListModelProvider)(EntityTypeSelectDialog, () => ({
  sort: {
    field: 'label',
    order: 'asc'
  }
})));

/***/ }),

/***/ "./modules/admin/configs/projecttypes/EntityTypeSelectDialog/index.js":
/*!****************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/EntityTypeSelectDialog/index.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _EntityTypeSelectDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _EntityTypeSelectDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EntityTypeSelectDialog */ "./modules/admin/configs/projecttypes/EntityTypeSelectDialog/EntityTypeSelectDialog.js");


/***/ }),

/***/ "./modules/admin/configs/projecttypes/EntityTypeSelectEditor/EntityTypeSelectEditor.js":
/*!*********************************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/EntityTypeSelectEditor/EntityTypeSelectEditor.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Box/Box.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Button/Button.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/FormHelperText/FormHelperText.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var admin_nls_esadEntityTypeSelect_nls__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! admin/nls/esadEntityTypeSelect.nls */ "./modules/admin/nls/esadEntityTypeSelect.nls");
/* harmony import */ var admin_nls_esadEntityTypeSelect_nls__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadEntityTypeSelect_nls__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/nls/escoForms.nls */ "./modules/commons/nls/escoForms.nls");
/* harmony import */ var commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/types/utils/uri */ "./modules/commons/types/utils/uri.js");
/* harmony import */ var admin_configs_projecttypes_utils_fieldDefinitions__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! admin/configs/projecttypes/utils/fieldDefinitions */ "./modules/admin/configs/projecttypes/utils/fieldDefinitions.js");
/* harmony import */ var admin_configs_entitytypes_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! admin/configs/entitytypes/utils/entityTypeQuery */ "./modules/admin/configs/entitytypes/utils/entityTypeQuery.js");
/* harmony import */ var commons_components_forms_editors_hooks_useFieldsEdit__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/components/forms/editors/hooks/useFieldsEdit */ "./modules/commons/components/forms/editors/hooks/useFieldsEdit.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var _EntityTypeSelectDialog__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../EntityTypeSelectDialog */ "./modules/admin/configs/projecttypes/EntityTypeSelectDialog/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");




















const NLS_BUNDLES = [(admin_nls_esadEntityTypeSelect_nls__WEBPACK_IMPORTED_MODULE_11___default()), (commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_12___default())];
const EntityTypeSelectEditor = _ref => {
  let {
    name,
    nodetype,
    graph,
    resourceURI,
    property,
    label,
    mandatory,
    dispatch
  } = _ref;
  const {
    fields,
    error,
    labelId,
    addField,
    removeField,
    updateValue
  } = (0,commons_components_forms_editors_hooks_useFieldsEdit__WEBPACK_IMPORTED_MODULE_19__.useFieldsEdit)({
    name,
    property,
    nodetype,
    graph,
    resourceURI,
    mandatory,
    dispatch,
    insertEmptyField: false
  });
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__.useTranslation)(NLS_BUNDLES);
  const [showEntityTypeSelectDialog, setShowEntityTypeSelectDialog] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)(false);
  const selectedResourceURIs = fields.map(field => field.getValue());
  const disabledResourceURIs = graph.find(resourceURI, property === admin_configs_projecttypes_utils_fieldDefinitions__WEBPACK_IMPORTED_MODULE_17__.optional.property ? admin_configs_projecttypes_utils_fieldDefinitions__WEBPACK_IMPORTED_MODULE_17__.defaults.property : admin_configs_projecttypes_utils_fieldDefinitions__WEBPACK_IMPORTED_MODULE_17__.optional.property).map(statement => statement.getValue());
  const [{
    refreshCount
  }] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__.useListModel)();
  const {
    entries: entityTypeEntries,
    status
  } = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__.useFetchEntries)({
    fetchEntries: admin_configs_entitytypes_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_18__.getEntityTypeEntries,
    refreshCount
  });
  const instanceAndBuiltinEntityTypes = (0,react__WEBPACK_IMPORTED_MODULE_6__.useMemo)(() => {
    return status === commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_20__.RESOLVED ? (0,admin_configs_entitytypes_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_18__.getEntityTypesByFilter)(entityTypeEntries) : null;
  }, [entityTypeEntries, status]);
  const {
    result: entityTypes,
    size
  } = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__.useListQuery)({
    items: instanceAndBuiltinEntityTypes,
    searchFields: []
  });
  const selectedEntityTypes = entityTypes.filter(entityType => selectedResourceURIs.includes((0,commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_16__.nameToURI)(entityType.id, admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_15__.CONFIG_CONTEXT)));
  const _onSelect = selection => {
    fields.forEach(fieldToRemove => removeField(fieldToRemove));
    selection.forEach(entityType => {
      const field = addField();
      updateValue(field, (0,commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_16__.nameToURI)(entityType.id, admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_15__.CONFIG_CONTEXT));
    });
  };
  const isDisabled = entityTypeId => disabledResourceURIs.includes((0,commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_16__.nameToURI)(entityTypeId, admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_15__.CONFIG_CONTEXT));
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_13__.Fields, {
    mandatory: mandatory,
    labelId: labelId,
    label: label,
    max: 1
  }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__.ListView, {
    status: status,
    size: size,
    renderPlaceholder: () => /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], {
      sx: {
        fontStyle: 'italic'
      }
    }, translate('selectionListPlaceholder')), /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], {
      variant: "text",
      onClick: () => setShowEntityTypeSelectDialog(true),
      sx: {
        paddingLeft: 0,
        paddingRight: 0
      }
    }, translate('addSelectionLabel')))
  }, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__.List, null, /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_13__.SelectionListItem, {
    translate: translate,
    label: translate('selectionListLabel'),
    onClick: () => setShowEntityTypeSelectDialog(true),
    selection: selectedEntityTypes,
    disabled: status !== 'resolved'
  }))), error ? /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_9__["default"], {
    error: true
  }, translate(error)) : null), showEntityTypeSelectDialog ? /*#__PURE__*/React.createElement(_EntityTypeSelectDialog__WEBPACK_IMPORTED_MODULE_21__["default"], {
    closeDialog: () => {
      setShowEntityTypeSelectDialog(false);
    },
    onSelect: selection => {
      _onSelect(selection);
      setShowEntityTypeSelectDialog(false);
    },
    isDisabled: isDisabled,
    selection: selectedEntityTypes
  }) : null);
};
EntityTypeSelectEditor.propTypes = {
  name: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  nodetype: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string).isRequired,
  graph: commons_util_entry__WEBPACK_IMPORTED_MODULE_5__.graphPropType,
  resourceURI: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  property: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  label: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().string),
  mandatory: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().bool),
  dispatch: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__.withListModelProvider)(EntityTypeSelectEditor, () => ({
  sort: {
    field: 'label',
    order: 'asc'
  }
})));

/***/ }),

/***/ "./modules/admin/configs/projecttypes/EntityTypeSelectEditor/index.js":
/*!****************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/EntityTypeSelectEditor/index.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   EntityTypeSelectEditor: () => (/* reexport safe */ _EntityTypeSelectEditor__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _EntityTypeSelectEditor__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EntityTypeSelectEditor */ "./modules/admin/configs/projecttypes/EntityTypeSelectEditor/EntityTypeSelectEditor.js");


/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeCreateDialog/ProjectTypeCreateDialog.js":
/*!***********************************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeCreateDialog/ProjectTypeCreateDialog.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var admin_configs_types_TypeCreateDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! admin/configs/types/TypeCreateDialog */ "./modules/admin/configs/types/TypeCreateDialog/index.js");
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! admin/nls/esadType.nls */ "./modules/admin/nls/esadType.nls");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! admin/nls/esadProjectType.nls */ "./modules/admin/nls/esadProjectType.nls");
/* harmony import */ var admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var admin_configs_utils_configQuery__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! admin/configs/utils/configQuery */ "./modules/admin/configs/utils/configQuery.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var _ProjectTypeForm__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../ProjectTypeForm */ "./modules/admin/configs/projecttypes/ProjectTypeForm/index.js");
/* harmony import */ var _utils_editorFields__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/editorFields */ "./modules/admin/configs/projecttypes/utils/editorFields.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");














const NLS_BUNDLES = [(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_7___default()), (admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_8___default())];
const CreateProjectTypeDialog = _ref => {
  let {
    closeDialog
  } = _ref;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_6__.useTranslation)(NLS_BUNDLES);
  const [prototypeEntry, setPrototypeEntry] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)();
  const {
    runAsync
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_11__["default"])();
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    runAsync((0,admin_configs_utils_configQuery__WEBPACK_IMPORTED_MODULE_10__.getOrCreateConfigContextEntry)().then(contextEntry => {
      const context = contextEntry.getResource(true);
      setPrototypeEntry(context.newEntry());
    }));
  }, [setPrototypeEntry, runAsync]);
  return prototypeEntry ? /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_4__.EditorProvider, {
    entry: prototypeEntry
  }, /*#__PURE__*/React.createElement(admin_configs_types_TypeCreateDialog__WEBPACK_IMPORTED_MODULE_3__["default"], {
    title: translate('createHeader'),
    closeDialog: closeDialog,
    rdfTypes: [admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_9__.RDF_CLASS_PROJECT_TYPE],
    nlsBundles: NLS_BUNDLES,
    fields: _utils_editorFields__WEBPACK_IMPORTED_MODULE_13__.editorFields
  }, /*#__PURE__*/React.createElement(_ProjectTypeForm__WEBPACK_IMPORTED_MODULE_12__["default"], {
    nlsBundles: NLS_BUNDLES
  }))) : null;
};
CreateProjectTypeDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CreateProjectTypeDialog);

/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeCreateDialog/index.js":
/*!*****************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeCreateDialog/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ProjectTypeCreateDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ProjectTypeCreateDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProjectTypeCreateDialog */ "./modules/admin/configs/projecttypes/ProjectTypeCreateDialog/ProjectTypeCreateDialog.js");


/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeEditDialog/ProjectTypeEditDialog.js":
/*!*******************************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeEditDialog/ProjectTypeEditDialog.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var admin_configs_types_TypeEditDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! admin/configs/types/TypeEditDialog */ "./modules/admin/configs/types/TypeEditDialog/index.js");
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var _utils_editorFields__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/editorFields */ "./modules/admin/configs/projecttypes/utils/editorFields.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");






const ProjectTypeEditDialog = _ref => {
  let {
    closeDialog,
    entry,
    onEdit,
    nlsBundles
  } = _ref;
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_4__.useTranslation)(nlsBundles);
  return /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_2__.EditorProvider, {
    entry: entry
  }, /*#__PURE__*/React.createElement(admin_configs_types_TypeEditDialog__WEBPACK_IMPORTED_MODULE_1__["default"], {
    title: t('editHeader'),
    closeDialog: closeDialog,
    nlsBundles: nlsBundles,
    fields: _utils_editorFields__WEBPACK_IMPORTED_MODULE_5__.editorFields,
    onEdit: onEdit
  }, /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_2__.Form, {
    fields: _utils_editorFields__WEBPACK_IMPORTED_MODULE_5__.editorFields,
    size: "small",
    nlsBundles: nlsBundles
  })));
};
ProjectTypeEditDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().func).isRequired,
  onEdit: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().func),
  entry: prop_types__WEBPACK_IMPORTED_MODULE_0___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_3__.Entry),
  nlsBundles: commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_4__.nlsBundlesPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProjectTypeEditDialog);

/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeEditDialog/index.js":
/*!***************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeEditDialog/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ProjectTypeEditDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ProjectTypeEditDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProjectTypeEditDialog */ "./modules/admin/configs/projecttypes/ProjectTypeEditDialog/ProjectTypeEditDialog.js");


/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeForm/ProjectTypeForm.js":
/*!*******************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeForm/ProjectTypeForm.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var _utils_editorFields__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/editorFields */ "./modules/admin/configs/projecttypes/utils/editorFields.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");



const ProjectTypeForm = _ref => {
  let {
    nlsBundles
  } = _ref;
  return /*#__PURE__*/React.createElement(commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_0__.Form, {
    nlsBundles: nlsBundles,
    fields: _utils_editorFields__WEBPACK_IMPORTED_MODULE_2__.editorFields,
    size: "small"
  });
};
ProjectTypeForm.propTypes = {
  nlsBundles: commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_1__.nlsBundlesPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProjectTypeForm);

/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeForm/index.js":
/*!*********************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeForm/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ProjectTypeForm__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ProjectTypeForm__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProjectTypeForm */ "./modules/admin/configs/projecttypes/ProjectTypeForm/ProjectTypeForm.js");


/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeOverview/ProjectTypeOverview.js":
/*!***************************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeOverview/ProjectTypeOverview.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/hooks/useEntry */ "./modules/commons/hooks/useEntry.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/hooks/useDocumentTitle */ "./modules/commons/hooks/useDocumentTitle.js");
/* harmony import */ var commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/hooks/usePageTitle */ "./modules/commons/hooks/usePageTitle.js");
/* harmony import */ var commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/hooks/useGetContributors */ "./modules/commons/hooks/useGetContributors.js");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/nls/escoOverview.nls */ "./modules/commons/nls/escoOverview.nls");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! admin/nls/esadContext.nls */ "./modules/admin/nls/esadContext.nls");
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! admin/nls/esadProjectType.nls */ "./modules/admin/nls/esadProjectType.nls");
/* harmony import */ var admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! admin/nls/esadType.nls */ "./modules/admin/nls/esadType.nls");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/overview/Overview */ "./modules/commons/components/overview/Overview/index.js");
/* harmony import */ var commons_components_overview__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/components/overview */ "./modules/commons/components/overview/index.js");
/* harmony import */ var commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/components/FieldsLinkedDataBrowserDialog */ "./modules/commons/components/FieldsLinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_locale__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/locale */ "./modules/commons/locale/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./actions */ "./modules/admin/configs/projecttypes/ProjectTypeOverview/actions.js");
/* harmony import */ var _utils_projectTypePresenters__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../utils/projectTypePresenters */ "./modules/admin/configs/projecttypes/utils/projectTypePresenters.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }






















const nlsBundles = [(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_6___default()), (commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_11___default()), (admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_12___default()), (admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_13___default()), (admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_14___default())];
const ProjectTypeOverview = () => {
  const entry = (0,commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_3__.useEntry)();
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__.useTranslation)(nlsBundles);
  const [{
    refreshCount
  }] = (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_17__.useOverviewModel)();
  const {
    contributors
  } = (0,commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_10__["default"])(entry, refreshCount);
  const [pageTitle] = (0,commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_9__["default"])();
  const viewDefinition = (0,commons_util_site__WEBPACK_IMPORTED_MODULE_5__.getViewDefFromName)('admin__projecttypes__projecttype');
  const viewDefinitionTitle = (0,commons_locale__WEBPACK_IMPORTED_MODULE_19__.localize)(viewDefinition.title);
  const descriptionItems = [commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_15__.DESCRIPTION_UPDATED, {
    id: 'edited',
    labelNlsKey: 'editedByLabel',
    getValues: () => contributors
  }];
  (0,commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_8__["default"])(`${pageTitle} - ${viewDefinitionTitle} ${(0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_4__.getLabel)(entry)}`);
  return /*#__PURE__*/React.createElement(commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_16__["default"], {
    backLabel: t('backTitle'),
    headerAction: _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_15__.ACTION_INFO_WITH_ICON), {}, {
      Dialog: commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_18__["default"],
      getProps: () => ({
        action: {
          fields: _utils_projectTypePresenters__WEBPACK_IMPORTED_MODULE_21__.fieldPresenters
        }
      })
    }),
    entry: entry,
    nlsBundles: nlsBundles,
    descriptionItems: descriptionItems,
    sidebarActions: _actions__WEBPACK_IMPORTED_MODULE_20__.sidebarActions,
    returnTo: "/admin/projecttypes"
  });
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_overview__WEBPACK_IMPORTED_MODULE_17__.withOverviewModelProvider)(ProjectTypeOverview));

/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeOverview/actions.js":
/*!***************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeOverview/actions.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   rowActions: () => (/* binding */ rowActions),
/* harmony export */   sidebarActions: () => (/* binding */ sidebarActions)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var commons_components_overview__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/components/overview */ "./modules/commons/components/overview/index.js");
/* harmony import */ var _ProjectTypeEditDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../ProjectTypeEditDialog */ "./modules/admin/configs/projecttypes/ProjectTypeEditDialog/index.js");
/* harmony import */ var _ProjectTypeRemoveDialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../ProjectTypeRemoveDialog */ "./modules/admin/configs/projecttypes/ProjectTypeRemoveDialog/index.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




const sidebarActions = [_objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_EDIT), {}, {
  Dialog: (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_2__.withOverviewRefresh)(_ProjectTypeEditDialog__WEBPACK_IMPORTED_MODULE_3__["default"], 'onEdit'),
  getProps: () => ({
    action: {
      formTemplateId: 'esc:Group'
    }
  })
}), commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REVISIONS, _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REMOVE), {}, {
  Dialog: _ProjectTypeRemoveDialog__WEBPACK_IMPORTED_MODULE_4__["default"]
})];
const rowActions = [commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REVISIONS];

/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeOverview/index.js":
/*!*************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeOverview/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ProjectTypeOverview__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ProjectTypeOverview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProjectTypeOverview */ "./modules/admin/configs/projecttypes/ProjectTypeOverview/ProjectTypeOverview.js");


/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeRemoveDialog/ProjectTypeRemoveDialog.js":
/*!***********************************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeRemoveDialog/ProjectTypeRemoveDialog.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_entry_RemoveEntryDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/entry/RemoveEntryDialog */ "./modules/commons/components/entry/RemoveEntryDialog/index.js");
/* harmony import */ var commons_components_router_useNavigate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/components/router/useNavigate */ "./modules/commons/components/router/useNavigate.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");

function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }



const ProjectTypeRemoveDialog = props => {
  const {
    navigate
  } = (0,commons_components_router_useNavigate__WEBPACK_IMPORTED_MODULE_2__["default"])();
  return /*#__PURE__*/React.createElement(commons_components_entry_RemoveEntryDialog__WEBPACK_IMPORTED_MODULE_1__["default"], _extends({}, props, {
    onRemoveCallback: () => navigate((0,commons_util_site__WEBPACK_IMPORTED_MODULE_3__.getPathFromViewName)('admin__projecttypes'))
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ProjectTypeRemoveDialog);

/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeRemoveDialog/index.js":
/*!*****************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeRemoveDialog/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ProjectTypeRemoveDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ProjectTypeRemoveDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProjectTypeRemoveDialog */ "./modules/admin/configs/projecttypes/ProjectTypeRemoveDialog/ProjectTypeRemoveDialog.js");


/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeView/ProjectTypeView.js":
/*!*******************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeView/ProjectTypeView.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/hooks/useUser */ "./modules/commons/hooks/useUser.js");
/* harmony import */ var commons_util_solr_context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/util/solr/context */ "./modules/commons/util/solr/context.js");
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/components/FieldsLinkedDataBrowserDialog */ "./modules/commons/components/FieldsLinkedDataBrowserDialog/index.js");
/* harmony import */ var _utils_projectTypePresenters__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../utils/projectTypePresenters */ "./modules/admin/configs/projecttypes/utils/projectTypePresenters.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./actions */ "./modules/admin/configs/projecttypes/ProjectTypeView/actions.js");
/* harmony import */ var _ProjectTypeEditDialog_ProjectTypeEditDialog__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../ProjectTypeEditDialog/ProjectTypeEditDialog */ "./modules/admin/configs/projecttypes/ProjectTypeEditDialog/ProjectTypeEditDialog.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
















const ProjectTypeView = () => {
  const {
    userEntry,
    userInfo
  } = (0,commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__.useUserState)();
  const createQuery = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
    const [query] = (0,commons_util_solr_context__WEBPACK_IMPORTED_MODULE_6__.getSearchQuery)({
      rdfType: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_7__.RDF_CLASS_PROJECT_TYPE,
      contextType: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_7__.CONFIG_CONTEXT
    }, {
      userEntry,
      userInfo
    });
    return query;
  }, [userEntry, userInfo]);
  const queryResults = (0,commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.useSolrQuery)({
    createQuery
  });
  return /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.EntryListView
  // eslint-disable-next-line react/jsx-props-no-spreading
  , _extends({}, queryResults, {
    nlsBundles: _actions__WEBPACK_IMPORTED_MODULE_14__.nlsBundles,
    listActions: _actions__WEBPACK_IMPORTED_MODULE_14__.listActions,
    listActionsProps: {
      userEntry,
      userInfo
    },
    columns: [_objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.TITLE_COLUMN), {}, {
      xs: 8
    }), commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.MODIFIED_COLUMN, _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.ACTIONS_GROUP_COLUMN), {}, {
      actions: [_objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_10__.LIST_ACTION_INFO), {}, {
        Dialog: commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_12__["default"],
        fields: _utils_projectTypePresenters__WEBPACK_IMPORTED_MODULE_13__.fieldPresenters
      }), _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_10__.LIST_ACTION_EDIT), {}, {
        Dialog: (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.withListRerender)(_ProjectTypeEditDialog_ProjectTypeEditDialog__WEBPACK_IMPORTED_MODULE_15__["default"], 'onEdit')
      })]
    })],
    getListItemProps: _ref => {
      let {
        entry
      } = _ref;
      return {
        to: (0,commons_util_site__WEBPACK_IMPORTED_MODULE_11__.getPathFromViewName)('admin__projecttypes__projecttype', {
          entryId: entry.getId(),
          contextId: entry.getContext().getId()
        })
      };
    }
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.withListModelProviderAndLocation)(ProjectTypeView));

/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeView/actions.js":
/*!***********************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeView/actions.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   listActions: () => (/* binding */ listActions),
/* harmony export */   nlsBundles: () => (/* binding */ nlsBundles),
/* harmony export */   presenterAction: () => (/* binding */ presenterAction),
/* harmony export */   rowActions: () => (/* binding */ rowActions)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_EntryListView_dialogs_ListRemoveEntryDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/EntryListView/dialogs/ListRemoveEntryDialog */ "./modules/commons/components/EntryListView/dialogs/ListRemoveEntryDialog/index.js");
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_actions_actionIds__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/actions/actionIds */ "./modules/commons/actions/actionIds.js");
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! admin/nls/esadProjectType.nls */ "./modules/admin/nls/esadProjectType.nls");
/* harmony import */ var admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! admin/nls/esadType.nls */ "./modules/admin/nls/esadType.nls");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/FieldsLinkedDataBrowserDialog */ "./modules/commons/components/FieldsLinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var _ProjectTypeCreateDialog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../ProjectTypeCreateDialog */ "./modules/admin/configs/projecttypes/ProjectTypeCreateDialog/index.js");
/* harmony import */ var _ProjectTypeEditDialog__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../ProjectTypeEditDialog */ "./modules/admin/configs/projecttypes/ProjectTypeEditDialog/index.js");
/* harmony import */ var _utils_projectTypePresenters__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../utils/projectTypePresenters */ "./modules/admin/configs/projecttypes/utils/projectTypePresenters.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }












const nlsBundles = [(admin_nls_esadProjectType_nls__WEBPACK_IMPORTED_MODULE_5___default()), (admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_7___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_6___default())];
const listActions = [{
  id: 'create',
  Dialog: _ProjectTypeCreateDialog__WEBPACK_IMPORTED_MODULE_10__["default"],
  labelNlsKey: 'addLabel',
  tooltipNlsKey: 'addTooltip'
}];
const presenterAction = {
  id: commons_actions_actionIds__WEBPACK_IMPORTED_MODULE_3__.ACTION_INFO_ID,
  Dialog: commons_components_FieldsLinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_8__["default"],
  idPrefix: admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_4__.PROJECT_TYPE_ID_PREFIX,
  fields: _utils_projectTypePresenters__WEBPACK_IMPORTED_MODULE_12__.fieldPresenters,
  labelNlsKey: 'infoEntry',
  nlsBundles
};
const rowActions = [_objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_2__.LIST_ACTION_EDIT), {}, {
  Dialog: (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_9__.withListRerender)(_ProjectTypeEditDialog__WEBPACK_IMPORTED_MODULE_11__["default"], 'onEdit')
}), commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_2__.LIST_ACTION_REVISIONS, _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_2__.LIST_ACTION_REMOVE), {}, {
  Dialog: commons_components_EntryListView_dialogs_ListRemoveEntryDialog__WEBPACK_IMPORTED_MODULE_1__["default"]
})];


/***/ }),

/***/ "./modules/admin/configs/projecttypes/ProjectTypeView/index.js":
/*!*********************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/ProjectTypeView/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ProjectTypeView__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ProjectTypeView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProjectTypeView */ "./modules/admin/configs/projecttypes/ProjectTypeView/ProjectTypeView.js");


/***/ }),

/***/ "./modules/admin/configs/projecttypes/utils/editorFields.js":
/*!******************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/utils/editorFields.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   editorFields: () => (/* binding */ editorFields)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var admin_configs_projecttypes_EntityTypeSelectEditor__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! admin/configs/projecttypes/EntityTypeSelectEditor */ "./modules/admin/configs/projecttypes/EntityTypeSelectEditor/index.js");
/* harmony import */ var _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./fieldDefinitions */ "./modules/admin/configs/projecttypes/utils/fieldDefinitions.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


const editorFields = [_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.label), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.description), _objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.module), _objectSpread(_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.defaults), {}, {
  Editor: admin_configs_projecttypes_EntityTypeSelectEditor__WEBPACK_IMPORTED_MODULE_1__.EntityTypeSelectEditor
}), _objectSpread(_objectSpread({}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_2__.optional), {}, {
  Editor: admin_configs_projecttypes_EntityTypeSelectEditor__WEBPACK_IMPORTED_MODULE_1__.EntityTypeSelectEditor
})];

/***/ }),

/***/ "./modules/admin/configs/projecttypes/utils/fieldDefinitions.js":
/*!**********************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/utils/fieldDefinitions.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   defaults: () => (/* binding */ defaults),
/* harmony export */   description: () => (/* binding */ description),
/* harmony export */   label: () => (/* binding */ label),
/* harmony export */   module: () => (/* binding */ module),
/* harmony export */   optional: () => (/* binding */ optional)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! admin/configs/utils/namespace */ "./modules/admin/configs/utils/namespace.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/types/utils/uri */ "./modules/commons/types/utils/uri.js");
/* harmony import */ var admin_configs_entitytypes_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! admin/configs/entitytypes/utils/entityTypeQuery */ "./modules/admin/configs/entitytypes/utils/entityTypeQuery.js");







const label = {
  name: 'label',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__.LANGUAGE_LITERAL,
  property: 'dcterms:title',
  labelNlsKey: 'labelLabel',
  mandatory: true
};
const description = {
  name: 'description',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__.LANGUAGE_LITERAL,
  property: 'dcterms:description',
  labelNlsKey: 'descriptionLabel'
};
const module = {
  name: 'module',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__.LITERAL,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:module`,
  choices: [{
    value: 'catalog',
    label: {
      en: 'Catalog'
    }
  }, {
    value: 'workbench',
    label: {
      en: 'Workbench'
    }
  }, {
    value: 'toolkit',
    label: {
      en: 'Toolkit'
    }
  }, {
    value: 'terms',
    label: {
      en: 'Terms'
    }
  }, {
    value: 'admin',
    label: {
      en: 'Admin'
    }
  }, {
    value: 'models',
    label: {
      en: 'Models'
    }
  }],
  Editor: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__.SelectEditor,
  labelNlsKey: 'moduleLabel'
};
const getValueFromEntityTypes = async _ref => {
  let {
    graph,
    resourceURI,
    property
  } = _ref;
  const selectedResourceURIs = graph.find(resourceURI, property).map(statement => statement.getValue());
  const entries = await commons_store__WEBPACK_IMPORTED_MODULE_3__.entrystoreUtil.loadEntriesByResourceURIs(selectedResourceURIs, null, true);
  const instanceAndBuiltinEntityTypes = (0,admin_configs_entitytypes_utils_entityTypeQuery__WEBPACK_IMPORTED_MODULE_6__.getInstanceAndBuiltinEntityTypes)();
  return entries.map((entry, index) => {
    if (entry) {
      const entryLabel = (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_4__.getLabel)(entry);
      if (entryLabel) {
        return entryLabel;
      }
    }
    const found = instanceAndBuiltinEntityTypes.find(entityType => (0,commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_5__.nameToURI)(`${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.ENTITY_TYPE_ID_PREFIX}-${entityType.id}`, admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_CONTEXT) === selectedResourceURIs[index]);
    if (found) {
      return found.label;
    }
    return selectedResourceURIs[index];
  }).join(', ');
};
const defaults = {
  name: 'default-et',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__.URI,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:default`,
  labelNlsKey: 'defaultEntityTypesLabel',
  mandatory: true,
  direct: false,
  getValue: getValueFromEntityTypes
};
const optional = {
  name: 'optional-et',
  nodetype: commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_1__.URI,
  property: `${admin_configs_utils_namespace__WEBPACK_IMPORTED_MODULE_2__.CONFIG_NAMESPACE}:optional`,
  labelNlsKey: 'optioinalEntityTypesLabel',
  direct: false,
  getValue: getValueFromEntityTypes
};

/***/ }),

/***/ "./modules/admin/configs/projecttypes/utils/projectTypePresenters.js":
/*!***************************************************************************!*\
  !*** ./modules/admin/configs/projecttypes/utils/projectTypePresenters.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fieldPresenters: () => (/* binding */ fieldPresenters)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _fieldDefinitions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./fieldDefinitions */ "./modules/admin/configs/projecttypes/utils/fieldDefinitions.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

const presenterNames = ['label', 'description', 'module', 'defaults', 'optional'];
const fieldPresenters = presenterNames.map(name => _objectSpread({
  name
}, _fieldDefinitions__WEBPACK_IMPORTED_MODULE_1__[name]));

/***/ }),

/***/ "./modules/admin/configs/types/TypeCreateDialog/TypeCreateDialog.js":
/*!**************************************************************************!*\
  !*** ./modules/admin/configs/types/TypeCreateDialog/TypeCreateDialog.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/components/LoadingButton */ "./modules/commons/components/LoadingButton/index.js");
/* harmony import */ var commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/errors/ErrorCatcher */ "./modules/commons/errors/ErrorCatcher/index.js");
/* harmony import */ var commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/errors/utils/errors */ "./modules/commons/errors/utils/errors.js");
/* harmony import */ var commons_components_dialogs_create_handlers__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/components/dialogs/create/handlers */ "./modules/commons/components/dialogs/create/handlers.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
















const TypeCreateDialog = _ref => {
  let {
    closeDialog,
    title,
    fields,
    rdfTypes,
    nlsBundles,
    children
  } = _ref;
  const [, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.useListModel)();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_6__.useTranslation)(nlsBundles);
  const [canSubmit, setCanSubmit] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
  const {
    runAsync,
    status,
    error: createError
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const {
    entry: prototypeEntry,
    graph,
    resourceURI,
    fieldSet
  } = (0,commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_10__.useEditorContext)();
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_7__.useSnackbar)();
  const confirmClose = (0,commons_components_dialogs_create_handlers__WEBPACK_IMPORTED_MODULE_15__.useConfirmCloseAction)(closeDialog);
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (!graph) return;
    graph.onChange = () => setCanSubmit(true);
  }, [graph, resourceURI, fields]);
  const dispatchEntryCreated = () => dispatch({
    type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.CREATE
  });
  const createEntry = async () => {
    const errors = (0,commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_10__.validateFieldSet)(fieldSet);
    if (errors.length) {
      return;
    }
    for (const rdfType of rdfTypes) {
      graph.add(resourceURI, 'rdf:type', rdfType);
    }
    prototypeEntry.setMetadata(graph);
    runAsync(prototypeEntry.commit().then(() => {
      closeDialog();
      dispatchEntryCreated();
      addSnackbar({
        message: translate('createCustomEntityTypeSuccess')
      });
    }).catch(error => {
      throw new commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_14__.ErrorWithMessage(translate('createCustomEntityTypeFail'), error);
    }));
  };
  const actions = /*#__PURE__*/React.createElement(commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_12__["default"], {
    onClick: createEntry,
    loading: status === commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_11__.PENDING,
    disabled: !canSubmit
  }, translate('createButtonLabel'));
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_5__["default"], {
    id: "create-type-dialog",
    title: title,
    actions: actions,
    closeDialog: () => confirmClose(canSubmit)
  }, /*#__PURE__*/React.createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_9__["default"], null, children)), /*#__PURE__*/React.createElement(commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_13__.ErrorCatcher, {
    error: createError
  }));
};
TypeCreateDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  fields: prop_types__WEBPACK_IMPORTED_MODULE_3___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape({})),
  rdfTypes: prop_types__WEBPACK_IMPORTED_MODULE_3___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)),
  title: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  nlsBundles: commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_6__.nlsBundlesPropType,
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TypeCreateDialog);

/***/ }),

/***/ "./modules/admin/configs/types/TypeCreateDialog/index.js":
/*!***************************************************************!*\
  !*** ./modules/admin/configs/types/TypeCreateDialog/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _TypeCreateDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _TypeCreateDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TypeCreateDialog */ "./modules/admin/configs/types/TypeCreateDialog/TypeCreateDialog.js");


/***/ }),

/***/ "./modules/admin/configs/types/TypeEditDialog/TypeEditDialog.js":
/*!**********************************************************************!*\
  !*** ./modules/admin/configs/types/TypeEditDialog/TypeEditDialog.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Button/Button.js");
/* harmony import */ var commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/forms/editors */ "./modules/commons/components/forms/editors/index.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/errors/ErrorCatcher */ "./modules/commons/errors/ErrorCatcher/index.js");
/* harmony import */ var commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/errors/utils/errors */ "./modules/commons/errors/utils/errors.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");














const TypeEditDialog = _ref => {
  let {
    closeDialog,
    title,
    nlsBundles,
    children,
    onEdit = () => {}
  } = _ref;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_6__.useTranslation)(nlsBundles);
  const [canSubmit, setCanSubmit] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
  const {
    runAsync,
    error: editError
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const {
    entry,
    graph,
    resourceURI,
    validate
  } = (0,commons_components_forms_editors__WEBPACK_IMPORTED_MODULE_9__.useEditorContext)();
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_11__.useSnackbar)();
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (!graph) return;
    graph.onChange = () => setCanSubmit(true);
  }, [graph, resourceURI]);
  const saveChanges = async () => {
    const errors = validate();
    if (errors.length) {
      return;
    }
    entry.setMetadata(graph);
    runAsync(entry.commitMetadata().then(() => {
      closeDialog();
      onEdit();
      addSnackbar({
        type: commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_11__.SUCCESS_EDIT
      });
    }).catch(error => {
      throw new commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_13__.ErrorWithMessage(translate('editCustomEntityTypeFail'), error);
    }));
  };
  const actions = /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], {
    onClick: () => saveChanges(),
    disabled: !canSubmit
  }, translate('saveButton'));
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_5__["default"], {
    id: "edit-type-dialog",
    title: title,
    actions: actions,
    closeDialog: closeDialog
  }, /*#__PURE__*/React.createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_7__["default"], null, children)), /*#__PURE__*/React.createElement(commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_12__.ErrorCatcher, {
    error: editError
  }));
};
TypeEditDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  title: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  nlsBundles: commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_6__.nlsBundlesPropType,
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node),
  onEdit: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (TypeEditDialog);

/***/ }),

/***/ "./modules/admin/configs/types/TypeEditDialog/index.js":
/*!*************************************************************!*\
  !*** ./modules/admin/configs/types/TypeEditDialog/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _TypeEditDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _TypeEditDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./TypeEditDialog */ "./modules/admin/configs/types/TypeEditDialog/TypeEditDialog.js");


/***/ }),

/***/ "./modules/admin/configs/types/presenters/Constraints/Constraints.js":
/*!***************************************************************************!*\
  !*** ./modules/admin/configs/types/presenters/Constraints/Constraints.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Constraints: () => (/* binding */ Constraints)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.sort.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.sort.js");
/* harmony import */ var core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_sort_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @entryscape/rdfjson */ "./node_modules/.pnpm/@entryscape+rdfjson@2.7.7/node_modules/@entryscape/rdfjson/src/main.js");
/* harmony import */ var commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/nls/escoForms.nls */ "./modules/commons/nls/escoForms.nls");
/* harmony import */ var commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/forms/presenters */ "./modules/commons/components/forms/presenters/index.js");
/* harmony import */ var models_utils_ns__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! models/utils/ns */ "./modules/models/utils/ns.js");
/* harmony import */ var _Constraints_scss__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./Constraints.scss */ "./modules/admin/configs/types/presenters/Constraints/Constraints.scss");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
const _excluded = ["graph", "resourceURI", "children"];
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }












/**
 * @param {Graph} graph
 * @param {string} resourceURI
 * @returns {object}
 */
const getConstraints = (graph, resourceURI) => {
  const statements = graph.find(resourceURI, models_utils_ns__WEBPACK_IMPORTED_MODULE_9__.RDF_PROPERTY_CONSTRAINT);
  const constraints = statements.map(statement => {
    const blankNodeId = statement.getValue();

    // constraint property
    const constraintProperty = graph.findFirstValue(blankNodeId, models_utils_ns__WEBPACK_IMPORTED_MODULE_9__.RDF_PROPERTY_CONSTRAINT_PROPERTY);
    const valueStatements = graph.find(blankNodeId, models_utils_ns__WEBPACK_IMPORTED_MODULE_9__.RDF_PROPERTY_CONSTRAINT_VALUE);

    // constraint values
    const constraintValues = valueStatements.map(valueStatement => {
      const valueBlankNodeId = valueStatement.getValue();
      const order = graph.findFirstValue(valueBlankNodeId, models_utils_ns__WEBPACK_IMPORTED_MODULE_9__.RDF_PROPERTY_ORDER);
      const value = graph.findFirstValue(valueBlankNodeId, 'rdf:value');
      return {
        value,
        order
      };
    }).sort((_ref, _ref2) => {
      let {
        order: firstOrder
      } = _ref;
      let {
        order: secondOrder
      } = _ref2;
      return firstOrder - secondOrder;
    }).map(_ref3 => {
      let {
        value
      } = _ref3;
      return value;
    }).join(', ');
    return {
      property: constraintProperty,
      values: constraintValues
    };
  });
  return constraints;
};
const Constraint = _ref4 => {
  let {
    property,
    values
  } = _ref4;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__.useTranslation)((commons_nls_escoForms_nls__WEBPACK_IMPORTED_MODULE_6___default()));
  return /*#__PURE__*/React.createElement("div", {
    className: "esadConstraint"
  }, /*#__PURE__*/React.createElement(commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_8__.FieldsLabel, {
    alignItems: "start",
    label: `${translate('constraintPropertyLabel')}: `
  }, /*#__PURE__*/React.createElement("span", {
    className: "esadConstraint__value"
  }, property)), /*#__PURE__*/React.createElement(commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_8__.FieldsLabel, {
    alignItems: "start",
    label: `${translate('constraintObjectLabel')}: `
  }, /*#__PURE__*/React.createElement("span", {
    className: "esadConstraint__value"
  }, values)));
};
Constraint.propTypes = {
  property: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  values: prop_types__WEBPACK_IMPORTED_MODULE_3___default().oneOfType([(prop_types__WEBPACK_IMPORTED_MODULE_3___default().string), (prop_types__WEBPACK_IMPORTED_MODULE_3___default().array)])
};
const Constraints = _ref5 => {
  let {
      graph,
      resourceURI,
      children
    } = _ref5,
    fieldsProps = _objectWithoutProperties(_ref5, _excluded);
  const constraints = getConstraints(graph, resourceURI);
  return constraints ?
  /*#__PURE__*/
  // eslint-disable-next-line react/jsx-props-no-spreading
  React.createElement(commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_8__.Fields, fieldsProps, constraints.map(_ref6 => {
    let {
      property,
      values
    } = _ref6;
    return /*#__PURE__*/React.createElement(Constraint, {
      key: property,
      property: property,
      values: values
    });
  }), children) : null;
};
Constraints.propTypes = {
  graph: commons_util_entry__WEBPACK_IMPORTED_MODULE_4__.graphPropType,
  resourceURI: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  children: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().node)
};

/***/ }),

/***/ "./modules/admin/configs/types/presenters/Constraints/Constraints.scss":
/*!*****************************************************************************!*\
  !*** ./modules/admin/configs/types/presenters/Constraints/Constraints.scss ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_Constraints_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../../../node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!../../../../../../node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./Constraints.scss */ "./node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!./node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./modules/admin/configs/types/presenters/Constraints/Constraints.scss");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_Constraints_scss__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_Constraints_scss__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_Constraints_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_Constraints_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./modules/admin/configs/types/presenters/Constraints/index.js":
/*!*********************************************************************!*\
  !*** ./modules/admin/configs/types/presenters/Constraints/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Constraints: () => (/* reexport safe */ _Constraints__WEBPACK_IMPORTED_MODULE_0__.Constraints)
/* harmony export */ });
/* harmony import */ var _Constraints__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Constraints */ "./modules/admin/configs/types/presenters/Constraints/Constraints.js");


/***/ }),

/***/ "./modules/admin/configs/types/presenters/StoreConfigPresenter/StoreConfigPresenter.js":
/*!*********************************************************************************************!*\
  !*** ./modules/admin/configs/types/presenters/StoreConfigPresenter/StoreConfigPresenter.js ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StoreConfig: () => (/* binding */ StoreConfig),
/* harmony export */   StoreConfigPresenter: () => (/* binding */ StoreConfigPresenter)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @entryscape/rdfjson */ "./node_modules/.pnpm/@entryscape+rdfjson@2.7.7/node_modules/@entryscape/rdfjson/src/main.js");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! admin/nls/esadType.nls */ "./modules/admin/nls/esadType.nls");
/* harmony import */ var admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var _StoreConfigPresenter_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./StoreConfigPresenter.scss */ "./modules/admin/configs/types/presenters/StoreConfigPresenter/StoreConfigPresenter.scss");
/* harmony import */ var commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/components/forms/presenters */ "./modules/commons/components/forms/presenters/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");

const _excluded = ["graph", "resourceURI", "property"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }








/**
 * @param {object} params
 * @param {Graph} params.graph
 * @param {string} params.resourceURI
 * @param {string} params.property
 * @returns {Array<object>}
 */
const getValues = _ref => {
  let {
    graph,
    resourceURI,
    property
  } = _ref;
  const blankNodeIds = graph.find(resourceURI, property).map(statement => statement.getValue());
  return blankNodeIds.map(blankNodeId => {
    const endpoint = graph.findFirstValue(blankNodeId, 'dcterms:source');
    return {
      blankNodeId,
      endpoint
    };
  });
};
const StoreConfig = _ref2 => {
  let {
    graph,
    blankNodeId,
    endpoint
  } = _ref2;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_5__.useTranslation)((admin_nls_esadType_nls__WEBPACK_IMPORTED_MODULE_4___default()));
  return /*#__PURE__*/React.createElement("div", {
    className: "esadStoreConfig"
  }, /*#__PURE__*/React.createElement(commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_7__.FieldsLabel, {
    alignItems: "start",
    label: `${translate('labelsLabel')}: `
  }), /*#__PURE__*/React.createElement(commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_7__.LanguageLiteral, {
    graph: graph,
    resourceURI: blankNodeId,
    property: "dcterms:title"
  }), /*#__PURE__*/React.createElement(commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_7__.FieldsLabel, {
    alignItems: "start",
    label: `${translate('endpointLabel')}: `
  }, /*#__PURE__*/React.createElement("span", {
    className: "esadStoreConfig__value"
  }, endpoint)));
};
StoreConfig.propTypes = {
  graph: commons_util_entry__WEBPACK_IMPORTED_MODULE_2__.graphPropType,
  blankNodeId: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  endpoint: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};
const StoreConfigPresenter = _ref3 => {
  let {
      graph,
      resourceURI,
      property
    } = _ref3,
    fieldsProps = _objectWithoutProperties(_ref3, _excluded);
  const values = getValues({
    graph,
    resourceURI,
    property
  });
  return values.length ? /*#__PURE__*/React.createElement(commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_7__.Fields, fieldsProps, values.map(value => {
    return /*#__PURE__*/React.createElement(StoreConfig, _extends({
      key: value.endpoint
    }, value, {
      graph: graph
    }));
  })) : null;
};
StoreConfigPresenter.propTypes = {
  graph: commons_util_entry__WEBPACK_IMPORTED_MODULE_2__.graphPropType,
  resourceURI: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string),
  property: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().string)
};

/***/ }),

/***/ "./modules/admin/configs/types/presenters/StoreConfigPresenter/StoreConfigPresenter.scss":
/*!***********************************************************************************************!*\
  !*** ./modules/admin/configs/types/presenters/StoreConfigPresenter/StoreConfigPresenter.scss ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_StoreConfigPresenter_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../../../node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!../../../../../../node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./StoreConfigPresenter.scss */ "./node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!./node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./modules/admin/configs/types/presenters/StoreConfigPresenter/StoreConfigPresenter.scss");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_StoreConfigPresenter_scss__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_StoreConfigPresenter_scss__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_StoreConfigPresenter_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_StoreConfigPresenter_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./modules/admin/configs/types/presenters/StoreConfigPresenter/index.js":
/*!******************************************************************************!*\
  !*** ./modules/admin/configs/types/presenters/StoreConfigPresenter/index.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   StoreConfig: () => (/* reexport safe */ _StoreConfigPresenter__WEBPACK_IMPORTED_MODULE_0__.StoreConfig),
/* harmony export */   StoreConfigPresenter: () => (/* reexport safe */ _StoreConfigPresenter__WEBPACK_IMPORTED_MODULE_0__.StoreConfigPresenter)
/* harmony export */ });
/* harmony import */ var _StoreConfigPresenter__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./StoreConfigPresenter */ "./modules/admin/configs/types/presenters/StoreConfigPresenter/StoreConfigPresenter.js");


/***/ }),

/***/ "./modules/admin/configs/utils/configQuery.js":
/*!****************************************************!*\
  !*** ./modules/admin/configs/utils/configQuery.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getConfigContext: () => (/* binding */ getConfigContext),
/* harmony export */   getConfigEntries: () => (/* binding */ getConfigEntries),
/* harmony export */   getOrCreateConfigContextEntry: () => (/* binding */ getOrCreateConfigContextEntry),
/* harmony export */   migrateTypesToStore: () => (/* binding */ migrateTypesToStore),
/* harmony export */   typeToPrototypeEntry: () => (/* binding */ typeToPrototypeEntry)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var _exporters__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./exporters */ "./modules/admin/configs/utils/exporters.js");
/* harmony import */ var _namespace__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./namespace */ "./modules/admin/configs/utils/namespace.js");
const _excluded = ["name"];
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }





/**
 * @returns {Context}
 */
const getConfigContext = () => {
  return commons_store__WEBPACK_IMPORTED_MODULE_4__.entrystore.getContextById(_namespace__WEBPACK_IMPORTED_MODULE_7__.CONFIG_CONTEXT);
};

/**
 * Get config context entry
 *
 * @returns {Promise<Entry>}
 */
const getConfigContextEntry = () => {
  return getConfigContext().getEntry();
};

/**
 * Get the config context entry or create it, if it doesn't exist.
 *
 * @returns {Promise<Entry>}
 */
const getOrCreateConfigContextEntry = () => {
  return getConfigContextEntry().then(null, () => {
    const prototypeEntry = commons_store__WEBPACK_IMPORTED_MODULE_4__.entrystore.newContext(_namespace__WEBPACK_IMPORTED_MODULE_7__.CONFIG_CONTEXT, _namespace__WEBPACK_IMPORTED_MODULE_7__.CONFIG_CONTEXT);
    const entryInfo = prototypeEntry.getEntryInfo();
    const acl = entryInfo.getACL(true);
    acl.rread.push('_users');
    acl.mread.push('_users');
    entryInfo.setACL(acl);
    return prototypeEntry.commit();
  });
};

/**
 * Converts a type object to a type prototype entry. Exports each property in
 * type object to metadata graph by finding matching exporter from field
 * definitions.
 *
 * @param {*} prototypeEntryOptions
 * @returns {Entry}
 */
const typeToPrototypeEntry = _ref => {
  let {
    context,
    idPrefix,
    type,
    fieldDefinitions,
    rdfType
  } = _ref;
  const {
      name
    } = type,
    typeConfig = _objectWithoutProperties(type, _excluded);

  // create prototype entry
  const prototypeEntry = new _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_5__.PrototypeEntry(context, idPrefix ? `${idPrefix}-${name}` : name);
  const graph = prototypeEntry.getMetadata();
  const resourceURI = prototypeEntry.getResourceURI();

  // add rdf type to prototype
  const rdfTypes = Array.isArray(rdfType) ? rdfType : [rdfType];
  for (const rdfTypeValue of rdfTypes) {
    graph.add(resourceURI, 'rdf:type', rdfTypeValue);
  }

  // add each type property to metadata
  const typeKeyValues = Object.entries(typeConfig);
  for (const [key, value] of typeKeyValues) {
    const fieldDefinition = fieldDefinitions[key];
    const exportPropertyToGraph = (0,_exporters__WEBPACK_IMPORTED_MODULE_6__.getExporter)(fieldDefinition);
    if (exportPropertyToGraph) {
      exportPropertyToGraph(_objectSpread({
        graph,
        resourceURI,
        value
      }, fieldDefinition));
    }
  }
  return prototypeEntry;
};

/**
 * Converts array of type objects to type entries.
 *
 * @param {*} typeMigrationOptions
 * @returns {Promise<Entry[]>}
 */
const migrateTypesToStore = async _ref2 => {
  let {
    types,
    idPrefix,
    fieldDefinitions,
    rdfType
  } = _ref2;
  const contextEntry = await getOrCreateConfigContextEntry();
  const context = contextEntry.getResource(true);
  const prototypeEntries = types.map(type => {
    return typeToPrototypeEntry({
      context,
      idPrefix,
      type,
      rdfType,
      fieldDefinitions
    });
  });
  const typeEntries = [];
  for (const prototypeEntry of prototypeEntries) {
    const typeEntry = await prototypeEntry.commit().then(null, () => {
      throw new Error('Something went wrong while migrating type to store');
    });
    typeEntries.push(typeEntry);
  }
  return typeEntries;
};

/**
 * @param {{rdfType: string}} queryOptions
 * @returns {Promise<object[]>}
 */
const getConfigEntries = async _ref3 => {
  let {
    rdfType
  } = _ref3;
  let context;
  try {
    context = await getConfigContextEntry();
  } catch (_error) {
    console.log('Config context entry not found');
    return;
  }
  return commons_store__WEBPACK_IMPORTED_MODULE_4__.entrystore.newSolrQuery().context(context).rdfType(rdfType).getEntries().then(entries => {
    return {
      entries,
      size: entries.length
    };
  });
};

/***/ }),

/***/ "./modules/admin/configs/utils/exporters.js":
/*!**************************************************!*\
  !*** ./modules/admin/configs/utils/exporters.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   addConstraintFromRdfType: () => (/* binding */ addConstraintFromRdfType),
/* harmony export */   addConstraints: () => (/* binding */ addConstraints),
/* harmony export */   addDatatype: () => (/* binding */ addDatatype),
/* harmony export */   addLanguageLiteral: () => (/* binding */ addLanguageLiteral),
/* harmony export */   addLiteral: () => (/* binding */ addLiteral),
/* harmony export */   addStoreConfig: () => (/* binding */ addStoreConfig),
/* harmony export */   addURI: () => (/* binding */ addURI),
/* harmony export */   addURIFromName: () => (/* binding */ addURIFromName),
/* harmony export */   getExporter: () => (/* binding */ getExporter),
/* harmony export */   typeConfigToGraph: () => (/* binding */ typeConfigToGraph)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var models_utils_ns__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! models/utils/ns */ "./modules/models/utils/ns.js");
/* harmony import */ var _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @entryscape/rdfjson */ "./node_modules/.pnpm/@entryscape+rdfjson@2.7.7/node_modules/@entryscape/rdfjson/src/main.js");
/* harmony import */ var commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/types/utils/uri */ "./modules/commons/types/utils/uri.js");
/* harmony import */ var commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/components/forms/presenters */ "./modules/commons/components/forms/presenters/index.js");
/* harmony import */ var _namespace__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./namespace */ "./modules/admin/configs/utils/namespace.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }









/**
 * @param {Object} fieldDefinition
 * @returns {Graph}
 */
const addLiteral = _ref => {
  let {
    graph,
    resourceURI,
    property,
    value
  } = _ref;
  graph.addL(resourceURI, property, value);
  return graph;
};

/**
 * @param {Object} fieldDefinition
 * @returns {Graph}
 */
const addURI = _ref2 => {
  let {
    graph,
    resourceURI,
    property,
    value
  } = _ref2;
  graph.add(resourceURI, property, value);
  return graph;
};

/**
 * @param {Object} fieldDefinition
 * @returns {Graph}
 */
const addDatatype = _ref3 => {
  let {
    graph,
    resourceURI,
    property,
    value,
    datatype
  } = _ref3;
  graph.addD(resourceURI, property, `${value}`, datatype);
  return graph;
};

/**
 * @param {Object} fieldDefinition
 * @returns {Graph}
 */
const addLanguageLiteral = _ref4 => {
  let {
    graph,
    resourceURI,
    property,
    value: languageValues
  } = _ref4;
  const languageKeyValues = Object.entries(languageValues);
  for (const [lang, value] of languageKeyValues) {
    graph.add(resourceURI, property, {
      type: 'literal',
      value,
      lang
    });
  }
  return graph;
};

/**
 * @param {Object} fieldDefinition
 * @returns {Graph}
 */
const addURIFromName = _ref5 => {
  let {
    graph,
    resourceURI,
    property,
    value
  } = _ref5;
  const refinesURI = (0,commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_5__.nameToURI)(`${_namespace__WEBPACK_IMPORTED_MODULE_7__.ENTITY_TYPE_ID_PREFIX}-${value}`, 'config');
  addURI({
    graph,
    resourceURI,
    property,
    value: refinesURI
  });
  return graph;
};

/**
 * @param {Object} fieldDefinition
 * @returns {Graph}
 */
const addStoreConfig = _ref6 => {
  let {
    graph,
    resourceURI,
    property,
    value
  } = _ref6;
  const {
    label,
    endpoint
  } = value;
  const blankNodeId = graph.add(resourceURI, property).getValue();
  addLanguageLiteral({
    graph,
    resourceURI: blankNodeId,
    property: 'dcterms:title',
    value: label
  });
  addURI({
    graph,
    resourceURI: blankNodeId,
    property: 'dcterms:source',
    value: endpoint
  });
  return graph;
};

/**
 * @param {Object} fieldDefinition
 * @returns {Graph}
 */
const addConstraint = _ref7 => {
  let {
    graph,
    resourceURI,
    property,
    values
  } = _ref7;
  const blankNodeId = graph.add(resourceURI, models_utils_ns__WEBPACK_IMPORTED_MODULE_3__.RDF_PROPERTY_CONSTRAINT).getValue();

  // Add constraint property
  graph.add(blankNodeId, 'rdf:type', models_utils_ns__WEBPACK_IMPORTED_MODULE_3__.RDF_TYPE_CONSTRAINT);
  graph.add(blankNodeId, models_utils_ns__WEBPACK_IMPORTED_MODULE_3__.RDF_PROPERTY_CONSTRAINT_PROPERTY, property);

  // Add constraint values
  values.forEach((value, index) => {
    const valueBlankId = graph.add(blankNodeId, models_utils_ns__WEBPACK_IMPORTED_MODULE_3__.RDF_PROPERTY_CONSTRAINT_VALUE).getValue();
    graph.add(valueBlankId, 'rdf:value', value === null ? models_utils_ns__WEBPACK_IMPORTED_MODULE_3__.RDF_CONSTRAINT_NULL_URI : value // some constraints uses null to express match
    );
    graph.addD(valueBlankId, models_utils_ns__WEBPACK_IMPORTED_MODULE_3__.RDF_PROPERTY_ORDER, `${index + 1}`, 'xsd:integer');
  });
  return graph;
};

/**
 * @param {Object} fieldDefinition
 * @returns {Graph}
 */
const addConstraints = _ref8 => {
  let {
    graph,
    resourceURI,
    value: constraintsValue
  } = _ref8;
  const constraintKeyValues = Object.entries(constraintsValue);
  for (const [property, value] of constraintKeyValues) {
    const values = Array.isArray(value) ? value : [value];
    addConstraint({
      graph,
      resourceURI,
      property,
      values
    });
  }
  return graph;
};
const addConstraintFromRdfType = _ref9 => {
  let {
    graph,
    resourceURI,
    value
  } = _ref9;
  const rdfTypeValues = Array.isArray(value) ? value : [value];
  addConstraint({
    graph,
    resourceURI,
    property: 'rdf:type',
    values: rdfTypeValues
  });
  return graph;
};

/**
 * @param {Object} fieldDefinition
 * @returns {Function|undefined}
 */
const getExporter = function getExporter() {
  let fieldDefinition = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  const {
    nodetype,
    toGraph
  } = fieldDefinition;
  if (toGraph) return toGraph;
  if (!nodetype) return;
  switch (nodetype) {
    case commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_6__.URI:
      return addURI;
    case commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_6__.LITERAL:
      return addLiteral;
    case commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_6__.LANGUAGE_LITERAL:
      return addLanguageLiteral;
    case commons_components_forms_presenters__WEBPACK_IMPORTED_MODULE_6__.DATATYPE_LITERAL:
      return addDatatype;
    default:
      console.error('Unknown type for converter');
      break;
  }
};

/**
 * @param {Object} exportOptions
 * @returns {Object}
 */
const typeConfigToGraph = _ref0 => {
  let {
    entry,
    typeConfig,
    fields,
    idPrefix
  } = _ref0;
  if (!typeConfig) return {};
  const graph = entry ? new _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_4__.Graph(entry.getMetadata().exportRDFJSON()) : new _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_4__.Graph();
  const resourceURI = entry ? entry.getResourceURI() : (0,commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_5__.nameToURI)(`${idPrefix}-${typeConfig.name}`, 'config');

  // add type configuration to graph
  const typeConfigKeyValues = Object.entries(typeConfig);
  typeConfigKeyValues.forEach(_ref1 => {
    let [key, value] = _ref1;
    const fieldDefinition = fields.find(_ref10 => {
      let {
        name
      } = _ref10;
      return name === key;
    });
    if (!fieldDefinition) return;
    const {
      property
    } = fieldDefinition;

    // don't add type config if property found in entry
    if (graph.findFirstValue(resourceURI, property)) return;
    const exportToGraph = getExporter(fieldDefinition);
    if (exportToGraph) {
      exportToGraph(_objectSpread({
        graph,
        resourceURI,
        value
      }, fieldDefinition));
    }
  });
  return {
    graph,
    resourceURI
  };
};

/***/ }),

/***/ "./modules/admin/configs/utils/namespace.js":
/*!**************************************************!*\
  !*** ./modules/admin/configs/utils/namespace.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CONFIG_CONTEXT: () => (/* binding */ CONFIG_CONTEXT),
/* harmony export */   CONFIG_NAMESPACE: () => (/* binding */ CONFIG_NAMESPACE),
/* harmony export */   ENTITY_TYPE_BUILTIN: () => (/* binding */ ENTITY_TYPE_BUILTIN),
/* harmony export */   ENTITY_TYPE_CUSTOM: () => (/* binding */ ENTITY_TYPE_CUSTOM),
/* harmony export */   ENTITY_TYPE_ID_PREFIX: () => (/* binding */ ENTITY_TYPE_ID_PREFIX),
/* harmony export */   PROJECT_TYPE_ID_PREFIX: () => (/* binding */ PROJECT_TYPE_ID_PREFIX),
/* harmony export */   RDF_CLASS_CUSTOM_ENTITY_TYPE: () => (/* binding */ RDF_CLASS_CUSTOM_ENTITY_TYPE),
/* harmony export */   RDF_CLASS_ENTITY_TYPE: () => (/* binding */ RDF_CLASS_ENTITY_TYPE),
/* harmony export */   RDF_CLASS_PROJECT_TYPE: () => (/* binding */ RDF_CLASS_PROJECT_TYPE)
/* harmony export */ });
/* harmony import */ var _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @entryscape/rdfjson */ "./node_modules/.pnpm/@entryscape+rdfjson@2.7.7/node_modules/@entryscape/rdfjson/src/main.js");

const CONFIG_NAMESPACE = 'escfg';
const CONFIG_CONTEXT = 'config';
_entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_0__.namespaces.add(CONFIG_NAMESPACE, `http://entryscape.com/terms/${CONFIG_CONTEXT}/`);
const RDF_CLASS_ENTITY_TYPE = `${CONFIG_NAMESPACE}:EntityType`;
const RDF_CLASS_CUSTOM_ENTITY_TYPE = `${CONFIG_NAMESPACE}:EntityType`;
const ENTITY_TYPE_ID_PREFIX = '_et';
const ENTITY_TYPE_BUILTIN = 'builtin';
const ENTITY_TYPE_CUSTOM = 'custom';
const PROJECT_TYPE_ID_PREFIX = '_pt';
const RDF_CLASS_PROJECT_TYPE = `${CONFIG_NAMESPACE}:ProjectType`;

/***/ }),

/***/ "./modules/admin/defaults.js":
/*!***********************************!*\
  !*** ./modules/admin/defaults.js ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @entryscape/rdfjson */ "./node_modules/.pnpm/@entryscape+rdfjson@2.7.7/node_modules/@entryscape/rdfjson/src/main.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (() => {
  _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_0__.namespaces.add('esterms', 'http://entryscape.com/terms/');
  _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_0__.namespaces.add('dcat', 'http://www.w3.org/ns/dcat#');
});

/***/ }),

/***/ "./modules/admin/groups/GroupOverview/GroupOverview.js":
/*!*************************************************************!*\
  !*** ./modules/admin/groups/GroupOverview/GroupOverview.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/hooks/useEntry */ "./modules/commons/hooks/useEntry.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! admin/nls/esadGroup.nls */ "./modules/admin/nls/esadGroup.nls");
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/hooks/useDocumentTitle */ "./modules/commons/hooks/useDocumentTitle.js");
/* harmony import */ var commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/hooks/usePageTitle */ "./modules/commons/hooks/usePageTitle.js");
/* harmony import */ var commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/hooks/useGetContributors */ "./modules/commons/hooks/useGetContributors.js");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/nls/escoOverview.nls */ "./modules/commons/nls/escoOverview.nls");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/components/overview/Overview */ "./modules/commons/components/overview/Overview/index.js");
/* harmony import */ var commons_components_overview__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/overview */ "./modules/commons/components/overview/index.js");
/* harmony import */ var commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/components/LinkedDataBrowserDialog */ "./modules/commons/components/LinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_locale__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/locale */ "./modules/commons/locale/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./actions */ "./modules/admin/groups/GroupOverview/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




















const nlsBundles = [(admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_7___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_8___default()), (commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_13___default())];
const GroupOverview = _ref => {
  let {
    overviewProps
  } = _ref;
  const entry = (0,commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_4__.useEntry)();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_9__.useTranslation)(nlsBundles);
  const [{
    refreshCount
  }] = (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_16__.useOverviewModel)();
  const {
    contributors
  } = (0,commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_12__["default"])(entry, refreshCount);
  const [pageTitle] = (0,commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const viewDefinition = (0,commons_util_site__WEBPACK_IMPORTED_MODULE_6__.getViewDefFromName)('admin__groups__group');
  const viewDefinitionTitle = (0,commons_locale__WEBPACK_IMPORTED_MODULE_18__.localize)(viewDefinition.title);
  const label = (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__.getRenderName)(entry) || translate('unnamedWorkspace', entry.getId());
  const descriptionItems = [commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_14__.DESCRIPTION_UPDATED, {
    id: 'edited',
    labelNlsKey: 'editedByLabel',
    getValues: () => contributors
  }];
  (0,commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_10__["default"])(`${pageTitle} - ${viewDefinitionTitle} ${(0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__.getRenderName)(entry)}`);
  return /*#__PURE__*/React.createElement(commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_15__["default"], _extends({}, overviewProps, {
    backLabel: translate('backTitle'),
    headerAction: _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_14__.ACTION_INFO_WITH_ICON), {}, {
      Dialog: commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_17__["default"],
      formTemplateId: 'esc:Group'
    }),
    headerActionParams: {
      formTemplateId: 'esc:Group'
    },
    entry: entry,
    nlsBundles: nlsBundles,
    descriptionItems: descriptionItems,
    sidebarActions: _actions__WEBPACK_IMPORTED_MODULE_19__.sidebarActions,
    sidebarProps: {
      formTemplateId: 'esc:Group'
    },
    returnTo: "/admin/groups",
    headerLabel: label
  }));
};
GroupOverview.propTypes = {
  overviewProps: commons_components_overview__WEBPACK_IMPORTED_MODULE_16__.overviewPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_overview__WEBPACK_IMPORTED_MODULE_16__.withOverviewModelProvider)(GroupOverview));

/***/ }),

/***/ "./modules/admin/groups/GroupOverview/actions.js":
/*!*******************************************************!*\
  !*** ./modules/admin/groups/GroupOverview/actions.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sidebarActions: () => (/* binding */ sidebarActions)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Group.js");
/* harmony import */ var _dialogs_RemoveDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dialogs/RemoveDialog */ "./modules/admin/groups/dialogs/RemoveDialog.js");
/* harmony import */ var _dialogs_MembersDialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../dialogs/MembersDialog */ "./modules/admin/groups/dialogs/MembersDialog/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




const sidebarActions = [_objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_EDIT), {}, {
  getProps: () => ({
    action: {
      formTemplateId: 'esc:Group'
    }
  })
}), commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REVISIONS, {
  id: 'members',
  Dialog: _dialogs_MembersDialog__WEBPACK_IMPORTED_MODULE_4__["default"],
  labelNlsKey: 'memberList',
  icon: /*#__PURE__*/React.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__["default"], null)
}, _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REMOVE), {}, {
  Dialog: _dialogs_RemoveDialog__WEBPACK_IMPORTED_MODULE_3__["default"]
})];

/***/ }),

/***/ "./modules/admin/groups/GroupOverview/index.js":
/*!*****************************************************!*\
  !*** ./modules/admin/groups/GroupOverview/index.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _GroupOverview__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _GroupOverview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./GroupOverview */ "./modules/admin/groups/GroupOverview/GroupOverview.js");


/***/ }),

/***/ "./modules/admin/groups/GroupsView/GroupsView.js":
/*!*******************************************************!*\
  !*** ./modules/admin/groups/GroupsView/GroupsView.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/hooks/useUser */ "./modules/commons/hooks/useUser.js");
/* harmony import */ var commons_util_solr_entry__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/util/solr/entry */ "./modules/commons/util/solr/entry.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var admin_utils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! admin/utils */ "./modules/admin/utils/index.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/components/LinkedDataBrowserDialog */ "./modules/commons/components/LinkedDataBrowserDialog/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./actions */ "./modules/admin/groups/GroupsView/actions.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }

















const entryType = _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__.types.ET_LOCAL;
const graphType = _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__.types.GT_GROUP;
const resourceType = 'InformationResource'; // types.RT_INFORMATIONRESOURCE); // TODO: in entrystore-js

const GroupsView = _ref => {
  let {
    listProps
  } = _ref;
  const {
    userEntry,
    userInfo
  } = (0,commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__.useUserState)();
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_11__.useTranslation)(_actions__WEBPACK_IMPORTED_MODULE_16__.nlsBundles);
  const entryTypeName = t('createEntryName');
  const createQuery = (0,react__WEBPACK_IMPORTED_MODULE_7__.useCallback)(() => {
    const [query] = (0,commons_util_solr_entry__WEBPACK_IMPORTED_MODULE_6__.getSearchQuery)({
      entryType,
      graphType,
      resourceType
    }, {
      userEntry,
      userInfo
    });
    return query;
  }, [userEntry, userInfo]);
  const queryResults = (0,commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_8__.useSolrQuery)({
    createQuery,
    applyQueryParams: admin_utils__WEBPACK_IMPORTED_MODULE_13__.applyUsersGroupParams
  });
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_7___default().createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_8__.EntryListView, _extends({}, queryResults, listProps, {
    nlsBundles: _actions__WEBPACK_IMPORTED_MODULE_16__.nlsBundles,
    listPlaceholderProps: {
      primaryText: t('emptyMessageWithName', entryTypeName)
    },
    getListItemProps: _ref2 => {
      let {
        entry
      } = _ref2;
      return {
        to: (0,commons_util_site__WEBPACK_IMPORTED_MODULE_14__.getPathFromViewName)('admin__groups__group', {
          entryId: entry.getId(),
          contextId: '_principals'
        })
      };
    },
    listActions: _actions__WEBPACK_IMPORTED_MODULE_16__.listActions,
    listActionsProps: {
      nlsBundles: _actions__WEBPACK_IMPORTED_MODULE_16__.nlsBundles
    },
    columns: [_objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_8__.TITLE_COLUMN), {}, {
      xs: 8,
      getProps: _ref3 => {
        let {
          entry
        } = _ref3;
        return {
          primary: (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_12__.getRenderName)(entry) || t('unnamedWorkspace', entry.getId())
        };
      }
    }), _objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_8__.MODIFIED_COLUMN), _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_8__.ACTIONS_GROUP_COLUMN), {}, {
      actions: [_objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_9__.LIST_ACTION_INFO), {}, {
        formTemplateId: 'esc:Group',
        Dialog: commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_15__["default"]
      }), _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_9__.LIST_ACTION_EDIT), {}, {
        formTemplateId: 'esc:Group'
      })]
    })]
  }));
};
GroupsView.propTypes = {
  listProps: commons_components_ListView__WEBPACK_IMPORTED_MODULE_10__.listPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_10__.withListModelProviderAndLocation)(GroupsView));

/***/ }),

/***/ "./modules/admin/groups/GroupsView/actions.js":
/*!****************************************************!*\
  !*** ./modules/admin/groups/GroupsView/actions.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   LIST_ACTION_GROUPS_ID: () => (/* binding */ LIST_ACTION_GROUPS_ID),
/* harmony export */   listActions: () => (/* binding */ listActions),
/* harmony export */   nlsBundles: () => (/* binding */ nlsBundles),
/* harmony export */   rowActions: () => (/* binding */ rowActions)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! admin/nls/esadGroup.nls */ "./modules/admin/nls/esadGroup.nls");
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/nls/escoPlaceholder.nls */ "./modules/commons/nls/escoPlaceholder.nls");
/* harmony import */ var commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _dialogs_CreateDialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../dialogs/CreateDialog */ "./modules/admin/groups/dialogs/CreateDialog.js");
/* harmony import */ var _dialogs_RemoveDialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dialogs/RemoveDialog */ "./modules/admin/groups/dialogs/RemoveDialog.js");
/* harmony import */ var _dialogs_MembersDialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../dialogs/MembersDialog */ "./modules/admin/groups/dialogs/MembersDialog/index.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }







const LIST_ACTION_GROUPS_ID = 'groups';
const nlsBundles = [(admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_2___default()), (commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_3___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_4___default())];
const listActions = [{
  id: 'create',
  Dialog: _dialogs_CreateDialog__WEBPACK_IMPORTED_MODULE_5__["default"],
  labelNlsKey: 'createButton',
  tooltipNlsKey: 'actionTooltip'
}];
const rowActions = [_objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__.LIST_ACTION_EDIT), {}, {
  formTemplateId: 'esc:Group'
}), commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__.LIST_ACTION_REVISIONS, {
  id: commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__.LIST_ACTION_SHARING_SETTINGS,
  Dialog: '',
  isVisible: () => false,
  labelNlsKey: 'groupACL'
}, {
  id: LIST_ACTION_GROUPS_ID,
  Dialog: _dialogs_MembersDialog__WEBPACK_IMPORTED_MODULE_7__["default"],
  labelNlsKey: 'memberList'
}, _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__.LIST_ACTION_REMOVE), {}, {
  Dialog: _dialogs_RemoveDialog__WEBPACK_IMPORTED_MODULE_6__["default"]
})];


/***/ }),

/***/ "./modules/admin/groups/GroupsView/index.js":
/*!**************************************************!*\
  !*** ./modules/admin/groups/GroupsView/index.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _GroupsView__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _GroupsView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./GroupsView */ "./modules/admin/groups/GroupsView/GroupsView.js");


/***/ }),

/***/ "./modules/admin/groups/dialogs/CreateDialog.js":
/*!******************************************************!*\
  !*** ./modules/admin/groups/dialogs/CreateDialog.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/TextField/TextField.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/FormControlLabel/FormControlLabel.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Checkbox/Checkbox.js");
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! admin/nls/esadGroup.nls */ "./modules/admin/nls/esadGroup.nls");
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_util_util__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/util/util */ "./modules/commons/util/util.js");
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/components/LoadingButton */ "./modules/commons/components/LoadingButton/index.js");
/* harmony import */ var commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/errors/ErrorCatcher */ "./modules/commons/errors/ErrorCatcher/index.js");
/* harmony import */ var commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/errors/utils/errors */ "./modules/commons/errors/utils/errors.js");
/* harmony import */ var commons_components_dialogs_create_handlers__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/components/dialogs/create/handlers */ "./modules/commons/components/dialogs/create/handlers.js");
/* harmony import */ var _handler__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./handler */ "./modules/admin/groups/dialogs/handler.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




















const CreateDialog = _ref => {
  let {
    closeDialog
  } = _ref;
  const [, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.useListModel)();
  const {
    runAsync,
    status,
    error: createError
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_16__["default"])();
  const [pristine, setPristine] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(true);
  const [timer, setTimer] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(null);
  const [formError, setFormError] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(null);
  const [groupName, setGroupName] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)({
    value: '',
    error: null,
    isValid: true
  });
  const [entryId, setEntryId] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)({
    value: '',
    error: null,
    isValid: true
  });
  const [fullGroupName, setFullGroupName] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)({
    value: '',
    error: null
  });
  const [showAdvancedOptions, setShowAdvancedOptions] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const [buttonDisabled, setButtonDisabled] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(true);
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_15__.useSnackbar)();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_12__.useTranslation)((admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_10___default()));
  const confirmClose = (0,commons_components_dialogs_create_handlers__WEBPACK_IMPORTED_MODULE_20__.useConfirmCloseAction)(closeDialog);
  const close = () => confirmClose(!pristine);
  const handleChange = (state, set) => e => {
    set(_objectSpread(_objectSpread({}, state), {}, {
      value: (0,commons_util_util__WEBPACK_IMPORTED_MODULE_14__.removeWhitespace)(e.target.value)
    }));
    if (e.target.id === 'fullGroupName') {
      setPristine(false);
    }
  };
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (groupName.value) {
      if (timer) {
        clearTimeout(timer);
        setTimer(null);
      }
      const t = setTimeout(() => (0,_handler__WEBPACK_IMPORTED_MODULE_21__.groupNameSearch)(groupName.value).then(result => {
        setGroupName(state => _objectSpread(_objectSpread({}, state), {}, {
          isValid: !result,
          error: result
        }));
      }), 300);
      setTimer(t);
    }
    setGroupName(state => _objectSpread(_objectSpread({}, state), {}, {
      isValid: true,
      error: null
    }));
  }, [groupName.value]);
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (entryId.value) {
      if (timer) {
        clearTimeout(timer);
        setTimer(null);
      }
      const t = setTimeout(() => (0,_handler__WEBPACK_IMPORTED_MODULE_21__.entryIdSearch)(entryId.value).then(result => {
        setEntryId(state => _objectSpread(_objectSpread({}, state), {}, {
          isValid: !result,
          error: result
        }));
      }), 300);
      setTimer(t);
    }
    setEntryId(state => _objectSpread(_objectSpread({}, state), {}, {
      isValid: true,
      error: null
    }));
  }, [entryId.value]);
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (fullGroupName.value && !pristine) {
      if (groupName.isValid && entryId.isValid) {
        setButtonDisabled(false);
      } else {
        setButtonDisabled(true);
      }
    } else {
      setButtonDisabled(true);
    }
  }, [fullGroupName.value, groupName.isValid, entryId.isValid]);
  const handleShowAdvancedOptions = () => {
    setShowAdvancedOptions(!showAdvancedOptions);
    setGroupName(state => _objectSpread(_objectSpread({}, state), {}, {
      value: '',
      isValid: true
    }));
    setEntryId(state => _objectSpread(_objectSpread({}, state), {}, {
      value: '',
      isValid: true
    }));
  };
  const handleSaveForm = async () => {
    if (groupName.isValid && entryId.isValid && fullGroupName.value) {
      const {
        value: name
      } = groupName;
      const {
        value: id
      } = entryId;
      const {
        value: fullName
      } = fullGroupName;
      return (0,_handler__WEBPACK_IMPORTED_MODULE_21__.createGroupEntry)({
        name,
        id,
        fullName
      }).then(closeDialog).then(() => {
        setPristine(true);
        clearTimeout(timer);
        setTimer(null);
      }).then(() => dispatch({
        type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_13__.CREATE
      })).then(() => addSnackbar({
        message: translate('createGroupSuccess')
      })).catch(err => {
        throw new commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_19__.ErrorWithMessage(translate('createGroupFail'), err);
      });
    }
  };
  const dialogActions = /*#__PURE__*/React.createElement(commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_17__["default"], {
    autoFocus: true,
    onClick: () => runAsync(handleSaveForm()),
    loading: status === commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_16__.PENDING,
    disabled: buttonDisabled
  }, translate('createGroupButton'));
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_11__["default"], {
    id: "create-entry",
    title: translate('createGroupHeader'),
    actions: dialogActions,
    closeDialog: close,
    alert: formError ? {
      message: translate(formError),
      setMessage: setFormError
    } : undefined,
    maxWidth: "md"
  }, /*#__PURE__*/React.createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_9__["default"], null, /*#__PURE__*/React.createElement("form", {
    autoComplete: "off",
    onSubmit: event => event.preventDefault()
  }, showAdvancedOptions && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_6__["default"], {
    id: "groupName",
    label: translate('createGroupname'),
    value: groupName.value,
    placeholder: translate('createGroupnamePlaceholder'),
    onChange: handleChange(groupName, setGroupName),
    error: !groupName.isValid,
    helperText: groupName.error && translate(`${groupName.error}`)
  }), /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_6__["default"], {
    id: "entryId",
    label: translate('createEntryId'),
    value: entryId.value,
    placeholder: translate('createEntryIdPlaceholder'),
    onChange: handleChange(entryId, setEntryId),
    error: !entryId.isValid,
    helperText: entryId.error && translate(`${entryId.error}`)
  })), /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_6__["default"], {
    id: "fullGroupName",
    label: translate('createFullname'),
    value: fullGroupName.value,
    placeholder: translate('createFullnamePlaceholder'),
    onChange: handleChange(fullGroupName, setFullGroupName),
    error: !pristine && !fullGroupName.value,
    helperText: !pristine && !fullGroupName.value && 'Name required',
    required: true
  }), /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], {
    control: /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], {
      checked: showAdvancedOptions,
      onChange: handleShowAdvancedOptions,
      inputProps: {
        'aria-label': translate('advancedOptionsCheckbox')
      }
    }),
    label: translate('advancedOptionsCheckbox')
  })))), /*#__PURE__*/React.createElement(commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_18__.ErrorCatcher, {
    error: createError
  }));
};
CreateDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CreateDialog);

/***/ }),

/***/ "./modules/admin/groups/dialogs/MembersDialog/MembersDialog.js":
/*!*********************************************************************!*\
  !*** ./modules/admin/groups/dialogs/MembersDialog/MembersDialog.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! admin/nls/esadGroup.nls */ "./modules/admin/nls/esadGroup.nls");
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/nls/escoPlaceholder.nls */ "./modules/commons/nls/escoPlaceholder.nls");
/* harmony import */ var commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_EntryListView_lists_UsersList__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/EntryListView/lists/UsersList */ "./modules/commons/components/EntryListView/lists/UsersList/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");









const MembersDialog = _ref => {
  let {
    entry: groupEntry,
    closeDialog
  } = _ref;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__.useTranslation)([(admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_4___default()), (commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_5___default())]);
  return /*#__PURE__*/React.createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_2__["default"], {
    id: "members-dialog",
    title: translate('memberHeader', (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_6__.getRenderName)(groupEntry)),
    closeDialog: closeDialog,
    closeDialogButtonLabel: translate('close')
  }, /*#__PURE__*/React.createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_3__["default"], {
    md: 12
  }, /*#__PURE__*/React.createElement(commons_components_EntryListView_lists_UsersList__WEBPACK_IMPORTED_MODULE_8__["default"], {
    groupEntry: groupEntry,
    messages: {
      removeSuccessMessage: translate('removeSuccessMessage'),
      removeFailMessage: translate('removeFailMessage')
    },
    viewPlaceholderProps: {
      label: translate('emptyMessageMembers')
    }
  })));
};
MembersDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_0___default().func).isRequired,
  entry: prop_types__WEBPACK_IMPORTED_MODULE_0___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_1__.Entry)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (MembersDialog);

/***/ }),

/***/ "./modules/admin/groups/dialogs/MembersDialog/index.js":
/*!*************************************************************!*\
  !*** ./modules/admin/groups/dialogs/MembersDialog/index.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _MembersDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _MembersDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MembersDialog */ "./modules/admin/groups/dialogs/MembersDialog/MembersDialog.js");


/***/ }),

/***/ "./modules/admin/groups/dialogs/RemoveDialog.js":
/*!******************************************************!*\
  !*** ./modules/admin/groups/dialogs/RemoveDialog.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useMainDialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/hooks/useMainDialog */ "./modules/commons/hooks/useMainDialog.js");
/* harmony import */ var commons_components_common_dialogs_MainDialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/components/common/dialogs/MainDialog */ "./modules/commons/components/common/dialogs/MainDialog/index.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_components_entry_RemoveEntryDialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/entry/RemoveEntryDialog */ "./modules/commons/components/entry/RemoveEntryDialog/index.js");
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var commons_components_router_useNavigate__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/router/useNavigate */ "./modules/commons/components/router/useNavigate.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
const _excluded = ["entry", "actionParams", "nlsBundles", "closeDialog"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }


function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }









const RemoveDialog = _ref => {
  let {
      entry,
      actionParams,
      nlsBundles,
      closeDialog
    } = _ref,
    restProps = _objectWithoutProperties(_ref, _excluded);
  const {
    openMainDialog
  } = (0,commons_hooks_useMainDialog__WEBPACK_IMPORTED_MODULE_4__.useMainDialog)();
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_3__.useTranslation)(nlsBundles);
  const groupName = (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_7__.getRenderName)(entry) || entry.getId();
  const {
    goBack
  } = (0,commons_components_router_useNavigate__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const confirmRemoveHomeContext = async homeContextId => {
    try {
      const context = commons_store__WEBPACK_IMPORTED_MODULE_6__.entrystore.getContextById(homeContextId);
      const homeContextEntry = await context.getEntry();
      if (homeContextEntry) {
        openMainDialog({
          content: t('removeHomecontext', (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_7__.getRenderName)(homeContextEntry) || homeContextEntry.getId()),
          actions: /*#__PURE__*/React.createElement(commons_components_common_dialogs_MainDialog__WEBPACK_IMPORTED_MODULE_5__.ConfirmAction, {
            onDone: () => homeContextEntry.del(),
            affirmLabel: t('confirmRemoveHomecontext'),
            rejectLabel: t('cancelRemoveHomecontext')
          })
        });
      }
    } catch (error) {
      console.error(error);
    }
  };
  const onRemove = async () => {
    const entryResource = entry.getResource(true);
    const homeContextId = entryResource.getHomeContext();
    if (homeContextId) {
      await confirmRemoveHomeContext(homeContextId);
    }
    try {
      await entry.del();
    } catch (error) {
      openMainDialog({
        content: t('failedRemoveGroup'),
        actions: /*#__PURE__*/React.createElement(commons_components_common_dialogs_MainDialog__WEBPACK_IMPORTED_MODULE_5__.AcknowledgeAction, {
          onDone: closeDialog
        })
      });
      console.error(error);
    }
  };
  return /*#__PURE__*/React.createElement(commons_components_entry_RemoveEntryDialog__WEBPACK_IMPORTED_MODULE_8__["default"], _extends({}, restProps, {
    closeDialog: closeDialog,
    onRemove: onRemove,
    onRemoveCallback: goBack,
    removeConfirmMessage: t('removeGroupMessage', groupName)
  }));
};
RemoveDialog.propTypes = {
  entry: commons_util_entry__WEBPACK_IMPORTED_MODULE_9__.entryPropType,
  actionParams: prop_types__WEBPACK_IMPORTED_MODULE_2___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_2___default().shape({})),
  nlsBundles: commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_3__.nlsBundlesPropType,
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RemoveDialog);

/***/ }),

/***/ "./modules/admin/groups/dialogs/handler.js":
/*!*************************************************!*\
  !*** ./modules/admin/groups/dialogs/handler.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createGroupEntry: () => (/* binding */ createGroupEntry),
/* harmony export */   entryIdSearch: () => (/* binding */ entryIdSearch),
/* harmony export */   groupNameSearch: () => (/* binding */ groupNameSearch)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @entryscape/rdfjson */ "./node_modules/.pnpm/@entryscape+rdfjson@2.7.7/node_modules/@entryscape/rdfjson/src/main.js");




const validate = text => {
  const re = /([A-Z]|\s)/g;
  return re.test(text);
};

/**
 * Searches for a given group name
 *
 * @param {string} groupName
 * @returns {string|null}
 */
const groupNameSearch = async groupName => {
  if (validate(groupName)) {
    return 'nameMalformed';
  }
  return commons_store__WEBPACK_IMPORTED_MODULE_2__.entrystore.getREST().get(`${commons_store__WEBPACK_IMPORTED_MODULE_2__.entrystore.getBaseURI()}_principals?entryname=${groupName.toLowerCase()}`).then(data => {
    return data.length > 0 ? 'nameTaken' : null;
  });
};

/**
 * Searches for a given entryId
 *
 * @param {string} entryId
 * @returns {string|null}
 */
const entryIdSearch = async entryId => {
  if (validate(entryId)) {
    return 'entryIdMalformed';
  }
  const sq = await commons_store__WEBPACK_IMPORTED_MODULE_2__.entrystore.newSolrQuery().uri(`${commons_store__WEBPACK_IMPORTED_MODULE_2__.entrystore.getBaseURI()}_principals/entry/${entryId}`).limit(1).list();
  return sq.getEntries().then(entries => {
    return entries.length > 0 ? 'entryIdTaken' : null;
  });
};
const createGroupEntry = async _ref => {
  let {
    name,
    id,
    fullName
  } = _ref;
  let prototypeEntry;
  if (!id) {
    if (!name) {
      prototypeEntry = commons_store__WEBPACK_IMPORTED_MODULE_2__.entrystore.newGroup();
    } else {
      prototypeEntry = commons_store__WEBPACK_IMPORTED_MODULE_2__.entrystore.newGroup(name);
    }
  } else {
    const groupName = name || null;
    prototypeEntry = commons_store__WEBPACK_IMPORTED_MODULE_2__.entrystore.newGroup(groupName, id);
  }
  if (prototypeEntry) {
    const md = prototypeEntry.getMetadata();
    md.add(prototypeEntry.getResourceURI(), _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_3__.namespaces.expand('foaf:name'), {
      type: 'literal',
      value: fullName
    });
  }
  return prototypeEntry.commit();
};


/***/ }),

/***/ "./modules/admin/nls/esadContext.nls":
/*!*******************************************!*\
  !*** ./modules/admin/nls/esadContext.nls ***!
  \*******************************************/
/***/ ((module) => {

module.exports = [{"lang":"root","nls":{"listHeaderLabel":"Project","unnamedWorkspace":"Project with ID \"$1\".","newContextnameHeader":"New project","createContextname":"Project name","createFullname":"Display name of the project","createFullnamePlaceholder":"Display name, may include spaces","setNamePlaceholder":"Project name, no whitespace","createEntryIdPlaceholder":"Entry ID, no whitespaces","contextnameTaken":"This project name is taken, choose a different one.","nameTaken":"This project name is taken, choose a different one","nameMalformed":"The project name must be lower case without any whitespace characters","removeContextMessage":"Remove project \"$1\"?","confirmRemove":"Remove","cancelRemove":"Cancel","failedRemoveContext":"Failed to remove project","contextName":"Project name","contextACL":"Sharing settings","editEntry":"Edit","createEntryName":"project","confirmGroupInProject":"This project belongs to a group. Do you want to remove the associated group \"$1\" as well?","context":"Project","makePremium":"Upgrade to premium","unmakePremium":"Downgrade from premium","upgradeToPremiumNotification":"Project has been upgraded to premium","downgradeFromPremiumNotification":"Project has been downgraded from premium","createButton":"Create","actionTooltip":"Create project","advancedOptions":"Advanced options","createEntryId":"Entry ID","entryIdTaken":"This entry ID is taken, choose a different one.","projectReindex":"Reindex","reindexConfirmationQuestionNLS":"Reindexing takes some time. Meanwhile you can use the application. Do you want to proceed with reindexing?","createProjectSuccess":"Project created successfully","createProjectFail":"Failed to create project","reindexError":"Something went wrong. Try reindexing later"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/esadContext.nls"},{"lang":"de","nls":{"unnamedWorkspace":"Projekt mit ID \"$1\".","newContextnameHeader":"Neues Projekt","createContextname":"Projektname","createFullname":"Anzeigename des Projektes","createFullnamePlaceholder":"Anzeigename, darf Leerzeichen enthalten","setNamePlaceholder":"Projektname, darf keine Leerzeichen enthalten","contextnameTaken":"Dieser Projektname ist bereits in Verwendung, wählen Sie einen anderen.","nameTaken":"Dieser Projektname ist bereits in Verwendung, wählen Sie einen anderen","nameMalformed":"Der Projektname muss aus Kleinbuchstaben bestehen und darf keine Leerzeichen enthalten","confirmRemove":"Entfernen","cancelRemove":"Abbrechen","contextName":"Projektname","contextACL":"Teilungseinstellungen","editEntry":"Bearbeiten","createEntryName":"Projekt","context":"Projekt","makePremium":"Auf Premium upgraden","unmakePremium":"Downgrade von Premium","listHeaderLabel":"Projekt","actionTooltip":"Projekt erstellen","createEntryIdPlaceholder":"Eintrags-ID, keine Leerzeichen","createButton":"Erstellen","advancedOptions":"Erweiterte Optionen","createEntryId":"Eintrags-ID","entryIdTaken":"Diese Eintrags-ID wird bereits verwendet, wählen Sie eine andere","removeContextMessage":"Projekt \"$1\" entfernen?","failedRemoveContext":"Das Projekt konnte nicht entfernt werden","confirmGroupInProject":"Dieses Projekt gehört zu einer Gruppe. Möchten Sie auch die zugehörige Gruppe \"$1\" entfernen?","projectReindex":"Neuindexieren","reindexConfirmationQuestionNLS":"Die Neuindexierung kann etwas Zeit in Anspruch nehmen. In der Zwischenzeit können Sie die Anwendung weiterverwenden. Möchten Sie mit der Neuindexierung fortfahren?","reindexError":"Ein Fehler ist aufgetreten. Versuchen Sie die Neuindexeriung zu einem anderen Zeitpunkt durchzuführen.","upgradeToPremiumNotification":"Das Projekt wurde auf Premium hochgestuft","downgradeFromPremiumNotification":"Das Projekt wurde von Premium heruntergestuft","createProjectSuccess":"Projekt erfolgreich erstellt","createProjectFail":"Projekt konnte nicht erstellt werden"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/de/esadContext.nls"},{"lang":"sv","nls":{"unnamedWorkspace":"Projekt med ID \"$1\".","newContextnameHeader":"Nytt projekt","createContextname":"Projektnamn","createFullname":"Projektets visningsnamn","createFullnamePlaceholder":"Visningsnamn, får innehålla blanktecken","setNamePlaceholder":"Projektnamn, inga blanktecken","contextnameTaken":"Detta projektnamn är taget, välj ett annat.","nameTaken":"Detta projektnamn är taget, välj ett annat.","nameMalformed":"Projektnamnet måste bestå av små bokstäver utan blanktecken","confirmRemove":"Ta bort","cancelRemove":"Avbryt","contextName":"Projektnamn","contextACL":"Delningsinställningar","editEntry":"Redigera","createEntryName":"projekt","context":"Projekt","makePremium":"Uppgradera till premium","unmakePremium":"Nedgradera från premium","listHeaderLabel":"Projekt","actionTooltip":"Skapa projekt","createEntryIdPlaceholder":"Post-ID, inga mellanslag","createButton":"Skapa","advancedOptions":"Avancerade inställningar","createEntryId":"Post-ID","entryIdTaken":"Detta post-ID används redan, välj ett annat.","removeContextMessage":"Ta bort projekt \"$1\"?","failedRemoveContext":"Projektet kunde inte tas bort","confirmGroupInProject":"Detta projekt tillhör en grupp. Vill du ta bort den tillhörande gruppen \"$1\" också?","projectReindex":"Omindexera","reindexConfirmationQuestionNLS":"Omindexering tar lite tid. Du kan använda programmet under omindexeringen. Vill du fortsätta med att omindexera?","reindexError":"Något gick fel. Prova att omindexa senare","upgradeToPremiumNotification":"Projektet har uppgraderats till premium","downgradeFromPremiumNotification":"Projektet har nedgraderats från premium","createProjectSuccess":"Projektet har skapats","createProjectFail":"Projektet kunde inte skapas"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/sv/esadContext.nls"},{"lang":"it","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/it/esadContext.nls"},{"lang":"fr","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/fr/esadContext.nls"}];

/***/ }),

/***/ "./modules/admin/nls/esadEntityType.nls":
/*!**********************************************!*\
  !*** ./modules/admin/nls/esadEntityType.nls ***!
  \**********************************************/
/***/ ((module) => {

module.exports = [{"lang":"root","nls":{"typeInfoDialogTitle":"Entity type configuration","showTypeInfoDialogTitle":"Show entity type configuration","builtinLabel":"Built-in entity type","customLabel":"Custom entity type","addLabel":"Create","addTooltip":"Create custom entity type","builtinFilterLabel":"Built-in","customFilterLabel":"Custom","migrateToStoreLabel":"Migrate to backend","emptyListWarning":"Custom entity types will appear here","createHeader":"Create custom entity type","selectEntityTypeTitle":"Select entity type","selectEntityTypeLabel":"Select","selectEntityTypeTooltip":"Select entity type","editCustomEntityTypeSuccess":"Entity type successfully saved","editCustomEntityTypeFail":"Failed to save entity type","createCustomEntityTypeSuccess":"Entity type successfully created","createCustomEntityTypeFail":"Failed to create entity type","removeCustomEntityTypeSuccess":"Entity type successfully removed","removeCustomEntityTypeFail":"Failed to remove entity type"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/esadEntityType.nls"},{"lang":"de","nls":{"typeInfoDialogTitle":"Konfiguration des Objekttyps","showTypeInfoDialogTitle":"Konfiguration des Objekttyps anzeigen","builtinLabel":"Integrierter Objekttyp","customLabel":"Benutzerdefinierter Objekttyp","addLabel":"Erstellen","addTooltip":"Benutzerdefinierten Objekttyp erstellen","builtinFilterLabel":"Integriert","customFilterLabel":"Benutzerdefiniert","migrateToStoreLabel":"In das Backend migrieren","emptyListWarning":"Benutzerdefinierte Objekttypen werden hier angezeigt","createHeader":"Benutzerdefinierten Objekttyp erstellen","selectEntityTypeTitle":"Objekttyp wählen","selectEntityTypeLabel":"Wählen","selectEntityTypeTooltip":"Objekttyp wählen","editCustomEntityTypeSuccess":"Der Objekttyp wurde gespeichert","createCustomEntityTypeSuccess":"Der Objekttyp wurde erstellt","removeCustomEntityTypeSuccess":"Der Objekttyp wurde entfernt","removeCustomEntityTypeFail":"Der Objekttyp konnte nicht entfernt werden","editCustomEntityTypeFail":"Der Objekttyp konnte nicht gespeichert werden","createCustomEntityTypeFail":"Der Objekttyp konnte nicht erstellt werden"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/de/esadEntityType.nls"},{"lang":"sv","nls":{"typeInfoDialogTitle":"Konfiguration av entitetstyp","showTypeInfoDialogTitle":"Visa konfiguration av entitetstyp","builtinLabel":"Inbyggd entitetstyp","customLabel":"Anpassad entitetstyp","addLabel":"Skapa","addTooltip":"Skapa anpassad entitetstyp","builtinFilterLabel":"Inbyggd","customFilterLabel":"Anpassat","migrateToStoreLabel":"Migrera till backend","emptyListWarning":"Anpassade entitetstyper visas här","createHeader":"Skapa anpassad entitetstyp","selectEntityTypeTitle":"Välj entitetstyp","selectEntityTypeLabel":"Välj","selectEntityTypeTooltip":"Välj entitetstyp","editCustomEntityTypeSuccess":"Entitetstypen har sparats","createCustomEntityTypeSuccess":"Entitetstypen har sparats","removeCustomEntityTypeSuccess":"Entitetstypen har tagits bort","removeCustomEntityTypeFail":"Det gick inte att ta bort entitetstypen","editCustomEntityTypeFail":"Entitetstyp kunde inte sparas","createCustomEntityTypeFail":"Entitetstyp kunde inte skapas"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/sv/esadEntityType.nls"},{"lang":"it","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/it/esadEntityType.nls"},{"lang":"fr","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/fr/esadEntityType.nls"}];

/***/ }),

/***/ "./modules/admin/nls/esadEntityTypeSelect.nls":
/*!****************************************************!*\
  !*** ./modules/admin/nls/esadEntityTypeSelect.nls ***!
  \****************************************************/
/***/ ((module) => {

module.exports = [{"lang":"root","nls":{"entityTypeSelectDialogTitle":"Select entity types","listHeaderLabel":"Entity types","entityTypeSelectDialogButtonLabel":"Select","editSelectionButton":"Edit selection","emptyListWarning":"Entity types will appear here","hideTooltip":"Hide selected entity types","showTooltip":"Show selected entity types","showSelectedLabel":"Show selected only","showAllLabel":"Show all","addSelectionLabel":"Add selection","selectionListPlaceholder":"Entity types will appear here","selectionListLabel":"Selected entity types","noSearchResults":"No results for \"$1\"","noSearchResultsFilters":"No entity types selected","noSearchResultsFiltersAndQuery":"No matching results in the selected entity types"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/esadEntityTypeSelect.nls"},{"lang":"de","nls":{"entityTypeSelectDialogTitle":"Wählen Sie Objekttypen","listHeaderLabel":"Objekttypen","entityTypeSelectDialogButtonLabel":"Auswählen","editSelectionButton":"Auswahl bearbeiten","emptyListWarning":"Objekttypen werden hier angezeigt","hideTooltip":"Ausgewählte Objekttypen ausblenden","showTooltip":"Ausgewählte Objekttypen anzeigen","showSelectedLabel":"Nur ausgewählte Objekttypen anzeigen","showAllLabel":"Alle anzeigen","addSelectionLabel":"Auswahl hinzufügen","selectionListPlaceholder":"Objekttypen werden hier angezeigt","selectionListLabel":"Ausgewählte Objekttypen","noSearchResults":"Keine Ergebnisse für \"$1\"","noSearchResultsFilters":"Keine Objekttypen ausgewählt","noSearchResultsFiltersAndQuery":"Keine Ergebnisse in den ausgewählten Entitätstypen"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/de/esadEntityTypeSelect.nls"},{"lang":"sv","nls":{"entityTypeSelectDialogTitle":"Välj entitetstyper","listHeaderLabel":"Entitetstyper","entityTypeSelectDialogButtonLabel":"Välj","editSelectionButton":"Redigera urval","emptyListWarning":"Entitetstyper visas här","hideTooltip":"Dölj valda entitetstyper","showTooltip":"Visa valda entitetstyper","showSelectedLabel":"Visa endast valda","showAllLabel":"Visa allt","addSelectionLabel":"Lägg till urval","selectionListPlaceholder":"Entitetstyper kommer att visas här","selectionListLabel":"Valda entitetstyper","noSearchResults":"Inga resultat för \"$1\"","noSearchResultsFilters":"Inga entitetstyper har valts","noSearchResultsFiltersAndQuery":"Inga matchande resultat för de valda entitetstyperna"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/sv/esadEntityTypeSelect.nls"},{"lang":"it","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/it/esadEntityTypeSelect.nls"},{"lang":"fr","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/fr/esadEntityTypeSelect.nls"}];

/***/ }),

/***/ "./modules/admin/nls/esadGroup.nls":
/*!*****************************************!*\
  !*** ./modules/admin/nls/esadGroup.nls ***!
  \*****************************************/
/***/ ((module) => {

module.exports = [{"lang":"root","nls":{"advancedOptionsCheckbox":"Advanced options","listHeaderLabel":"Group","createGroupHeader":"Create group","createGroupname":"Group name","createGroupnamePlaceholder":"Group name, must not contain whitespaces","createEntryId":"Entry ID","createEntryIdPlaceholder":"Entry ID, must not contain whitespaces","createGroupButton":"Create group","createFullname":"Display name of the group","createFullnamePlaceholder":"Display name, may include whitespaces","removeGroupMessage":"Remove group \"$1\"?","confirmRemove":"Remove","cancelRemove":"Cancel","removeHomecontext":"Do you also want to remove the associated project \"$1\"?","confirmRemoveHomecontext":"Remove","cancelRemoveHomecontext":"Cancel","failedRemoveGroup":"Failed to remove group","failCreateGroup":"Could not create group and context entry","memberHeader":"Members in group \"$1\"","memberList":"Members","groupACL":"Sharing settings","nameTaken":"This group name is already in use","nameMalformed":"The group name must be lowercase without any whitespace characters","entryIdTaken":"This entry ID is already in use","entryIdMalformed":"The entry ID must be lowercase without any whitespace characters","setNamePlaceholder":"Group name, without whitespaces","groupName":"Group name","editEntry":"Edit","createEntryName":"group","manager":"Manager","member":"Member","removeManager":"The user is manager and cannot be removed from the group. You have to downgrade the user to a regular member before removal.","removeMemberFromGroup":"Are you sure you want to remove the member from the group?","removeSuccessMessage":"The user has been removed from the group","removeFailMessage":"Failed to remove user from group","emptyMessageMembers":"Members of the group will be shown here","nonMemberInfoMsg":"Contact the manager of the group if you need to change something","actionTooltip":"Create group","removeGroupFromUser":"Are you sure you want to remove the user from the group?","unnamedWorkspace":"Group with ID \"$1\".","selectEntity":"Add","selectedEntityLabel":"Added","selectGroup":"Select a group to add the user to","addUserToGroupNLS":"Add user to group","emptyListWarning":"Groups the user is a member of will be shown here","createGroupSuccess":"Group created successfully","createGroupFail":"Failed to create group","close":"Close"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/esadGroup.nls"},{"lang":"de","nls":{"createGroupHeader":"Gruppe erstellen","createGroupname":"Gruppenname","createGroupnamePlaceholder":"Gruppenname, darf keine Leerzeichen enthalten","createGroupButton":"Gruppe erstellen","createFullname":"Anzeigename der Gruppe","createFullnamePlaceholder":"Anzeigename, darf Leerzeichen enthalten","confirmRemove":"Entfernen","cancelRemove":"Abbrechen","removeHomecontext":"Möchten Sie auch das zugehörige Projekt \"$1\" entfernen?","confirmRemoveHomecontext":"Entfernen","cancelRemoveHomecontext":"Abbrechen","memberHeader":"Mitglieder der Gruppe \"$1\"","memberList":"Mitglieder","groupACL":"Teilungseinstellungen","nameTaken":"Der Gruppenname ist bereits in Verwendung","nameMalformed":"Der Gruppenname muss aus Kleinbuchstaben bestehen und darf keine Leerzeichen enthalten","setNamePlaceholder":"Gruppenname, ohne Leerzeichen","groupName":"Gruppenname","editEntry":"Bearbeiten","createEntryName":"Gruppe","manager":"Manager","member":"Mitglied","removeManager":"Der Benutzer ist Manager und kann nicht aus der Gruppe entfernt werden. Sie müssen ihn zu einem regulären Mitglied herunterstufen bevor Sie ihn aus der Gruppe entfernen können.","emptyMessageMembers":"Gruppenmitglieder werden hier angezeigt werden","nonMemberInfoMsg":"Kontaktieren Sie den Manager dieser Gruppe falls Sie etwas ändern müssen","listHeaderLabel":"Gruppe","removeMemberFromGroup":"Möchten Sie den Benutzer aus der Gruppe entfernen?","actionTooltip":"Gruppe erstellen","addUserToGroupNLS":"Benutzer zur Gruppe hinzufügen","advancedOptionsCheckbox":"Erweiterte Optionen","createEntryId":"Eintrags-ID","createEntryIdPlaceholder":"Eintrags-ID, darf keine Leerzeichen enthalten","failCreateGroup":"Einträge für Gruppe oder Kontext konnte nicht erstellt werden","entryIdTaken":"Diese Eintrags-ID wird bereits verwendet","entryIdMalformed":"Die Eintrags-ID muss in Kleinbuchstaben und ohne Leerzeichen angegeben werden","removeGroupFromUser":"Soll der Benutzer aus der Gruppe entfernt werden?","unnamedWorkspace":"Gruppe mit ID \"$1\".","selectEntity":"Hinzufügen","selectGroup":"Wählen Sie eine Gruppe aus, zu der der Benutzer hinzugefügt werden soll","close":"Schließen","emptyListWarning":"Hier werden die Gruppen angezeigt, in denen der Benutzer Mitglied ist","removeGroupMessage":"Gruppe \"$1\" entfernen?","failedRemoveGroup":"Die Gruppe konnte nicht entfernt werden","selectedEntityLabel":"Hinzugefügt","removeSuccessMessage":"Der Benutzer wurde aus der Gruppe entfernt","removeFailMessage":"Der Benutzer konnte nicht aus der Gruppe entfernt werden","createGroupSuccess":"Gruppe erfolgreich erstellt","createGroupFail":"Gruppe konnte nicht erstellt werden"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/de/esadGroup.nls"},{"lang":"sv","nls":{"createGroupHeader":"Skapa grupp","createGroupname":"Gruppnamn","createGroupnamePlaceholder":"Gruppnamn, får inte innehålla blanktecken","createGroupButton":"Skapa grupp","createFullname":"Gruppens visningsnamn","createFullnamePlaceholder":"Visningsnamn, får innehålla mellanslag","confirmRemove":"Ta bort","cancelRemove":"Avbryt","removeHomecontext":"Vill du också ta bort det associerade projektet \"$1\"?","confirmRemoveHomecontext":"Ta bort","cancelRemoveHomecontext":"Avbryt","memberHeader":"Medlemmar i grupp \"$1\"","memberList":"Medlemmar","groupACL":"Delningsinställningar","nameTaken":"Detta gruppnamn är taget, välj ett annat.","nameMalformed":"Namnet får enbart bestå av små bokstäver och inte innehålla blanktecken.","setNamePlaceholder":"Gruppnamn, inga mellanslag","groupName":"Namn","editEntry":"Redigera","createEntryName":"grupp","manager":"Gruppansvarig","member":"Medlem","removeManager":"Användaren är gruppansvarig och kan inte tas bort från gruppen. Du måste nedgradera användaren till en vanlig medlem innan den kan tas bort.","emptyMessageMembers":"Gruppmedlemmar kommer visas här","nonMemberInfoMsg":"Kontakta gruppansvarig om du vill ändra någonting","listHeaderLabel":"Grupp","removeMemberFromGroup":"Vill du ta bort användaren från gruppen?","actionTooltip":"Skapa grupp","addUserToGroupNLS":"Lägg till användare i gruppen","advancedOptionsCheckbox":"Avancerade inställningar","createEntryId":"Post-ID","createEntryIdPlaceholder":"Post-ID, får inte innehålla mellanslag","failCreateGroup":"Det gick inte att skapa poster för grupp och kontext","entryIdTaken":"Detta post-ID används redan","entryIdMalformed":"Post-ID måste bestå av gemener utan mellanslag","removeGroupFromUser":"Ska användaren tas bort från gruppen?","unnamedWorkspace":"Grupp med ID \"$1\".","selectEntity":"Lägg till","selectGroup":"Välj en grupp att lägga till användaren till","close":"Stäng","emptyListWarning":"Grupper som användaren är medlem i kommer visas här","removeGroupMessage":"Ta bort grupp \"$1\"?","failedRemoveGroup":"Gruppen kunde inte tas bort","selectedEntityLabel":"Lagt till","removeSuccessMessage":"Användaren har tagits bort från gruppen","removeFailMessage":"Det gick inte att ta bort användaren från gruppen","createGroupSuccess":"Gruppen har skapats","createGroupFail":"Gruppen kunde inte skapas"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/sv/esadGroup.nls"},{"lang":"it","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/it/esadGroup.nls"},{"lang":"fr","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/fr/esadGroup.nls"}];

/***/ }),

/***/ "./modules/admin/nls/esadProjectType.nls":
/*!***********************************************!*\
  !*** ./modules/admin/nls/esadProjectType.nls ***!
  \***********************************************/
/***/ ((module) => {

module.exports = [{"lang":"root","nls":{"addLabel":"Create","addTooltip":"Create project type","createCustomEntityTypeSuccess":"Project type successfully created","createHeader":"Create project type","close":"Close","disabledSelectionTooltip":"Already in use","editCustomEntityTypeSuccess":"Project type successfully saved","editHeader":"Edit project type","emptyListWarning":"Project types will appear here","entityTypeSelectDialogTitle":"Select entity types","iconTooltip":"Project type","listHeaderLabel":"Project types","removeProjectTypeSuccess":"Project type successfully removed","removeProjectTypeFail":"An error occured while removing the project type","showTypeInfoDialogTitle":"Show project type configuration","typeInfoDialogTitle":"Project type configuration"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/esadProjectType.nls"},{"lang":"de","nls":{"addLabel":"Erstellen","addTooltip":"Projekttyp erstellen","createCustomEntityTypeSuccess":"Projekttyp erfolgreich erstellt","createHeader":"Projekttyp erstellen","close":"Schließen","disabledSelectionTooltip":"Bereits in Verwendung","editCustomEntityTypeSuccess":"Projekttyp erfolgreich gespeichert","editHeader":"Projekttyp bearbeiten","emptyListWarning":"Projekttypen werden hier angezeigt","entityTypeSelectDialogTitle":"Wählen Sie Objekttypen aus","iconTooltip":"Projekttyp","listHeaderLabel":"Projekttyp","removeProjectTypeSuccess":"Projekttyp erfolgreich entfernt","removeProjectTypeFail":"Fehler beim Entfernen des Projekttyps","showTypeInfoDialogTitle":"Beim Entfernens des Projekttyps ist ein Fehler aufgetreten","typeInfoDialogTitle":"Konfiguration des Projekttyps"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/de/esadProjectType.nls"},{"lang":"sv","nls":{"addLabel":"Skapa","addTooltip":"Skapa projekttyp","createCustomEntityTypeSuccess":"Projekttyp har skapats","createHeader":"Skapa projekttyp","close":"Stäng","disabledSelectionTooltip":"Används redan","editCustomEntityTypeSuccess":"Projekttypen har sparats","editHeader":"Redigera projekttyp","emptyListWarning":"Projekttyper kommer att visas här","entityTypeSelectDialogTitle":"Välj entitetstyper","iconTooltip":"Projekttyp","listHeaderLabel":"Projekttyper","removeProjectTypeSuccess":"Projekttypen har tagits bort","removeProjectTypeFail":"Ett fel uppstod när projekttypen skulle tas bort","showTypeInfoDialogTitle":"Visa projekttypskonfiguration","typeInfoDialogTitle":"Projekttypskonfiguration"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/sv/esadProjectType.nls"},{"lang":"it","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/it/esadProjectType.nls"},{"lang":"fr","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/fr/esadProjectType.nls"}];

/***/ }),

/***/ "./modules/admin/nls/esadType.nls":
/*!****************************************!*\
  !*** ./modules/admin/nls/esadType.nls ***!
  \****************************************/
/***/ ((module) => {

module.exports = [{"lang":"root","nls":{"labelListHeader":"Label","modifiedListHeader":"Modified","close":"Close","createButtonLabel":"Create","editHeader":"Edit","endpointLabel":"Endpoint","labelsLabel":"Labels","showAdvancedLabel":"Show advanced options","hideAdvancedLabel":"Hide advanced options","confirmRemove":"Remove","cancelRemove":"Cancel","removeConfirmMessage":"Remove the entry?","constraintsLabel":"Constraints","constraintObjectLabel":"Constraint object","constraintPropertyLabel":"Constraint property","labelLabel":"Label","descriptionLabel":"Description","rdfTypeLabel":"RDF type","templateLabel":"Template","moduleLabel":"Module","includeInternalLabel":"Include internal","inlineCreationLabel":"Inline creation","includeFileLabel":"Include file","includeLinkLabel":"Include link","createOptionsLabel":"Create options","iconIdLabel":"Icon ID","useWithLabel":"Use with","refinesLabel":"Refines","templateLevelLabel":"Template level","publishControlLabel":"Publish control","searchPropsLabel":"Search props","allContextsLabel":"All contexts","contextLabel":"Context","uriPatternLabel":"URI pattern","restrictToLabel":"Restrict to","globalLabel":"Global","mainLabel":"Main","storeConfigLabel":"Store config","defaultEntityTypesLabel":"Default entity types","optioinalEntityTypesLabel":"Optional entity types","namespaceLabel":"Namespace","localNameLabel":"Local name"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/esadType.nls"},{"lang":"de","nls":{"labelListHeader":"Bezeichnung","modifiedListHeader":"Geändert","close":"Schließen","createButtonLabel":"Erstellen","editHeader":"Bearbeiten","showAdvancedLabel":"Erweiterte Optionen anzeigen","hideAdvancedLabel":"Erweiterte Optionen verbergen","confirmRemove":"Entfernen","cancelRemove":"Abbrechen","removeConfirmMessage":"Eintrag entfernen?","endpointLabel":"Endpunkt","labelsLabel":"Labels","constraintsLabel":"Begrenzungen","constraintObjectLabel":"Begrenzungsobjekt","constraintPropertyLabel":"Begrenzungseigenschaft","namespaceLabel":"Namensraum","localNameLabel":"Lokaler Name","labelLabel":"Name","descriptionLabel":"Beschreibung","rdfTypeLabel":"RDF-Typ","templateLabel":"Vorlage","moduleLabel":"Modul","includeInternalLabel":"Intern inkludieren","inlineCreationLabel":"Inline-Erstellung","includeFileLabel":"Datei inkludieren","includeLinkLabel":"Link inkludieren","createOptionsLabel":"Optionen erstellen","iconIdLabel":"Symbol ID","useWithLabel":"Verwenden mit","refinesLabel":"Verfeinert","templateLevelLabel":"Vorlagenebene","publishControlLabel":"Veröffentlichungskontrolle","searchPropsLabel":"Eigenschaften für Suche","allContextsLabel":"Alle Kontexte","contextLabel":"Kontext","uriPatternLabel":"URI-Muster","restrictToLabel":"Beschränken auf","globalLabel":"Global","mainLabel":"Main","storeConfigLabel":"Store-Konfiguration","defaultEntityTypesLabel":"Standardobjekttypen","optioinalEntityTypesLabel":"Optionale objekttypen"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/de/esadType.nls"},{"lang":"sv","nls":{"labelListHeader":"Beteckning","modifiedListHeader":"Ändrad","close":"Stäng","createButtonLabel":"Skapa","editHeader":"Redigera","showAdvancedLabel":"Visa avancerade alternativ","hideAdvancedLabel":"Dölj avancerade alternativ","confirmRemove":"Ta bort","cancelRemove":"Avbryt","removeConfirmMessage":"Ta bort posten?","endpointLabel":"Endpoint","labelsLabel":"Labels","constraintsLabel":"Begränsningar","constraintObjectLabel":"Begränsningsobjekt","constraintPropertyLabel":"Begränsningsegenskap","namespaceLabel":"Namnrymd","localNameLabel":"Lokalt namn","labelLabel":"Namn","descriptionLabel":"Beskrivning","rdfTypeLabel":"RDF-typ","templateLabel":"Mall","moduleLabel":"Modul","includeInternalLabel":"Inkludera internt","inlineCreationLabel":"Inline-skapning","includeFileLabel":"Inkludera fil","includeLinkLabel":"Inkludera länk","createOptionsLabel":"Skapa alternativ","iconIdLabel":"Symbol-ID","useWithLabel":"Använd med","refinesLabel":"Förfinar","templateLevelLabel":"Mallnivå","publishControlLabel":"Publiceringskontroll","searchPropsLabel":"Egenskaper för sökning","allContextsLabel":"Alla kontext","contextLabel":"Kontext","uriPatternLabel":"URI-mönster","restrictToLabel":"Begränsa till","globalLabel":"Global","mainLabel":"Main","storeConfigLabel":"Store-konfiguration","defaultEntityTypesLabel":"Standardentitetstyper","optioinalEntityTypesLabel":"Valfria entitetstyper"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/sv/esadType.nls"},{"lang":"it","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/it/esadType.nls"},{"lang":"fr","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/fr/esadType.nls"}];

/***/ }),

/***/ "./modules/admin/nls/esadUser.nls":
/*!****************************************!*\
  !*** ./modules/admin/nls/esadUser.nls ***!
  \****************************************/
/***/ ((module) => {

module.exports = [{"lang":"root","nls":{"listHeaderLabel":"User","unnamedUser":"User with ID \"${id}\".","createUserHeader":"Create user","createUsername":"Username","createUsernamePlaceholder":"Username, should be a valid email address","createUsernameHelptext":"Username, has to be a valid email address to be able to reset password","usernameTaken":"This username is already in use.","usernameHasSpaces":"The username should not contain spaces.","createUserButton":"Create user","createContextWithUser":"Create personal project","createFirstname":"Given name","createFirstnamePlaceholder":"The given name of the user","createLastname":"Family name","createLastnamePlaceholder":"The family name of the user","removeHomecontext":"Remove the user's personal project as well?","confirmRemoveHomecontext":"Remove","cancelRemoveHomecontext":"Cancel","groupsList":"Memberships","groupHeader":"Groups of which user \"${user}\" is member","userACL":"Sharing settings","selectUser":"Select user to add to group","selectEntity":"Select","listHeaderUser":"User","userStatusEnable":"Enable","userStatusDisable":"Disable","userStatusDisabled":"This user is disabled and cannot sign in to the application","userStatusEnableConfirmation":"Are you sure you want to enable this user? Doing so will allow the user to sign in to the application.","userStatusDisableConfirmation":"Are you sure you want to disable this user? Doing so will disallow the user from signing in to the application.","setPassword":"Change password","setPasswordHeader":"Change password","setPasswordButton":"Save new password","setPasswordError":"The password could not be changed","currentPasswordError":"The provided current password is wrong","setPasswordSuccess":"The password was successfully changed","changeUsernameFail":"Failed to change username","customProperties":"Custom properties","createEntryName":"user","changeUsername":"Change username","currentUsernameLabel":"Current username","changeUsernameLabel":"Change username to","changeUsernameHeader":"Change username","changeUsernameButton":"Save new username","addToPremiumGroup":"Upgrade to premium","removeFromPremiumGroup":"Downgrade from premium","upgradeToPremiumNotification":"User has been upgraded to premium","downgradeFromPremiumNotification":"User has been downgraded from premium","actionTooltip":"Create user","usernameRequired":"Username is required","firstnameRequired":"First name is required","lastnameRequired":"Last name is required","disableUserButtonLabel":"Disable","createUserSuccess":"User created successfully","createUserFail":"Failed to create user","enableUserButtonLabel":"Enable","disabledTag":"Disabled","removeUserMessage":"Remove user \"$1\"?"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/esadUser.nls"},{"lang":"de","nls":{"unnamedUser":"Benutzer mit ID \"${id}\".","createUserHeader":"Benutzer erstellen","createUsername":"Benutzername","createUsernamePlaceholder":"Benutzername, muss eine gültige E-Mail-Adresse sein","usernameTaken":"Der Benutzername ist bereits in Verwendung.","createUserButton":"Benutzer erstellen","createContextWithUser":"Persönliches Projekt erstellen","createFirstname":"Vorname","createFirstnamePlaceholder":"Der Vorname des Benutzers","createLastname":"Nachname","createLastnamePlaceholder":"Der Nachname des Benutzers","removeHomecontext":"Soll auch das persönliche Projekt des Benutzers entfernt werden?","confirmRemoveHomecontext":"Entfernen","cancelRemoveHomecontext":"Abbrechen","groupsList":"Mitgliedschaften","groupHeader":"Gruppen, deren Mitglied \"${user}\" ist","userACL":"Teilungseinstellungen","setPassword":"Kennwort ändern","setPasswordHeader":"Kennwort ändern","setPasswordButton":"Neues Kennwort speichern","customProperties":"Benutzerdefinierte Eigenschaften","setPasswordError":"Das Kennwort konnte nicht geändert werden","createEntryName":"Benutzer","changeUsername":"Benutzername ändern","currentUsernameLabel":"Aktueller Benutzername","changeUsernameLabel":"Benutzername ändern auf","changeUsernameHeader":"Benutzername ändern","changeUsernameButton":"Benutzername speichern","addToPremiumGroup":"Auf Premium upgraden","removeFromPremiumGroup":"Downgrade von Premium","userStatusEnable":"Aktivieren","userStatusDisable":"Deaktivieren","userStatusDisabled":"Dieser Benutzer ist deaktiviert und kann sich nicht anmelden","userStatusEnableConfirmation":"Möchten Sie diesen Benutzer aktivieren? Dies ermöglicht dem Benutzer sich anzumelden.","userStatusDisableConfirmation":"Möchten Sie diesen Benutzer deaktivieren? Dies führt dazu dass der Benutzer sich nicht mehr anmelden kann.","usernameHasSpaces":"Der Benutzername sollte keine Leerzeichen enthalten.","listHeaderLabel":"Benutzer","selectUser":"Wählen Sie den Benutzer aus, der der Gruppe hinzugefügt werden soll","selectEntity":"Wählen","listHeaderUser":"Benutzer","setPasswordSuccess":"Das Kennwort wurde erfolgreich geändert","actionTooltip":"Benutzer erstellen","firstnameRequired":"Vorname ist erforderlich","lastnameRequired":"Nachname ist erforderlich","usernameRequired":"Ein Benutzername wird benötigt","disableUserButtonLabel":"Deaktivieren","enableUserButtonLabel":"Aktivieren","createUsernameHelptext":"Benutzername, muss eine gültige E-Mail-Adresse sein um das Kennwort zurücksetzen zu können","upgradeToPremiumNotification":"Der Benutzer wurde auf Premium hochgestuft","downgradeFromPremiumNotification":"Der Benutzer wurde von Premium heruntergestuft","currentPasswordError":"Das angegebene aktuelle Kennwort ist falsch","createUserSuccess":"Benutzer erfolgreich erstellt","createUserFail":"Benutzer konnte nicht erstellt werden","changeUsernameFail":"Der Benutzername konnte nicht geändert werden","removeUserMessage":"Benutzer \"$1\" entfernen?","disabledTag":"Deaktiviert"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/de/esadUser.nls"},{"lang":"sv","nls":{"unnamedUser":"Användare med ID \"${id}\".","createUserHeader":"Skapa användare","createUsername":"Användarnamn","createUsernamePlaceholder":"Användarnamn, måste vara en e-post-adress","usernameTaken":"Detta användarnamn är taget, välj ett annat.","createUserButton":"Skapa användare","createContextWithUser":"Skapa ett personligt projekt","createFirstname":"Förnamn","createFirstnamePlaceholder":"Användarens förnamn","createLastname":"Efternamn","createLastnamePlaceholder":"Användarens efternamn","removeHomecontext":"Ta även bort användarens personliga projekt?","confirmRemoveHomecontext":"Ta bort","cancelRemoveHomecontext":"Avbryt","groupsList":"Medlemskap","groupHeader":"Grupper där användaren \"${user}\" är medlem","userACL":"Delningsinställningar","setPassword":"Ändra lösenord","setPasswordHeader":"Ändra lösenord","setPasswordButton":"Spara nytt lösenord","customProperties":"Anpassade egenskaper","setPasswordError":"Lösenordet kunde inte ändras","createEntryName":"användare","changeUsername":"Ändra användarnamn","currentUsernameLabel":"Nuvarande användarnamn","changeUsernameLabel":"Ändra användarnamn till","changeUsernameHeader":"Ändra användarnamn","changeUsernameButton":"Spara nytt användarnamn","addToPremiumGroup":"Uppgradera till premium","removeFromPremiumGroup":"Nedgradera från premium","userStatusEnable":"Aktivera","userStatusDisable":"Inaktivera","userStatusDisabled":"Användaren är inaktiverad och kan inte logga in","userStatusEnableConfirmation":"Är du säker på att du vill aktivera användaren? Om du gör det kan användaren logga in.","userStatusDisableConfirmation":"Är du säker på att du vill inaktivera användaren? Om du gör det kommer användaren inte att kunna logga in.","usernameHasSpaces":"Användarnamnet bör inte innehålla mellanslag.","listHeaderLabel":"Användare","selectUser":"Välj användare som du vill lägga till i gruppen","selectEntity":"Välj","listHeaderUser":"Användare","setPasswordSuccess":"Lösenordet ändrades","actionTooltip":"Skapa användare","firstnameRequired":"Förnamn krävs","lastnameRequired":"Efternamn krävs","usernameRequired":"Användarnamn krävs","disableUserButtonLabel":"Avaktivera","enableUserButtonLabel":"Aktivera","createUsernameHelptext":"Användarnamnet, måste vara en korrekt e-post-adress för att kunna återställa lösenordet","upgradeToPremiumNotification":"Användare har uppgraderats till premium","downgradeFromPremiumNotification":"Användare har nedgraderats från premium","currentPasswordError":"Det angivna aktuella lösenordet är fel","createUserSuccess":"Användaren har skapats","createUserFail":"Användaren kunde inte skapas","changeUsernameFail":"Användarnamn kunde inte sparas","removeUserMessage":"Ta bort användare \"$1\"?","disabledTag":"Inaktiverad"},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/sv/esadUser.nls"},{"lang":"it","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/it/esadUser.nls"},{"lang":"fr","nls":{},"path":"/opt/atlassian/pipelines/agent/build/modules/admin/nls/fr/esadUser.nls"}];

/***/ }),

/***/ "./modules/admin/projects/ProjectOverview/ProjectOverview.js":
/*!*******************************************************************!*\
  !*** ./modules/admin/projects/ProjectOverview/ProjectOverview.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/hooks/useEntry */ "./modules/commons/hooks/useEntry.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/hooks/useDocumentTitle */ "./modules/commons/hooks/useDocumentTitle.js");
/* harmony import */ var commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/hooks/usePageTitle */ "./modules/commons/hooks/usePageTitle.js");
/* harmony import */ var commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/hooks/useGetContributors */ "./modules/commons/hooks/useGetContributors.js");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/nls/escoOverview.nls */ "./modules/commons/nls/escoOverview.nls");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! admin/nls/esadContext.nls */ "./modules/admin/nls/esadContext.nls");
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/components/overview/Overview */ "./modules/commons/components/overview/Overview/index.js");
/* harmony import */ var commons_components_overview__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/overview */ "./modules/commons/components/overview/index.js");
/* harmony import */ var commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/components/LinkedDataBrowserDialog */ "./modules/commons/components/LinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_locale__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/locale */ "./modules/commons/locale/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./actions */ "./modules/admin/projects/ProjectOverview/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




















const nlsBundles = [(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_7___default()), (commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_12___default()), (admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_13___default())];
const ProjectOverview = _ref => {
  let {
    overviewProps
  } = _ref;
  const entry = (0,commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_4__.useEntry)();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__.useTranslation)(nlsBundles);
  const [{
    refreshCount
  }] = (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_16__.useOverviewModel)();
  const {
    contributors
  } = (0,commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_11__["default"])(entry, refreshCount);
  const [pageTitle] = (0,commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const viewDefinition = (0,commons_util_site__WEBPACK_IMPORTED_MODULE_6__.getViewDefFromName)('admin__projects__project');
  const viewDefinitionTitle = (0,commons_locale__WEBPACK_IMPORTED_MODULE_18__.localize)(viewDefinition.title);
  const label = (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__.getRenderName)(entry) || translate('unnamedWorkspace', entry.getId());
  const descriptionItems = [commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_14__.DESCRIPTION_UPDATED, {
    id: 'edited',
    labelNlsKey: 'editedByLabel',
    getValues: () => contributors
  }];
  (0,commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_9__["default"])(`${pageTitle} - ${viewDefinitionTitle} ${(0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__.getRenderName)(entry)}`);
  return /*#__PURE__*/React.createElement(commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_15__["default"], _extends({}, overviewProps, {
    backLabel: translate('backTitle'),
    headerAction: _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_14__.ACTION_INFO_WITH_ICON), {}, {
      Dialog: commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_17__["default"],
      formTemplateId: 'esc:Context'
    }),
    headerActionParams: {
      formTemplateId: 'esc:Context'
    },
    entry: entry,
    nlsBundles: nlsBundles,
    descriptionItems: descriptionItems,
    sidebarActions: _actions__WEBPACK_IMPORTED_MODULE_19__.sidebarActions,
    sidebarProps: {
      formTemplateId: 'esc:Context'
    },
    returnTo: "/admin/projects",
    headerLabel: label
  }));
};
ProjectOverview.propTypes = {
  overviewProps: commons_components_overview__WEBPACK_IMPORTED_MODULE_16__.overviewPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_overview__WEBPACK_IMPORTED_MODULE_16__.withOverviewModelProvider)(ProjectOverview));

/***/ }),

/***/ "./modules/admin/projects/ProjectOverview/actions.js":
/*!***********************************************************!*\
  !*** ./modules/admin/projects/ProjectOverview/actions.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sidebarActions: () => (/* binding */ sidebarActions)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/icons-material */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Autorenew.js");
/* harmony import */ var _ProjectsView_dialogs_ReindexProjectDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../ProjectsView/dialogs/ReindexProjectDialog */ "./modules/admin/projects/ProjectsView/dialogs/ReindexProjectDialog/index.js");
/* harmony import */ var _ProjectsView_dialogs_RemoveProjectDialog__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../ProjectsView/dialogs/RemoveProjectDialog */ "./modules/admin/projects/ProjectsView/dialogs/RemoveProjectDialog/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




const sidebarActions = [_objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_EDIT), {}, {
  getProps: () => ({
    action: {
      formTemplateId: 'esc:Context'
    }
  })
}), commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REVISIONS, {
  id: 'reindex',
  Dialog: _ProjectsView_dialogs_ReindexProjectDialog__WEBPACK_IMPORTED_MODULE_3__["default"],
  labelNlsKey: 'projectReindex',
  icon: /*#__PURE__*/React.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_2__["default"], null)
}, _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REMOVE), {}, {
  Dialog: _ProjectsView_dialogs_RemoveProjectDialog__WEBPACK_IMPORTED_MODULE_4__["default"]
})];

/***/ }),

/***/ "./modules/admin/projects/ProjectOverview/index.js":
/*!*********************************************************!*\
  !*** ./modules/admin/projects/ProjectOverview/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ProjectOverview__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ProjectOverview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProjectOverview */ "./modules/admin/projects/ProjectOverview/ProjectOverview.js");


/***/ }),

/***/ "./modules/admin/projects/ProjectsView/ProjectsView.js":
/*!*************************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/ProjectsView.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/hooks/useUser */ "./modules/commons/hooks/useUser.js");
/* harmony import */ var commons_util_solr_entry__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/util/solr/entry */ "./modules/commons/util/solr/entry.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/components/LinkedDataBrowserDialog */ "./modules/commons/components/LinkedDataBrowserDialog/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./actions */ "./modules/admin/projects/ProjectsView/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
















const ProjectsView = _ref => {
  let {
    listProps
  } = _ref;
  const {
    userEntry,
    userInfo
  } = (0,commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_9__.useUserState)();
  const createQuery = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
    const [query] = (0,commons_util_solr_entry__WEBPACK_IMPORTED_MODULE_10__.getSearchQuery)({
      entryType: _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_8__.types.ET_LOCAL,
      graphType: _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_8__.types.GT_CONTEXT,
      resourceType: 'InformationResource'
    }, {
      userEntry,
      userInfo
    });
    return query;
  }, [userEntry, userInfo]);
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_12__.useTranslation)(_actions__WEBPACK_IMPORTED_MODULE_15__.nlsBundles);
  const entryTypeName = translate('createEntryName');
  const queryResults = (0,commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_5__.useSolrQuery)({
    createQuery
  });
  return /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_5__.EntryListView, _extends({}, queryResults, listProps, {
    nlsBundles: _actions__WEBPACK_IMPORTED_MODULE_15__.nlsBundles,
    viewPlaceholderProps: {
      label: translate('emptyMessageWithName', entryTypeName)
    },
    listActions: _actions__WEBPACK_IMPORTED_MODULE_15__.listActions,
    getListItemProps: _ref2 => {
      let {
        entry
      } = _ref2;
      return {
        to: (0,commons_util_site__WEBPACK_IMPORTED_MODULE_13__.getPathFromViewName)('admin__projects__project', {
          entryId: entry.getId(),
          contextId: entry.getContext().getId()
        })
      };
    },
    columns: [_objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_5__.TITLE_COLUMN), {}, {
      xs: 8,
      sortBy: commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_5__.TITLE_SORT,
      getProps: _ref3 => {
        let {
          entry
        } = _ref3;
        return {
          primary: (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_11__.getRenderName)(entry) || translate('unnamedWorkspace', entry.getId())
        };
      }
    }), commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_5__.MODIFIED_COLUMN, _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_5__.ACTIONS_GROUP_COLUMN), {}, {
      actions: [_objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_6__.LIST_ACTION_INFO), {}, {
        Dialog: commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_14__["default"],
        formTemplateId: 'esc:Context'
      }), _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_6__.LIST_ACTION_EDIT), {}, {
        formTemplateId: 'esc:Context'
      })]
    })]
  }));
};
ProjectsView.propTypes = {
  listProps: commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.listPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.withListModelProviderAndLocation)(ProjectsView));

/***/ }),

/***/ "./modules/admin/projects/ProjectsView/actions.js":
/*!********************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/actions.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   listActions: () => (/* binding */ listActions),
/* harmony export */   nlsBundles: () => (/* binding */ nlsBundles),
/* harmony export */   rowActions: () => (/* binding */ rowActions)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! admin/nls/esadContext.nls */ "./modules/admin/nls/esadContext.nls");
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/nls/escoPlaceholder.nls */ "./modules/commons/nls/escoPlaceholder.nls");
/* harmony import */ var commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_util_context__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/util/context */ "./modules/commons/util/context.js");
/* harmony import */ var _dialogs_RemoveProjectDialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./dialogs/RemoveProjectDialog */ "./modules/admin/projects/ProjectsView/dialogs/RemoveProjectDialog/index.js");
/* harmony import */ var _dialogs_CreateProjectDialog__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./dialogs/CreateProjectDialog */ "./modules/admin/projects/ProjectsView/dialogs/CreateProjectDialog/index.js");
/* harmony import */ var _dialogs_ReindexProjectDialog__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dialogs/ReindexProjectDialog */ "./modules/admin/projects/ProjectsView/dialogs/ReindexProjectDialog/index.js");
/* harmony import */ var _dialogs_UpgradeProjectToPremiumDialog__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./dialogs/UpgradeProjectToPremiumDialog */ "./modules/admin/projects/ProjectsView/dialogs/UpgradeProjectToPremiumDialog/index.js");
/* harmony import */ var _dialogs_DowngradeProjectFromPremiumDialog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./dialogs/DowngradeProjectFromPremiumDialog */ "./modules/admin/projects/ProjectsView/dialogs/DowngradeProjectFromPremiumDialog/index.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }










const LIST_ACTION_MAKE_PREMIUM_ID = 'upgradeToPremium';
const LIST_ACTION_REMOVE_PREMIUM_ID = 'downgradeFromPremium';
const LIST_ACTION_REINDEX_ID = 'reindex';
const nlsBundles = [(admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_2___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_3___default()), (commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_4___default())];
const listActions = [{
  id: 'create',
  Dialog: _dialogs_CreateProjectDialog__WEBPACK_IMPORTED_MODULE_7__["default"],
  labelNlsKey: 'createButton',
  tooltipNlsKey: 'actionTooltip'
}];
const rowActions = [_objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__.LIST_ACTION_EDIT), {}, {
  formTemplateId: 'esc:Context'
}), commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__.LIST_ACTION_REVISIONS, {
  id: LIST_ACTION_REINDEX_ID,
  Dialog: _dialogs_ReindexProjectDialog__WEBPACK_IMPORTED_MODULE_8__["default"],
  labelNlsKey: 'projectReindex'
}, {
  id: commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__.LIST_ACTION_SHARING_SETTINGS,
  Dialog: '',
  isVisible: () => false,
  // no restriction when we develop sharing settings for admin
  labelNlsKey: 'contextACL'
}, {
  id: LIST_ACTION_MAKE_PREMIUM_ID,
  Dialog: _dialogs_UpgradeProjectToPremiumDialog__WEBPACK_IMPORTED_MODULE_9__["default"],
  isVisible: _ref => {
    let {
      entry: contextEntry
    } = _ref;
    return (0,commons_util_context__WEBPACK_IMPORTED_MODULE_5__.premiumContextsEnabled)() && !(0,commons_util_context__WEBPACK_IMPORTED_MODULE_5__.isContextPremium)(contextEntry);
  },
  labelNlsKey: 'makePremium'
}, {
  id: LIST_ACTION_REMOVE_PREMIUM_ID,
  Dialog: _dialogs_DowngradeProjectFromPremiumDialog__WEBPACK_IMPORTED_MODULE_10__["default"],
  isVisible: _ref2 => {
    let {
      entry: contextEntry
    } = _ref2;
    return (0,commons_util_context__WEBPACK_IMPORTED_MODULE_5__.premiumContextsEnabled)() && (0,commons_util_context__WEBPACK_IMPORTED_MODULE_5__.isContextPremium)(contextEntry);
  },
  labelNlsKey: 'unmakePremium'
}, _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__.LIST_ACTION_REMOVE), {}, {
  Dialog: _dialogs_RemoveProjectDialog__WEBPACK_IMPORTED_MODULE_6__["default"]
})];

/***/ }),

/***/ "./modules/admin/projects/ProjectsView/dialogs/CreateProjectDialog/CreateProjectDialog.js":
/*!************************************************************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/dialogs/CreateProjectDialog/CreateProjectDialog.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/TextField/TextField.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/FormControlLabel/FormControlLabel.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Checkbox/Checkbox.js");
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var esi18n__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! esi18n */ "./node_modules/.pnpm/esi18n@1.8.0/node_modules/esi18n/src/index.js");
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! admin/nls/esadContext.nls */ "./modules/admin/nls/esadContext.nls");
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var commons_util_util__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/util/util */ "./modules/commons/util/util.js");
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/components/LoadingButton */ "./modules/commons/components/LoadingButton/index.js");
/* harmony import */ var commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/errors/ErrorCatcher */ "./modules/commons/errors/ErrorCatcher/index.js");
/* harmony import */ var commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! commons/errors/utils/errors */ "./modules/commons/errors/utils/errors.js");
/* harmony import */ var commons_components_dialogs_create_handlers__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! commons/components/dialogs/create/handlers */ "./modules/commons/components/dialogs/create/handlers.js");





















const CreateProjectDialog = _ref => {
  let {
    closeDialog
  } = _ref;
  const [, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_6__.useListModel)();
  const [contextName, setContextName] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)('');
  const [entryId, setEntryId] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)('');
  const [fullname, setFullname] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)('');
  const [contextErrorMsg, setContextErrorMsg] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)('');
  const [EntryErrorMsg, setEntryErrorMsg] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)('');
  const [advancedOption, setAdvancedOption] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(false);
  const [contextTimer, setContextTimer] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(null);
  const [entryIdTimer, setEntryIdTimer] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)(null);
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_11__.useTranslation)((admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_15___default()));
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_17__.useSnackbar)();
  const {
    runAsync,
    status,
    error: createError
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_18__["default"])();
  const confirmClose = (0,commons_components_dialogs_create_handlers__WEBPACK_IMPORTED_MODULE_22__.useConfirmCloseAction)(closeDialog);
  const close = () => confirmClose(fullname !== '' || contextName !== '' || entryId !== '');
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (!advancedOption) {
      setContextName('');
      setEntryId('');
      setContextErrorMsg('');
      setEntryErrorMsg('');
    }
  }, [advancedOption]);
  const contextNameValidation = async () => {
    let isValid = true;
    setContextErrorMsg('');
    if (contextName.trim()) {
      try {
        const data = await commons_store__WEBPACK_IMPORTED_MODULE_13__.entrystore.getREST().get(`${commons_store__WEBPACK_IMPORTED_MODULE_13__.entrystore.getBaseURI()}_contexts?entryname=${contextName}`);
        if (data.length > 0) {
          setContextErrorMsg('contextnameTaken');
          isValid = false;
        }
      } catch (e) {
        console.log(e);
      }
    }
    return isValid;
  };
  const entryIdValidation = async () => {
    let isValid = true;
    setEntryErrorMsg('');
    if (entryId.trim()) {
      try {
        const data = await commons_store__WEBPACK_IMPORTED_MODULE_13__.entrystore.getREST().get(`${commons_store__WEBPACK_IMPORTED_MODULE_13__.entrystore.getBaseURI()}_contexts/entry/${entryId}`);
        if (Object.keys(data).length > 0) {
          setEntryErrorMsg('entryIdTaken');
          isValid = false;
        }
      } catch (e) {
        console.log(e);
      }
    }
    return isValid;
  };
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (contextName) {
      if (contextTimer) {
        clearTimeout(contextTimer);
      }
      const time = setTimeout(contextNameValidation, 300);
      setContextTimer(time);
    }
  }, [contextName]);
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (entryId) {
      if (entryIdTimer) {
        clearTimeout(entryIdTimer);
      }
      const time = setTimeout(entryIdValidation, 300);
      setEntryIdTimer(time);
    }
  }, [entryId]);
  const submitHandler = async () => {
    const contextEntry = commons_store__WEBPACK_IMPORTED_MODULE_13__.entrystore.newContext(contextName, entryId || undefined);
    const language = esi18n__WEBPACK_IMPORTED_MODULE_14__.i18n.getLocale();
    const metadata = contextEntry.getMetadata();
    metadata.addL(contextEntry.getResourceURI(), 'dcterms:title', fullname, language);
    return contextEntry.commit().then(closeDialog).then(() => {
      clearTimeout(contextTimer);
      clearTimeout(entryIdTimer);
      setContextTimer(null);
      setEntryIdTimer(null);
    }).then(() => {
      dispatch({
        type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_6__.CREATE
      });
      addSnackbar({
        message: translate('createProjectSuccess')
      });
    }).catch(error => {
      throw new commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_21__.ErrorWithMessage(translate('createProjectFail'), error);
    });
  };
  const dialogActions = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_19__["default"], {
    autoFocus: true,
    onClick: () => runAsync(submitHandler()),
    loading: status === commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_18__.PENDING,
    disabled: !fullname || !!EntryErrorMsg || !!contextErrorMsg
  }, translate('createButton'));
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement((react__WEBPACK_IMPORTED_MODULE_4___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_12__["default"], {
    id: "create-entry",
    title: translate('newContextnameHeader'),
    actions: dialogActions,
    closeDialog: close,
    maxWidth: "md"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_10__["default"], null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement("form", {
    autoComplete: "off"
  }, advancedOption && /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement((react__WEBPACK_IMPORTED_MODULE_4___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], {
    id: "contextName",
    label: translate('createContextname'),
    placeholder: translate('setNamePlaceholder'),
    variant: "filled",
    value: contextName,
    onChange: e => {
      setContextName(e.target.value.trim());
      setContextErrorMsg('');
    },
    error: !!contextErrorMsg,
    helperText: !!contextErrorMsg && translate(contextErrorMsg)
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], {
    id: "entryId",
    label: translate('createEntryId'),
    placeholder: translate('createEntryIdPlaceholder'),
    variant: "filled",
    value: entryId,
    onChange: e => {
      setEntryId(e.target.value.trim());
      setEntryErrorMsg('');
    },
    error: !!EntryErrorMsg,
    helperText: !!EntryErrorMsg && translate(EntryErrorMsg)
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], {
    id: "fullname",
    label: translate('createFullname'),
    placeholder: translate('createFullnamePlaceholder'),
    variant: "filled",
    value: fullname,
    onChange: e => {
      setFullname((0,commons_util_util__WEBPACK_IMPORTED_MODULE_16__.removeWhitespace)(e.target.value));
    }
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], {
    control: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_9__["default"], {
      color: "default",
      inputProps: {
        'aria-label': translate('advancedOptions')
      },
      onClick: () => setAdvancedOption(!advancedOption)
    }),
    label: translate('advancedOptions')
  })))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_20__.ErrorCatcher, {
    error: createError
  }));
};
CreateProjectDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CreateProjectDialog);

/***/ }),

/***/ "./modules/admin/projects/ProjectsView/dialogs/CreateProjectDialog/index.js":
/*!**********************************************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/dialogs/CreateProjectDialog/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _CreateProjectDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _CreateProjectDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CreateProjectDialog */ "./modules/admin/projects/ProjectsView/dialogs/CreateProjectDialog/CreateProjectDialog.js");


/***/ }),

/***/ "./modules/admin/projects/ProjectsView/dialogs/DowngradeProjectFromPremiumDialog/DowngradeProjectFromPremiumDialog.js":
/*!****************************************************************************************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/dialogs/DowngradeProjectFromPremiumDialog/DowngradeProjectFromPremiumDialog.js ***!
  \****************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! admin/nls/esadContext.nls */ "./modules/admin/nls/esadContext.nls");
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var commons_util_context__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/util/context */ "./modules/commons/util/context.js");











const DowngradeProjectFromPremiumDialog = _ref => {
  let {
    entry: contextEntry
  } = _ref;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__.useTranslation)((admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_9___default()));
  const [, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_5__.useListModel)();
  const {
    runAsync
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_6__["default"])(null);
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_7__.useSnackbar)();
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    runAsync((0,commons_util_context__WEBPACK_IMPORTED_MODULE_10__.downgradeContextFromPremium)(contextEntry).then(() => {
      dispatch({
        type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_5__.REFRESH
      });
      addSnackbar({
        message: translate('downgradeFromPremiumNotification')
      });
    }));
  }, [addSnackbar, contextEntry, dispatch, runAsync, translate]);
  return null;
};
DowngradeProjectFromPremiumDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_3___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__.Entry)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DowngradeProjectFromPremiumDialog);

/***/ }),

/***/ "./modules/admin/projects/ProjectsView/dialogs/DowngradeProjectFromPremiumDialog/index.js":
/*!************************************************************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/dialogs/DowngradeProjectFromPremiumDialog/index.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _DowngradeProjectFromPremiumDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _DowngradeProjectFromPremiumDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DowngradeProjectFromPremiumDialog */ "./modules/admin/projects/ProjectsView/dialogs/DowngradeProjectFromPremiumDialog/DowngradeProjectFromPremiumDialog.js");


/***/ }),

/***/ "./modules/admin/projects/ProjectsView/dialogs/ReindexProjectDialog/ReindexProjectDialog.js":
/*!**************************************************************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/dialogs/ReindexProjectDialog/ReindexProjectDialog.js ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _mui_material_Button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/material/Button */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Button/Button.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");











const ReindexDialog = _ref => {
  let {
    entry,
    closeDialog,
    nlsBundles
  } = _ref;
  const [statusError, setStatusError] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__.useTranslation)(nlsBundles);
  const handleClose = () => {
    closeDialog();
    setStatusError(false);
  };
  const triggerReindex = async () => {
    const url = `${commons_store__WEBPACK_IMPORTED_MODULE_7__.entrystore.getBaseURI()}management/solr`;
    try {
      const response = await fetch(url, {
        credentials: 'include',
        method: 'POST',
        headers: {
          'Content-Type': 'application/json'
        },
        body: JSON.stringify({
          command: 'reindex',
          context: entry.getURI()
        })
      });
      if (response.status !== 202) {
        setStatusError(true);
      } else {
        handleClose();
      }
    } catch (error) {
      setStatusError(true);
      console.error(error);
    }
  };
  const actions = /*#__PURE__*/React.createElement(_mui_material_Button__WEBPACK_IMPORTED_MODULE_5__["default"], {
    autoFocus: true,
    onClick: () => triggerReindex()
  }, translate('projectReindex'));
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_9__["default"], {
    id: "reindex-entry",
    closeDialog: () => handleClose(),
    actions: actions,
    maxWidth: "xs",
    alert: statusError ? {
      message: translate('reindexError')
    } : {
      message: null
    }
  }, /*#__PURE__*/React.createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_8__["default"], {
    xs: 10
  }, /*#__PURE__*/React.createElement("div", null, translate('reindexConfirmationQuestionNLS')))));
};
ReindexDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_4___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_6__.Entry),
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func).isRequired,
  nlsBundles: commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__.nlsBundlesPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ReindexDialog);

/***/ }),

/***/ "./modules/admin/projects/ProjectsView/dialogs/ReindexProjectDialog/index.js":
/*!***********************************************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/dialogs/ReindexProjectDialog/index.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ReindexProjectDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ReindexProjectDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ReindexProjectDialog */ "./modules/admin/projects/ProjectsView/dialogs/ReindexProjectDialog/ReindexProjectDialog.js");


/***/ }),

/***/ "./modules/admin/projects/ProjectsView/dialogs/RemoveProjectDialog/RemoveProjectDialog.js":
/*!************************************************************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/dialogs/RemoveProjectDialog/RemoveProjectDialog.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useMainDialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/hooks/useMainDialog */ "./modules/commons/hooks/useMainDialog.js");
/* harmony import */ var commons_components_common_dialogs_MainDialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/components/common/dialogs/MainDialog */ "./modules/commons/components/common/dialogs/MainDialog/index.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_util_store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/util/store */ "./modules/commons/util/store.js");
/* harmony import */ var commons_components_router_useNavigate__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/router/useNavigate */ "./modules/commons/components/router/useNavigate.js");
/* harmony import */ var commons_components_entry_RemoveEntryDialog__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/components/entry/RemoveEntryDialog */ "./modules/commons/components/entry/RemoveEntryDialog/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
const _excluded = ["entry", "nlsBundles", "closeDialog"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }


function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }










const RemoveDialog = _ref => {
  let {
      entry,
      nlsBundles,
      closeDialog
    } = _ref,
    restProps = _objectWithoutProperties(_ref, _excluded);
  const {
    openMainDialog
  } = (0,commons_hooks_useMainDialog__WEBPACK_IMPORTED_MODULE_5__.useMainDialog)();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_4__.useTranslation)(nlsBundles);
  const projectName = (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_8__.getRenderName)(entry) || entry.getId();
  const {
    goBack
  } = (0,commons_components_router_useNavigate__WEBPACK_IMPORTED_MODULE_10__["default"])();
  const confirmRemoveAssociatedGroup = async groupEntry => {
    openMainDialog({
      content: translate('confirmGroupInProject', (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_8__.getRenderName)(groupEntry) || groupEntry.getId()),
      actions: /*#__PURE__*/React.createElement(commons_components_common_dialogs_MainDialog__WEBPACK_IMPORTED_MODULE_6__.ConfirmAction, {
        onDone: () => groupEntry.del(),
        affirmLabel: translate('confirmRemove'),
        rejectLabel: translate('cancelRemove')
      })
    });
  };
  const onRemove = async () => {
    try {
      const entryId = entry.getId();
      const context = commons_store__WEBPACK_IMPORTED_MODULE_7__.entrystore.getContextById(entryId);
      const groupEntry = await (0,commons_util_store__WEBPACK_IMPORTED_MODULE_9__.getGroupWithHomeContext)(context);
      if (groupEntry) {
        await confirmRemoveAssociatedGroup(groupEntry);
      }
      await entry.del();
    } catch (error) {
      openMainDialog({
        content: translate('failedRemoveContext'),
        actions: /*#__PURE__*/React.createElement(commons_components_common_dialogs_MainDialog__WEBPACK_IMPORTED_MODULE_6__.AcknowledgeAction, {
          onDone: closeDialog
        })
      });
      console.error(error);
    }
  };
  return /*#__PURE__*/React.createElement(commons_components_entry_RemoveEntryDialog__WEBPACK_IMPORTED_MODULE_11__["default"], _extends({}, restProps, {
    closeDialog: closeDialog,
    onRemove: onRemove,
    onRemoveCallback: goBack,
    removeConfirmMessage: translate('removeContextMessage', projectName)
  }));
};
RemoveDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_2___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_3__.Entry),
  nlsBundles: commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_4__.nlsBundlesPropType,
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RemoveDialog);

/***/ }),

/***/ "./modules/admin/projects/ProjectsView/dialogs/RemoveProjectDialog/index.js":
/*!**********************************************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/dialogs/RemoveProjectDialog/index.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _RemoveProjectDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _RemoveProjectDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RemoveProjectDialog */ "./modules/admin/projects/ProjectsView/dialogs/RemoveProjectDialog/RemoveProjectDialog.js");


/***/ }),

/***/ "./modules/admin/projects/ProjectsView/dialogs/UpgradeProjectToPremiumDialog/UpgradeProjectToPremiumDialog.js":
/*!********************************************************************************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/dialogs/UpgradeProjectToPremiumDialog/UpgradeProjectToPremiumDialog.js ***!
  \********************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! admin/nls/esadContext.nls */ "./modules/admin/nls/esadContext.nls");
/* harmony import */ var admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var commons_util_context__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/util/context */ "./modules/commons/util/context.js");











const UpgradeProjectToPremiumDialog = _ref => {
  let {
    entry: contextEntry
  } = _ref;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__.useTranslation)((admin_nls_esadContext_nls__WEBPACK_IMPORTED_MODULE_9___default()));
  const [, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_5__.useListModel)();
  const {
    runAsync
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_6__["default"])(null);
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_7__.useSnackbar)();
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    runAsync((0,commons_util_context__WEBPACK_IMPORTED_MODULE_10__.upgradeContextToPremium)(contextEntry).then(() => {
      dispatch({
        type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_5__.REFRESH
      });
      addSnackbar({
        message: translate('upgradeToPremiumNotification')
      });
    }));
  }, [addSnackbar, contextEntry, dispatch, runAsync, translate]);
  return null;
};
UpgradeProjectToPremiumDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_3___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__.Entry)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UpgradeProjectToPremiumDialog);

/***/ }),

/***/ "./modules/admin/projects/ProjectsView/dialogs/UpgradeProjectToPremiumDialog/index.js":
/*!********************************************************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/dialogs/UpgradeProjectToPremiumDialog/index.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _UpgradeProjectToPremiumDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _UpgradeProjectToPremiumDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./UpgradeProjectToPremiumDialog */ "./modules/admin/projects/ProjectsView/dialogs/UpgradeProjectToPremiumDialog/UpgradeProjectToPremiumDialog.js");


/***/ }),

/***/ "./modules/admin/projects/ProjectsView/index.js":
/*!******************************************************!*\
  !*** ./modules/admin/projects/ProjectsView/index.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ProjectsView__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ProjectsView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ProjectsView */ "./modules/admin/projects/ProjectsView/ProjectsView.js");


/***/ }),

/***/ "./modules/admin/users/UserOverview/UserOverview.js":
/*!**********************************************************!*\
  !*** ./modules/admin/users/UserOverview/UserOverview.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/hooks/useEntry */ "./modules/commons/hooks/useEntry.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! admin/nls/esadUser.nls */ "./modules/admin/nls/esadUser.nls");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/hooks/useDocumentTitle */ "./modules/commons/hooks/useDocumentTitle.js");
/* harmony import */ var commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/hooks/usePageTitle */ "./modules/commons/hooks/usePageTitle.js");
/* harmony import */ var commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/hooks/useGetContributors */ "./modules/commons/hooks/useGetContributors.js");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/nls/escoOverview.nls */ "./modules/commons/nls/escoOverview.nls");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/overview/Overview */ "./modules/commons/components/overview/Overview/index.js");
/* harmony import */ var commons_components_overview__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/components/overview */ "./modules/commons/components/overview/index.js");
/* harmony import */ var commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/components/LinkedDataBrowserDialog */ "./modules/commons/components/LinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_locale__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/locale */ "./modules/commons/locale/index.js");
/* harmony import */ var commons_util_user__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/util/user */ "./modules/commons/util/user.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./actions */ "./modules/admin/users/UserOverview/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }






















const nlsBundles = [(admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_9___default()), (commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_14___default())];
const DISABLED_TAG = {
  id: 'disabledTag',
  labelNlsKey: 'disabledTag',
  nlsBundles: (admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8___default()),
  isVisible: entry => (0,commons_util_user__WEBPACK_IMPORTED_MODULE_20__.getIsUserDisabled)(entry)
};
const UserOverview = _ref => {
  var _getLabel;
  let {
    overviewProps
  } = _ref;
  const entry = (0,commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_5__.useEntry)();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__.useTranslation)(nlsBundles);
  const [{
    refreshCount
  }] = (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_17__.useOverviewModel)();
  const {
    contributors
  } = (0,commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_13__["default"])(entry, refreshCount);
  const [pageTitle] = (0,commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_12__["default"])();
  const viewDefinition = (0,commons_util_site__WEBPACK_IMPORTED_MODULE_7__.getViewDefFromName)('admin__users__user');
  const viewDefinitionTitle = (0,commons_locale__WEBPACK_IMPORTED_MODULE_19__.localize)(viewDefinition.title);
  const descriptionItems = [commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_15__.DESCRIPTION_UPDATED, {
    id: 'edited',
    labelNlsKey: 'editedByLabel',
    getValues: () => contributors
  }];
  (0,commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_11__["default"])(`${pageTitle} - ${viewDefinitionTitle} ${(0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_6__.getLabel)(entry)}`);
  return /*#__PURE__*/React.createElement(commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_16__["default"], _extends({}, overviewProps, {
    backLabel: translate('backTitle'),
    headerAction: _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_15__.ACTION_INFO_WITH_ICON), {}, {
      Dialog: commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_18__["default"]
    }),
    headerActionParams: {
      formTemplateId: 'esc:User'
    },
    entry: entry,
    nlsBundles: nlsBundles,
    descriptionItems: descriptionItems,
    sidebarActions: _actions__WEBPACK_IMPORTED_MODULE_21__.sidebarActions,
    sidebarProps: {
      formTemplateId: 'esc:User'
    },
    returnTo: "/admin/users",
    headerLabel: ((_getLabel = (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_6__.getLabel)(entry)) === null || _getLabel === void 0 ? void 0 : _getLabel.trim()) || (0,commons_util_user__WEBPACK_IMPORTED_MODULE_20__.getUserRenderName)(entry),
    tags: [DISABLED_TAG]
  }));
};
UserOverview.propTypes = {
  overviewProps: commons_components_overview__WEBPACK_IMPORTED_MODULE_17__.overviewPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_overview__WEBPACK_IMPORTED_MODULE_17__.withOverviewModelProvider)(UserOverview));

/***/ }),

/***/ "./modules/admin/users/UserOverview/actions.js":
/*!*****************************************************!*\
  !*** ./modules/admin/users/UserOverview/actions.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sidebarActions: () => (/* binding */ sidebarActions)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var commons_util_user__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/util/user */ "./modules/commons/util/user.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/icons-material */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/AccountCircle.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/icons-material */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Group.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/icons-material */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/LockOpen.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/icons-material */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/PersonAdd.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/icons-material */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/PersonAddDisabled.js");
/* harmony import */ var commons_components_overview__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/overview */ "./modules/commons/components/overview/index.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var _UsersView_dialogs_ChangeUsernameDialog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../UsersView/dialogs/ChangeUsernameDialog */ "./modules/admin/users/UsersView/dialogs/ChangeUsernameDialog/index.js");
/* harmony import */ var _UsersView_dialogs_DisableUserDialog__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../UsersView/dialogs/DisableUserDialog */ "./modules/admin/users/UsersView/dialogs/DisableUserDialog/index.js");
/* harmony import */ var _UsersView_dialogs_ChangePasswordDialog__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../UsersView/dialogs/ChangePasswordDialog */ "./modules/admin/users/UsersView/dialogs/ChangePasswordDialog/index.js");
/* harmony import */ var _UsersView_dialogs_GroupMembershipsDialog__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../UsersView/dialogs/GroupMembershipsDialog */ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/index.js");
/* harmony import */ var _UsersView_dialogs_UpgradeUserToPremiumDialog__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../UsersView/dialogs/UpgradeUserToPremiumDialog */ "./modules/admin/users/UsersView/dialogs/UpgradeUserToPremiumDialog/index.js");
/* harmony import */ var _UsersView_dialogs_DowngradeUserFromPremiumDialog__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../UsersView/dialogs/DowngradeUserFromPremiumDialog */ "./modules/admin/users/UsersView/dialogs/DowngradeUserFromPremiumDialog/index.js");
/* harmony import */ var _utils_user__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../utils/user */ "./modules/admin/users/utils/user.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }












const ACTION_CHANGE_USERNAME_ID = 'username';
const ACTION_CHANGE_PASSWORD_ID = 'password';
const ACTION_GROUPS_ID = 'groups';
const ACTION_ENABLE_USER_ID = 'enable-user';
const ACTION_DISABLE_USER_ID = 'disable-user';
const ACTION_MAKE_PREMIUM_ID = 'upgradeToPremium';
const ACTION_REMOVE_PREMIUM_ID = 'downgradeFromPremium';
const canChangeUserStatus = entry => entry.canAdministerEntry();
const canChangeUserStatusAndIsEnabled = _ref => {
  let {
    entry
  } = _ref;
  return (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isRegularUser)(entry) && canChangeUserStatus(entry) && (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isUserEnabled)(entry);
};
const canChangeUserStatusAndIsDisabled = _ref2 => {
  let {
    entry
  } = _ref2;
  return (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isRegularUser)(entry) && canChangeUserStatus(entry) && (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isUserDisabled)(entry);
};
const handleUserEntryEdit = entry => {
  (0,_utils_user__WEBPACK_IMPORTED_MODULE_16__.replaceNameWithFirstAndLastName)(entry);
  return entry.commitMetadata();
};
const sidebarActions = [_objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_EDIT), {}, {
  getProps: () => ({
    action: {
      formTemplateId: 'esc:User',
      onEntryEdit: handleUserEntryEdit
    }
  })
}), {
  id: ACTION_CHANGE_USERNAME_ID,
  Dialog: (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_8__.withOverviewRefresh)(_UsersView_dialogs_ChangeUsernameDialog__WEBPACK_IMPORTED_MODULE_10__["default"], 'onCreate'),
  labelNlsKey: 'changeUsername',
  isVisible: _ref3 => {
    let {
      entry
    } = _ref3;
    return (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isRegularUser)(entry);
  },
  icon: /*#__PURE__*/React.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_3__["default"], null)
}, {
  id: ACTION_CHANGE_PASSWORD_ID,
  Dialog: _UsersView_dialogs_ChangePasswordDialog__WEBPACK_IMPORTED_MODULE_12__["default"],
  labelNlsKey: 'setPassword',
  isVisible: _ref4 => {
    let {
      entry
    } = _ref4;
    return !(0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isGuest)(entry);
  },
  icon: /*#__PURE__*/React.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_5__["default"], null)
}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REVISIONS, {
  id: ACTION_GROUPS_ID,
  Dialog: _UsersView_dialogs_GroupMembershipsDialog__WEBPACK_IMPORTED_MODULE_13__["default"],
  labelNlsKey: 'groupsList',
  isVisible: _ref5 => {
    let {
      entry
    } = _ref5;
    return !(0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isAdmin)(entry);
  },
  icon: /*#__PURE__*/React.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_4__["default"], null)
}, {
  id: ACTION_ENABLE_USER_ID,
  Dialog: (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_8__.withOverviewRefresh)(_UsersView_dialogs_DisableUserDialog__WEBPACK_IMPORTED_MODULE_11__["default"], 'onStatusChange'),
  isVisible: canChangeUserStatusAndIsDisabled,
  labelNlsKey: 'userStatusEnable',
  icon: /*#__PURE__*/React.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_6__["default"], null)
}, {
  id: ACTION_DISABLE_USER_ID,
  Dialog: (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_8__.withOverviewRefresh)(_UsersView_dialogs_DisableUserDialog__WEBPACK_IMPORTED_MODULE_11__["default"], 'onStatusChange'),
  isVisible: canChangeUserStatusAndIsEnabled,
  labelNlsKey: 'userStatusDisable',
  icon: /*#__PURE__*/React.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_7__["default"], null)
}, {
  id: ACTION_MAKE_PREMIUM_ID,
  Dialog: (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_8__.withOverviewRefresh)(_UsersView_dialogs_UpgradeUserToPremiumDialog__WEBPACK_IMPORTED_MODULE_14__["default"], 'onUpgrade'),
  isVisible: _ref6 => {
    let {
      entry
    } = _ref6;
    return (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isRegularUser)(entry) && (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isPremiumConfigured)() && !(0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isUserPremium)(entry);
  },
  labelNlsKey: 'addToPremiumGroup'
}, {
  id: ACTION_REMOVE_PREMIUM_ID,
  Dialog: (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_8__.withOverviewRefresh)(_UsersView_dialogs_DowngradeUserFromPremiumDialog__WEBPACK_IMPORTED_MODULE_15__["default"], 'onDowngrade'),
  isVisible: _ref7 => {
    let {
      entry
    } = _ref7;
    return (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isRegularUser)(entry) && (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isPremiumConfigured)() && (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isUserPremium)(entry);
  },
  labelNlsKey: 'removeFromPremiumGroup',
  tooltipNlsKey: 'removeFromPremiumGroup'
}, _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REMOVE), {}, {
  isVisible: _ref8 => {
    let {
      entry
    } = _ref8;
    return (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.isRegularUser)(entry);
  },
  getProps: _ref9 => {
    let {
      entry,
      translate
    } = _ref9;
    return {
      action: {
        removeConfirmMessage: translate('removeUserMessage', (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_9__.getRenderName)(entry) || entry.getId())
      }
    };
  }
})];

/***/ }),

/***/ "./modules/admin/users/UserOverview/index.js":
/*!***************************************************!*\
  !*** ./modules/admin/users/UserOverview/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _UserOverview__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _UserOverview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./UserOverview */ "./modules/admin/users/UserOverview/UserOverview.js");


/***/ }),

/***/ "./modules/admin/users/UsersView/UsersView.js":
/*!****************************************************!*\
  !*** ./modules/admin/users/UsersView/UsersView.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var _mui_icons_material_PersonAddDisabled__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/icons-material/PersonAddDisabled */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/PersonAddDisabled.js");
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/hooks/useUser */ "./modules/commons/hooks/useUser.js");
/* harmony import */ var commons_util_solr_entry__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/util/solr/entry */ "./modules/commons/util/solr/entry.js");
/* harmony import */ var commons_util_user__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/util/user */ "./modules/commons/util/user.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_util_solr__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/util/solr */ "./modules/commons/util/solr/index.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/LinkedDataBrowserDialog */ "./modules/commons/components/LinkedDataBrowserDialog/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./actions */ "./modules/admin/users/UsersView/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


















const UsersList = _ref => {
  let {
    listProps
  } = _ref;
  const {
    userEntry,
    userInfo
  } = (0,commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_10__.useUserState)();
  const createQuery = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
    const [query] = (0,commons_util_solr_entry__WEBPACK_IMPORTED_MODULE_11__.getSearchQuery)({
      entryType: _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_5__.types.ET_LOCAL,
      graphType: _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_5__.types.GT_USER,
      resourceType: 'InformationResource'
    }, {
      userEntry,
      userInfo
    });
    return query;
  }, [userEntry, userInfo]);
  const queryResults = (0,commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_7__.useSolrQuery)({
    createQuery,
    applyQueryParams: commons_util_solr__WEBPACK_IMPORTED_MODULE_14__.applyTitleOrUsernameParams
  });
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_13__.useTranslation)(_actions__WEBPACK_IMPORTED_MODULE_17__.nlsBundles);
  const entryTypeName = translate('createEntryName');
  return /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_7__.EntryListView, _extends({}, queryResults, listProps, {
    nlsBundles: _actions__WEBPACK_IMPORTED_MODULE_17__.nlsBundles,
    viewPlaceholderProps: {
      label: translate('emptyMessageWithName', entryTypeName)
    },
    listActions: _actions__WEBPACK_IMPORTED_MODULE_17__.listActions,
    getListItemProps: _ref2 => {
      let {
        entry
      } = _ref2;
      return {
        to: (0,commons_util_site__WEBPACK_IMPORTED_MODULE_15__.getPathFromViewName)('admin__users__user', {
          entryId: entry.getId(),
          contextId: '_principals'
        })
      };
    },
    columns: [_objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_7__.TITLE_COLUMN), {}, {
      xs: 8,
      sortBy: commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_7__.TITLE_SORT,
      direction: 'row',
      getProps: _ref3 => {
        let {
          entry
        } = _ref3;
        return {
          primary: (0,commons_util_user__WEBPACK_IMPORTED_MODULE_12__.getUserRenderName)(entry),
          secondary: (0,commons_util_user__WEBPACK_IMPORTED_MODULE_12__.getIsUserDisabled)(entry) ? /*#__PURE__*/React.createElement(_mui_icons_material_PersonAddDisabled__WEBPACK_IMPORTED_MODULE_6__["default"], {
            fontSize: "small",
            title: translate('userStatusDisabled')
          }) : null
        };
      }
    }), commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_7__.MODIFIED_COLUMN, _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_7__.ACTIONS_GROUP_COLUMN), {}, {
      actions: [_objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_8__.LIST_ACTION_INFO), {}, {
        formTemplateId: 'esc:User',
        Dialog: commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_16__["default"]
      }), _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_8__.LIST_ACTION_EDIT), {}, {
        formTemplateId: 'esc:User'
      })]
    })]
  }));
};
UsersList.propTypes = {
  listProps: commons_components_ListView__WEBPACK_IMPORTED_MODULE_9__.listPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_9__.withListModelProviderAndLocation)(UsersList));

/***/ }),

/***/ "./modules/admin/users/UsersView/actions.js":
/*!**************************************************!*\
  !*** ./modules/admin/users/UsersView/actions.js ***!
  \**************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   USER_EDIT_ACTION: () => (/* binding */ USER_EDIT_ACTION),
/* harmony export */   listActions: () => (/* binding */ listActions),
/* harmony export */   nlsBundles: () => (/* binding */ nlsBundles)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! admin/nls/esadUser.nls */ "./modules/admin/nls/esadUser.nls");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/nls/escoPlaceholder.nls */ "./modules/commons/nls/escoPlaceholder.nls");
/* harmony import */ var commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _dialogs_CreateUserDialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dialogs/CreateUserDialog */ "./modules/admin/users/UsersView/dialogs/CreateUserDialog/index.js");
/* harmony import */ var _utils_user__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../utils/user */ "./modules/admin/users/utils/user.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }






const handleUserEntryEdit = entry => {
  (0,_utils_user__WEBPACK_IMPORTED_MODULE_6__.replaceNameWithFirstAndLastName)(entry);
  return entry.commitMetadata();
};
const nlsBundles = [(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_3___default()), (admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_2___default()), (commons_nls_escoPlaceholder_nls__WEBPACK_IMPORTED_MODULE_4___default())];
const listActions = [{
  id: 'create',
  Dialog: _dialogs_CreateUserDialog__WEBPACK_IMPORTED_MODULE_5__["default"],
  labelNlsKey: 'createButton',
  tooltipNlsKey: 'actionTooltip'
}];
const USER_EDIT_ACTION = _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_1__.LIST_ACTION_EDIT), {}, {
  formTemplateId: 'esc:User',
  onEntryEdit: handleUserEntryEdit
});

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/ChangePasswordDialog/ChangePasswordDialog.js":
/*!********************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/ChangePasswordDialog/ChangePasswordDialog.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/TextField/TextField.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/InputAdornment/InputAdornment.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/IconButton/IconButton.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/icons-material */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Visibility.js");
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/icons-material */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/VisibilityOff.js");
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var commons_components_common_Tooltip__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/components/common/Tooltip */ "./modules/commons/components/common/Tooltip/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/hooks/useUser */ "./modules/commons/hooks/useUser.js");
/* harmony import */ var commons_util_user__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/util/user */ "./modules/commons/util/user.js");
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! admin/nls/esadUser.nls */ "./modules/admin/nls/esadUser.nls");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var commons_nls_escoSignin_nls__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/nls/escoSignin.nls */ "./modules/commons/nls/escoSignin.nls");
/* harmony import */ var commons_nls_escoSignin_nls__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoSignin_nls__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var commons_auth_usePassword__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/auth/usePassword */ "./modules/commons/auth/usePassword.js");
/* harmony import */ var commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/errors/ErrorCatcher */ "./modules/commons/errors/ErrorCatcher/index.js");
/* harmony import */ var commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! commons/errors/utils/errors */ "./modules/commons/errors/utils/errors.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! commons/components/LoadingButton */ "./modules/commons/components/LoadingButton/index.js");
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var _style_scss__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./style.scss */ "./modules/admin/users/UsersView/dialogs/ChangePasswordDialog/style.scss");























const ChangePasswordDialog = _ref => {
  let {
    entry: userEntry,
    closeDialog
  } = _ref;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_13__.useTranslation)([(admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_17___default()), (commons_nls_escoSignin_nls__WEBPACK_IMPORTED_MODULE_18___default())]);
  const {
    password,
    passwordError,
    isPasswordVisible,
    handleChangePassword,
    togglePasswordVisibility,
    passwordConfirmation,
    passwordConfirmationError,
    isPasswordConfirmationVisible,
    handleChangePasswordConfirmation,
    togglePasswordConfirmationVisibility,
    currentPassword,
    handleChangeCurrentPassword,
    isCurrentPasswordVisible,
    toggleCurrentVisibility
  } = (0,commons_auth_usePassword__WEBPACK_IMPORTED_MODULE_19__["default"])();
  const {
    userEntry: currentUserEntry
  } = (0,commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_14__.useUserState)();
  const {
    runAsync,
    error: changeError,
    status
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_22__["default"])();
  const hasAdministratorRights = (0,commons_util_user__WEBPACK_IMPORTED_MODULE_15__.hasAdminRights)(currentUserEntry);
  const isChangingOwnPassword = userEntry === currentUserEntry;
  const showCurrentPassword = !hasAdministratorRights || hasAdministratorRights && isChangingOwnPassword;
  const [currentPasswordError, setCurrentPasswordError] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)(false);
  const hasValidPassAndConfirmation = password && !passwordError && passwordConfirmation && !passwordConfirmationError;
  const canSave = showCurrentPassword ? hasValidPassAndConfirmation && currentPassword && !currentPasswordError : hasValidPassAndConfirmation;
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_24__.useSnackbar)();
  const confirmPasswordChange = () => {
    return addSnackbar({
      message: translate('setPasswordSuccess')
    });
  };
  const handleSave = () => {
    const formData = {
      password: password.trim()
    };
    if (showCurrentPassword) formData.currentPassword = currentPassword.trim();
    return userEntry.getResource().then(resourceEntry => commons_store__WEBPACK_IMPORTED_MODULE_5__.entrystore.getREST().put(resourceEntry.getResourceURI(), JSON.stringify(formData))).then(closeDialog).then(confirmPasswordChange).catch(error => {
      if ((error === null || error === void 0 ? void 0 : error.status) === 403) {
        setCurrentPasswordError(true);
      } else throw new commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_21__.ErrorWithMessage(translate('setPasswordError'), error);
    });
  };
  const actions = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_23__["default"], {
    loading: status === commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_22__.PENDING,
    disabled: !canSave,
    onClick: () => runAsync(handleSave())
  }, translate('setPasswordButton'));
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement((react__WEBPACK_IMPORTED_MODULE_3___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_16__["default"], {
    id: "change-password",
    title: translate('setPasswordHeader'),
    actions: actions,
    closeDialog: closeDialog,
    maxWidth: "sm"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_11__["default"], null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement("form", {
    autoComplete: "on"
  }, showCurrentPassword ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_6__["default"], {
    autoComplete: "current-password",
    autoFocus: true,
    id: "current-password-input",
    "aria-describedby": "current-password-input",
    label: translate('currentPassword'),
    error: Boolean(currentPasswordError),
    helperText: currentPasswordError ? translate('currentPasswordError') : null,
    onChange: _ref2 => {
      let {
        target
      } = _ref2;
      setCurrentPasswordError(false);
      handleChangeCurrentPassword(target.value);
    },
    type: isCurrentPasswordVisible ? 'text' : 'password',
    required: true,
    InputProps: {
      endAdornment: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], {
        position: "end"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(commons_components_common_Tooltip__WEBPACK_IMPORTED_MODULE_12__["default"], {
        title: translate('passwordVisibility')
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], {
        "aria-label": translate('passwordVisibility'),
        onClick: toggleCurrentVisibility,
        onMouseDown: e => e.preventDefault()
      }, isCurrentPasswordVisible ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_9__["default"], null) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_10__["default"], null))))
    }
  }) : null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_6__["default"], {
    autoComplete: "new-password",
    autoFocus: !showCurrentPassword,
    error: Boolean(passwordError),
    id: "password-input",
    "aria-describedby": "password-input",
    label: translate('resetToNewPassword'),
    helperText: passwordError,
    onChange: _ref3 => {
      let {
        target
      } = _ref3;
      return handleChangePassword(target.value);
    },
    type: isPasswordVisible ? 'text' : 'password',
    required: true,
    InputProps: {
      endAdornment: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], {
        position: "end"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(commons_components_common_Tooltip__WEBPACK_IMPORTED_MODULE_12__["default"], {
        title: translate('passwordVisibility')
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], {
        "aria-label": translate('passwordVisibility'),
        onClick: togglePasswordVisibility,
        onMouseDown: e => e.preventDefault()
      }, isPasswordVisible ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_9__["default"], null) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_10__["default"], null))))
    }
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_6__["default"], {
    autoComplete: "new-password",
    error: Boolean(passwordConfirmationError),
    id: "password-confirm-input",
    "aria-describedby": "password-confirm-input",
    label: translate('confirmPassword'),
    helperText: passwordConfirmationError,
    onChange: _ref4 => {
      let {
        target
      } = _ref4;
      return handleChangePasswordConfirmation(target.value);
    },
    type: isPasswordConfirmationVisible ? 'text' : 'password',
    required: true,
    InputProps: {
      endAdornment: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], {
        position: "end"
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(commons_components_common_Tooltip__WEBPACK_IMPORTED_MODULE_12__["default"], {
        title: translate('passwordVisibility')
      }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], {
        "aria-label": translate('passwordVisibility'),
        onClick: togglePasswordConfirmationVisibility,
        onMouseDown: e => e.preventDefault()
      }, isPasswordConfirmationVisible ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_9__["default"], null) : /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_10__["default"], null))))
    }
  })))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_3___default().createElement(commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_20__.ErrorCatcher, {
    error: changeError
  }));
};
ChangePasswordDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func).isRequired,
  entry: prop_types__WEBPACK_IMPORTED_MODULE_4___default().shape({
    getResource: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func).isRequired
  }).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangePasswordDialog);

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/ChangePasswordDialog/index.js":
/*!*****************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/ChangePasswordDialog/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ChangePasswordDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ChangePasswordDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ChangePasswordDialog */ "./modules/admin/users/UsersView/dialogs/ChangePasswordDialog/ChangePasswordDialog.js");


/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/ChangePasswordDialog/style.scss":
/*!*******************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/ChangePasswordDialog/style.scss ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_style_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../../../node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!../../../../../../node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./style.scss */ "./node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!./node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./modules/admin/users/UsersView/dialogs/ChangePasswordDialog/style.scss");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_style_scss__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_style_scss__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_style_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_style_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/ChangeUsernameDialog/ChangeUsernameDialog.js":
/*!********************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/ChangeUsernameDialog/ChangeUsernameDialog.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/TextField/TextField.js");
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! admin/nls/esadUser.nls */ "./modules/admin/nls/esadUser.nls");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_util_user__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/util/user */ "./modules/commons/util/user.js");
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/errors/ErrorCatcher */ "./modules/commons/errors/ErrorCatcher/index.js");
/* harmony import */ var commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/errors/utils/errors */ "./modules/commons/errors/utils/errors.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/components/LoadingButton */ "./modules/commons/components/LoadingButton/index.js");














const ChangeUsernameDialog = _ref => {
  let {
    entry,
    closeDialog,
    onCreate
  } = _ref;
  const [username, setUsername] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)('');
  const [newUsername, setNewUsername] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)('');
  const [hasUsernameError, setUsernameError] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(false);
  const {
    runAsync,
    error: changeError,
    status
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_12__["default"])();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__.useTranslation)((admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_6___default()));
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    entry.getResource().then(userEntry => {
      setUsername(userEntry.getName());
    });
  }, []);
  const handleUsernameChange = e => {
    setNewUsername(e.target.value); // update UI
    (0,commons_util_user__WEBPACK_IMPORTED_MODULE_8__.isUsernameInUse)(e.target.value).then(setUsernameError); // check if new username is already used
    // TODO use some debounce hook
  };
  const saveNewUsername = () => {
    return entry.getResource().then(user => user.setName(newUsername)).then(onCreate).then(closeDialog).catch(error => {
      throw new commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_11__.ErrorWithMessage(translate('changeUsernameFail'), error);
    });
  };
  const actions = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_13__["default"], {
    loading: status === commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_12__.PENDING,
    onClick: () => runAsync(saveNewUsername()),
    disabled: username === newUsername || newUsername.length < 2 || hasUsernameError
  }, translate('changeUsernameButton') /* TODO nls too long for this UI */);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement((react__WEBPACK_IMPORTED_MODULE_2___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_9__["default"], {
    id: "change-username",
    title: translate('changeUsernameHeader'),
    actions: actions,
    closeDialog: closeDialog,
    maxWidth: "sm"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_5__["default"], null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement("form", {
    noValidate: true
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_4__["default"], {
    id: "current-username",
    label: translate('currentUsernameLabel'),
    type: "email",
    disabled: true,
    value: username
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_4__["default"], {
    error: hasUsernameError,
    helperText: hasUsernameError ? translate('usernameTaken') : '',
    autoFocus: true,
    id: "new-username",
    label: translate('changeUsernameLabel'),
    type: "email",
    value: newUsername,
    onChange: handleUsernameChange
  })))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_2___default().createElement(commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_10__.ErrorCatcher, {
    error: changeError
  }));
};
ChangeUsernameDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_3___default().shape(),
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func).isRequired,
  onCreate: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ChangeUsernameDialog);

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/ChangeUsernameDialog/index.js":
/*!*****************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/ChangeUsernameDialog/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ChangeUsernameDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ChangeUsernameDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ChangeUsernameDialog */ "./modules/admin/users/UsersView/dialogs/ChangeUsernameDialog/ChangeUsernameDialog.js");


/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/CreateUserDialog/CreateUserDialog.js":
/*!************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/CreateUserDialog/CreateUserDialog.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! admin/nls/esadUser.nls */ "./modules/admin/nls/esadUser.nls");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @entryscape/rdfjson */ "./node_modules/.pnpm/@entryscape+rdfjson@2.7.7/node_modules/@entryscape/rdfjson/src/main.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/TextField/TextField.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/FormControlLabel/FormControlLabel.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Checkbox/Checkbox.js");
/* harmony import */ var commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/LoadingButton */ "./modules/commons/components/LoadingButton/index.js");
/* harmony import */ var commons_util_util__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/util/util */ "./modules/commons/util/util.js");
/* harmony import */ var config__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! config */ "./app/registry/config/config.js");
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/errors/ErrorCatcher */ "./modules/commons/errors/ErrorCatcher/index.js");
/* harmony import */ var commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! commons/errors/utils/errors */ "./modules/commons/errors/utils/errors.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_components_dialogs_create_handlers__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! commons/components/dialogs/create/handlers */ "./modules/commons/components/dialogs/create/handlers.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }






















const validateUsername = async username => {
  if (!username.isPristine && !username.value) return 'usernameRequired';
  if (username.value.split(' ').length > 1) return 'usernameHasSpaces';
  return commons_store__WEBPACK_IMPORTED_MODULE_11__.entrystore.getREST().get(`${commons_store__WEBPACK_IMPORTED_MODULE_11__.entrystore.getBaseURI()}_principals?entryname=${username.value.toLowerCase()}`).then(data => {
    if (data.length > 0) return 'usernameTaken';
    return null;
  });
};
const validateFirstname = firstname => {
  return !firstname.isPristine && !firstname.value ? 'firstnameRequired' : null;
};
const validateLastname = lastname => {
  return !lastname.isPristine && !lastname.value ? 'lastnameRequired' : null;
};
const CreateUserDialog = _ref => {
  let {
    closeDialog
  } = _ref;
  const [, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.useListModel)();
  const {
    runAsync,
    error: createError,
    status
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_22__["default"])();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__.useTranslation)((admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_9___default()));
  const [username, setUsername] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)({
    value: '',
    error: null,
    isPristine: true
  });
  const [firstname, setFirstname] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)({
    value: '',
    error: null,
    isPristine: true
  });
  const [lastname, setLastname] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)({
    value: '',
    error: null,
    isPristine: true
  });
  const confirmClose = (0,commons_components_dialogs_create_handlers__WEBPACK_IMPORTED_MODULE_23__.useConfirmCloseAction)(closeDialog);
  const close = () => confirmClose(!username.isPristine || !firstname.isPristine || !lastname.isPristine);
  const [context, setContext] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const [usernameTimer, setUsernameTimer] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(null);
  const [changed, setChanged] = (0,react__WEBPACK_IMPORTED_MODULE_5__.useState)(false);
  const includePersonalProject = config__WEBPACK_IMPORTED_MODULE_18__["default"].get('admin.includePersonalProject');
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_19__.useSnackbar)();
  const update = (state, set) => evt => {
    set(_objectSpread(_objectSpread({}, state), {}, {
      isPristine: false,
      value: (0,commons_util_util__WEBPACK_IMPORTED_MODULE_17__.removeWhitespace)(evt.target.value)
    }));
  };
  const usernameChanged = () => setChanged(!changed);
  const handleUsernameChange = evt => {
    setUsername(_objectSpread(_objectSpread({}, username), {}, {
      isPristine: false,
      value: evt.target.value
    }));
    clearTimeout(usernameTimer);
    setUsernameTimer(setTimeout(usernameChanged, 500));
  };
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (!firstname.isPristine) {
      const firstnameError = validateFirstname(firstname);
      setFirstname(firstnameState => _objectSpread(_objectSpread({}, firstnameState), {}, {
        error: firstnameError ? translate(firstnameError) : null
      }));
    }
    if (!lastname.isPristine) {
      const lastnameError = validateLastname(lastname);
      setLastname(s => _objectSpread(_objectSpread({}, s), {}, {
        error: lastnameError ? translate(lastnameError) : null
      }));
    }
  }, [firstname.value, lastname.value]);
  (0,react__WEBPACK_IMPORTED_MODULE_5__.useEffect)(() => {
    if (!username.isPristine) {
      validateUsername(username).then(e => setUsername(usernameState => _objectSpread(_objectSpread({}, usernameState), {}, {
        error: e ? translate(e) : null
      })));
    }
  }, [changed]);
  const hasNoErrors = username.error === null && firstname.error === null && lastname.error === null;
  const isNotPristine = !username.isPristine && !firstname.isPristine && !lastname.isPristine;
  const canSubmit = hasNoErrors && isNotPristine && firstname.value && lastname.value;
  const dispatchEntryCreated = () => {
    dispatch({
      type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.CREATE
    });
  };
  const handleSubmit = () => {
    if (!canSubmit) return;
    let userEntry;
    let contextEntry;
    const pue = commons_store__WEBPACK_IMPORTED_MODULE_11__.entrystore.newUser(username.value);
    const md = pue.getMetadata();
    const resURI = pue.getResourceURI();
    const usersURI = commons_store__WEBPACK_IMPORTED_MODULE_11__.entrystore.getResourceURI('_principals', '_users');
    md.add(pue.getResourceURI(), _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_10__.namespaces.expand('foaf:givenName'), {
      type: 'literal',
      value: firstname.value
    });
    md.add(pue.getResourceURI(), _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_10__.namespaces.expand('foaf:familyName'), {
      type: 'literal',
      value: lastname.value
    });
    md.add(pue.getResourceURI(), _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_10__.namespaces.expand('foaf:name'), {
      type: 'literal',
      value: `${firstname.value} ${lastname.value}`
    });
    pue.getEntryInfo().setACL({
      mread: [usersURI],
      mwrite: [resURI],
      rwrite: [resURI]
    });
    return pue.commit().then(ue => {
      userEntry = ue;
      if (context) {
        const cpe = commons_store__WEBPACK_IMPORTED_MODULE_11__.entrystore.newContext();
        cpe.getEntryInfo().setACL({
          admin: [userEntry.getResourceURI()]
        });
        return cpe.commit();
      }
      return userEntry;
    }).then(ce => {
      contextEntry = ce;
      if (context) {
        return userEntry.getResource(true).setHomeContext(contextEntry.getId()).then(() => {
          contextEntry.setRefreshNeeded();
          return contextEntry.refresh();
        });
      }
      return ce;
    }).then(() => {
      closeDialog();
      dispatchEntryCreated();
      addSnackbar({
        message: translate('createUserSuccess')
      });
    }).catch(error => {
      if (userEntry) userEntry.del();
      if (contextEntry) contextEntry.del();
      throw new commons_errors_utils_errors__WEBPACK_IMPORTED_MODULE_21__.ErrorWithMessage(translate('createUserFail'), error);
    });
  };
  const actions = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().createElement(commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_16__["default"], {
    success: status === commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_22__.RESOLVED,
    loading: status === commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_22__.PENDING,
    onClick: () => runAsync(handleSubmit()),
    disabled: !canSubmit
  }, translate('createUserButton'));
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().createElement((react__WEBPACK_IMPORTED_MODULE_5___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_6__["default"], {
    id: "create-user",
    title: translate('createUserHeader'),
    actions: actions,
    closeDialog: close,
    maxWidth: "md"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_12__["default"], null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().createElement("form", {
    noValidate: true,
    onSubmit: () => canSubmit && runAsync(handleSubmit())
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_13__["default"], {
    placeholder: translate('createUsernamePlaceholder'),
    error: username.error && !username.isPristine,
    helperText: username.error ? username.error : translate('createUsernameHelptext'),
    autoFocus: true,
    id: "username",
    label: translate('createUsername'),
    type: "email",
    value: username.value,
    onChange: handleUsernameChange,
    required: true
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_13__["default"], {
    placeholder: translate('createFirstnamePlaceholder'),
    error: firstname.error && !firstname.isPristine,
    helperText: firstname.error ? firstname.error : '',
    id: "firstname",
    label: translate('createFirstname'),
    value: firstname.value,
    onChange: update(firstname, setFirstname),
    required: true
  }), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_13__["default"], {
    placeholder: translate('createLastnamePlaceholder'),
    error: lastname.error && !lastname.isPristine,
    helperText: lastname.error ? lastname.error : '',
    id: "lastname",
    label: translate('createLastname'),
    value: lastname.value,
    onChange: update(lastname, setLastname),
    required: true
  }), includePersonalProject ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_14__["default"], {
    control: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_15__["default"], {
      color: "primary"
    }),
    label: translate('createContextWithUser'),
    labelPlacement: "start",
    onChange: () => setContext(!context),
    checked: context
  }) : null))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_5___default().createElement(commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_20__.ErrorCatcher, {
    error: createError
  }));
};
CreateUserDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CreateUserDialog);

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/CreateUserDialog/index.js":
/*!*************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/CreateUserDialog/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _CreateUserDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _CreateUserDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CreateUserDialog */ "./modules/admin/users/UsersView/dialogs/CreateUserDialog/CreateUserDialog.js");


/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/DisableUserDialog/DisableUserDialog.js":
/*!**************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/DisableUserDialog/DisableUserDialog.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _mui_material_Button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @mui/material/Button */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Button/Button.js");
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! admin/nls/esadUser.nls */ "./modules/admin/nls/esadUser.nls");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var admin_users_hooks_useUserStatus__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! admin/users/hooks/useUserStatus */ "./modules/admin/users/hooks/useUserStatus.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");









const DisableUserDialog = _ref => {
  let {
    entry,
    isOpen,
    closeDialog,
    onStatusChange
  } = _ref;
  const [isUserDisabled, toggleUserStatus] = (0,admin_users_hooks_useUserStatus__WEBPACK_IMPORTED_MODULE_8__["default"])(entry);
  const handleUserStatusChange = () => {
    toggleUserStatus().then(() => {
      closeDialog();
      onStatusChange();
    });
  };
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_5__.useTranslation)((admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_7___default()));
  const dialogActions = /*#__PURE__*/React.createElement(_mui_material_Button__WEBPACK_IMPORTED_MODULE_3__["default"], {
    onClick: handleUserStatusChange
  }, isUserDisabled ? t('enableUserButtonLabel') : t('disableUserButtonLabel'));
  return /*#__PURE__*/React.createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_6__["default"], {
    id: "change-user-status-dialog",
    open: isOpen,
    closeDialog: closeDialog,
    actions: dialogActions,
    "aria-labelledby": "change-user-status-dialog-title",
    maxWidth: "sm"
  }, /*#__PURE__*/React.createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_4__["default"], {
    xs: 10,
    justifyContent: "flex-start",
    alignItems: "flex-start"
  }, isUserDisabled ? t('userStatusEnableConfirmation') : t('userStatusDisableConfirmation')));
};
DisableUserDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_2___default().shape().isRequired,
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func).isRequired,
  onStatusChange: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().func),
  isOpen: (prop_types__WEBPACK_IMPORTED_MODULE_2___default().bool)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DisableUserDialog);

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/DisableUserDialog/index.js":
/*!**************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/DisableUserDialog/index.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _DisableUserDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _DisableUserDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DisableUserDialog */ "./modules/admin/users/UsersView/dialogs/DisableUserDialog/DisableUserDialog.js");


/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/DowngradeUserFromPremiumDialog/DowngradeUserFromPremiumDialog.js":
/*!****************************************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/DowngradeUserFromPremiumDialog/DowngradeUserFromPremiumDialog.js ***!
  \****************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! admin/nls/esadUser.nls */ "./modules/admin/nls/esadUser.nls");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var commons_util_user__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/util/user */ "./modules/commons/util/user.js");










const DowngradeUserFromPremiumDialog = _ref => {
  let {
    entry: userEntry,
    onDowngrade
  } = _ref;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__.useTranslation)((admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8___default()));
  const {
    runAsync
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_5__["default"])(null);
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_6__.useSnackbar)();
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    runAsync((0,commons_util_user__WEBPACK_IMPORTED_MODULE_9__.downgradeUserFromPremium)(userEntry).then(() => {
      onDowngrade();
      addSnackbar({
        message: translate('downgradeFromPremiumNotification')
      });
    }));
  }, [addSnackbar, onDowngrade, runAsync, translate, userEntry]);
  return null;
};
DowngradeUserFromPremiumDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_3___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__.Entry),
  onDowngrade: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (DowngradeUserFromPremiumDialog);

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/DowngradeUserFromPremiumDialog/index.js":
/*!***************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/DowngradeUserFromPremiumDialog/index.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _DowngradeUserFromPremiumDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _DowngradeUserFromPremiumDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DowngradeUserFromPremiumDialog */ "./modules/admin/users/UsersView/dialogs/DowngradeUserFromPremiumDialog/DowngradeUserFromPremiumDialog.js");


/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/AddUserToGroupDialog/AddUserToGroupDialog.js":
/*!*******************************************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/AddUserToGroupDialog/AddUserToGroupDialog.js ***!
  \*******************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_util_solr_entry__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/util/solr/entry */ "./modules/commons/util/solr/entry.js");
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var admin_utils__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! admin/utils */ "./modules/admin/utils/index.js");
/* harmony import */ var commons_errors_hooks_useErrorHandler__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/errors/hooks/useErrorHandler */ "./modules/commons/errors/hooks/useErrorHandler.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./actions */ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/AddUserToGroupDialog/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


















const entryType = _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_8__.types.ET_LOCAL;
const graphType = _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_8__.types.GT_GROUP;
const resourceType = 'InformationResource';
const GroupList = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_12__.withListModelProvider)(_ref => {
  let {
    userEntry,
    closeDialog,
    updateList,
    userGroupIds
  } = _ref;
  const [selectError, setSelectError] = (0,react__WEBPACK_IMPORTED_MODULE_6__.useState)();
  (0,commons_errors_hooks_useErrorHandler__WEBPACK_IMPORTED_MODULE_16__["default"])(selectError);
  const createQuery = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
    const [query] = (0,commons_util_solr_entry__WEBPACK_IMPORTED_MODULE_9__.getSearchQuery)({
      entryType,
      graphType,
      resourceType
    });
    return query;
  }, []);
  const queryResults = (0,commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_11__.useSolrQuery)({
    createQuery,
    applyQueryParams: admin_utils__WEBPACK_IMPORTED_MODULE_15__.applyUsersGroupParams
  });
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_14__.useTranslation)(_actions__WEBPACK_IMPORTED_MODULE_17__.nlsBundles);
  const handleSelectUser = async groupEntry => groupEntry.getResource(true).addEntry(userEntry).then(() => {
    userEntry.setRefreshNeeded();
    return userEntry.refresh();
  }).then(() => {
    updateList();
    closeDialog();
  }).catch(error => setSelectError(error));
  const getSelectEntryProps = _ref2 => {
    let {
      entry: groupEntry
    } = _ref2;
    const disabled = Boolean(userGroupIds.find(userGroupId => userGroupId === groupEntry.getId()));
    return {
      onClick: () => handleSelectUser(groupEntry),
      disabled,
      label: disabled ? translate('selectedEntityLabel') : translate('selectEntity')
    };
  };
  return /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_11__.EntryListView
  // eslint-disable-next-line react/jsx-props-no-spreading
  , _extends({}, queryResults, {
    nlsBundles: _actions__WEBPACK_IMPORTED_MODULE_17__.nlsBundles,
    columns: [_objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_11__.TITLE_COLUMN), {}, {
      xs: 8,
      getProps: _ref3 => {
        let {
          entry: groupEntry
        } = _ref3;
        return {
          primary: (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_13__.getRenderName)(groupEntry) || translate('unnamedWorkspace', groupEntry.getId())
        };
      }
    }), _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_11__.MODIFIED_COLUMN), {}, {
      xs: 3
    }), {
      id: 'select-entry',
      xs: 1,
      Component: commons_components_ListView__WEBPACK_IMPORTED_MODULE_12__.ListItemButton,
      getProps: getSelectEntryProps
    }]
  }));
});
GroupList.propTypes = {
  userEntry: prop_types__WEBPACK_IMPORTED_MODULE_5___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_8__.Entry),
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  updateList: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  userGroupIds: prop_types__WEBPACK_IMPORTED_MODULE_5___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_5___default().string))
};
const AddUserToGroupDialog = _ref4 => {
  let {
    closeDialog,
    userEntry,
    updateList,
    userGroupIds
  } = _ref4;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_14__.useTranslation)(_actions__WEBPACK_IMPORTED_MODULE_17__.nlsBundles);
  return /*#__PURE__*/React.createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_10__["default"], {
    id: "select-group-dialog",
    closeDialog: closeDialog,
    title: translate('selectGroup'),
    fixedHeight: true
  }, /*#__PURE__*/React.createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_7__["default"], null, /*#__PURE__*/React.createElement(GroupList, {
    userEntry: userEntry,
    closeDialog: closeDialog,
    updateList: updateList,
    userGroupIds: userGroupIds
  })));
};
AddUserToGroupDialog.propTypes = {
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  userEntry: prop_types__WEBPACK_IMPORTED_MODULE_5___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_8__.Entry),
  updateList: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  userGroupIds: prop_types__WEBPACK_IMPORTED_MODULE_5___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_5___default().string))
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (AddUserToGroupDialog);

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/AddUserToGroupDialog/actions.js":
/*!******************************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/AddUserToGroupDialog/actions.js ***!
  \******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   nlsBundles: () => (/* binding */ nlsBundles)
/* harmony export */ });
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! admin/nls/esadGroup.nls */ "./modules/admin/nls/esadGroup.nls");
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_1__);


const nlsBundles = [(admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_0___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_1___default())];

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/AddUserToGroupDialog/index.js":
/*!****************************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/AddUserToGroupDialog/index.js ***!
  \****************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _AddUserToGroupDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _AddUserToGroupDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AddUserToGroupDialog */ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/AddUserToGroupDialog/AddUserToGroupDialog.js");


/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/GroupMembershipsDialog.js":
/*!************************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/GroupMembershipsDialog.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/components/common/ContentWrapper */ "./modules/commons/components/common/ContentWrapper/index.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_util_userIds__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/util/userIds */ "./modules/commons/util/userIds.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/components/LinkedDataBrowserDialog */ "./modules/commons/components/LinkedDataBrowserDialog/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./actions */ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }



















const GroupsList = _ref => {
  let {
    userEntry
  } = _ref;
  const {
    data: groupItems,
    runAsync,
    status
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_15__["default"])();
  const [, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_16__.useListModel)();
  const userGroupIds = (groupItems === null || groupItems === void 0 ? void 0 : groupItems.map(_ref2 => {
    let {
      entry
    } = _ref2;
    return entry.getId();
  })) || [];
  const {
    size,
    result: groupItemsInPage
  } = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_16__.useListQuery)({
    items: groupItems
  });
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_11__.useTranslation)(_actions__WEBPACK_IMPORTED_MODULE_18__.nlsBundles);
  const getTitle = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(entry => (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_9__.getRenderName)(entry) || translate('unnamedWorkspace', entry.getId()), [translate]);
  const getGroupItems = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(async () => {
    const usersGroupURI = commons_store__WEBPACK_IMPORTED_MODULE_8__.entrystore.getEntryURI('_principals', commons_util_userIds__WEBPACK_IMPORTED_MODULE_10__.USERS_ENTRY_ID);
    const groupURIs = userEntry.getParentGroups().filter(groupURI => groupURI !== usersGroupURI);
    return Promise.all(groupURIs.map(groupURI => commons_store__WEBPACK_IMPORTED_MODULE_8__.entrystore.getEntry(groupURI))).then(groupEntries => groupEntries.map(entry => ({
      entry,
      title: getTitle(entry)
    })));
  }, [userEntry, getTitle]);
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    runAsync(getGroupItems());
  }, [runAsync, getGroupItems]);
  const updateList = () => {
    runAsync(getGroupItems().then(entries => {
      dispatch({
        type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_16__.REFRESH
      });
      return entries;
    }));
  };
  return /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.EntryListView, {
    entries: groupItemsInPage.map(_ref3 => {
      let {
        entry
      } = _ref3;
      return entry;
    }),
    status: status,
    size: size,
    nlsBundles: _actions__WEBPACK_IMPORTED_MODULE_18__.nlsBundles,
    includeDefaultListActions: false,
    listActions: _actions__WEBPACK_IMPORTED_MODULE_18__.listActions,
    listActionsProps: {
      userEntry,
      updateList,
      userGroupIds
    },
    getListItemProps: _ref4 => {
      let {
        entry
      } = _ref4;
      return {
        action: _objectSpread(_objectSpread({}, _actions__WEBPACK_IMPORTED_MODULE_18__.presenterAction), {}, {
          entry
        })
      };
    },
    columns: [_objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.TITLE_COLUMN), {}, {
      xs: 8,
      sortBy: commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.TITLE_SORT,
      getProps: _ref5 => {
        let {
          entry
        } = _ref5;
        return {
          primary: getTitle(entry)
        };
      }
    }), commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.MODIFIED_COLUMN, _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.INFO_COLUMN), {}, {
      justifyContent: 'end',
      getProps: _ref6 => {
        let {
          entry,
          translate: t
        } = _ref6;
        return {
          action: _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_14__.LIST_ACTION_INFO), {}, {
            entry,
            nlsBundles: _actions__WEBPACK_IMPORTED_MODULE_18__.nlsBundles,
            formTemplateId: 'esc:Group',
            Dialog: commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_17__["default"]
          }),
          title: t('infoEntry')
        };
      }
    }), _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.ACTION_MENU_COLUMN), {}, {
      userEntry,
      updateList,
      actions: _actions__WEBPACK_IMPORTED_MODULE_18__.rowActions
    })]
  });
};
GroupsList.propTypes = {
  userEntry: prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape().isRequired
};
const GroupMembershipsDialog = _ref7 => {
  let {
    entry,
    closeDialog
  } = _ref7;
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_11__.useTranslation)(_actions__WEBPACK_IMPORTED_MODULE_18__.nlsBundles);
  return /*#__PURE__*/React.createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_12__["default"], {
    id: "group-membership",
    closeDialog: closeDialog,
    title: t('groupHeader', {
      user: (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_9__.getRenderName)(entry)
    }),
    closeDialogButtonLabel: t('close')
  }, /*#__PURE__*/React.createElement(commons_components_common_ContentWrapper__WEBPACK_IMPORTED_MODULE_7__["default"], null, /*#__PURE__*/React.createElement(commons_components_ListView__WEBPACK_IMPORTED_MODULE_16__.ListModelProvider, null, /*#__PURE__*/React.createElement(GroupsList, {
    userEntry: entry
  }))));
};
GroupMembershipsDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_5___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_6__.Entry),
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func).isRequired
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (GroupMembershipsDialog);

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/RemoveUserDialog/RemoveUserDialog.js":
/*!***********************************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/RemoveUserDialog/RemoveUserDialog.js ***!
  \***********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useMainDialog__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/hooks/useMainDialog */ "./modules/commons/hooks/useMainDialog.js");
/* harmony import */ var commons_components_EntryListView_dialogs_ListRemoveEntryDialog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/EntryListView/dialogs/ListRemoveEntryDialog */ "./modules/commons/components/EntryListView/dialogs/ListRemoveEntryDialog/index.js");
/* harmony import */ var commons_components_common_dialogs_MainDialog__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/components/common/dialogs/MainDialog */ "./modules/commons/components/common/dialogs/MainDialog/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
const _excluded = ["entry", "userEntry", "updateList", "nlsBundles", "closeDialog"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }












const removeUserFromGroup = async (groupEntry, userEntry) => {
  await groupEntry.getResource(true).removeEntry(userEntry);
};
const RemoveUserDialog = _ref => {
  let {
      entry: groupEntry,
      userEntry,
      updateList,
      nlsBundles,
      closeDialog
    } = _ref,
    restProps = _objectWithoutProperties(_ref, _excluded);
  const [isUserManager, setIsUserManager] = (0,react__WEBPACK_IMPORTED_MODULE_7__.useState)(false);
  const {
    openMainDialog
  } = (0,commons_hooks_useMainDialog__WEBPACK_IMPORTED_MODULE_9__.useMainDialog)();
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__.useTranslation)(nlsBundles);
  (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    const isManager = groupEntry.getEntryInfo().getACL().admin.includes(userEntry.getResourceURI());
    if (isManager) {
      setIsUserManager(true);
      openMainDialog({
        content: t('removeManager'),
        actions: /*#__PURE__*/React.createElement(commons_components_common_dialogs_MainDialog__WEBPACK_IMPORTED_MODULE_11__.AcknowledgeAction, {
          onDone: closeDialog
        })
      });
    }
  }, [isUserManager]);
  const onRemove = async () => {
    await removeUserFromGroup(groupEntry, userEntry);
    await userEntry.setRefreshNeeded(true);
    await userEntry.refresh();
    updateList();
  };
  return /*#__PURE__*/React.createElement(React.Fragment, null, !isUserManager && /*#__PURE__*/React.createElement(commons_components_EntryListView_dialogs_ListRemoveEntryDialog__WEBPACK_IMPORTED_MODULE_10__["default"], _extends({}, restProps, {
    onRemove: onRemove,
    closeDialog: closeDialog,
    removeConfirmMessage: t('removeGroupFromUser')
  })));
};
RemoveUserDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_5___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_6__.Entry),
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  nlsBundles: commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__.nlsBundlesPropType,
  actions: prop_types__WEBPACK_IMPORTED_MODULE_5___default().arrayOf(prop_types__WEBPACK_IMPORTED_MODULE_5___default().shape({})),
  userEntry: prop_types__WEBPACK_IMPORTED_MODULE_5___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_6__.Entry),
  updateList: (prop_types__WEBPACK_IMPORTED_MODULE_5___default().func),
  userGroupIds: prop_types__WEBPACK_IMPORTED_MODULE_5___default().arrayOf((prop_types__WEBPACK_IMPORTED_MODULE_5___default().string))
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RemoveUserDialog);

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/RemoveUserDialog/index.js":
/*!************************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/RemoveUserDialog/index.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _RemoveUserDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _RemoveUserDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RemoveUserDialog */ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/RemoveUserDialog/RemoveUserDialog.js");


/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/actions.js":
/*!*********************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/actions.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   listActions: () => (/* binding */ listActions),
/* harmony export */   nlsBundles: () => (/* binding */ nlsBundles),
/* harmony export */   presenterAction: () => (/* binding */ presenterAction),
/* harmony export */   rowActions: () => (/* binding */ rowActions)
/* harmony export */ });
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! admin/nls/esadGroup.nls */ "./modules/admin/nls/esadGroup.nls");
/* harmony import */ var admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! admin/nls/esadUser.nls */ "./modules/admin/nls/esadUser.nls");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/components/LinkedDataBrowserDialog */ "./modules/commons/components/LinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var _AddUserToGroupDialog__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./AddUserToGroupDialog */ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/AddUserToGroupDialog/index.js");
/* harmony import */ var _RemoveUserDialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./RemoveUserDialog */ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/RemoveUserDialog/index.js");







const nlsBundles = [(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_2___default()), (admin_nls_esadGroup_nls__WEBPACK_IMPORTED_MODULE_0___default()), (admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_1___default())];
const listActions = [{
  id: 'add-user',
  Dialog: _AddUserToGroupDialog__WEBPACK_IMPORTED_MODULE_5__["default"],
  labelNlsKey: 'addUserToGroupNLS'
}];
const rowActions = [{
  id: 'remove',
  Dialog: _RemoveUserDialog__WEBPACK_IMPORTED_MODULE_6__["default"],
  isVisible: _ref => {
    let {
      entry
    } = _ref;
    return (0,commons_util_entry__WEBPACK_IMPORTED_MODULE_4__.canWriteResource)(entry);
  },
  labelNlsKey: 'removeEntryLabel'
}];
const presenterAction = {
  id: 'info',
  Dialog: commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_3__["default"],
  isVisible: _ref2 => {
    let {
      entry
    } = _ref2;
    return (0,commons_util_entry__WEBPACK_IMPORTED_MODULE_4__.canReadMetadata)(entry);
  },
  labelNlsKey: 'infoEntry',
  formTemplateId: 'esc:Group'
};

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/index.js":
/*!*******************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/index.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _GroupMembershipsDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _GroupMembershipsDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./GroupMembershipsDialog */ "./modules/admin/users/UsersView/dialogs/GroupMembershipsDialog/GroupMembershipsDialog.js");


/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/UpgradeUserToPremiumDialog/UpgradeUserToPremiumDialog.js":
/*!********************************************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/UpgradeUserToPremiumDialog/UpgradeUserToPremiumDialog.js ***!
  \********************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! admin/nls/esadUser.nls */ "./modules/admin/nls/esadUser.nls");
/* harmony import */ var admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var commons_util_user__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/util/user */ "./modules/commons/util/user.js");










const UpgradeUserToPremiumDialog = _ref => {
  let {
    entry: userEntry,
    onUpgrade
  } = _ref;
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_7__.useTranslation)((admin_nls_esadUser_nls__WEBPACK_IMPORTED_MODULE_8___default()));
  const {
    runAsync
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_5__["default"])(null);
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_6__.useSnackbar)();
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    runAsync((0,commons_util_user__WEBPACK_IMPORTED_MODULE_9__.upgradeUserToPremium)(userEntry).then(() => {
      onUpgrade();
      addSnackbar({
        message: translate('upgradeToPremiumNotification')
      });
    }));
  }, [addSnackbar, onUpgrade, runAsync, translate, userEntry]);
  return null;
};
UpgradeUserToPremiumDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_3___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_4__.Entry),
  onUpgrade: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (UpgradeUserToPremiumDialog);

/***/ }),

/***/ "./modules/admin/users/UsersView/dialogs/UpgradeUserToPremiumDialog/index.js":
/*!***********************************************************************************!*\
  !*** ./modules/admin/users/UsersView/dialogs/UpgradeUserToPremiumDialog/index.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _UpgradeUserToPremiumDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _UpgradeUserToPremiumDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./UpgradeUserToPremiumDialog */ "./modules/admin/users/UsersView/dialogs/UpgradeUserToPremiumDialog/UpgradeUserToPremiumDialog.js");


/***/ }),

/***/ "./modules/admin/users/UsersView/index.js":
/*!************************************************!*\
  !*** ./modules/admin/users/UsersView/index.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _UsersView__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _UsersView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./UsersView */ "./modules/admin/users/UsersView/UsersView.js");


/***/ }),

/***/ "./modules/admin/users/hooks/useUserStatus.js":
/*!****************************************************!*\
  !*** ./modules/admin/users/hooks/useUserStatus.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_util_user__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/util/user */ "./modules/commons/util/user.js");






/**
 * Manages a user's status (enabled/disabled)
 * @param {Entry} userEntry
 * @returns {[boolean, function]}
 */
const useUserStatus = userEntry => {
  const [isUserDisabled, setUserStatus] = (0,react__WEBPACK_IMPORTED_MODULE_3__.useState)((0,commons_util_user__WEBPACK_IMPORTED_MODULE_4__.getIsUserDisabled)(userEntry));
  const toggleUserStatus = async () => {
    const newUserStatus = !isUserDisabled;
    const userResource = await userEntry.getResource();
    await userResource.setDisabled(newUserStatus);
    setUserStatus(newUserStatus);
  };
  return [isUserDisabled, toggleUserStatus];
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useUserStatus);

/***/ }),

/***/ "./modules/admin/users/utils/user.js":
/*!*******************************************!*\
  !*** ./modules/admin/users/utils/user.js ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   replaceNameWithFirstAndLastName: () => (/* binding */ replaceNameWithFirstAndLastName)
/* harmony export */ });
/* harmony import */ var commons_util_store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! commons/util/store */ "./modules/commons/util/store.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");



/**
 *
 * @param {Entry} entry
 */
const replaceNameWithFirstAndLastName = entry => {
  const {
    metadata,
    resourceURI
  } = (0,commons_util_store__WEBPACK_IMPORTED_MODULE_0__.spreadEntry)(entry);
  const firstname = metadata.findFirstValue(resourceURI, 'foaf:givenName');
  const lastname = metadata.findFirstValue(resourceURI, 'foaf:familyName');
  metadata.findAndRemove(resourceURI, 'foaf:name');
  metadata.addL(resourceURI, 'foaf:name', `${firstname} ${lastname}`);
};

/***/ }),

/***/ "./modules/admin/utils/index.js":
/*!**************************************!*\
  !*** ./modules/admin/utils/index.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   applyUsersGroupParams: () => (/* binding */ applyUsersGroupParams),
/* harmony export */   checkPermission: () => (/* binding */ checkPermission),
/* harmony export */   getSecondaryNavViewsForAdmin: () => (/* binding */ getSecondaryNavViewsForAdmin)
/* harmony export */ });
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var commons_util_userIds__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/util/userIds */ "./modules/commons/util/userIds.js");
/* harmony import */ var commons_util_solr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/util/solr */ "./modules/commons/util/solr/index.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! config */ "./app/registry/config/config.js");






/**
 *
 * @param {object} query
 * @param {object} queryParams
 * @returns {undefined}
 */
const applyUsersGroupParams = (query, queryParams) => {
  (0,commons_util_solr__WEBPACK_IMPORTED_MODULE_2__.applyQueryParams)(query, queryParams);
  query.uri(commons_store__WEBPACK_IMPORTED_MODULE_0__.entrystore.getEntryURI('_principals', commons_util_userIds__WEBPACK_IMPORTED_MODULE_1__.USERS_ENTRY_ID), 'not');
};

/**
 *
 * @returns {object[]}
 */
const getSecondaryNavViewsForAdmin = () => {
  return (0,commons_util_site__WEBPACK_IMPORTED_MODULE_3__.getSubviewsOfView)('admin');
};

/**
 * Admin module-specific view permission check
 *
 * @param {string} userPermission
 * @param {string} restrictTo
 * @param {boolean} hasPermission - non-module-specific checks result
 * @returns {boolean}
 */
const checkPermission = (userPermission, restrictTo, hasPermission) => {
  if (userPermission === 'admin' && restrictTo === 'advancedAdmin') {
    return config__WEBPACK_IMPORTED_MODULE_4__["default"].get('admin.advancedAdminVisibleForAdminGroup');
  }
  return hasPermission;
};

/***/ }),

/***/ "./modules/catalog/catalogs/CatalogOverview/CatalogOverview.js":
/*!*********************************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogOverview/CatalogOverview.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.string.includes.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.includes.js");
/* harmony import */ var core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_includes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var entitytype_lookup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! entitytype-lookup */ "./node_modules/.pnpm/entitytype-lookup@https+++bitbucket.org+metasolutions+entitytype-lookup+get+e4b4dfb8f83_9b0bd6f7d39b11bfe772b06530743694/node_modules/entitytype-lookup/src/index.js");
/* harmony import */ var commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/hooks/useESContext */ "./modules/commons/hooks/useESContext.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var react_router_dom__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react-router-dom */ "./node_modules/.pnpm/react-router@6.30.1_react@18.3.1/node_modules/react-router/dist/index.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var catalog_nls_escaStatistics_nls__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! catalog/nls/escaStatistics.nls */ "./modules/catalog/nls/escaStatistics.nls");
/* harmony import */ var catalog_nls_escaStatistics_nls__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaStatistics_nls__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var catalog_nls_escaOverview_nls__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! catalog/nls/escaOverview.nls */ "./modules/catalog/nls/escaOverview.nls");
/* harmony import */ var catalog_nls_escaOverview_nls__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaOverview_nls__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/nls/escoOverview.nls */ "./modules/commons/nls/escoOverview.nls");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! catalog/nls/escaCatalog.nls */ "./modules/catalog/nls/escaCatalog.nls");
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/components/overview/Overview */ "./modules/commons/components/overview/Overview/index.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_hooks_useAsyncCallback__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/hooks/useAsyncCallback */ "./modules/commons/hooks/useAsyncCallback.js");
/* harmony import */ var catalog_utils_react_catalog__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! catalog/utils/react/catalog */ "./modules/catalog/utils/react/catalog.js");
/* harmony import */ var config__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! config */ "./app/registry/config/config.js");
/* harmony import */ var commons_errors_hooks_useErrorHandler__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! commons/errors/hooks/useErrorHandler */ "./modules/commons/errors/hooks/useErrorHandler.js");
/* harmony import */ var commons_components_overview_utils_contextOverview__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! commons/components/overview/utils/contextOverview */ "./modules/commons/components/overview/utils/contextOverview.js");
/* harmony import */ var commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! commons/hooks/useUser */ "./modules/commons/hooks/useUser.js");
/* harmony import */ var commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! commons/types/utils/uri */ "./modules/commons/types/utils/uri.js");
/* harmony import */ var catalog_config_config__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! catalog/config/config */ "./modules/catalog/config/config.js");
/* harmony import */ var commons_components_router_useNavigate__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! commons/components/router/useNavigate */ "./modules/commons/components/router/useNavigate.js");
/* harmony import */ var commons_components_overview__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! commons/components/overview */ "./modules/commons/components/overview/index.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_locale__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! commons/locale */ "./modules/commons/locale/index.js");
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var commons_components_Loader_Loader__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! commons/components/Loader/Loader */ "./modules/commons/components/Loader/Loader.js");
/* harmony import */ var commons_nls_escoDialogs_nls__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! commons/nls/escoDialogs.nls */ "./modules/commons/nls/escoDialogs.nls");
/* harmony import */ var commons_nls_escoDialogs_nls__WEBPACK_IMPORTED_MODULE_33___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoDialogs_nls__WEBPACK_IMPORTED_MODULE_33__);
/* harmony import */ var _datasets_queries__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../../datasets/queries */ "./modules/catalog/datasets/queries.js");
/* harmony import */ var _components_Statistics__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./components/Statistics */ "./modules/catalog/catalogs/CatalogOverview/components/Statistics/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./actions */ "./modules/catalog/catalogs/CatalogOverview/actions.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }





































const nlsBundles = [(commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_14___default()), (catalog_nls_escaOverview_nls__WEBPACK_IMPORTED_MODULE_13___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_15___default()), (catalog_nls_escaStatistics_nls__WEBPACK_IMPORTED_MODULE_12___default()), (catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_16___default()), (commons_nls_escoDialogs_nls__WEBPACK_IMPORTED_MODULE_33___default())];

/**
 * Returns catalog specific counting queries when applicable
 *
 * @param {Context} _context
 * @param {EntityType} entityType
 * @returns {number}
 */
const getCatalogCountQuery = (_context, entityType) => {
  if (entityType.get('name') !== 'dataset') return null;
  return _datasets_queries__WEBPACK_IMPORTED_MODULE_34__.getCountQuery;
};

/**
 * Checks whether any of the entity types or the entity types they refine
 * correspond to the statistics shown in the graph.
 *
 * @param {EntityType} entityTypes
 * @returns {boolean}
 */
const getHasStatsTypes = function getHasStatsTypes() {
  let entityTypes = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  if (!entityTypes.length) return false;
  const statsTypeNames = ['datasetDocument', 'distribution'];
  const hasStatsTypes = entityTypes.some(entityType => statsTypeNames.includes(entityType.get('name')));
  const statsTypesUris = statsTypeNames.map(typeName => (0,commons_types_utils_uri__WEBPACK_IMPORTED_MODULE_25__.nameToURI)(typeName, 'entitytypes'));
  const refinedTypeUris = entityTypes.map(type => type.get('refines'));
  const refinesStatsTypes = statsTypesUris.filter(uri => refinedTypeUris.includes(uri));
  return hasStatsTypes || refinesStatsTypes;
};
const CatalogOverview = _ref => {
  let {
    overviewProps
  } = _ref;
  const {
    userInfo,
    userEntry
  } = (0,commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_24__.useUserState)();
  const {
    data: state,
    runAsync,
    error,
    isLoading
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_18__["default"])({
    data: {}
  });
  const {
    goBackToListView
  } = (0,commons_components_router_useNavigate__WEBPACK_IMPORTED_MODULE_27__["default"])();
  (0,commons_errors_hooks_useErrorHandler__WEBPACK_IMPORTED_MODULE_22__["default"])(error);
  const viewParams = (0,react_router_dom__WEBPACK_IMPORTED_MODULE_10__.useParams)();
  const viewParamsRef = (0,react__WEBPACK_IMPORTED_MODULE_6__.useRef)(viewParams);
  const {
    context
  } = (0,commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_8__.useESContext)();
  const [isPublic] = (0,commons_hooks_useAsyncCallback__WEBPACK_IMPORTED_MODULE_19__["default"])(catalog_utils_react_catalog__WEBPACK_IMPORTED_MODULE_20__.isCatalogPublic, context);
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_9__.useTranslation)(nlsBundles);
  const [{
    refreshCount
  }] = (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_28__.useOverviewModel)();
  (0,react__WEBPACK_IMPORTED_MODULE_6__.useEffect)(() => {
    const getCatalogEntry = async () => {
      const catalogEntry = await commons_store__WEBPACK_IMPORTED_MODULE_11__.entrystoreUtil.getEntryByType('dcat:Catalog', context);
      return catalogEntry;
    };
    runAsync(getCatalogEntry().then(catalogEntry => {
      return (0,commons_components_overview_utils_contextOverview__WEBPACK_IMPORTED_MODULE_23__["default"])(viewParamsRef.current, catalogEntry, context, translate, userInfo, getCatalogCountQuery);
    }));
  }, [context, runAsync, translate, userInfo, refreshCount]);
  const descriptionItems = [commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_31__.DESCRIPTION_CREATED, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_31__.DESCRIPTION_UPDATED, _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_31__.DESCRIPTION_PROJECT_TYPE), {}, {
    getValues: () => {
      var _state$projectType;
      return state !== null && state !== void 0 && state.projectType ? [(0,commons_locale__WEBPACK_IMPORTED_MODULE_30__.localize)(state === null || state === void 0 || (_state$projectType = state.projectType) === null || _state$projectType === void 0 ? void 0 : _state$projectType.getLabel())] : [translate('defaultProjectType')];
    }
  })];
  const handleRemove = (0,react__WEBPACK_IMPORTED_MODULE_6__.useCallback)(() => {
    goBackToListView(catalog_config_config__WEBPACK_IMPORTED_MODULE_26__.CATALOGS_LISTVIEW);
  }, [goBackToListView]);
  const showStatistics = config__WEBPACK_IMPORTED_MODULE_21__["default"].get('catalog.includeStatistics') && isPublic && getHasStatsTypes(state === null || state === void 0 ? void 0 : state.entityTypes);
  if (isLoading) return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default().createElement(commons_components_Loader_Loader__WEBPACK_IMPORTED_MODULE_32__["default"], null);
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default().createElement(commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_17__["default"], _extends({
    backLabel: translate('backTitle'),
    entry: state.entry,
    nlsBundles: nlsBundles,
    descriptionItems: descriptionItems,
    rowActions: state.rowActions,
    sidebarActions: _actions__WEBPACK_IMPORTED_MODULE_36__.sidebarActions,
    sidebarProps: {
      userEntry,
      userInfo,
      context,
      onRemove: handleRemove
    }
  }, overviewProps), showStatistics ? /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_6___default().createElement(_components_Statistics__WEBPACK_IMPORTED_MODULE_35__["default"], null) : null);
};
CatalogOverview.propTypes = {
  overviewProps: commons_components_overview__WEBPACK_IMPORTED_MODULE_28__.overviewPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_overview__WEBPACK_IMPORTED_MODULE_28__.withOverviewModelProvider)(CatalogOverview));

/***/ }),

/***/ "./modules/catalog/catalogs/CatalogOverview/actions.js":
/*!*************************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogOverview/actions.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sidebarActions: () => (/* binding */ sidebarActions)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_types_dialogs_ProjectTypeChangeDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/types/dialogs/ProjectTypeChangeDialog */ "./modules/commons/types/dialogs/ProjectTypeChangeDialog/index.js");
/* harmony import */ var commons_util_user__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/util/user */ "./modules/commons/util/user.js");
/* harmony import */ var commons_types_Lookup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/types/Lookup */ "./modules/commons/types/Lookup.js");
/* harmony import */ var commons_components_overview_hooks_useOverviewModel__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/components/overview/hooks/useOverviewModel */ "./modules/commons/components/overview/hooks/useOverviewModel.js");
/* harmony import */ var commons_util_context__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/util/context */ "./modules/commons/util/context.js");
/* harmony import */ var config__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! config */ "./app/registry/config/config.js");
/* harmony import */ var commons_components_overview_dialogs_OverviewEditContextDialog__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/overview/dialogs/OverviewEditContextDialog */ "./modules/commons/components/overview/dialogs/OverviewEditContextDialog/index.js");
/* harmony import */ var catalog_catalogs_dialogs_RemoveCatalogDialog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! catalog/catalogs/dialogs/RemoveCatalogDialog */ "./modules/catalog/catalogs/dialogs/RemoveCatalogDialog/index.js");
/* harmony import */ var _dialogs_EmbedDialog_index__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../dialogs/EmbedDialog/index */ "./modules/catalog/catalogs/dialogs/EmbedDialog/index.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }











const canEditProjectType = (entry, userEntry, userInfo) => {
  if (!userInfo) return false;
  return (0,commons_util_context__WEBPACK_IMPORTED_MODULE_7__.canEditContextMetadata)(entry, userEntry, true) && commons_types_Lookup__WEBPACK_IMPORTED_MODULE_5__["default"].getProjectTypeOptions(userInfo).length;
};
const isExemptFromRestrictions = (userEntry, contextEntry) => (0,commons_util_user__WEBPACK_IMPORTED_MODULE_4__.hasAdminRights)(userEntry) || config__WEBPACK_IMPORTED_MODULE_8__["default"].get('catalog.includeEmbeddOption') || (0,commons_util_context__WEBPACK_IMPORTED_MODULE_7__.isContextPremium)(contextEntry);
const sidebarActions = [_objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_EDIT), {}, {
  Dialog: commons_components_overview_dialogs_OverviewEditContextDialog__WEBPACK_IMPORTED_MODULE_9__["default"],
  isVisible: _ref => {
    let {
      entry,
      userEntry
    } = _ref;
    return (0,commons_util_context__WEBPACK_IMPORTED_MODULE_7__.canEditContextMetadata)(entry, userEntry, true);
  }
}), _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REVISIONS), {}, {
  isVisible: _ref2 => {
    let {
      entry,
      userEntry
    } = _ref2;
    return (0,commons_util_context__WEBPACK_IMPORTED_MODULE_7__.canEditContextMetadata)(entry, userEntry, true);
  },
  getProps: () => ({
    action: {
      excludeProperties: ['dcat:dataset']
    }
  })
}), {
  id: 'change-projecttype',
  Dialog: (0,commons_components_overview_hooks_useOverviewModel__WEBPACK_IMPORTED_MODULE_6__.withOverviewRefresh)(commons_types_dialogs_ProjectTypeChangeDialog__WEBPACK_IMPORTED_MODULE_3__["default"], 'onChange'),
  labelNlsKey: 'changeProjectTypeLabel',
  isVisible: _ref3 => {
    let {
      entry,
      userEntry,
      userInfo
    } = _ref3;
    return canEditProjectType(entry, userEntry, userInfo);
  }
}, _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_2__.LIST_ACTION_SHARING_SETTINGS), {}, {
  labelNlsKey: 'catalogMember',
  getProps: () => ({
    action: {
      sharingSettingsRestrictionPath: () => config__WEBPACK_IMPORTED_MODULE_8__["default"].get('catalog.disallowCatalogCollaborationDialog')
    }
  }),
  highlightId: 'overviewActionSharing'
}), _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_2__.LIST_ACTION_DOWNLOAD), {}, {
  labelNlsKey: 'catalogExport',
  getProps: () => ({
    action: {
      profile: 'dcat'
    }
  }),
  highlightId: 'overviewActionDownload'
}), {
  id: 'embed',
  Dialog: _dialogs_EmbedDialog_index__WEBPACK_IMPORTED_MODULE_11__["default"],
  labelNlsKey: 'catalogEmbed',
  isVisible: _ref4 => {
    let {
      entry,
      userEntry
    } = _ref4;
    const contextEntry = entry.getContext().getEntry(true);
    return isExemptFromRestrictions(userEntry, contextEntry);
  },
  highlightId: 'overviewActionEmbed'
}, _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REMOVE), {}, {
  isVisible: _ref5 => {
    let {
      entry,
      userEntry
    } = _ref5;
    return (0,commons_util_context__WEBPACK_IMPORTED_MODULE_7__.canEditContextMetadata)(entry, userEntry, true);
  },
  Dialog: catalog_catalogs_dialogs_RemoveCatalogDialog__WEBPACK_IMPORTED_MODULE_10__["default"]
})];


/***/ }),

/***/ "./modules/catalog/catalogs/CatalogOverview/components/ListItem/ListItem.js":
/*!**********************************************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogOverview/components/ListItem/ListItem.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/ListItem/ListItem.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/ListItemText/ListItemText.js");
/* harmony import */ var _ListItem_scss__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./ListItem.scss */ "./modules/catalog/catalogs/CatalogOverview/components/ListItem/ListItem.scss");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");

function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }


const ListItem = props => {
  return /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_1__["default"], {
    disableGutters: true,
    classes: {
      root: 'escaOverviewListItem'
    }
  }, /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_2__["default"], _extends({
    classes: {
      root: 'escaOverviewListItemText__root',
      primary: 'escaOverviewListItemText__primary',
      secondary: 'escaOverviewListItemText__secondary'
    }
  }, props)));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (ListItem);

/***/ }),

/***/ "./modules/catalog/catalogs/CatalogOverview/components/ListItem/ListItem.scss":
/*!************************************************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogOverview/components/ListItem/ListItem.scss ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_ListItem_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../../../node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!../../../../../../node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./ListItem.scss */ "./node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!./node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./modules/catalog/catalogs/CatalogOverview/components/ListItem/ListItem.scss");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_ListItem_scss__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_ListItem_scss__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_ListItem_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_ListItem_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./modules/catalog/catalogs/CatalogOverview/components/ListItem/index.js":
/*!*******************************************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogOverview/components/ListItem/index.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ListItem__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ListItem__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ListItem */ "./modules/catalog/catalogs/CatalogOverview/components/ListItem/ListItem.js");


/***/ }),

/***/ "./modules/catalog/catalogs/CatalogOverview/components/Statistics/Statistics.js":
/*!**************************************************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogOverview/components/Statistics/Statistics.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/hooks/useESContext */ "./modules/commons/hooks/useESContext.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var catalog_nls_escaStatistics_nls__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! catalog/nls/escaStatistics.nls */ "./modules/catalog/nls/escaStatistics.nls");
/* harmony import */ var catalog_nls_escaStatistics_nls__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaStatistics_nls__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var catalog_nls_escaOverview_nls__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! catalog/nls/escaOverview.nls */ "./modules/catalog/nls/escaOverview.nls");
/* harmony import */ var catalog_nls_escaOverview_nls__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaOverview_nls__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var commons_components_chart_ChartPlaceholder__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/components/chart/ChartPlaceholder */ "./modules/commons/components/chart/ChartPlaceholder/index.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/List/List.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_components_chart_Time__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/chart/Time */ "./modules/commons/components/chart/Time/index.js");
/* harmony import */ var catalog_catalogs_CatalogOverview_util__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! catalog/catalogs/CatalogOverview/util */ "./modules/catalog/catalogs/CatalogOverview/util.js");
/* harmony import */ var _ListItem__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../ListItem */ "./modules/catalog/catalogs/CatalogOverview/components/ListItem/index.js");
/* harmony import */ var _Statistics_scss__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./Statistics.scss */ "./modules/catalog/catalogs/CatalogOverview/components/Statistics/Statistics.scss");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");














const Statistics = () => {
  var _chartData$bar$datase;
  const [loading, setLoading] = (0,react__WEBPACK_IMPORTED_MODULE_2__.useState)(true);
  const {
    context
  } = (0,commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_3__.useESContext)();
  const {
    data: chartData,
    runAsync
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_9__["default"])(null);
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_4__.useTranslation)([(catalog_nls_escaOverview_nls__WEBPACK_IMPORTED_MODULE_6___default()), (catalog_nls_escaStatistics_nls__WEBPACK_IMPORTED_MODULE_5___default())]);
  const stopLoading = () => {
    setLoading(false);
  };
  (0,react__WEBPACK_IMPORTED_MODULE_2__.useEffect)(() => {
    runAsync((0,catalog_catalogs_CatalogOverview_util__WEBPACK_IMPORTED_MODULE_11__.getStatisticsData)(context, t, stopLoading));
  }, [context, runAsync, t]);
  return /*#__PURE__*/React.createElement("div", {
    className: "escaOverviewStats",
    "data-highlight-id": "overviewStatistics"
  }, /*#__PURE__*/React.createElement("h2", {
    className: "escaOverviewStats__header"
  }, t('statsCatalogOverviewTitle')), /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], {
    classes: {
      root: 'escaOverviewStats__list'
    },
    disablePadding: true
  }, /*#__PURE__*/React.createElement(_ListItem__WEBPACK_IMPORTED_MODULE_12__["default"], {
    primary: t('statsCatalogOverviewChartFileLabel'),
    secondary: chartData !== null && chartData !== void 0 && chartData.fileTotalCount ? chartData.fileTotalCount : '-'
  }), /*#__PURE__*/React.createElement(_ListItem__WEBPACK_IMPORTED_MODULE_12__["default"], {
    primary: t('statsCatalogOverviewChartAPILabel'),
    secondary: chartData !== null && chartData !== void 0 && chartData.apiTotalCount ? chartData.apiTotalCount : '-'
  })), chartData !== null && chartData !== void 0 && (_chartData$bar$datase = chartData.bar.datasets) !== null && _chartData$bar$datase !== void 0 && _chartData$bar$datase.length ? /*#__PURE__*/React.createElement(commons_components_chart_Time__WEBPACK_IMPORTED_MODULE_10__["default"], {
    data: chartData.bar,
    dimensions: {
      height: '306px',
      width: '100%'
    }
  }) : /*#__PURE__*/React.createElement(commons_components_chart_ChartPlaceholder__WEBPACK_IMPORTED_MODULE_7__["default"], {
    label: t('statsChartPlaceholder'),
    loading: loading
  }));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Statistics);

/***/ }),

/***/ "./modules/catalog/catalogs/CatalogOverview/components/Statistics/Statistics.scss":
/*!****************************************************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogOverview/components/Statistics/Statistics.scss ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_Statistics_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../../../node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!../../../../../../node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./Statistics.scss */ "./node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!./node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./modules/catalog/catalogs/CatalogOverview/components/Statistics/Statistics.scss");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_Statistics_scss__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_Statistics_scss__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_Statistics_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_Statistics_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./modules/catalog/catalogs/CatalogOverview/components/Statistics/index.js":
/*!*********************************************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogOverview/components/Statistics/index.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _Statistics__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _Statistics__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./Statistics */ "./modules/catalog/catalogs/CatalogOverview/components/Statistics/Statistics.js");


/***/ }),

/***/ "./modules/catalog/catalogs/CatalogOverview/index.js":
/*!***********************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogOverview/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _CatalogOverview__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _CatalogOverview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CatalogOverview */ "./modules/catalog/catalogs/CatalogOverview/CatalogOverview.js");


/***/ }),

/***/ "./modules/catalog/catalogs/CatalogOverview/util.js":
/*!**********************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogOverview/util.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getStatisticsData: () => (/* binding */ getStatisticsData)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.reduce.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.reduce.js");
/* harmony import */ var core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_reduce_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_statistics_api__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/statistics/api */ "./modules/commons/statistics/api.js");
/* harmony import */ var catalog_statistics_utils_distribution__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! catalog/statistics/utils/distribution */ "./modules/catalog/statistics/utils/distribution.js");









/**
 * Get top statistics for a specific time. Used here only with specific dates
 *
 * @param {Context} context
 * @param {object} timeRangeDay
 * @returns {Promise<*>}
 */
const getCatalogStatistics = (context, timeRangeDay) => commons_statistics_api__WEBPACK_IMPORTED_MODULE_6__["default"].getTopStatistics(context.getId(), catalog_statistics_utils_distribution__WEBPACK_IMPORTED_MODULE_7__.RESOURCE_TYPE_ALL, timeRangeDay);

/**
 * Sum downloads of api/file or both
 *
 * @param {object[]} results
 * @param {null|String} type
 * @returns {number}
 */
const sumTotalCountFromResult = function sumTotalCountFromResult(results) {
  let type = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  return results.reduce((totalCount, res) => {
    if (type === null || type === res.type) {
      return totalCount + res.count;
    }
    return totalCount;
  }, 0);
};

/**
 * Get statistics for catalog in the last 7 days
 *
 * @param {Context} context
 * @param {Function} translate
 * @param {Function} callback
 * @returns {Promise<{bar: {datasets: Array}, doughnut: {datasets: {data: number[], label: *}[], labels: *[]}}>}
 */
const getStatisticsData = async (context, translate, callback) => {
  // prepare data structures and api calls
  const barData = {
    datasets: []
  };
  const today = new Date();
  const timeRanges = [];
  for (let i = 0; i < 7; i++) {
    const date = new Date();
    date.setDate(today.getDate() - i);
    timeRanges.push({
      year: date.getFullYear(),
      month: date.getMonth(),
      // month is zero indexed
      date: date.getDate()
    });
  }

  // make api call and calculate results
  const dataPointsFiles = [];
  const dataPointsAPI = [];
  let fileTotalCount = 0;
  let apiTotalCount = 0;
  const results = await Promise.all(timeRanges.map(timeRange => getCatalogStatistics(context, timeRange)));
  results.forEach((result, idx) => {
    const fileCount = sumTotalCountFromResult(result, catalog_statistics_utils_distribution__WEBPACK_IMPORTED_MODULE_7__.RESOURCE_TYPE_FILE);
    const apiCount = sumTotalCountFromResult(result, catalog_statistics_utils_distribution__WEBPACK_IMPORTED_MODULE_7__.RESOURCE_TYPE_API);
    const timeRange = timeRanges[idx];
    dataPointsFiles.push({
      x: new Date(timeRange.year, timeRange.month, timeRange.date),
      y: fileCount
    });
    dataPointsAPI.push({
      x: new Date(timeRange.year, timeRange.month, timeRange.date),
      y: apiCount
    });
    fileTotalCount += fileCount;
    apiTotalCount += apiCount;
  });

  // populate the data structures for the charts
  if (fileTotalCount || apiTotalCount) {
    // at least some data, not all 0
    barData.datasets.push({
      data: dataPointsFiles,
      label: translate('statsCatalogOverviewChartFileLabel')
    });
    barData.datasets.push({
      data: dataPointsAPI,
      label: translate('statsCatalogOverviewChartAPILabel')
    });
  }
  callback();
  return {
    bar: barData,
    fileTotalCount,
    apiTotalCount
  };
};

/***/ }),

/***/ "./modules/catalog/catalogs/CatalogsView/CatalogsView.js":
/*!***************************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogsView/CatalogsView.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/hooks/useUser */ "./modules/commons/hooks/useUser.js");
/* harmony import */ var commons_util_solr_context__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/util/solr/context */ "./modules/commons/util/solr/context.js");
/* harmony import */ var commons_util_context__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/util/context */ "./modules/commons/util/context.js");
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var config__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! config */ "./app/registry/config/config.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var catalog_catalogs_utils_catalog__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! catalog/catalogs/utils/catalog */ "./modules/catalog/catalogs/utils/catalog.js");
/* harmony import */ var catalog_utils_catalog__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! catalog/utils/catalog */ "./modules/catalog/utils/catalog.js");
/* harmony import */ var commons_hooks_useGetMainDialog__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/hooks/useGetMainDialog */ "./modules/commons/hooks/useGetMainDialog.js");
/* harmony import */ var commons_util_reactUtils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/util/reactUtils */ "./modules/commons/util/reactUtils.js");
/* harmony import */ var commons_components_EntryListView_dialogs_ListEditContextDialog__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/components/EntryListView/dialogs/ListEditContextDialog */ "./modules/commons/components/EntryListView/dialogs/ListEditContextDialog/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./actions */ "./modules/catalog/catalogs/CatalogsView/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }




















const CatalogsView = _ref => {
  let {
    listProps
  } = _ref;
  const {
    userEntry,
    userInfo
  } = (0,commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_4__.useUserState)();
  const queryParams = (0,react__WEBPACK_IMPORTED_MODULE_3__.useMemo)(() => {
    const queryTypeParams = {
      rdfType: commons_util_entry__WEBPACK_IMPORTED_MODULE_7__.RDF_TYPE_CATALOG,
      contextType: commons_util_context__WEBPACK_IMPORTED_MODULE_6__.CONTEXT_TYPE_CATALOG
    };
    return (0,commons_util_solr_context__WEBPACK_IMPORTED_MODULE_5__.getContextSearchQuery)(queryTypeParams, {
      userEntry,
      userInfo
    });
  }, [userEntry, userInfo]);
  const queryResults = (0,commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.useSolrQuery)(queryParams);
  const catalogStartView = config__WEBPACK_IMPORTED_MODULE_12__["default"].get('catalog.startView');
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_13__.useTranslation)(_actions__WEBPACK_IMPORTED_MODULE_19__.nlsBundles);
  const {
    getConfirmationDialog
  } = (0,commons_hooks_useGetMainDialog__WEBPACK_IMPORTED_MODULE_16__["default"])();
  const confirmUnpublish = async catalogEntry => {
    const apiDistributions = await (0,catalog_catalogs_utils_catalog__WEBPACK_IMPORTED_MODULE_14__.getApiDistributions)(catalogEntry.getContext());
    if (!apiDistributions.length) {
      return true;
    }
    return getConfirmationDialog({
      content: (0,commons_util_reactUtils__WEBPACK_IMPORTED_MODULE_17__.renderHtmlString)(translate('apiExistsToUnpublishCatalog'))
    });
  };
  return /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.EntryListView, _extends({}, listProps, {
    nlsBundles: _actions__WEBPACK_IMPORTED_MODULE_19__.nlsBundles,
    listActions: _actions__WEBPACK_IMPORTED_MODULE_19__.listActions,
    listActionsProps: {
      userEntry,
      userInfo,
      numberOfCatalogs: queryResults.size
    },
    getListItemProps: _ref2 => {
      let {
        entry
      } = _ref2;
      return {
        to: (0,commons_util_site__WEBPACK_IMPORTED_MODULE_11__.getPathFromViewName)(catalogStartView, {
          contextId: entry.getContext().getId()
        })
      };
    },
    viewPlaceholderProps: {
      label: !(0,catalog_utils_catalog__WEBPACK_IMPORTED_MODULE_15__.isUserAllowedCatalogCreation)(userEntry, userInfo) ? translate('emptyListWithNoAccessWarning') : null
    },
    columns: [_objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.TOGGLE_CONTEXT_COLUMN), {}, {
      xs: 1,
      getProps: _ref3 => {
        let {
          entry
        } = _ref3;
        return {
          entry,
          publicTooltip: translate('publicCatalogTitle'),
          privateTooltip: translate('privateCatalogTitle'),
          noAccess: translate('catalogSharingNoAccess')
        };
      },
      confirmUnpublish
    }), _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.TITLE_COLUMN), {}, {
      xs: 7
    }), commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.MODIFIED_COLUMN, _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_9__.ACTIONS_GROUP_COLUMN), {}, {
      actions: [commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_10__.LIST_ACTION_INFO, _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_10__.LIST_ACTION_EDIT), {}, {
        isVisible: _ref4 => {
          let {
            entry
          } = _ref4;
          return (0,commons_util_context__WEBPACK_IMPORTED_MODULE_6__.canEditContextMetadata)(entry, userEntry);
        },
        Dialog: commons_components_EntryListView_dialogs_ListEditContextDialog__WEBPACK_IMPORTED_MODULE_18__["default"]
      })]
    })]
  }, queryResults));
};
CatalogsView.propTypes = {
  listProps: commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.listPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_8__.withListModelProviderAndLocation)(CatalogsView));

/***/ }),

/***/ "./modules/catalog/catalogs/CatalogsView/actions.js":
/*!**********************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogsView/actions.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   listActions: () => (/* binding */ listActions),
/* harmony export */   nlsBundles: () => (/* binding */ nlsBundles)
/* harmony export */ });
/* harmony import */ var catalog_utils_catalog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! catalog/utils/catalog */ "./modules/catalog/utils/catalog.js");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! catalog/nls/escaCatalog.nls */ "./modules/catalog/nls/escaCatalog.nls");
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _dialogs_CreateDialog__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../dialogs/CreateDialog */ "./modules/catalog/catalogs/dialogs/CreateDialog.js");




const nlsBundles = [(catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_2___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_1___default())];
const listActions = [{
  id: 'create',
  Dialog: _dialogs_CreateDialog__WEBPACK_IMPORTED_MODULE_3__["default"],
  isVisible: _ref => {
    let {
      userEntry,
      userInfo
    } = _ref;
    return (0,catalog_utils_catalog__WEBPACK_IMPORTED_MODULE_0__.isUserAllowedCatalogCreation)(userEntry, userInfo);
  },
  labelNlsKey: 'createButtonLabel',
  tooltipNlsKey: 'actionTooltip',
  highlightId: 'listActionCreate'
}];

/***/ }),

/***/ "./modules/catalog/catalogs/CatalogsView/index.js":
/*!********************************************************!*\
  !*** ./modules/catalog/catalogs/CatalogsView/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _CatalogsView__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _CatalogsView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CatalogsView */ "./modules/catalog/catalogs/CatalogsView/CatalogsView.js");


/***/ }),

/***/ "./modules/catalog/catalogs/dialogs/CreateDialog.js":
/*!**********************************************************!*\
  !*** ./modules/catalog/catalogs/dialogs/CreateDialog.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var commons_components_dialogs_create_handlers__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/components/dialogs/create/handlers */ "./modules/commons/components/dialogs/create/handlers.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_components_rdforms_RdformsDialogFormWrapper__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/components/rdforms/RdformsDialogFormWrapper */ "./modules/commons/components/rdforms/RdformsDialogFormWrapper/index.js");
/* harmony import */ var commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/components/LoadingButton */ "./modules/commons/components/LoadingButton/index.js");
/* harmony import */ var commons_components_rdforms_hooks_useRDFormsValidation__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/components/rdforms/hooks/useRDFormsValidation */ "./modules/commons/components/rdforms/hooks/useRDFormsValidation.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var config__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! config */ "./app/registry/config/config.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/TextField/TextField.js");
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! catalog/nls/escaCatalog.nls */ "./modules/catalog/nls/escaCatalog.nls");
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_19___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_19__);
/* harmony import */ var catalog_catalogs_utils_catalog__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! catalog/catalogs/utils/catalog */ "./modules/catalog/catalogs/utils/catalog.js");
/* harmony import */ var commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! commons/hooks/useUser */ "./modules/commons/hooks/useUser.js");
/* harmony import */ var commons_types_ProjectTypeChooser__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! commons/types/ProjectTypeChooser */ "./modules/commons/types/ProjectTypeChooser/index.js");
/* harmony import */ var commons_hooks_useRestrictionDialog__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! commons/hooks/useRestrictionDialog */ "./modules/commons/hooks/useRestrictionDialog.js");
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var commons_types_Lookup__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! commons/types/Lookup */ "./modules/commons/types/Lookup.js");
/* harmony import */ var _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! @entryscape/rdfjson */ "./node_modules/.pnpm/@entryscape+rdfjson@2.7.7/node_modules/@entryscape/rdfjson/src/main.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! commons/errors/ErrorCatcher */ "./modules/commons/errors/ErrorCatcher/index.js");
/* harmony import */ var commons_hooks_useRdformsContext__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! commons/hooks/useRdformsContext */ "./modules/commons/hooks/useRdformsContext.js");
/* harmony import */ var commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! commons/hooks/useESContext */ "./modules/commons/hooks/useESContext.js");
/* harmony import */ var commons_util_store__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! commons/util/store */ "./modules/commons/util/store.js");
/* harmony import */ var _useCatalogRestriction__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../useCatalogRestriction */ "./modules/catalog/catalogs/useCatalogRestriction.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
const _excluded = ["numberOfCatalogs", "closeDialog"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }

































const PUBLISHER_PROPERTY = 'http://purl.org/dc/terms/publisher';
const nlsBundles = [(catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_19___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_5___default())];
const createPrototypes = async () => {
  const contextEntry = await commons_store__WEBPACK_IMPORTED_MODULE_9__.entrystore.newContext();
  const context = contextEntry.getPrototypeContext();
  const catalogEntry = (0,commons_util_store__WEBPACK_IMPORTED_MODULE_31__.createEntry)(context, commons_util_entry__WEBPACK_IMPORTED_MODULE_8__.RDF_TYPE_CATALOG);
  catalogEntry.add('rdf:type', commons_util_entry__WEBPACK_IMPORTED_MODULE_8__.RDF_TYPE_CATALOG);
  return {
    contextEntry,
    context,
    catalogEntry
  };
};
const isInputValid = inputValue => !!inputValue.trim().length;
const CreateDialog = _ref => {
  let {
      numberOfCatalogs,
      closeDialog
    } = _ref,
    props = _objectWithoutProperties(_ref, _excluded);
  const confirmClose = (0,commons_components_dialogs_create_handlers__WEBPACK_IMPORTED_MODULE_6__.useConfirmCloseAction)(closeDialog);
  const {
    userEntry,
    userInfo
  } = (0,commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_21__.useUserState)();
  const [selectedProjectType, setSelectedProjectType] = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)('');
  const {
    runAsync: runCreateAsync,
    data: {
      contextEntry,
      context,
      catalogEntry
    }
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_27__["default"])({
    data: {}
  });
  (0,react__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    runCreateAsync(createPrototypes());
  }, [selectedProjectType, runCreateAsync]);
  const [publisher, setPublisher] = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)({
    value: '',
    pristine: true
  });
  const {
    runAsync,
    status,
    error
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_27__["default"])();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_15__.useTranslation)(nlsBundles);
  const [, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.useListModel)();
  const updateParentList = () => dispatch({
    type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_7__.CREATE
  });
  const projectTypes = (0,react__WEBPACK_IMPORTED_MODULE_10__.useMemo)(() => commons_types_Lookup__WEBPACK_IMPORTED_MODULE_25__["default"].getProjectTypeOptions(userInfo), [userInfo]);
  const projectType = projectTypes.find(type => type.getId() === selectedProjectType);
  const defaultEntityType = commons_types_Lookup__WEBPACK_IMPORTED_MODULE_25__["default"].getEntityTypeByRdfType(_entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_26__.namespaces.expand(commons_util_entry__WEBPACK_IMPORTED_MODULE_8__.RDF_TYPE_CATALOG), 'catalog');
  const matchingEntityTypeTemplateId = (projectType ? commons_types_Lookup__WEBPACK_IMPORTED_MODULE_25__["default"].getPrimaryForRdfType(projectType, _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_26__.namespaces.expand(commons_util_entry__WEBPACK_IMPORTED_MODULE_8__.RDF_TYPE_CATALOG)) || defaultEntityType : defaultEntityType).template().getId();
  const createWithPublisher = !config__WEBPACK_IMPORTED_MODULE_16__["default"].get('catalog.createWithoutPublisher');
  const publisherEntityType = commons_types_Lookup__WEBPACK_IMPORTED_MODULE_25__["default"].getByName('publisher');
  const allContexts = publisherEntityType.get('allContexts');
  const createWithTemplatePublisher = Boolean(createWithPublisher && allContexts);
  const createWithCustomPublisher = createWithPublisher && !createWithTemplatePublisher;
  const [filterPredicates] = (0,react__WEBPACK_IMPORTED_MODULE_10__.useState)({
    [PUBLISHER_PROPERTY]: !createWithTemplatePublisher
  });
  const {
    editor,
    EditorComponent,
    graph,
    setButtonDisabled,
    buttonDisabled
  } = (0,commons_components_dialogs_create_handlers__WEBPACK_IMPORTED_MODULE_6__.useCreateEntryState)({
    entry: catalogEntry,
    formTemplateId: matchingEntityTypeTemplateId,
    filterPredicates
  });
  const {
    formErrorMessage,
    setFormErrorMessage,
    checkFormErrors
  } = (0,commons_components_rdforms_hooks_useRDFormsValidation__WEBPACK_IMPORTED_MODULE_14__.useRDFormsValidation)({
    editor
  });
  const {
    isRestricted,
    contentPath
  } = (0,_useCatalogRestriction__WEBPACK_IMPORTED_MODULE_32__["default"])(numberOfCatalogs);
  (0,commons_hooks_useRestrictionDialog__WEBPACK_IMPORTED_MODULE_23__["default"])({
    open: isRestricted,
    contentPath,
    callback: closeDialog
  });
  const close = () => confirmClose(!buttonDisabled || !publisher.pristine);
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_24__.useSnackbar)();
  const showSnackbar = () => {
    addSnackbar({
      message: translate('createCatalogSuccess')
    });
  };
  (0,react__WEBPACK_IMPORTED_MODULE_10__.useEffect)(() => {
    if (graph) {
      graph.onChange = () => {
        setButtonDisabled(false);
        setFormErrorMessage(null);
      };
    }
  }, [graph, setButtonDisabled, setFormErrorMessage, checkFormErrors]);
  const handleCreate = () => {
    if (checkFormErrors(createWithCustomPublisher ? formError => (formError === null || formError === void 0 ? void 0 : formError.item.getProperty()) !== _entryscape_rdfjson__WEBPACK_IMPORTED_MODULE_26__.namespaces.expand(PUBLISHER_PROPERTY) : null)) return;
    runAsync((0,catalog_catalogs_utils_catalog__WEBPACK_IMPORTED_MODULE_20__.createCatalogEntry)({
      contextEntry,
      catalogEntry,
      context,
      createWithPublisher,
      graph,
      publisher,
      userEntry,
      userInfo,
      projectType: selectedProjectType
    }).then(() => {
      updateParentList();
      closeDialog();
      showSnackbar();
    }));
  };
  const isFormValid = () => {
    if (createWithCustomPublisher) {
      return !buttonDisabled && isInputValid(publisher.value);
    }
    return !buttonDisabled;
  };
  const handleProjectTypeChange = newProjectType => {
    setButtonDisabled(true);
    setPublisher({
      value: '',
      pristine: true
    });
    setSelectedProjectType(newProjectType);
  };
  const isDisabled = !isFormValid() || buttonDisabled;
  const dialogActions = /*#__PURE__*/React.createElement(commons_components_LoadingButton__WEBPACK_IMPORTED_MODULE_13__["default"], {
    autoFocus: true,
    loading: status === commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_27__.PENDING,
    onClick: handleCreate,
    disabled: isDisabled
  }, translate('createButtonLabel'));
  if (isRestricted) return null;
  return catalogEntry ? /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_30__.ESContextProvider, {
    context: context,
    contextEntry: contextEntry
  }, /*#__PURE__*/React.createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_11__["default"], _extends({
    id: "create-entry",
    title: translate('createCatalogHeader'),
    actions: dialogActions,
    closeDialog: close,
    maxWidth: "md"
  }, props, {
    alert: formErrorMessage ? {
      message: formErrorMessage,
      setMessage: setFormErrorMessage
    } : undefined
  }), /*#__PURE__*/React.createElement(commons_components_rdforms_RdformsDialogFormWrapper__WEBPACK_IMPORTED_MODULE_12__.RdformsDialogContent, null, /*#__PURE__*/React.createElement(commons_types_ProjectTypeChooser__WEBPACK_IMPORTED_MODULE_22__["default"], {
    onChangeProjectType: handleProjectTypeChange,
    selectedId: selectedProjectType,
    userInfo: userInfo,
    sx: {
      pb: '12px'
    }
  }), editor && /*#__PURE__*/React.createElement(EditorComponent, null), createWithCustomPublisher && /*#__PURE__*/React.createElement(_mui_material__WEBPACK_IMPORTED_MODULE_18__["default"], {
    id: "create-catalog-publisher",
    label: translate('createAgentName'),
    value: publisher.value,
    onChange: event => {
      setPublisher({
        value: event.target.value,
        pristine: false
      });
    },
    placeholder: translate('createAgentNamePlaceholder'),
    error: !publisher.pristine && !isInputValid(publisher.value),
    helperText: !publisher.pristine && !isInputValid(publisher.value) ? translate('publisherRequired') : '',
    required: createWithPublisher
  })))), /*#__PURE__*/React.createElement(commons_errors_ErrorCatcher__WEBPACK_IMPORTED_MODULE_28__.ErrorCatcher, {
    error: error
  })) : null;
};
CreateDialog.propTypes = {
  numberOfCatalogs: (prop_types__WEBPACK_IMPORTED_MODULE_17___default().number),
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_17___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_hooks_useRdformsContext__WEBPACK_IMPORTED_MODULE_29__.withRdformsContextProvider)(CreateDialog));

/***/ }),

/***/ "./modules/catalog/catalogs/dialogs/EmbedDialog/index.js":
/*!***************************************************************!*\
  !*** ./modules/catalog/catalogs/dialogs/EmbedDialog/index.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.regexp.exec.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.regexp.exec.js");
/* harmony import */ var core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_regexp_exec_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.string.match.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.match.js");
/* harmony import */ var core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_match_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _mui_material_Button__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/material/Button */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Button/Button.js");
/* harmony import */ var _mui_material_FormControlLabel__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material/FormControlLabel */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/FormControlLabel/FormControlLabel.js");
/* harmony import */ var _mui_material_FormGroup__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/material/FormGroup */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/FormGroup/FormGroup.js");
/* harmony import */ var _mui_material_FormLabel__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material/FormLabel */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/FormLabel/FormLabel.js");
/* harmony import */ var _mui_material_Radio__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/material/Radio */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Radio/Radio.js");
/* harmony import */ var _mui_material_RadioGroup__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/material/RadioGroup */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/RadioGroup/RadioGroup.js");
/* harmony import */ var _mui_material_Switch__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @mui/material/Switch */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Switch/Switch.js");
/* harmony import */ var _mui_material_TextField__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @mui/material/TextField */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/TextField/TextField.js");
/* harmony import */ var catalog_nls_escaEmbed_nls__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! catalog/nls/escaEmbed.nls */ "./modules/catalog/nls/escaEmbed.nls");
/* harmony import */ var catalog_nls_escaEmbed_nls__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaEmbed_nls__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var catalog_catalogs_dialogs_EmbedPreviewDialog__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! catalog/catalogs/dialogs/EmbedPreviewDialog */ "./modules/catalog/catalogs/dialogs/EmbedPreviewDialog/index.js");
/* harmony import */ var commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/components/common/dialogs/ListActionDialog */ "./modules/commons/components/common/dialogs/ListActionDialog/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var config__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! config */ "./app/registry/config/config.js");
/* harmony import */ var _index_scss__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./index.scss */ "./modules/catalog/catalogs/dialogs/EmbedDialog/index.scss");





















const EMBED_URL = 'https://static.cdn.entryscape.com/embed/catalog/latest/embed.js';
// TODO @valentino get the static URL from config

const FONTAWESOME_PATH = 'libs/fontawesome/css/font-awesome.min.css';

/**
 * extract protocol + hostname from url
 * @param {string} url
 * @returns {string}
 */
const getBaseUrl = url => {
  var _url$match;
  return (_url$match = url.match(/(^https?:\/\/[^/?#]+)(?:[/?#]|$)/i)) === null || _url$match === void 0 ? void 0 : _url$match[1];
};

/**
 *
 * @returns {string}
 */
const getFontawesomeUrl = () => {
  const staticUrl = config__WEBPACK_IMPORTED_MODULE_19__["default"].get('entryscape.static.url');
  return `${staticUrl}${FONTAWESOME_PATH}`;
};
const EmbedDialog = _ref => {
  let {
    entry,
    closeDialog
  } = _ref;
  const [isTargetBlank, setTargetBlank] = (0,react__WEBPACK_IMPORTED_MODULE_18__.useState)(true);
  const [openPreview, setOpenPreview] = (0,react__WEBPACK_IMPORTED_MODULE_18__.useState)(false);
  const [theme, setTheme] = (0,react__WEBPACK_IMPORTED_MODULE_18__.useState)('FA');
  const entryId = entry.getId();
  const ctxId = entry.getContext().getId();
  const repobase = getBaseUrl(config__WEBPACK_IMPORTED_MODULE_19__["default"].get('entrystore.repository'));

  // TODO unecessary! just set it to either and offer a copy to clipboard
  const handleTargetChange = event => {
    setTargetBlank(event.target.checked);
  };
  const handleThemeChange = event => {
    setTheme(event.target.value);
  };
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_16__.useTranslation)((catalog_nls_escaEmbed_nls__WEBPACK_IMPORTED_MODULE_13___default()));
  const themeStyles = [{
    value: 'FA',
    label: t('faLabel')
  }, {
    value: 'IMG',
    label: t('imgLabel')
  }];
  const actions = /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_Button__WEBPACK_IMPORTED_MODULE_5__["default"], {
    autoFocus: true,
    onClick: () => setOpenPreview(true)
  }, t('previewButton'));
  const scriptAttributes = [`src="${EMBED_URL}"`, `data-entry-id="${entryId}"`, `data-context-id="${ctxId}"`, `data-theme-style="${theme}"`, `data-repository="${repobase}"`, `data-target="${isTargetBlank ? '_blank' : '_self'}"`, 'data-ignore-auth="true"', 'data-ignore-fa-css="true"'].join(' ');
  const embedScript = `<script ${scriptAttributes}></script>`;
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement((react__WEBPACK_IMPORTED_MODULE_18___default().Fragment), null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(commons_components_common_dialogs_ListActionDialog__WEBPACK_IMPORTED_MODULE_15__["default"], {
    closeDialog: closeDialog,
    title: `${t('embedHeader')} ${(0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_17__.getLabel)(entry)}`,
    id: "edit-embed",
    actions: actions
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_FormGroup__WEBPACK_IMPORTED_MODULE_7__["default"], {
    row: true,
    key: "embed-themeFormats",
    className: "escaEmbedDialog__themeFormats"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_FormLabel__WEBPACK_IMPORTED_MODULE_8__["default"], {
    component: "legend",
    className: "escaEmbedDialog__formatLabel"
  }, t('themeFormats')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_RadioGroup__WEBPACK_IMPORTED_MODULE_10__["default"], {
    "aria-label": t('themeStyle'),
    name: "themeStyle",
    value: theme,
    onChange: handleThemeChange,
    className: "escaEmbedDialog__radioGroup"
  }, themeStyles.map((_ref2, index) => {
    let {
      value,
      label
    } = _ref2;
    return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_FormControlLabel__WEBPACK_IMPORTED_MODULE_6__["default"], {
      key: value,
      value: value,
      control: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_Radio__WEBPACK_IMPORTED_MODULE_9__["default"], null),
      label: label,
      autoFocus: index === 0
    });
  }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_FormGroup__WEBPACK_IMPORTED_MODULE_7__["default"], {
    row: true,
    key: "embed-openToTarget"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_FormControlLabel__WEBPACK_IMPORTED_MODULE_6__["default"], {
    classes: {
      root: 'escaEmbedDialog__switch'
    },
    control: /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_Switch__WEBPACK_IMPORTED_MODULE_11__["default"], {
      checked: isTargetBlank,
      onChange: handleTargetChange,
      name: "checked",
      color: "primary"
    }),
    label: t('chkNewTab'),
    labelPlacement: "start"
  })), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_FormGroup__WEBPACK_IMPORTED_MODULE_7__["default"], {
    row: true,
    key: "embed-snippetCode"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_FormLabel__WEBPACK_IMPORTED_MODULE_8__["default"], {
    component: "legend",
    className: "escaEmbedDialog__snippetLabel"
  }, t('snippet')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(_mui_material_TextField__WEBPACK_IMPORTED_MODULE_12__["default"], {
    id: "filled-multiline-static",
    multiline: true,
    rows: 10,
    disabled: true,
    value: embedScript
  }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_18___default().createElement(catalog_catalogs_dialogs_EmbedPreviewDialog__WEBPACK_IMPORTED_MODULE_14__["default"], {
    open: openPreview,
    onClose: () => setOpenPreview(false),
    embedScript: embedScript,
    fontawesomeUrl: theme === 'FA' ? getFontawesomeUrl() : null
  }));
};
EmbedDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_4___default().shape({
    getId: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func),
    getContext: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)
  }),
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_4___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EmbedDialog);

/***/ }),

/***/ "./modules/catalog/catalogs/dialogs/EmbedDialog/index.scss":
/*!*****************************************************************!*\
  !*** ./modules/catalog/catalogs/dialogs/EmbedDialog/index.scss ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_index_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../../node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!../../../../../node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./index.scss */ "./node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!./node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./modules/catalog/catalogs/dialogs/EmbedDialog/index.scss");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_index_scss__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_index_scss__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_index_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_index_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./modules/catalog/catalogs/dialogs/EmbedPreviewDialog/index.js":
/*!**********************************************************************!*\
  !*** ./modules/catalog/catalogs/dialogs/EmbedPreviewDialog/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Dialog/Dialog.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/DialogTitle/DialogTitle.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Divider/Divider.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/DialogContent/DialogContent.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Grid/Grid.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/DialogActions/DialogActions.js");
/* harmony import */ var _mui_material__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @mui/material */ "./node_modules/.pnpm/@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1.13_react@18.3.1__@emotion+_7163db19e3cbdc52fa5c040e15588010/node_modules/@mui/material/esm/Button/Button.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var catalog_nls_escaEmbedPreview_nls__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! catalog/nls/escaEmbedPreview.nls */ "./modules/catalog/nls/escaEmbedPreview.nls");
/* harmony import */ var catalog_nls_escaEmbedPreview_nls__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaEmbedPreview_nls__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var commons_util_sleep__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/util/sleep */ "./modules/commons/util/sleep.js");
/* harmony import */ var _index_scss__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./index.scss */ "./modules/catalog/catalogs/dialogs/EmbedPreviewDialog/index.scss");











const EmbedPreviewDialog = _ref => {
  let {
    open,
    onClose,
    embedScript,
    fontawesomeUrl
  } = _ref;
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_12__.useTranslation)([(catalog_nls_escaEmbedPreview_nls__WEBPACK_IMPORTED_MODULE_13___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_14___default())]);
  const iframeEl = (0,react__WEBPACK_IMPORTED_MODULE_4__.useRef)(null);
  const [height, setHeight] = (0,react__WEBPACK_IMPORTED_MODULE_4__.useState)('auto');
  const fontawesomeLink = fontawesomeUrl ? `<link rel="stylesheet" href=${fontawesomeUrl}>` : '';
  const updateIframeHeight = async () => {
    var _iframeEl$current;
    await (0,commons_util_sleep__WEBPACK_IMPORTED_MODULE_15__["default"])(300);
    const body = (_iframeEl$current = iframeEl.current) === null || _iframeEl$current === void 0 || (_iframeEl$current = _iframeEl$current.contentWindow) === null || _iframeEl$current === void 0 || (_iframeEl$current = _iframeEl$current.document) === null || _iframeEl$current === void 0 ? void 0 : _iframeEl$current.body;
    if (!body) return;
    if (body.querySelector('.dataset')) {
      setHeight(`${body.scrollHeight}px`);
      return;
    }
    updateIframeHeight();
  };
  return /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_5__["default"], {
    fullWidth: true,
    maxWidth: "lg",
    "aria-labelledby": "embed-preview-dialog",
    open: open,
    onClose: onClose
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_6__["default"], {
    id: "embed-preview-dialog"
  }, t('embedPreviewHeader')), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], null), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_8__["default"], null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_9__["default"], {
    container: true,
    justifyContent: "center",
    alignItems: "center"
  }, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement("iframe", {
    ref: iframeEl,
    title: t('embedPreviewHeader'),
    className: "embedPreviewDialog__embedCode",
    onLoad: () => updateIframeHeight(),
    scrolling: "auto",
    style: {
      height,
      minHeight: '400px'
    },
    srcDoc: `
                <!DOCTYPE html>
                <html>
                  <head><meta charset="utf-8">${fontawesomeLink}</head>
                  <body>${embedScript}</body>
                </html>`
  }))), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_7__["default"], null), /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_10__["default"], null, /*#__PURE__*/react__WEBPACK_IMPORTED_MODULE_4___default().createElement(_mui_material__WEBPACK_IMPORTED_MODULE_11__["default"], {
    autoFocus: true,
    variant: "text",
    onClick: onClose
  }, t('close'))));
};
EmbedPreviewDialog.propTypes = {
  open: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().bool),
  onClose: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func),
  embedScript: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string),
  fontawesomeUrl: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().string)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (EmbedPreviewDialog);

/***/ }),

/***/ "./modules/catalog/catalogs/dialogs/EmbedPreviewDialog/index.scss":
/*!************************************************************************!*\
  !*** ./modules/catalog/catalogs/dialogs/EmbedPreviewDialog/index.scss ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/injectStylesIntoStyleTag.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleDomAPI.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertBySelector.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/setAttributesWithoutAttributes.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/insertStyleElement.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! !../../../../../node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js */ "./node_modules/.pnpm/style-loader@3.3.4_webpack@5.101.3/node_modules/style-loader/dist/runtime/styleTagTransform.js");
/* harmony import */ var _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_index_scss__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! !!../../../../../node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!../../../../../node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./index.scss */ "./node_modules/.pnpm/css-loader@6.11.0_webpack@5.101.3/node_modules/css-loader/dist/cjs.js!./node_modules/.pnpm/sass-loader@16.0.5_sass@1.93.0_webpack@5.101.3/node_modules/sass-loader/dist/cjs.js??ruleSet[1].rules[3].use[2]!./modules/catalog/catalogs/dialogs/EmbedPreviewDialog/index.scss");

      
      
      
      
      
      
      
      
      

var options = {};

options.styleTagTransform = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleTagTransform_js__WEBPACK_IMPORTED_MODULE_5___default());
options.setAttributes = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_setAttributesWithoutAttributes_js__WEBPACK_IMPORTED_MODULE_3___default());

      options.insert = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertBySelector_js__WEBPACK_IMPORTED_MODULE_2___default().bind(null, "head");
    
options.domAPI = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_styleDomAPI_js__WEBPACK_IMPORTED_MODULE_1___default());
options.insertStyleElement = (_node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_insertStyleElement_js__WEBPACK_IMPORTED_MODULE_4___default());

var update = _node_modules_pnpm_style_loader_3_3_4_webpack_5_101_3_node_modules_style_loader_dist_runtime_injectStylesIntoStyleTag_js__WEBPACK_IMPORTED_MODULE_0___default()(_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_index_scss__WEBPACK_IMPORTED_MODULE_6__["default"], options);




       /* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (_node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_index_scss__WEBPACK_IMPORTED_MODULE_6__["default"] && _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_index_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals ? _node_modules_pnpm_css_loader_6_11_0_webpack_5_101_3_node_modules_css_loader_dist_cjs_js_node_modules_pnpm_sass_loader_16_0_5_sass_1_93_0_webpack_5_101_3_node_modules_sass_loader_dist_cjs_js_ruleSet_1_rules_3_use_2_index_scss__WEBPACK_IMPORTED_MODULE_6__["default"].locals : undefined);


/***/ }),

/***/ "./modules/catalog/catalogs/dialogs/RemoveCatalogDialog/RemoveCatalogDialog.js":
/*!*************************************************************************************!*\
  !*** ./modules/catalog/catalogs/dialogs/RemoveCatalogDialog/RemoveCatalogDialog.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_promise_finally_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.promise.finally.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.finally.js");
/* harmony import */ var core_js_modules_es_promise_finally_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_finally_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/hooks/useUser */ "./modules/commons/hooks/useUser.js");
/* harmony import */ var commons_hooks_useGetMainDialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/hooks/useGetMainDialog */ "./modules/commons/hooks/useGetMainDialog.js");
/* harmony import */ var commons_hooks_useAsyncCallback__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useAsyncCallback */ "./modules/commons/hooks/useAsyncCallback.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! catalog/nls/escaCatalog.nls */ "./modules/catalog/nls/escaCatalog.nls");
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var catalog_catalogs_utils_catalog__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! catalog/catalogs/utils/catalog */ "./modules/catalog/catalogs/utils/catalog.js");
/* harmony import */ var commons_util_context__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/util/context */ "./modules/commons/util/context.js");
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_13__);
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");















const RemoveCatalogDialog = _ref => {
  let {
    entry: catalogEntry,
    closeDialog,
    onRemove
  } = _ref;
  const {
    getConfirmationDialog,
    getAcknowledgeDialog
  } = (0,commons_hooks_useGetMainDialog__WEBPACK_IMPORTED_MODULE_6__["default"])();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_8__.useTranslation)((catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9___default()));
  const {
    userEntry
  } = (0,commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_5__.useUserState)();
  const context = catalogEntry.getContext();
  const [apiDistributions] = (0,commons_hooks_useAsyncCallback__WEBPACK_IMPORTED_MODULE_7__["default"])(catalog_catalogs_utils_catalog__WEBPACK_IMPORTED_MODULE_10__.getApiDistributions, context);
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_14__.useSnackbar)();
  (0,react__WEBPACK_IMPORTED_MODULE_4__.useEffect)(() => {
    if (!apiDistributions) {
      return;
    }
    if (apiDistributions.length) {
      getAcknowledgeDialog({
        content: translate('confirmRemoveCatalogWithApiDistributions')
      }).then(() => closeDialog());
      return;
    }
    getConfirmationDialog({
      content: translate('confirmRemoveCatalog')
    }).then(proceed => {
      if (!proceed) {
        return;
      }
      (0,commons_util_context__WEBPACK_IMPORTED_MODULE_11__.deleteContext)(catalogEntry, userEntry).then(() => {
        addSnackbar({
          message: translate('removeSnackbarMessage')
        });
        onRemove();
      });
    }).catch(err => {
      console.error(err);
      addSnackbar({
        message: translate('removeFailSnackbarMessage'),
        type: commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_14__.ERROR
      });
    }).finally(() => {
      closeDialog();
    });
  }, [apiDistributions, catalogEntry, closeDialog, context, onRemove, getAcknowledgeDialog, getConfirmationDialog, translate, userEntry, addSnackbar]);
  return null;
};
RemoveCatalogDialog.propTypes = {
  entry: commons_util_entry__WEBPACK_IMPORTED_MODULE_12__.entryPropType,
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().func),
  onRemove: (prop_types__WEBPACK_IMPORTED_MODULE_13___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RemoveCatalogDialog);

/***/ }),

/***/ "./modules/catalog/catalogs/dialogs/RemoveCatalogDialog/index.js":
/*!***********************************************************************!*\
  !*** ./modules/catalog/catalogs/dialogs/RemoveCatalogDialog/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _RemoveCatalogDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _RemoveCatalogDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RemoveCatalogDialog */ "./modules/catalog/catalogs/dialogs/RemoveCatalogDialog/RemoveCatalogDialog.js");


/***/ }),

/***/ "./modules/catalog/catalogs/useCatalogRestriction.js":
/*!***********************************************************!*\
  !*** ./modules/catalog/catalogs/useCatalogRestriction.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var config__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! config */ "./app/registry/config/config.js");
/* harmony import */ var commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/hooks/useUser */ "./modules/commons/hooks/useUser.js");
/* harmony import */ var commons_util_user__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! commons/util/user */ "./modules/commons/util/user.js");



const useCatalogRestriction = numberOfCatalogs => {
  const {
    userEntry
  } = (0,commons_hooks_useUser__WEBPACK_IMPORTED_MODULE_1__.useUserState)();
  const isExemptFromRestrictions = (0,commons_util_user__WEBPACK_IMPORTED_MODULE_2__.hasUserPermission)(userEntry, [commons_util_user__WEBPACK_IMPORTED_MODULE_2__.PREMIUM, commons_util_user__WEBPACK_IMPORTED_MODULE_2__.ADMIN_RIGHTS]);
  if (isExemptFromRestrictions) return {
    isRestricted: false
  };
  const catalogLimit = config__WEBPACK_IMPORTED_MODULE_0__["default"].get('catalog.catalogLimit');
  const pathToCatalogLimitContent = config__WEBPACK_IMPORTED_MODULE_0__["default"].get('catalog.catalogLimitDialog');
  const isRestricted = catalogLimit && numberOfCatalogs >= catalogLimit || catalogLimit === 0;
  return {
    isRestricted,
    contentPath: pathToCatalogLimitContent
  };
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (useCatalogRestriction);

/***/ }),

/***/ "./modules/catalog/catalogs/utils/catalog.js":
/*!***************************************************!*\
  !*** ./modules/catalog/catalogs/utils/catalog.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   createCatalogEntry: () => (/* binding */ createCatalogEntry),
/* harmony export */   createPublisher: () => (/* binding */ createPublisher),
/* harmony export */   getApiDistributions: () => (/* binding */ getApiDistributions)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.string.trim.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.string.trim.js");
/* harmony import */ var core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_string_trim_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var esi18n__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! esi18n */ "./node_modules/.pnpm/esi18n@1.8.0/node_modules/esi18n/src/index.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var commons_util_context__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/util/context */ "./modules/commons/util/context.js");
/* harmony import */ var entitytype_lookup__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! entitytype-lookup */ "./node_modules/.pnpm/entitytype-lookup@https+++bitbucket.org+metasolutions+entitytype-lookup+get+e4b4dfb8f83_9b0bd6f7d39b11bfe772b06530743694/node_modules/entitytype-lookup/src/index.js");
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var commons_util_metadata__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/util/metadata */ "./modules/commons/util/metadata.js");








const createPublisher = async (homeContext, publisher) => {
  try {
    const publisherEntry = homeContext.newNamedEntry();
    const publisherMetadata = publisherEntry.getMetadata();
    const publisherResourceRURI = publisherEntry.getResourceURI();
    const language = esi18n__WEBPACK_IMPORTED_MODULE_2__.i18n.getLocale();
    publisherMetadata.add(publisherResourceRURI, 'rdf:type', 'foaf:Agent');
    publisherMetadata.addL(publisherResourceRURI, 'foaf:name', publisher.value.trim(), language);
    return publisherEntry.commit();
  } catch (error) {
    throw Error(`Unable to create publisher: ${error}`);
  }
};

// Make the context a esterms:CatalogContext
const updateHomeContextEntryInfo = async (contextEntry, groupEntry, projectType) => {
  try {
    const homeContextEntryInfo = contextEntry.getEntryInfo();
    const homeContextResourceURI = contextEntry.getResourceURI();
    homeContextEntryInfo.getGraph().add(homeContextResourceURI, 'rdf:type', 'esterms:CatalogContext');

    // If project type is set, add it to entryinfo
    if (projectType) {
      homeContextEntryInfo.getGraph().add(homeContextResourceURI, entitytype_lookup__WEBPACK_IMPORTED_MODULE_5__.RDF_PROPERTY_PROJECTTYPE, projectType);
    }

    // access to homecontext metadata by default.
    const acl = homeContextEntryInfo.getACL(true);
    acl.mread.push(groupEntry.getId());
    homeContextEntryInfo.setACL(acl);
    await homeContextEntryInfo.commit();
  } catch (error) {
    throw Error(`There was some error while trying to set access to the home context metadata ${error}`);
  }
};

/**
 *
 * @param {Object} catalogCreateOptions
 * @returns {Promise}
 */
const createCatalogEntry = async _ref => {
  let {
    contextEntry: prototypeContextEntry,
    catalogEntry: prototypeCatalogEntry,
    context: prototypeContext,
    userEntry,
    userInfo,
    projectType,
    createWithCustomPublisher,
    publisher,
    graph
  } = _ref;
  try {
    prototypeCatalogEntry.setMetadata(graph);

    // Publisher is not reused from other catalog
    if (createWithCustomPublisher) {
      const publisherEntry = await createPublisher(prototypeContext, publisher);
      prototypeCatalogEntry.add('dcterms:publisher', publisherEntry.getResourceURI());
    }
    const {
      contextEntry,
      groupEntry,
      initialEntries
    } = await prototypeContextEntry.createGroupAndContext();
    const homeContextId = groupEntry.getResource(true).getHomeContext();
    const catalogEntry = initialEntries.find(entry => (0,commons_util_metadata__WEBPACK_IMPORTED_MODULE_7__.isType)(entry.getMetadata(), entry.getResourceURI(), commons_util_entry__WEBPACK_IMPORTED_MODULE_6__.RDF_TYPE_CATALOG));
    await (0,commons_util_context__WEBPACK_IMPORTED_MODULE_4__.updateContextTitle)(catalogEntry);
    userEntry.setRefreshNeeded();
    userEntry.refresh();
    await updateHomeContextEntryInfo(contextEntry, groupEntry, projectType);
    if (!userInfo.hasAdminRights) {
      (0,commons_util_context__WEBPACK_IMPORTED_MODULE_4__.setGroupIdForContext)(homeContextId, groupEntry.getId());
    }
  } catch (error) {
    throw Error(`Failed to create catalog: ${error}`);
  }
};

/**
 * Checks whether a context (catalog) has api distributions
 *
 * @param {Context} context
 * @returns {Promise}
 */
const getApiDistributions = context => commons_store__WEBPACK_IMPORTED_MODULE_3__.entrystore.newSolrQuery().context(context).rdfType('dcat:Distribution').uriProperty('dcterms:source', '*').limit(1).list().getEntries();

/***/ }),

/***/ "./modules/catalog/config/config.js":
/*!******************************************!*\
  !*** ./modules/catalog/config/config.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   CATALOGS_LISTVIEW: () => (/* binding */ CATALOGS_LISTVIEW),
/* harmony export */   CATALOG_OVERVIEW_NAME: () => (/* binding */ CATALOG_OVERVIEW_NAME),
/* harmony export */   CONTACTS_LISTVIEW: () => (/* binding */ CONTACTS_LISTVIEW),
/* harmony export */   CONTACT_OVERVIEW_NAME: () => (/* binding */ CONTACT_OVERVIEW_NAME),
/* harmony export */   DATASERVICES_LISTVIEW: () => (/* binding */ DATASERVICES_LISTVIEW),
/* harmony export */   DATASETS_LISTVIEW: () => (/* binding */ DATASETS_LISTVIEW),
/* harmony export */   DATASET_OVERVIEW_NAME: () => (/* binding */ DATASET_OVERVIEW_NAME),
/* harmony export */   DATA_SERVICE_OVERVIEW_NAME: () => (/* binding */ DATA_SERVICE_OVERVIEW_NAME),
/* harmony export */   DOCUMENTS_LISTVIEW: () => (/* binding */ DOCUMENTS_LISTVIEW),
/* harmony export */   DOCUMENT_OVERVIEW_NAME: () => (/* binding */ DOCUMENT_OVERVIEW_NAME),
/* harmony export */   IDEAS_LISTVIEW: () => (/* binding */ IDEAS_LISTVIEW),
/* harmony export */   IDEA_OVERVIEW_NAME: () => (/* binding */ IDEA_OVERVIEW_NAME),
/* harmony export */   PUBLISHERS_LISTVIEW: () => (/* binding */ PUBLISHERS_LISTVIEW),
/* harmony export */   PUBLISHER_OVERVIEW_NAME: () => (/* binding */ PUBLISHER_OVERVIEW_NAME),
/* harmony export */   SHOWCASES_LISTVIEW: () => (/* binding */ SHOWCASES_LISTVIEW),
/* harmony export */   SHOWCASE_OVERVIEW_NAME: () => (/* binding */ SHOWCASE_OVERVIEW_NAME),
/* harmony export */   SUGGESTIONS_LISTVIEW: () => (/* binding */ SUGGESTIONS_LISTVIEW),
/* harmony export */   SUGGESTION_OVERVIEW_NAME: () => (/* binding */ SUGGESTION_OVERVIEW_NAME),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* eslint-disable max-len */
const CATALOGS_LISTVIEW = 'catalog__list';
const SUGGESTIONS_LISTVIEW = 'catalog__suggestions';
const DATASETS_LISTVIEW = 'catalog__datasets';
const DATASERVICES_LISTVIEW = 'catalog__dataservices';
const SHOWCASES_LISTVIEW = 'catalog__showcases';
const IDEAS_LISTVIEW = 'catalog__ideas';
const PUBLISHERS_LISTVIEW = 'catalog__publishers';
const CONTACTS_LISTVIEW = 'catalog__contacts';
const DOCUMENTS_LISTVIEW = 'catalog__documents';
const CATALOG_OVERVIEW_NAME = 'catalog__overview';
const SUGGESTION_OVERVIEW_NAME = 'catalog__suggestions__suggestion';
const DATASET_OVERVIEW_NAME = 'catalog__datasets__dataset';
const DATA_SERVICE_OVERVIEW_NAME = 'catalog__dataservices__dataservice';
const SHOWCASE_OVERVIEW_NAME = 'catalog__showcases__showcase';
const IDEA_OVERVIEW_NAME = 'catalog__ideas__idea';
const PUBLISHER_OVERVIEW_NAME = 'catalog__publishers__publisher';
const CONTACT_OVERVIEW_NAME = 'catalog__contacts__contact';
const DOCUMENT_OVERVIEW_NAME = 'catalog__documents__document';
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  catalog: {
    // Determines whether file scheme URIs are allowed e.g. on the distribution access URL
    allowFileURI: false,
    /**
     * RDForms catalog template id
     *
     * @type {string}
     * @memberof catalog
     */
    catalogTemplateId: undefined,
    /**
     * RDForms dataset template id
     *
     * @type {string}
     * @memberof catalog
     */
    datasetTemplateId: undefined,
    /**
     * RDForms distribution template id
     *
     * @type {string}
     * @memberof catalog
     */
    distributionTemplateId: undefined,
    /**
     * RDForms contact point template id
     *
     * @type {string}
     * @memberof catalog
     */
    contactPointTemplateId: 'dcat:contactPoint',
    /**
     * RDForms document template id
     * @type {string}
     * @memberof catalog
     */
    documentTemplateId: 'esc:Documentish',
    /**
     * RDForms contact template id
     * @type {string}
     * @memberof catalog
     */
    contactTemplateId: 'dcat:contactPoint',
    // @todo perhaps not needed and is a duplicate of contactPointTemplateId. But used in code

    /**
     * RDForms agent template id
     * @type {string}
     * @memberof catalog
     */
    agentTemplateId: 'dcat:foaf:Agent',
    /**
     * RDForms template id for dataservices
     * @type {string}
     * @memberof catalog
     */
    dataServiceTemplateId: 'dcat:DataService',
    /**
     * RDForms result template id
     * @type {string}
     * @memberof catalog
     */
    datasetResultTemplateId: 'esc:Results',
    /**
     * RDForms idea template id
     * @type {string}
     * @memberof catalog
     */
    datasetIdeaTemplateId: 'esc:Ideas',
    /**
     * RDForms suggestion template id
     * @type {string}
     * @memberof catalog
     */
    suggestionTemplateId: 'esc:Suggestion',
    /**
     * RDForms format template id
     * @type {string}
     * @memberof catalog
     */
    formatTemplateId: 'dcat:format-group_di',
    /**
     * @type {string}
     * @memberof catalog
     */
    formatProperty: 'dcterms:format',
    // default rdf types

    /**
     * Default RDF agent type
     * @type {string}
     * @memberof catalog
     */
    defaultAgentType: 'foaf:Agent',
    /**
     * Specifies who is allowed to create catalogs. Usually set to a group's entry ID.
     * @type {string}
     * @memberof catalog
     */
    catalogCreationAllowedFor: '_users',
    /**
     * Specifies who may (un)publish datasets
     * @type {string}
     * @memberof catalog
     */
    publishDatasetAllowedFor: '_users',
    /**
     * @type {string}
     * @memberof catalog
     */
    previewURL: '#view=dataset&resource=${url}',
    // eslint-disable-line no-template-curly-in-string

    // feature toggles

    /**
     * Include/exclude download action in catalog list row
     * @type {boolean}
     * @memberof catalog
     */
    includeExportOption: true,
    /**
     * Include/exclude embed action in catalog list row
     * @type {boolean}
     * @memberof catalog
     */
    includeEmbeddOption: true,
    /**
     * Include/exclude publisher view in the secondary navigation
     * @type {boolean}
     * @memberof catalog
     */
    includePublishers: true,
    /**
     * Include/exclude contact view in the secondary navigation
     * @type {boolean}
     * @memberof catalog
     */
    includeContacts: true,
    /**
     * Include/exclude document view in the secondary navigation
     * @type {boolean}
     * @memberof catalog
     */
    includeDocuments: true,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    includeShowcases: true,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    includeIdeas: true,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    includeStatistics: true,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    includeTableView: true,
    sectionFormsAsColsTableView: false,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    includePreparations: true,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    includeVisualizations: false,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    includeMapServiceVisualizations: false,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    includeCreateByService: false,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    includeOverview: true,
    /**
     * Determines whether dataset series are available
     *
     * @type {boolean}
     */
    includeDatasetSeries: true,
    /**
     * Determines whether or which filters are visible in catalog. Using a boolean shows/hides
     * all filters, while an array containing the names of the filters to exclude can
     * also be provided.
     *
     * @type {boolean|string[]}
     */
    excludeFilters: false,
    /**
     * @type {string}
     * @memberof catalog
     */
    startView: 'catalog__overview',
    /**
     * @type {boolean}
     * @memberof catalog
     */
    distributionTemplateCreate: false,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    excludeEmptyCatalogsInSearch: true,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    allowInternalDatasetPublish: false,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    includeInternalPublish: false,
    /**
     * @type {boolean}
     * @memberof catalog
     */
    includeListSizeByDefault: false,
    /**
     * Toggles ability to create a catalog without a publisher
     * @type {boolean}
     * @memberof catalog
     */
    createWithoutPublisher: false,
    /**
     * empty string works as no limit
     * @type {string|number}
     * @memberof catalog
     */
    catalogLimit: '',
    /**
     * A pointer to a text file in the configuration directory.
     * @type {string}
     * @memberof catalog
     */
    catalogLimitDialog: '',
    /**
     * empty string works as no limit
     * @type {string|number}
     * @memberof catalog
     */
    datasetLimit: '',
    /**
     * A pointer to a text file in the configuration directory.
     * @type {string}
     * @memberof catalog
     */
    datasetLimitDialog: '',
    /**
     * A pointer to a text file in the configuration directory.
     * @type {string}
     * @memberof catalog
     */
    disallowCatalogPublishingDialog: '',
    /**
     * A pointer to a text file in the configuration directory.
     * @type {string}
     * @memberof catalog
     */
    disallowCatalogCollaborationDialog: '',
    /**
     * A pointer to a text file in the configuration directory.
     * @type {string}
     * @memberof catalog
     */
    disallowFileuploadDistributionDialog: '',
    /**
     * @type {boolean}
     * @memberof catalog
     */
    excludeFileuploadDistribution: false,
    /**
     * @type {string}
     * @memberof catalog
     */
    previewURLNewWindow: '',
    /**
     * @type {number}
     * @memberof catalog
     */
    maxFileSizeForAPI: 25000000,
    /**
     * Store hosting dataset templates that can be used to create datasets or suggestions.
     * Also used as flag for dataset template functionality.
     * @type {string}
     */
    datasetTemplateEndpoint: '',
    /**
     * Default selected catalog on the dataset template filters' context dropdown.
     * Should be a catalog ID or empty. If specified, the dropdown autohides currently.
     * @type {string}
     */
    datasetTemplateDefaultCatalog: '',
    /**
     * Default RDF type used to query dataset templates.
     */
    datasetTemplateRDFType: 'esterms:DatasetTemplate',
    /**
     * Default RDF type used to query catalog templates.
     */
    catalogTemplateRDFType: 'esterms:CatalogTemplate',
    // URL pointing to a json file with the config for help drawer
    help: 'https://docs.entryscape.com/help/3.17/catalog.json',
    /**
     * The checklist consists of a task name, title (short label), short description (label) and detailed description. These are all provided in different languages.
     * @typedef {{en: string, sv: string, da: string, de: string}} TitleTranslationObj
     * @typedef {{sv: string, da: string, en: string, de: string}} TranslationObj
     * @typedef {{name: string, shortLabel: TitleTranslationObj, label: TranslationObj, description: TranslationObj, mandatory: boolean}} checklistObj
     * @type checklistObj
     * @memberof catalog
     */
    checklist: [{
      name: 'noPrivacyIssues',
      shortLabel: {
        en: 'Privacy',
        sv: 'Sekretess',
        da: 'Fortrolig',
        de: 'Datenschutz'
      },
      label: {
        sv: 'Inga sekretessbelagda eller personuppgifter ingår i datamängden',
        da: 'Datasættet indeholder ikke fortrolige eller personlige information',
        en: 'The dataset does not contain confidential or personal information',
        de: 'Der Datensatz beinhaltet keine vertraulichen oder persönlichen Informationen'
      },
      description: {
        sv: 'Om genomgång av datamängd visat på hinder iform av sekretessbelagd information eller personuppgifter så redovisas detta som kommentarer på datamängden. Eventuella alternativ för publicering av delar av datamängden ska också redovisas.',
        da: 'Hvis gennemgangen af datasættet frembringer forhindringer såsom fortrolighed eller personlige informationinformation skal dette dokumenteres som kommentarer på datasættet. Et eventuelt alternativ er publicering af dele af datasættet skal også beskrives i kommentarerne.',
        en: 'If the review of the dataset revealed obstacles such as confidential or personal information this is documented as comments on the dataset. Possible alternatives such as partial publication of the dataset should also be presented as comments.',
        de: 'Falls beim Durchsehen des Datensatzes Hürden wie vertrauliche oder persönliche Informationen offenlegt werden, werden diese als Kommentar am Datensatz dokumentiert. Mögliche Alternativen wie eine teilweise Veröffentlichung des Datensatzes können ebenfalls als Kommentare dargestellt werden.'
      },
      mandatory: true
    }, {
      name: 'clearLicense',
      shortLabel: {
        en: 'License',
        sv: 'Upphovsrätt',
        da: 'Uphavsrett',
        de: 'Lizenz'
      },
      label: {
        sv: 'Upphovsrätten är klargjord',
        da: 'Ophavsretten er sikret',
        en: 'Copyright is cleared',
        de: 'Urheberrecht ist geklärt'
      },
      description: {
        sv: 'Det upphovsrättskydd som gäller för datamängden har klargjorts. Om erkännande krävs i samband med vidarutnyttjande är det också viktigt att det tydliggörs, redovisa i så fall ägare av upphovsrätten och annan relevant information i en kommentar på datamängden.',
        da: 'Den ophavsret og ejerrettigheder på datasættet som er sikret. Hvis anerkendelse af ophavsret eller rettighedsejer er nødvendig i forbindelse med genbrug eller videreanvendelse, er det vigtigt at navnet på rettighedsindehaveratt samt andre relevante informationer er beskrevet i kommentarerne.',
        en: 'The copyright and ownership rights of the dataset have been cleared. If recognition is required in connection with re-use, it is important that the name of the copyright holder and other relevant information are provided as comments.',
        de: 'Das Urheberrecht und die Eigentümerrechte des Datensatzes wurden geklärt. Falls Wiedererkennung benötigt wird in Verbindung mit der Wiederverwendung, ist es wichtig, dass der Name des Urheberrechtsinhabers und andere relevante Informationen als Kommentare bereitgestellt werden.'
      },
      mandatory: true
    }, {
      name: 'clearOwnership',
      shortLabel: {
        en: 'Ownership',
        sv: 'Ägarskap',
        da: 'Ejendom',
        de: 'Eigentum'
      },
      label: {
        sv: 'Dataägare i organisationen är identifierad',
        da: 'Dataejere indenfor organisationen er identificeret',
        en: 'Data owner within the organization is identified',
        de: 'Eigentümer der Daten innerhalb der Organisation ist identifiziert'
      },
      description: {
        sv: 'Ansvar för datamängden i organisationen är känd. Kontaktpunkt, i form av en person eller funktionsadress lämnas som kommentar på datamängden.',
        da: 'Ansvar for datasættet i organisationen er kendt. Kontaktpunkt, i form af en person eller funktionspostkasse beskrives i kommentarerne på datasættet.',
        en: 'The responsible for the dataset is known within the organization. The contact point, in the form of an email address, should be provided as comment on the dataset.',
        de: 'Die Verantwortlichen für den Datensatz sind innerhalb der Organisation bekannt. Der Kontakt in Form einer E-Mail-Adresse sollte als Kommentar im Datensatz bereitgestellt werden.'
      },
      mandatory: true
    }, {
      name: 'digitallyAccessible',
      shortLabel: {
        en: 'Digital',
        sv: 'Digitalt',
        da: 'Digitald',
        de: 'Digital'
      },
      label: {
        sv: 'Datamängden är tillgänglig digitalt',
        da: 'Datasættet er tilgængeligt digitalt',
        en: 'The dataset can be digitally accessed',
        de: 'Auf den Datensatz kann digital zugegriffen werden'
      },
      description: {
        sv: 'Datamängden finns tillgänglig i kända format. Hur man kommer åt datamängden i respektive format är också klargjort.',
        da: 'Datasættet findes tilgængeligt i kendte formatter. Det er gjort tydeligt hvordan man får adgang til datasættets respektive formatter.',
        en: "The dataset is available in known formats. It is clear how the dataset's respective formats can be accessed.",
        de: 'Der Datensatz ist in verschiedenen Formaten verfügbar. Es ist klar wie auf die entsprechenden Formate zugegriffen werden kann.'
      }
    }, {
      name: 'addedValue',
      shortLabel: {
        en: 'Added value',
        sv: 'Mervärde',
        da: 'Merværdi',
        de: 'Mehrwert'
      },
      label: {
        sv: 'Publicering av datamängden innebär ett tydligt mervärde',
        da: 'Publicering af datasættet har en tydelig merværdi',
        en: 'The publication of the dataset implies a clear added value',
        de: 'Die Veröffentlichung des Datensatzes stellt einen Mehrwert dar'
      },
      description: {
        sv: 'Datamängden medför ökad transparens, innovation eller effektivisering. Effektivisering omfattar förbättringar inom såväl den egna organisationen som externt.',
        da: 'Datasættet medfører øget transparens, innovation eller effektivisering. Effektivisering omfatter forbedringer både indenfor egen organisation såvel som udenfor.',
        en: 'The dataset contributes to increased transparency, innovation or efficiency. Efficiency includes improvements both within the own organization as well as externally.',
        de: 'Der Datensatz trägt zu steigender Transparenz, Innovation oder Effizienz bei. Effizienz beinhaltet Verbesserungen innerhalb der Organisation als auch externer Art.'
      }
    }, {
      name: 'demand',
      shortLabel: {
        en: 'Demand',
        sv: 'Efterfråga',
        da: 'Efterspørgsel',
        de: 'Nachfrage'
      },
      label: {
        sv: 'Datamängden är efterfrågad',
        da: 'Datasættet er efterspurgt',
        en: 'The dataset is sought after',
        de: 'Nach dem Datensatz wird gesucht'
      },
      description: {
        sv: 'Datamängden är efterfrågad antingen inom den egna organisationen eller externt. Detta innebär att minst en målgrupp till datamängden är identifierad.',
        da: 'Datasættet er efterspurgt indenfor egen organisation eller udenfor. Dette indebærer at der er identificeret mindst en målgruppe til datasættet.',
        en: 'The dataset is sought after within the own organization or externally. This means that at least one target group for the dataset has been identified.',
        de: 'Nach dem Datensatz wird innerhalb der Organisation oder von externer Seite aus gesucht. Das bedeutet das mindestens eine Zielgruppe für den Datensatz identifiziert wurde.'
      }
    }, {
      name: 'formatDemand',
      shortLabel: {
        en: 'Formats',
        sv: 'Format',
        da: 'Formatter',
        de: 'Formate'
      },
      label: {
        sv: 'Efterfrågade format eller protokoll stöds',
        da: 'Efterspurgte formatter eller protokoller er understøttet',
        en: 'Requested formats or protocols are supported',
        de: 'Angefragte Formate oder Protokolle werden unterstützt'
      },
      description: {
        sv: 'Datamängden är tillgänglig i de format och protokoll som efterfrågas. Om nya format efterfrågats görs en kommentar om vilka på datamängden, t.ex. om API önskas för målgruppen.',
        da: 'Datasættet er tilgængeligt i de formatter og protokoller som er efterspurgt. Det skal registreres som kommentarer hvis yderligere formatter eller protokoller er efterspurgt, f.eks. hvis et API er efterspurgt af en specifik målgruppe.',
        en: 'The dataset is available in the formats and protocols that have been requested. It should be noted as a comment if additional formats or protocols are requested, e.g., if an API is requested by a target group.',
        de: 'Der Datensatz ist verfügbar in den Formaten und Protokollen die angefragt wurden. Es sollte eine Notiz als Kommentar gemacht werden, falls zusätzliche Formate oder Protokolle angefragt werden, zum Beispiel falls eine API durch eine Zielgruppe angefragt wurde.'
      }
    }, {
      name: 'addedCost',
      shortLabel: {
        en: 'Cost',
        sv: 'Kostnader',
        da: 'Omkostninger',
        de: 'Kosten'
      },
      label: {
        sv: 'Resurser, kostnader och effektiviseringar är kända',
        da: 'Resurser, omkostninger og effektiviseringar er kendte',
        en: 'Resources, costs and increased efficiency are known',
        de: 'Ressourcen, Kosten und eine ansteigende Effizienz sind bekannt'
      },
      description: {
        sv: 'Resurser för publicering och eventuella engångskostnader är kända och sammanvägda med eventuell intern effektivisering. Nya kostnader för framtagning eller underhåll av datamängd lämnas som kommentar.',
        da: 'Nødvendigte resurser or publicering og eventuelle engangsomkostninger er kendte vurderet i forhold til mulige forbedringer af intern effektivitet. Yderligere omkostninger for at bevare eller vedligeholde datasættet er registreret i en kommentar.',
        en: 'Resources for publication and any one-time costs are known and weighted with possible improvements of internal efficiency. Additional costs for obtaining or maintaining the dataset are provided as comment.',
        de: 'Ressourcen zum Veröffentlichen und alle einmaligen Kosten sind bekannt und gewichtet nach möglichen Verbesserungen der internen Effizienz. Zusätzliche Kosten zum Erhalt oder Pflege des Datensatzes werden als Kommentar zur Verfügung gestellt.'
      }
    }, {
      name: 'maintenancePlan',
      shortLabel: {
        en: 'Maintenance',
        sv: 'Underhåll',
        da: 'Vedligehold',
        de: 'Pflege'
      },
      label: {
        sv: 'Plan för underhåll av datamängden finns',
        da: 'Plan for vedligehold af datasættet findes',
        en: 'A plan for maintenance of the dataset is available',
        de: 'Ein Konzept für die Pflege des Datensatzes ist verfügbar'
      },
      description: {
        sv: 'Plan och metod för underhåll av datamängden i den frekvens som krävs är undersökt och klargjort.',
        da: 'Plan og metode for vedligeholdelse af datasættet i den frekvens som er påkrævet er undersøgt og tydeliggjort.',
        en: 'Plan and method for maintenance of the dataset in the required frequency have been investigated and clarified.',
        de: 'Konzept und Methode für die Pflege des Datensatzes in der benötigten Frequenz sind untersucht und geklärt wurden.'
      }
    }]
  },
  itemstore: {
    /**
     * Names of available choosers
     *
     * @type {string[]}
     * @memberof itemstore
     */
    choosers: ['EntryChooser', 'GeonamesChooser', 'GeoChooser'],
    /**
     * Map projections in order of importance
     *
     * @type {object[]}
     * @memberof itemstore
     */
    projections: [{
      code: 'EPSG:3006',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3007',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3008',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=13.5 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3009',
      boundingBox: [-16.1, 32.88, 40.18, 84.17],
      definition: '+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3010',
      boundingBox: [-16.1, 32.88, 40.18, 84.17],
      definition: '+proj=tmerc +lat_0=0 +lon_0=16.5 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3011',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=18 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3012',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=14.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3013',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=15.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3014',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=17.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3015',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=18.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3016',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=20.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3017',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=21.75 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3018',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=23.25 +k=1 +x_0=150000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3019',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=11.30827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3020',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=13.55827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3021',
      boundingBox: [10.03, 54.96, 24.17, 69.07],
      definition: '+proj=tmerc +lat_0=0 +lon_0=15.80827777777778 +k=1 +x_0=1500000 +y_0=0 +ellps=bessel +towgs84=414.1,41.3,603.1,-0.855,2.141,-7.023,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:3034',
      boundingBox: [-16.1, 32.88, 40.18, 84.17],
      definition: '+proj=lcc +lat_1=35 +lat_2=65 +lat_0=52 +lon_0=10 +x_0=4000000 +y_0=2800000 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:31467',
      boundingBox: [5.87, 47.27, 13.84, 55.09],
      definition: '+proj=tmerc +lat_0=0 +lon_0=9 +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:31468',
      boundingBox: [5.87, 47.27, 13.84, 55.09],
      definition: '+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +axis=neu +no_defs'
    }, {
      code: 'EPSG:25833',
      boundingBox: [-16.1, 32.88, 40.18, 84.17],
      definition: '+proj=utm +zone=33 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +axis=enu +no_defs'
    }]
  },
  /**
   * Specifies the different types of entities,
   * sets their name,
   * which module they belong to,
   * the CSS class of their icon,
   * and various options like adding files or link and the possibility for inline creation.
   *
   * @typedef {{en: string}} LabelObj
   * @typedef {{name: string, label: LabelObj, rdfType: string[], module: string, template: string,
   *            includeInternal: boolean, includeFile: boolean, includeLink: boolean, inlineCreation: boolean,
   *            faClass: string}} EntityObj
   * @type {object} EntityObj
   */
  entitytypes: [{
    name: 'publisher',
    label: {
      en: 'Publisher',
      sv: 'Utgivare',
      de: 'Herausgeber'
    },
    rdfType: ['http://xmlns.com/foaf/0.1/Agent', 'http://xmlns.com/foaf/0.1/Person', 'http://xmlns.com/foaf/0.1/Organization'],
    mainModule: 'catalog',
    module: 'catalog',
    template: 'dcat:foaf:Agent',
    includeInternal: true,
    // TODO will this exist after migration, if yes in what form?
    includeFile: false,
    includeLink: false,
    inlineCreation: true,
    faClass: 'users',
    listview: PUBLISHERS_LISTVIEW,
    overview: PUBLISHER_OVERVIEW_NAME
  }, {
    name: 'contactPoint',
    label: {
      en: 'Contact point',
      sv: 'Kontakt',
      de: 'Kontakt'
    },
    rdfType: ['http://www.w3.org/2006/vcard/ns#Individual', 'http://www.w3.org/2006/vcard/ns#Organization', 'http://www.w3.org/2006/vcard/ns#Kind'],
    mainModule: 'catalog',
    module: 'catalog',
    template: 'dcat:contactPoint',
    includeInternal: true,
    includeFile: false,
    includeLink: false,
    inlineCreation: true,
    faClass: 'phone',
    listview: CONTACTS_LISTVIEW,
    overview: CONTACT_OVERVIEW_NAME
  }, {
    name: 'dataset',
    label: {
      en: 'Dataset',
      sv: 'Datamängd',
      de: 'Datensatz'
    },
    main: true,
    rdfType: ['http://www.w3.org/ns/dcat#Dataset'],
    mainModule: 'catalog',
    module: 'catalog',
    template: 'dcat:Dataset',
    includeInternal: true,
    includeFile: false,
    includeLink: false,
    inlineCreation: false,
    faClass: 'cubes',
    listview: DATASETS_LISTVIEW,
    overview: DATASET_OVERVIEW_NAME,
    draftsEnabled: true
  }, {
    name: 'datasetSeries',
    label: {
      en: 'Dataset series',
      sv: 'Datamängdsserie',
      de: 'Datensatzserie'
    },
    rdfType: ['http://www.w3.org/ns/dcat#DatasetSeries'],
    mainModule: 'catalog',
    module: 'catalog',
    template: 'dcat:DatasetSeries',
    includeInternal: true,
    includeFile: false,
    includeLink: false,
    inlineCreation: false,
    listview: DATASETS_LISTVIEW,
    overview: DATASET_OVERVIEW_NAME,
    draftsEnabled: true,
    hideFromOverview: true
  }, {
    name: 'dataService',
    label: {
      en: 'Data service',
      sv: 'Datatjänst',
      de: 'Datendienst'
    },
    rdfType: ['http://www.w3.org/ns/dcat#DataService'],
    mainModule: 'catalog',
    module: 'catalog',
    template: 'dcat:DataService',
    includeInternal: true,
    includeFile: false,
    includeLink: false,
    inlineCreation: false,
    faClass: 'exchange-alt',
    listview: DATASERVICES_LISTVIEW,
    overview: DATA_SERVICE_OVERVIEW_NAME,
    draftsEnabled: true
  }, {
    name: 'distribution',
    label: {
      en: 'Distribution',
      sv: 'Distribution',
      de: 'Distribution'
    },
    rdfType: ['http://www.w3.org/ns/dcat#Distribution'],
    mainModule: 'catalog',
    module: 'catalog',
    template: 'dcat:Distribution',
    useWith: 'dataset',
    useWithProperty: 'http://www.w3.org/ns/dcat#distribution',
    includeInternal: true,
    includeFile: false,
    includeLink: false,
    inlineCreation: false,
    overview: DATASET_OVERVIEW_NAME
  }, {
    name: 'catalog',
    label: {
      en: 'Catalog',
      sv: 'Katalog',
      de: 'Katalog'
    },
    rdfType: ['http://www.w3.org/ns/dcat#Catalog'],
    mainModule: 'catalog',
    module: 'catalog',
    template: 'dcat:Catalog',
    includeInternal: true,
    includeFile: false,
    includeLink: false,
    inlineCreation: false,
    overview: CATALOG_OVERVIEW_NAME
  }, {
    name: 'datasetResult',
    label: {
      en: 'Showcase',
      sv: 'Showcase',
      de: 'Showcase'
    },
    rdfType: ['http://entryscape.com/terms/Result'],
    mainModule: 'catalog',
    module: 'catalog',
    template: 'esc:Results',
    includeInternal: true,
    includeFile: false,
    includeLink: false,
    inlineCreation: false,
    faClass: 'gem',
    listview: SHOWCASES_LISTVIEW,
    overview: SHOWCASE_OVERVIEW_NAME
  }, {
    name: 'datasetIdea',
    label: {
      en: 'Idea',
      sv: 'Idé',
      de: 'Idee'
    },
    rdfType: ['http://entryscape.com/terms/Idea'],
    mainModule: 'catalog',
    module: 'catalog',
    template: 'esc:Ideas',
    includeInternal: true,
    includeFile: false,
    includeLink: false,
    inlineCreation: false,
    faClass: 'lightbulb',
    listview: IDEAS_LISTVIEW,
    overview: IDEA_OVERVIEW_NAME
  }, {
    name: 'catalogSuggestion',
    label: {
      en: 'Suggestion',
      sv: 'Förslag',
      de: 'Vorschlag'
    },
    rdfType: ['http://entryscape.com/terms/Suggestion'],
    mainModule: 'catalog',
    module: 'catalog',
    template: 'esc:Suggestion',
    includeInternal: true,
    includeFile: false,
    includeLink: false,
    inlineCreation: false,
    listview: SUGGESTIONS_LISTVIEW,
    overview: SUGGESTION_OVERVIEW_NAME,
    relations: [{
      entityType: 'dataset',
      type: 'aggregation',
      property: 'dcterms:references',
      label: {
        en: 'Datasets',
        sv: 'Datamängder',
        de: 'Datensätze'
      }
    }]
  }, {
    uniqueURIScope: 'entitytypeContextScope',
    name: 'datasetDocument',
    label: {
      en: 'Document',
      sv: 'Dokument',
      de: 'Dokument'
    },
    rdfType: ['foaf:Document', 'dcterms:LicenseDocument', 'dcterms:Standard', 'prof:Profile'],
    mainModule: 'catalog',
    module: 'catalog',
    template: 'esc:Documentish',
    externalTemplate: 'prof:Profile',
    complementaryTemplate: 'esc:complementaryDocumentish',
    includeInternal: false,
    includeFile: true,
    includeLink: true,
    inlineCreation: true,
    faClass: 'file',
    listview: DOCUMENTS_LISTVIEW,
    overview: DOCUMENT_OVERVIEW_NAME
  }, {
    name: 'datasettemplate',
    label: {
      en: 'Dataset Template',
      sv: 'Datamängdsmall',
      de: 'Datensatzvorlage'
    },
    rdfType: 'http://entryscape.com/terms/DatasetTemplate',
    mainModule: 'catalog',
    module: 'catalog',
    template: 'dcat:Dataset',
    includeInternal: true,
    includeFile: false,
    includeLink: false,
    inlineCreation: false,
    faClass: 'cubes'
  }, {
    name: 'distributionFile',
    label: {
      en: 'Distribution file',
      sv: 'Distributionsfilen',
      de: 'Distributionsdatei'
    },
    rdfType: 'http://entryscape.com/terms/File',
    mainModule: 'catalog',
    module: 'catalog',
    template: 'esc:File',
    includeInternal: false,
    includeFile: true,
    includeLink: false,
    inlineCreation: false,
    faClass: 'file'
  }, {
    name: 'visualization',
    label: {
      en: 'Visualization',
      sv: 'Visualisering',
      de: 'Visualisierung'
    },
    rdfType: 'http://entryscape.com/terms/visualization/Visualization',
    mainModule: 'catalog',
    module: 'catalog',
    template: 'esc:context',
    useWith: 'dataset',
    useWithProperty: 'http://schema.org/diagram',
    includeInternal: false,
    includeFile: false,
    includeLink: false,
    inlineCreation: false,
    overview: DATASET_OVERVIEW_NAME
  }]
});

/***/ }),

/***/ "./modules/catalog/config/site.js":
/*!****************************************!*\
  !*** ./modules/catalog/config/site.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var catalog_catalogs_CatalogsView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! catalog/catalogs/CatalogsView */ "./modules/catalog/catalogs/CatalogsView/index.js");
/* harmony import */ var catalog_datasets_DatasetsView__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! catalog/datasets/DatasetsView */ "./modules/catalog/datasets/DatasetsView/index.js");
/* harmony import */ var catalog_showcases_ShowcasesView__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! catalog/showcases/ShowcasesView */ "./modules/catalog/showcases/ShowcasesView/index.js");
/* harmony import */ var catalog_ideas_IdeasView__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! catalog/ideas/IdeasView */ "./modules/catalog/ideas/IdeasView/index.js");
/* harmony import */ var catalog_contacts_ContactsView__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! catalog/contacts/ContactsView */ "./modules/catalog/contacts/ContactsView/index.js");
/* harmony import */ var catalog_datasets_DatasetOverview__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! catalog/datasets/DatasetOverview */ "./modules/catalog/datasets/DatasetOverview/index.js");
/* harmony import */ var catalog_publishers_PublisherOverview__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! catalog/publishers/PublisherOverview */ "./modules/catalog/publishers/PublisherOverview/index.js");
/* harmony import */ var catalog_suggestions_SuggestionOverview__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! catalog/suggestions/SuggestionOverview */ "./modules/catalog/suggestions/SuggestionOverview/index.js");
/* harmony import */ var catalog_dataServices_DataServiceOverview__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! catalog/dataServices/DataServiceOverview */ "./modules/catalog/dataServices/DataServiceOverview/index.js");
/* harmony import */ var catalog_showcases_ShowcaseOverview__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! catalog/showcases/ShowcaseOverview */ "./modules/catalog/showcases/ShowcaseOverview/index.js");
/* harmony import */ var catalog_contacts_ContactOverview__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! catalog/contacts/ContactOverview */ "./modules/catalog/contacts/ContactOverview/index.js");
/* harmony import */ var catalog_ideas_IdeaOverview__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! catalog/ideas/IdeaOverview */ "./modules/catalog/ideas/IdeaOverview/index.js");
/* harmony import */ var catalog_documents_DocumentOverview__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! catalog/documents/DocumentOverview */ "./modules/catalog/documents/DocumentOverview/index.js");
/* harmony import */ var catalog_datasets_preview__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! catalog/datasets/preview */ "./modules/catalog/datasets/preview/index.js");
/* harmony import */ var catalog_dataServices_DataServicesView__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! catalog/dataServices/DataServicesView */ "./modules/catalog/dataServices/DataServicesView/index.js");
/* harmony import */ var catalog_catalogs_CatalogOverview__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! catalog/catalogs/CatalogOverview */ "./modules/catalog/catalogs/CatalogOverview/index.js");
/* harmony import */ var catalog_publishers_PublishersView__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! catalog/publishers/PublishersView */ "./modules/catalog/publishers/PublishersView/index.js");
/* harmony import */ var catalog_suggestions_SuggestionsView__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! catalog/suggestions/SuggestionsView */ "./modules/catalog/suggestions/SuggestionsView/index.js");
/* harmony import */ var catalog_documents_DocumentsView__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! catalog/documents/DocumentsView */ "./modules/catalog/documents/DocumentsView/index.js");
/* harmony import */ var catalog_statistics__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! catalog/statistics */ "./modules/catalog/statistics/index.js");
/* harmony import */ var commons_components_views_EntityListView__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/components/views/EntityListView */ "./modules/commons/components/views/EntityListView/index.js");
/* harmony import */ var commons_components_EntityOverview__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! commons/components/EntityOverview */ "./modules/commons/components/EntityOverview/index.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var _config__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./config */ "./modules/catalog/config/config.js");
























/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  modules: [{
    name: 'catalog',
    productName: {
      en: 'Catalog',
      sv: 'Catalog',
      de: 'Catalog'
    },
    faClass: 'archive',
    startView: 'catalog__list',
    // compulsory
    sidebar: true,
    getLayoutProps: commons_util_site__WEBPACK_IMPORTED_MODULE_22__.getSecondaryNavViewsFromEntityTypes
  }],
  views: [{
    name: _config__WEBPACK_IMPORTED_MODULE_23__.CATALOGS_LISTVIEW,
    class: catalog_catalogs_CatalogsView__WEBPACK_IMPORTED_MODULE_0__["default"],
    title: {
      en: 'Catalogs',
      sv: 'Kataloger',
      da: 'Kataloger',
      de: 'Kataloge'
    },
    constructorParams: {
      rowClickView: _config__WEBPACK_IMPORTED_MODULE_23__.CATALOG_OVERVIEW_NAME
    },
    faClass: 'archive',
    route: '/catalog',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.CATALOG_OVERVIEW_NAME,
    title: {
      en: 'Overview',
      sv: 'Översikt',
      de: 'Überblick'
    },
    class: catalog_catalogs_CatalogOverview__WEBPACK_IMPORTED_MODULE_15__["default"],
    faClass: 'eye',
    route: '/catalog/:contextId/overview',
    parent: 'catalog__list',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.SUGGESTIONS_LISTVIEW,
    title: {
      en: 'Sug\u00ADges\u00ADtions',
      sv: 'För\u00ADslag',
      de: 'Vor\u00ADschlä\u00ADge'
    },
    class: catalog_suggestions_SuggestionsView__WEBPACK_IMPORTED_MODULE_17__["default"],
    faClass: 'tasks',
    route: '/catalog/:contextId/suggestions',
    parent: 'catalog__list',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.SUGGESTION_OVERVIEW_NAME,
    class: catalog_suggestions_SuggestionOverview__WEBPACK_IMPORTED_MODULE_7__["default"],
    title: {
      en: 'Sug\u00ADges\u00ADtion',
      //  TODO: translate singular
      sv: 'För\u00ADslag',
      de: 'Vor\u00ADschlä\u00ADge'
    },
    route: '/catalog/:contextId/suggestions/:entryId/overview',
    parent: 'catalog__suggestions',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.DATASETS_LISTVIEW,
    class: catalog_datasets_DatasetsView__WEBPACK_IMPORTED_MODULE_1__["default"],
    faClass: 'cubes',
    title: {
      en: 'Datasets',
      sv: 'Data\u00ADmängder',
      da: 'Datasæt',
      de: 'Daten\u00ADsätze'
    },
    constructorParams: {
      createAndRemoveDistributions: true
    },
    route: '/catalog/:contextId/datasets',
    parent: 'catalog__list',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.DATASET_OVERVIEW_NAME,
    class: catalog_datasets_DatasetOverview__WEBPACK_IMPORTED_MODULE_5__["default"],
    faClass: 'cubes',
    title: {
      en: 'Dataset',
      sv: 'Data\u00ADmängd',
      da: 'Datasæt',
      de: 'Daten\u00ADsatz'
    },
    constructorParams: {
      createAndRemoveDistributions: true
    },
    route: '/catalog/:contextId/datasets/:entryId/overview',
    parent: 'catalog__datasets',
    module: 'catalog'
  }, {
    name: 'catalog__datasets__preview',
    class: catalog_datasets_preview__WEBPACK_IMPORTED_MODULE_13__["default"],
    title: {
      en: 'Dataset',
      sv: 'Data\u00ADmängd',
      da: 'Datasæt',
      de: 'Daten\u00ADsatz'
    },
    route: '/catalog/:contextId/datasets/:entryId',
    parent: 'catalog__datasets__dataset',
    module: 'catalog',
    public: true
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.DATASERVICES_LISTVIEW,
    title: {
      en: 'Data services',
      sv: 'Datatjänster',
      de: 'Datendienste'
    },
    class: catalog_dataServices_DataServicesView__WEBPACK_IMPORTED_MODULE_14__["default"],
    faClass: 'exchange-alt',
    route: '/catalog/:contextId/dataservices',
    parent: 'catalog__list',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.DATA_SERVICE_OVERVIEW_NAME,
    class: catalog_dataServices_DataServiceOverview__WEBPACK_IMPORTED_MODULE_8__["default"],
    title: {
      en: 'Data service',
      //  TODO: translate singular
      sv: 'Datatjänster',
      de: 'Datendienste'
    },
    route: '/catalog/:contextId/dataservices/:entryId/overview',
    parent: 'catalog__dataservices',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.SHOWCASES_LISTVIEW,
    title: {
      en: 'Showcases',
      sv: 'Showcases',
      da: 'Showcases',
      de: 'Showcases'
    },
    class: catalog_showcases_ShowcasesView__WEBPACK_IMPORTED_MODULE_2__["default"],
    faClass: 'gem',
    route: '/catalog/:contextId/showcases',
    parent: 'catalog__list',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.SHOWCASE_OVERVIEW_NAME,
    class: catalog_showcases_ShowcaseOverview__WEBPACK_IMPORTED_MODULE_9__["default"],
    title: {
      en: 'Showcase',
      sv: 'Showcase',
      de: 'Showcase'
    },
    route: '/catalog/:contextId/showcases/:entryId/overview',
    parent: 'catalog__showcases',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.IDEAS_LISTVIEW,
    title: {
      en: 'Ideas',
      sv: 'Idéer',
      da: 'Ideer',
      de: 'Ideen'
    },
    class: catalog_ideas_IdeasView__WEBPACK_IMPORTED_MODULE_3__["default"],
    faClass: 'lightbulb',
    route: '/catalog/:contextId/ideas',
    parent: 'catalog__list',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.IDEA_OVERVIEW_NAME,
    class: catalog_ideas_IdeaOverview__WEBPACK_IMPORTED_MODULE_11__["default"],
    title: {
      en: 'Ideas',
      //  TODO: translate singular
      sv: 'Idéer',
      da: 'Ideer',
      de: 'Ideen'
    },
    route: '/catalog/:contextId/ideas/:entryId/overview',
    parent: 'catalog__ideas',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.PUBLISHERS_LISTVIEW,
    class: catalog_publishers_PublishersView__WEBPACK_IMPORTED_MODULE_16__["default"],
    faClass: 'users',
    title: {
      en: 'Publishers',
      sv: 'Organisa\u00ADtioner',
      da: 'Organisa\u00ADtioner',
      de: 'Heraus\u00ADgeber'
    },
    constructorParams: {
      publishers: true,
      contacts: false
    },
    route: '/catalog/:contextId/publishers',
    parent: 'catalog__list',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.PUBLISHER_OVERVIEW_NAME,
    class: catalog_publishers_PublisherOverview__WEBPACK_IMPORTED_MODULE_6__["default"],
    title: {
      en: 'Publisher',
      sv: 'Organisa\u00ADtioner',
      da: 'Organisa\u00ADtioner',
      de: 'Heraus\u00ADgeber'
    },
    route: '/catalog/:contextId/publishers/:entryId/overview',
    parent: 'catalog__publishers',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.CONTACTS_LISTVIEW,
    class: catalog_contacts_ContactsView__WEBPACK_IMPORTED_MODULE_4__["default"],
    faClass: 'phone',
    title: {
      en: 'Contacts',
      sv: 'Kontakter',
      da: 'Kontakter',
      de: 'Kontakte'
    },
    constructorParams: {
      publishers: false,
      contacts: true
    },
    route: '/catalog/:contextId/contacts',
    parent: 'catalog__list',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.CONTACT_OVERVIEW_NAME,
    class: catalog_contacts_ContactOverview__WEBPACK_IMPORTED_MODULE_10__["default"],
    title: {
      en: 'Contact',
      //  TODO: translate singular
      sv: 'Kontakter',
      da: 'Kontakter',
      de: 'Kontakte'
    },
    route: '/catalog/:contextId/contacts/:entryId/overview',
    parent: 'catalog__contacts',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.DOCUMENTS_LISTVIEW,
    class: catalog_documents_DocumentsView__WEBPACK_IMPORTED_MODULE_18__["default"],
    faClass: 'file',
    title: {
      en: 'Documents',
      sv: 'Dokument',
      de: 'Dokumente'
    },
    route: '/catalog/:contextId/documents',
    parent: 'catalog__list',
    module: 'catalog'
  }, {
    name: _config__WEBPACK_IMPORTED_MODULE_23__.DOCUMENT_OVERVIEW_NAME,
    class: catalog_documents_DocumentOverview__WEBPACK_IMPORTED_MODULE_12__["default"],
    title: {
      en: 'Document',
      //  TODO: translate singular
      sv: 'Dokument',
      de: 'Dokumente'
    },
    route: '/catalog/:contextId/documents/:entryId/overview',
    parent: 'catalog__documents',
    module: 'catalog'
  }, {
    name: 'catalog__entities__type',
    class: commons_components_views_EntityListView__WEBPACK_IMPORTED_MODULE_20__["default"],
    title: {
      en: 'Entities',
      sv: 'Entiteter',
      de: 'Objekte'
    },
    route: '/catalog/:contextId/:entityName',
    parent: 'catalog__list',
    module: 'catalog'
  }, {
    name: 'catalog__entities__type__overview',
    class: commons_components_EntityOverview__WEBPACK_IMPORTED_MODULE_21__["default"],
    title: {
      en: 'Entity',
      sv: 'Entitet',
      de: 'Objekt'
    },
    route: '/catalog/:contextId/:entityName/:entryId/overview',
    parent: 'catalog__entities__type',
    module: 'catalog'
  }, {
    name: 'catalog__statistics',
    title: {
      en: 'Statistics',
      sv: 'Statistik',
      de: 'Statistik'
    },
    class: catalog_statistics__WEBPACK_IMPORTED_MODULE_19__["default"],
    // StatisticsView,
    faClass: 'chart-bar',
    route: '/catalog/:contextId/statistics',
    parent: 'catalog__list',
    module: 'catalog'
  }]
});

/***/ }),

/***/ "./modules/catalog/contacts/ContactOverview/ContactOverview.js":
/*!*********************************************************************!*\
  !*** ./modules/catalog/contacts/ContactOverview/ContactOverview.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/hooks/useEntry */ "./modules/commons/hooks/useEntry.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_util_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/util/util */ "./modules/commons/util/util.js");
/* harmony import */ var commons_util_metadata__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/util/metadata */ "./modules/commons/util/metadata.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! catalog/nls/escaCatalog.nls */ "./modules/catalog/nls/escaCatalog.nls");
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! catalog/nls/escaContacts.nls */ "./modules/catalog/nls/escaContacts.nls");
/* harmony import */ var catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useAsyncCallback__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/hooks/useAsyncCallback */ "./modules/commons/hooks/useAsyncCallback.js");
/* harmony import */ var commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/hooks/useDocumentTitle */ "./modules/commons/hooks/useDocumentTitle.js");
/* harmony import */ var commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/hooks/usePageTitle */ "./modules/commons/hooks/usePageTitle.js");
/* harmony import */ var commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/hooks/useGetContributors */ "./modules/commons/hooks/useGetContributors.js");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/nls/escoOverview.nls */ "./modules/commons/nls/escoOverview.nls");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_17___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_17__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/components/overview/Overview */ "./modules/commons/components/overview/Overview/index.js");
/* harmony import */ var commons_components_overview__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/components/overview */ "./modules/commons/components/overview/index.js");
/* harmony import */ var commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! commons/components/LinkedDataBrowserDialog */ "./modules/commons/components/LinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_locale__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! commons/locale */ "./modules/commons/locale/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./actions */ "./modules/catalog/contacts/ContactOverview/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
























const nlsBundles = [(catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_11___default()), (catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_10___default()), (commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_17___default())];
const ContactOverview = _ref => {
  let {
    overviewProps
  } = _ref;
  const entry = (0,commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_4__.useEntry)();
  const t = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_12__.useTranslation)(nlsBundles);
  const [catalogEntry] = (0,commons_hooks_useAsyncCallback__WEBPACK_IMPORTED_MODULE_13__["default"])(commons_util_metadata__WEBPACK_IMPORTED_MODULE_7__.getParentCatalogEntry, entry);
  const [{
    refreshCount
  }] = (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_20__.useOverviewModel)();
  const {
    contributors
  } = (0,commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_16__["default"])(entry, refreshCount);
  const [pageTitle] = (0,commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_15__["default"])();
  const viewDefinition = (0,commons_util_site__WEBPACK_IMPORTED_MODULE_8__.getViewDefFromName)('catalog__contacts__contact');
  const viewDefinitionTitle = (0,commons_locale__WEBPACK_IMPORTED_MODULE_22__.localize)(viewDefinition.title);
  const descriptionItems = [{
    id: 'catalog',
    labelNlsKey: 'overviewCatalogLabel',
    getValues: () => catalogEntry ? [(0,commons_util_util__WEBPACK_IMPORTED_MODULE_6__.truncate)((0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__.getFullLengthLabel)(catalogEntry), 90)] : []
  }, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_18__.DESCRIPTION_UPDATED, {
    id: 'edited',
    labelNlsKey: 'editedByLabel',
    getValues: () => contributors
  }];
  (0,commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_14__["default"])(`${pageTitle} - ${viewDefinitionTitle} ${(0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__.getLabel)(entry)}`);
  return /*#__PURE__*/React.createElement(commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_19__["default"], _extends({}, overviewProps, {
    backLabel: t('backTitle'),
    headerAction: _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_18__.ACTION_INFO_WITH_ICON), {}, {
      Dialog: commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_21__["default"]
    }),
    entry: entry,
    nlsBundles: nlsBundles,
    descriptionItems: descriptionItems,
    sidebarActions: _actions__WEBPACK_IMPORTED_MODULE_23__.sidebarActions
  }));
};
ContactOverview.propTypes = {
  overviewProps: commons_components_overview__WEBPACK_IMPORTED_MODULE_20__.overviewPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_overview__WEBPACK_IMPORTED_MODULE_20__.withOverviewModelProvider)(ContactOverview));

/***/ }),

/***/ "./modules/catalog/contacts/ContactOverview/actions.js":
/*!*************************************************************!*\
  !*** ./modules/catalog/contacts/ContactOverview/actions.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sidebarActions: () => (/* binding */ sidebarActions)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var _dialogs_RemoveContactDialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dialogs/RemoveContactDialog */ "./modules/catalog/contacts/dialogs/RemoveContactDialog/index.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


const sidebarActions = [commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_EDIT, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REVISIONS, _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REMOVE), {}, {
  Dialog: _dialogs_RemoveContactDialog__WEBPACK_IMPORTED_MODULE_2__["default"]
})];


/***/ }),

/***/ "./modules/catalog/contacts/ContactOverview/index.js":
/*!***********************************************************!*\
  !*** ./modules/catalog/contacts/ContactOverview/index.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ContactOverview__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ContactOverview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ContactOverview */ "./modules/catalog/contacts/ContactOverview/ContactOverview.js");


/***/ }),

/***/ "./modules/catalog/contacts/ContactsView/ContactsView.js":
/*!***************************************************************!*\
  !*** ./modules/catalog/contacts/ContactsView/ContactsView.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var _mui_icons_material__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @mui/icons-material */ "./node_modules/.pnpm/@mui+icons-material@7.3.2_@mui+material@7.3.2_@emotion+react@11.14.0_@types+react@19.1._64db9f6672aac850f352bc22706e4e05/node_modules/@mui/icons-material/esm/Call.js");
/* harmony import */ var commons_types_Lookup__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/types/Lookup */ "./modules/commons/types/Lookup.js");
/* harmony import */ var commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useESContext */ "./modules/commons/hooks/useESContext.js");
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var commons_components_TableView__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/components/TableView */ "./modules/commons/components/TableView/index.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_components_filters_hooks_useSearchFilters__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/components/filters/hooks/useSearchFilters */ "./modules/commons/components/filters/hooks/useSearchFilters.js");
/* harmony import */ var commons_components_filters_utils_filterDefinitions__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/filters/utils/filterDefinitions */ "./modules/commons/components/filters/utils/filterDefinitions.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_types_utils_entityType__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/types/utils/entityType */ "./modules/commons/types/utils/entityType.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./actions */ "./modules/catalog/contacts/ContactsView/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
const _excluded = ["applyFilters", "isLoading", "hasFilters"],
  _excluded2 = ["callbackResults"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }





















const getAllContextsEnabled = () => {
  const entityType = commons_types_Lookup__WEBPACK_IMPORTED_MODULE_6__["default"].getByName('contactPoint');
  return Boolean(entityType === null || entityType === void 0 ? void 0 : entityType.get('allContexts'));
};
const ContactsView = _ref => {
  let {
    listProps
  } = _ref;
  const [{
    showTableView
  }, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__.useListModel)();
  const {
    context
  } = (0,commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_7__.useESContext)();
  const contextId = context.getId();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_19__.useTranslation)(_actions__WEBPACK_IMPORTED_MODULE_20__.nlsBundles);
  const entityType = commons_types_Lookup__WEBPACK_IMPORTED_MODULE_6__["default"].getByName('contactPoint');
  const includeContextFilter = getAllContextsEnabled();
  const filters = includeContextFilter && !showTableView ? [_objectSpread(_objectSpread({}, commons_components_filters_utils_filterDefinitions__WEBPACK_IMPORTED_MODULE_16__.CONTEXT_CHECKBOX_FILTER), {}, {
    headerNlsKey: 'contextFilterHeaderCatalog',
    loadItems: () => [commons_components_filters_utils_filterDefinitions__WEBPACK_IMPORTED_MODULE_16__.ANY_FILTER_ITEM, {
      value: contextId
    }],
    defaultValue: contextId,
    initialSelection: contextId
  })] : [];
  const _useSearchFilters = (0,commons_components_filters_hooks_useSearchFilters__WEBPACK_IMPORTED_MODULE_15__["default"])(filters),
    {
      applyFilters,
      isLoading,
      hasFilters
    } = _useSearchFilters,
    filterProps = _objectWithoutProperties(_useSearchFilters, _excluded);
  const createQuery = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => {
    const query = commons_store__WEBPACK_IMPORTED_MODULE_9__.entrystore.newSolrQuery().rdfType(commons_util_entry__WEBPACK_IMPORTED_MODULE_8__.RDF_TYPE_CONTACT);
    if (!includeContextFilter) query.context(context);
    return query;
  }, [context, includeContextFilter]);
  const _useSolrQuery = (0,commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_12__.useSolrQuery)({
      createQuery,
      applyFilters,
      wait: isLoading,
      callback: includeContextFilter ? commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_12__.getContextEntriesCallback : commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_12__.getItemsCallback
    }),
    {
      callbackResults: items = []
    } = _useSolrQuery,
    queryResults = _objectWithoutProperties(_useSolrQuery, _excluded2);
  const getTitleWithContextProps = _ref2 => {
    let {
      entry
    } = _ref2;
    if (contextId === entry.getContext().getId()) {
      return {
        primary: (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_17__.getFullLengthLabel)(entry)
      };
    }
    return {
      primary: (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_17__.getFullLengthLabel)(entry),
      secondary: (0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_17__.getFullLengthLabel)(entry.getContext().getEntry(true))
    };
  };
  const getCanAccessOverview = entry => {
    const overviewName = (0,commons_types_utils_entityType__WEBPACK_IMPORTED_MODULE_18__.getOverviewName)(entityType);
    return Boolean(overviewName && entry.canAdministerEntry());
  };
  return showTableView ? /*#__PURE__*/React.createElement(commons_components_TableView__WEBPACK_IMPORTED_MODULE_10__["default"], {
    setTableView: () => dispatch({
      type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__.TOGGLE_TABLEVIEW
    }),
    rdfType: commons_util_entry__WEBPACK_IMPORTED_MODULE_8__.RDF_TYPE_CONTACT,
    templateId: commons_types_Lookup__WEBPACK_IMPORTED_MODULE_6__["default"].getByName('contactPoint').complementaryTemplateId()
  }) : /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_12__.EntryListView, _extends({}, queryResults, listProps, {
    items: items,
    nlsBundles: _actions__WEBPACK_IMPORTED_MODULE_20__.nlsBundles,
    includeFilters: hasFilters,
    filtersProps: hasFilters ? filterProps : null,
    getListItemProps: _ref3 => {
      let {
        entry
      } = _ref3;
      return getCanAccessOverview(entry) ? {
        to: (0,commons_util_site__WEBPACK_IMPORTED_MODULE_11__.getPathFromViewName)('catalog__contacts__contact', {
          contextId: entry.getContext().getId(),
          entryId: entry.getId()
        })
      } : {
        tooltip: translate('noAccessTooltip')
      };
    },
    includeTableView: true,
    listActions: _actions__WEBPACK_IMPORTED_MODULE_20__.listActions,
    listActionsProps: {
      nlsBundles: _actions__WEBPACK_IMPORTED_MODULE_20__.nlsBundles
    },
    columns: [{
      id: 'call-icon',
      xs: 1,
      Component: commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__.ListItemIcon,
      icon: /*#__PURE__*/React.createElement(_mui_icons_material__WEBPACK_IMPORTED_MODULE_5__["default"], {
        color: "primary"
      })
    }, includeContextFilter ? _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_12__.TITLE_WITH_CONTEXT_COLUMN), {}, {
      getProps: getTitleWithContextProps
    }) : _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_12__.TITLE_COLUMN), {}, {
      xs: 7
    }), commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_12__.MODIFIED_COLUMN, _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_12__.ACTIONS_GROUP_COLUMN), {}, {
      actions: [commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_13__.LIST_ACTION_INFO, _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_13__.LIST_ACTION_EDIT), {}, {
        isVisible: _ref4 => {
          let {
            entry
          } = _ref4;
          return entry.canAdministerEntry();
        }
      })]
    })]
  }));
};
ContactsView.propTypes = {
  listProps: commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__.listPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_14__.withListModelProviderAndLocation)(ContactsView, () => ({
  showFilters: getAllContextsEnabled()
})));

/***/ }),

/***/ "./modules/catalog/contacts/ContactsView/actions.js":
/*!**********************************************************!*\
  !*** ./modules/catalog/contacts/ContactsView/actions.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   listActions: () => (/* binding */ listActions),
/* harmony export */   nlsBundles: () => (/* binding */ nlsBundles),
/* harmony export */   rowActions: () => (/* binding */ rowActions)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var catalog_contacts_dialogs_CreateContactsDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! catalog/contacts/dialogs/CreateContactsDialog */ "./modules/catalog/contacts/dialogs/CreateContactsDialog/index.js");
/* harmony import */ var catalog_contacts_dialogs_RemoveContactDialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! catalog/contacts/dialogs/RemoveContactDialog */ "./modules/catalog/contacts/dialogs/RemoveContactDialog/index.js");
/* harmony import */ var catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! catalog/nls/escaContacts.nls */ "./modules/catalog/nls/escaContacts.nls");
/* harmony import */ var catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }






const nlsBundles = [(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_4___default()), (catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_3___default())];
const listActions = [{
  id: 'create',
  Dialog: (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_6__.withListRefresh)(catalog_contacts_dialogs_CreateContactsDialog__WEBPACK_IMPORTED_MODULE_1__["default"], 'onCreate'),
  labelNlsKey: 'createButtonLabel',
  tooltipNlsKey: 'actionTooltipContact',
  highlightId: 'listActionCreate'
}];
const rowActions = [commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_5__.LIST_ACTION_EDIT, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_5__.LIST_ACTION_REVISIONS, _objectSpread(_objectSpread({}, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_5__.LIST_ACTION_REMOVE), {}, {
  Dialog: catalog_contacts_dialogs_RemoveContactDialog__WEBPACK_IMPORTED_MODULE_2__["default"]
})];


/***/ }),

/***/ "./modules/catalog/contacts/ContactsView/index.js":
/*!********************************************************!*\
  !*** ./modules/catalog/contacts/ContactsView/index.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _ContactsView__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _ContactsView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ContactsView */ "./modules/catalog/contacts/ContactsView/ContactsView.js");


/***/ }),

/***/ "./modules/catalog/contacts/dialogs/CreateContactsDialog/CreateContactsDialog.js":
/*!***************************************************************************************!*\
  !*** ./modules/catalog/contacts/dialogs/CreateContactsDialog/CreateContactsDialog.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_util_store__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/util/store */ "./modules/commons/util/store.js");
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_components_dialogs_create_CreateEntryByTemplateDialog__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/components/dialogs/create/CreateEntryByTemplateDialog */ "./modules/commons/components/dialogs/create/CreateEntryByTemplateDialog/index.js");
/* harmony import */ var commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useESContext */ "./modules/commons/hooks/useESContext.js");
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var commons_components_rdforms_LevelSelector__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/components/rdforms/LevelSelector */ "./modules/commons/components/rdforms/LevelSelector/index.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! catalog/nls/escaContacts.nls */ "./modules/catalog/nls/escaContacts.nls");
/* harmony import */ var catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/hooks/useSnackbar */ "./modules/commons/hooks/useSnackbar.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_13___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_13__);
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
const _excluded = ["onCreate"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }






// eslint-disable-next-line max-len









/**
 *
 * @param {Context} context
 * @returns {Entry}
 */
const createPrototypeEntry = context => {
  const [, defaultRdfContactType] = commons_util_entry__WEBPACK_IMPORTED_MODULE_8__.RDF_TYPE_CONTACT;
  const prototypeEntry = (0,commons_util_store__WEBPACK_IMPORTED_MODULE_4__.createEntry)(context, defaultRdfContactType);
  prototypeEntry.getMetadata().add(prototypeEntry.getResourceURI(), 'rdf:type', defaultRdfContactType);
  return prototypeEntry;
};
const CreateContactsDialog = _ref => {
  let {
      onCreate
    } = _ref,
    props = _objectWithoutProperties(_ref, _excluded);
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_10__.useTranslation)((catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_11___default()));
  const [addSnackbar] = (0,commons_hooks_useSnackbar__WEBPACK_IMPORTED_MODULE_12__.useSnackbar)();
  const {
    context
  } = (0,commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_7__.useESContext)();
  const [prototypeEntry] = (0,react__WEBPACK_IMPORTED_MODULE_13__.useState)(() => createPrototypeEntry(context));
  return /*#__PURE__*/React.createElement(commons_components_dialogs_create_CreateEntryByTemplateDialog__WEBPACK_IMPORTED_MODULE_6__["default"]
  // eslint-disable-next-line react/jsx-props-no-spreading
  , _extends({}, props, {
    entry: prototypeEntry,
    editorLevel: commons_components_rdforms_LevelSelector__WEBPACK_IMPORTED_MODULE_9__.LEVEL_MANDATORY,
    createHeaderLabel: translate('createContactpointHeader'),
    onEntryEdit: () => {
      onCreate();
      addSnackbar({
        message: translate('createContactSuccess')
      });
    }
  }));
};
CreateContactsDialog.propTypes = {
  onCreate: (prop_types__WEBPACK_IMPORTED_MODULE_3___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (CreateContactsDialog);

/***/ }),

/***/ "./modules/catalog/contacts/dialogs/CreateContactsDialog/index.js":
/*!************************************************************************!*\
  !*** ./modules/catalog/contacts/dialogs/CreateContactsDialog/index.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _CreateContactsDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _CreateContactsDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CreateContactsDialog */ "./modules/catalog/contacts/dialogs/CreateContactsDialog/CreateContactsDialog.js");


/***/ }),

/***/ "./modules/catalog/contacts/dialogs/RemoveContactDialog/RemoveContactDialog.js":
/*!*************************************************************************************!*\
  !*** ./modules/catalog/contacts/dialogs/RemoveContactDialog/RemoveContactDialog.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var _entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @entryscape/entrystore-js */ "./node_modules/.pnpm/@entryscape+entrystore-js@4.16.0/node_modules/@entryscape/entrystore-js/src/index.js");
/* harmony import */ var commons_components_overview__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! commons/components/overview */ "./modules/commons/components/overview/index.js");
/* harmony import */ var commons_hooks_references_useCheckReferences__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/hooks/references/useCheckReferences */ "./modules/commons/hooks/references/useCheckReferences.js");
/* harmony import */ var catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! catalog/nls/escaContacts.nls */ "./modules/catalog/nls/escaContacts.nls");
/* harmony import */ var catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");

const _excluded = ["entry", "closeDialog"];
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }






const RemoveContactDialog = _ref => {
  let {
      entry: contactEntry,
      closeDialog
    } = _ref,
    rest = _objectWithoutProperties(_ref, _excluded);
  const {
    references,
    checkReferencesStatus
  } = (0,commons_hooks_references_useCheckReferences__WEBPACK_IMPORTED_MODULE_4__["default"])({
    entry: contactEntry,
    nlsBundles: [(catalog_nls_escaContacts_nls__WEBPACK_IMPORTED_MODULE_5___default())],
    callback: closeDialog
  });
  if (checkReferencesStatus !== commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_6__.RESOLVED || references.length !== 0) return null;
  return /*#__PURE__*/React.createElement(commons_components_overview__WEBPACK_IMPORTED_MODULE_3__.OverviewRemoveEntryDialog, _extends({
    entry: contactEntry,
    closeDialog: closeDialog
  }, rest));
};
RemoveContactDialog.propTypes = {
  entry: prop_types__WEBPACK_IMPORTED_MODULE_1___default().instanceOf(_entryscape_entrystore_js__WEBPACK_IMPORTED_MODULE_2__.Entry),
  closeDialog: (prop_types__WEBPACK_IMPORTED_MODULE_1___default().func)
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (RemoveContactDialog);

/***/ }),

/***/ "./modules/catalog/contacts/dialogs/RemoveContactDialog/index.js":
/*!***********************************************************************!*\
  !*** ./modules/catalog/contacts/dialogs/RemoveContactDialog/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _RemoveContactDialog__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _RemoveContactDialog__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./RemoveContactDialog */ "./modules/catalog/contacts/dialogs/RemoveContactDialog/RemoveContactDialog.js");


/***/ }),

/***/ "./modules/catalog/dataServices/DataServiceOverview/DataServiceOverview.js":
/*!*********************************************************************************!*\
  !*** ./modules/catalog/dataServices/DataServiceOverview/DataServiceOverview.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! commons/hooks/useEntry */ "./modules/commons/hooks/useEntry.js");
/* harmony import */ var commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/util/rdfUtils */ "./modules/commons/util/rdfUtils.js");
/* harmony import */ var commons_util_util__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/util/util */ "./modules/commons/util/util.js");
/* harmony import */ var commons_util_metadata__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/util/metadata */ "./modules/commons/util/metadata.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! catalog/nls/escaCatalog.nls */ "./modules/catalog/nls/escaCatalog.nls");
/* harmony import */ var catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9__);
/* harmony import */ var catalog_nls_escaDataset_nls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! catalog/nls/escaDataset.nls */ "./modules/catalog/nls/escaDataset.nls");
/* harmony import */ var catalog_nls_escaDataset_nls__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaDataset_nls__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var catalog_nls_escaServices_nls__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! catalog/nls/escaServices.nls */ "./modules/catalog/nls/escaServices.nls");
/* harmony import */ var catalog_nls_escaServices_nls__WEBPACK_IMPORTED_MODULE_11___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaServices_nls__WEBPACK_IMPORTED_MODULE_11__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_12___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_12__);
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_hooks_useAsyncCallback__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/hooks/useAsyncCallback */ "./modules/commons/hooks/useAsyncCallback.js");
/* harmony import */ var commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/hooks/useDocumentTitle */ "./modules/commons/hooks/useDocumentTitle.js");
/* harmony import */ var commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/hooks/usePageTitle */ "./modules/commons/hooks/usePageTitle.js");
/* harmony import */ var commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/hooks/useGetContributors */ "./modules/commons/hooks/useGetContributors.js");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/nls/escoOverview.nls */ "./modules/commons/nls/escoOverview.nls");
/* harmony import */ var commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_18___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_18__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/components/overview/Overview */ "./modules/commons/components/overview/Overview/index.js");
/* harmony import */ var commons_components_overview__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! commons/components/overview */ "./modules/commons/components/overview/index.js");
/* harmony import */ var commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! commons/components/LinkedDataBrowserDialog */ "./modules/commons/components/LinkedDataBrowserDialog/index.js");
/* harmony import */ var commons_locale__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! commons/locale */ "./modules/commons/locale/index.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./actions */ "./modules/catalog/dataServices/DataServiceOverview/actions.js");
/* harmony import */ var _DatasetList_DatasetList__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./DatasetList/DatasetList */ "./modules/catalog/dataServices/DataServiceOverview/DatasetList/DatasetList.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


























const nlsBundles = [(catalog_nls_escaDataset_nls__WEBPACK_IMPORTED_MODULE_10___default()), (catalog_nls_escaCatalog_nls__WEBPACK_IMPORTED_MODULE_9___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_12___default()), (catalog_nls_escaServices_nls__WEBPACK_IMPORTED_MODULE_11___default()), (commons_nls_escoOverview_nls__WEBPACK_IMPORTED_MODULE_18___default())];
const DataServiceOverview = _ref => {
  let {
    overviewProps
  } = _ref;
  const entry = (0,commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_4__.useEntry)();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_13__.useTranslation)(nlsBundles);
  const [catalogEntry] = (0,commons_hooks_useAsyncCallback__WEBPACK_IMPORTED_MODULE_14__["default"])(commons_util_metadata__WEBPACK_IMPORTED_MODULE_7__.getParentCatalogEntry, entry);
  const [{
    refreshCount
  }] = (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_21__.useOverviewModel)();
  const {
    contributors
  } = (0,commons_hooks_useGetContributors__WEBPACK_IMPORTED_MODULE_17__["default"])(entry, refreshCount);
  const [pageTitle] = (0,commons_hooks_usePageTitle__WEBPACK_IMPORTED_MODULE_16__["default"])();
  const viewDefinition = (0,commons_util_site__WEBPACK_IMPORTED_MODULE_8__.getViewDefFromName)('catalog__dataservices__dataservice');
  const viewDefinitionTitle = (0,commons_locale__WEBPACK_IMPORTED_MODULE_23__.localize)(viewDefinition.title);
  const descriptionItems = [{
    id: 'catalog',
    labelNlsKey: 'overviewCatalogLabel',
    getValues: () => catalogEntry ? [(0,commons_util_util__WEBPACK_IMPORTED_MODULE_6__.truncate)((0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__.getFullLengthLabel)(catalogEntry), 90)] : []
  }, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_19__.DESCRIPTION_UPDATED, {
    id: 'edited',
    labelNlsKey: 'editedByLabel',
    getValues: () => contributors
  }];
  (0,commons_hooks_useDocumentTitle__WEBPACK_IMPORTED_MODULE_15__["default"])(`${pageTitle} - ${viewDefinitionTitle} ${(0,commons_util_rdfUtils__WEBPACK_IMPORTED_MODULE_5__.getLabel)(entry)}`);
  return /*#__PURE__*/React.createElement(commons_components_overview_Overview__WEBPACK_IMPORTED_MODULE_20__["default"], _extends({}, overviewProps, {
    backLabel: translate('backTitle'),
    headerAction: _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_19__.ACTION_INFO_WITH_ICON), {}, {
      Dialog: commons_components_LinkedDataBrowserDialog__WEBPACK_IMPORTED_MODULE_22__["default"]
    }),
    entry: entry,
    nlsBundles: nlsBundles,
    descriptionItems: descriptionItems,
    sidebarActions: _actions__WEBPACK_IMPORTED_MODULE_24__.sidebarActions
  }), /*#__PURE__*/React.createElement(_DatasetList_DatasetList__WEBPACK_IMPORTED_MODULE_25__["default"], null));
};
DataServiceOverview.propTypes = {
  overviewProps: commons_components_overview__WEBPACK_IMPORTED_MODULE_21__.overviewPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_overview__WEBPACK_IMPORTED_MODULE_21__.withOverviewModelProvider)(DataServiceOverview));

/***/ }),

/***/ "./modules/catalog/dataServices/DataServiceOverview/DatasetList/DatasetList.js":
/*!*************************************************************************************!*\
  !*** ./modules/catalog/dataServices/DataServiceOverview/DatasetList/DatasetList.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_flat_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.flat.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.flat.js");
/* harmony import */ var core_js_modules_es_array_flat_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_flat_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_unscopables_flat_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.unscopables.flat.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.unscopables.flat.js");
/* harmony import */ var core_js_modules_es_array_unscopables_flat_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_unscopables_flat_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_6___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_6__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_7___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_7__);
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lodash-es */ "./node_modules/.pnpm/lodash-es@4.17.21/node_modules/lodash-es/chunk.js");
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lodash-es */ "./node_modules/.pnpm/lodash-es@4.17.21/node_modules/lodash-es/uniq.js");
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var catalog_nls_escaDataset_nls__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! catalog/nls/escaDataset.nls */ "./modules/catalog/nls/escaDataset.nls");
/* harmony import */ var catalog_nls_escaDataset_nls__WEBPACK_IMPORTED_MODULE_14___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaDataset_nls__WEBPACK_IMPORTED_MODULE_14__);
/* harmony import */ var catalog_nls_escaCatalogSearch_nls__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! catalog/nls/escaCatalogSearch.nls */ "./modules/catalog/nls/escaCatalogSearch.nls");
/* harmony import */ var catalog_nls_escaCatalogSearch_nls__WEBPACK_IMPORTED_MODULE_15___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaCatalogSearch_nls__WEBPACK_IMPORTED_MODULE_15__);
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_16___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_16__);
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_errors_hooks_useErrorHandler__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! commons/errors/hooks/useErrorHandler */ "./modules/commons/errors/hooks/useErrorHandler.js");
/* harmony import */ var commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! commons/hooks/useEntry */ "./modules/commons/hooks/useEntry.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/commons/hooks/useTranslation/index.js");
/* harmony import */ var commons_components_overview_OverviewListHeader__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! commons/components/overview/OverviewListHeader */ "./modules/commons/components/overview/OverviewListHeader/index.js");
/* harmony import */ var commons_components_overview__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! commons/components/overview */ "./modules/commons/components/overview/index.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
























const nlsBundles = [(catalog_nls_escaDataset_nls__WEBPACK_IMPORTED_MODULE_14___default()), (catalog_nls_escaCatalogSearch_nls__WEBPACK_IMPORTED_MODULE_15___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_16___default())];
const SEARCH_FIELDS = ['label'];

/**
 * get all entries typed as distribution
 * and with the dcat:accessService property pointing to the dataservice,
 * and within the same context
 *
 * @param {object} dataserviceEntry
 * @returns {Promise<Array>} distributionEntries
 */
const getDistributionEntries = dataserviceEntry => {
  const resourceURI = dataserviceEntry.getResourceURI();
  const distributionEntries = commons_store__WEBPACK_IMPORTED_MODULE_12__.entrystore.newSolrQuery().rdfType(commons_util_entry__WEBPACK_IMPORTED_MODULE_13__.RDF_TYPE_DISTRIBUTION).uriProperty('dcat:accessService', resourceURI).list().getEntries();
  return distributionEntries;
};

/**
 * @param {object} dataserviceEntry
 * @returns {Promise<Array>} datasetEntries
 */
const getRelatedDatasets = async dataserviceEntry => {
  const statements = (0,commons_util_entry__WEBPACK_IMPORTED_MODULE_13__.findResourceStatements)(dataserviceEntry, 'dcat:servesDataset');
  const servesDatasetURIs = statements.map(statement => statement.getValue());
  if (!servesDatasetURIs.length) return [];
  const local = await commons_store__WEBPACK_IMPORTED_MODULE_12__.entrystoreUtil.loadEntriesByResourceURIs(servesDatasetURIs, undefined, true);
  return local.filter(Boolean);
};

/**
 * @param {object} dataserviceEntry
 * @returns {Promise} datasetEntries
 */
const getDatasetEntries = async dataserviceEntry => {
  const distributions = await getDistributionEntries(dataserviceEntry);
  const batchSize = 50;
  const datasetEntries = [];
  if (distributions.length > 50) {
    return {
      entries: [],
      exceededLimit: true
    };
  }
  const batchDistributionEntries = (0,lodash_es__WEBPACK_IMPORTED_MODULE_8__["default"])(distributions, batchSize);
  const batchEntriesPromises = batchDistributionEntries.map(batch => {
    const batchUris = batch.map(entry => entry.getResourceURI());
    return commons_store__WEBPACK_IMPORTED_MODULE_12__.entrystore.newSolrQuery().rdfType(commons_util_entry__WEBPACK_IMPORTED_MODULE_13__.RDF_TYPE_DATASET).context(batch[0].getContext()).uriProperty('dcat:distribution', batchUris).list().getEntries();
  });
  const batchEntries = await Promise.all(batchEntriesPromises);
  datasetEntries.push(...batchEntries.flat());
  const relatedDatasets = await getRelatedDatasets(dataserviceEntry);
  const allLinkedDatasets = [...datasetEntries, ...relatedDatasets];
  return {
    entries: (0,lodash_es__WEBPACK_IMPORTED_MODULE_9__["default"])(allLinkedDatasets).map(entry => ({
      entry
    })),
    exceededLimit: false
  };
};
const DatasetList = () => {
  const dataserviceEntry = (0,commons_hooks_useEntry__WEBPACK_IMPORTED_MODULE_21__.useEntry)();
  const translate = (0,commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_22__.useTranslation)(nlsBundles);
  const {
    runAsync,
    data: datasetItems,
    error,
    status
  } = (0,commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_11__["default"])();
  const [{
    refreshCount
  }] = (0,commons_components_overview__WEBPACK_IMPORTED_MODULE_24__.useOverviewModel)();
  (0,commons_errors_hooks_useErrorHandler__WEBPACK_IMPORTED_MODULE_20__["default"])(error);
  (0,react__WEBPACK_IMPORTED_MODULE_7__.useEffect)(() => {
    runAsync(getDatasetEntries(dataserviceEntry));
  }, [runAsync, dataserviceEntry, refreshCount]);
  const listQueries = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_17__.useListQuery)({
    items: datasetItems && datasetItems.entries,
    searchFields: SEARCH_FIELDS
  });
  const entries = listQueries === null || listQueries === void 0 ? void 0 : listQueries.result.map(_ref => {
    let {
      entry
    } = _ref;
    return entry;
  });
  const reshapedListQueries = _objectSpread(_objectSpread({}, listQueries), {}, {
    entries,
    exceededLimit: datasetItems && datasetItems.exceededLimit
  });
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(commons_components_overview_OverviewListHeader__WEBPACK_IMPORTED_MODULE_23__.OverviewListHeader, {
    heading: translate('datasetsHeading')
  }), /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_18__.EntryListView, _extends({}, reshapedListQueries, {
    status: status,
    nlsBundles: nlsBundles,
    getListItemProps: _ref2 => {
      let {
        entry
      } = _ref2;
      return {
        to: (0,commons_util_site__WEBPACK_IMPORTED_MODULE_10__.getPathFromViewName)('catalog__datasets__dataset', {
          contextId: entry.getContext().getId(),
          entryId: entry.getId()
        })
      };
    },
    includeDefaultListActions: false,
    includeHeader: false,
    renderViewPlaceholder: () => /*#__PURE__*/React.createElement(commons_components_overview__WEBPACK_IMPORTED_MODULE_24__.OverviewListPlaceholder, {
      label: datasetItems && datasetItems.exceededLimit ? translate('tooManyConnectedDatasets') : translate('datasetsListPlaceholder')
    }),
    columns: [_objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_18__.TITLE_COLUMN), {}, {
      xs: 8
    }), commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_18__.MODIFIED_COLUMN, _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_18__.ACTIONS_GROUP_COLUMN), {}, {
      actions: [commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_19__.LIST_ACTION_INFO, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_19__.LIST_ACTION_EDIT]
    })]
  })));
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_17__.withListModelProvider)(DatasetList));

/***/ }),

/***/ "./modules/catalog/dataServices/DataServiceOverview/actions.js":
/*!*********************************************************************!*\
  !*** ./modules/catalog/dataServices/DataServiceOverview/actions.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   sidebarActions: () => (/* binding */ sidebarActions)
/* harmony export */ });
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! commons/components/overview/actions */ "./modules/commons/components/overview/actions/index.js");
/* harmony import */ var _dialogs_RemoveDataServiceDialog__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dialogs/RemoveDataServiceDialog */ "./modules/catalog/dataServices/dialogs/RemoveDataServiceDialog/index.js");

function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }


const sidebarActions = [commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_EDIT, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REVISIONS, _objectSpread(_objectSpread({}, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_REMOVE), {}, {
  Dialog: _dialogs_RemoveDataServiceDialog__WEBPACK_IMPORTED_MODULE_2__["default"]
}), commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_DIVIDER, commons_components_overview_actions__WEBPACK_IMPORTED_MODULE_1__.ACTION_PUBLISH];


/***/ }),

/***/ "./modules/catalog/dataServices/DataServiceOverview/index.js":
/*!*******************************************************************!*\
  !*** ./modules/catalog/dataServices/DataServiceOverview/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _DataServiceOverview__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _DataServiceOverview__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DataServiceOverview */ "./modules/catalog/dataServices/DataServiceOverview/DataServiceOverview.js");


/***/ }),

/***/ "./modules/catalog/dataServices/DataServicesView/DataServicesView.js":
/*!***************************************************************************!*\
  !*** ./modules/catalog/dataServices/DataServicesView/DataServicesView.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/web.dom-collections.for-each.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.for-each.js");
/* harmony import */ var core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_for_each_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var commons_store__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! commons/store */ "./modules/commons/store/index.js");
/* harmony import */ var commons_types_Lookup__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/types/Lookup */ "./modules/commons/types/Lookup.js");
/* harmony import */ var commons_components_TableView__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/components/TableView */ "./modules/commons/components/TableView/index.js");
/* harmony import */ var catalog_nls_escaServices_nls__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! catalog/nls/escaServices.nls */ "./modules/catalog/nls/escaServices.nls");
/* harmony import */ var catalog_nls_escaServices_nls__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(catalog_nls_escaServices_nls__WEBPACK_IMPORTED_MODULE_8__);
/* harmony import */ var commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! commons/hooks/useESContext */ "./modules/commons/hooks/useESContext.js");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! commons/nls/escoList.nls */ "./modules/commons/nls/escoList.nls");
/* harmony import */ var commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_10___default = /*#__PURE__*/__webpack_require__.n(commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_10__);
/* harmony import */ var commons_util_site__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/util/site */ "./modules/commons/util/site.js");
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/components/EntryListView */ "./modules/commons/components/EntryListView/index.js");
/* harmony import */ var commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/components/EntryListView/actions */ "./modules/commons/components/EntryListView/actions/index.js");
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var commons_components_filters_utils_filterDefinitions__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! commons/components/filters/utils/filterDefinitions */ "./modules/commons/components/filters/utils/filterDefinitions.js");
/* harmony import */ var commons_components_filters_hooks_useSearchFilters__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! commons/components/filters/hooks/useSearchFilters */ "./modules/commons/components/filters/hooks/useSearchFilters.js");
/* harmony import */ var commons_types_utils_entityType__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! commons/types/utils/entityType */ "./modules/commons/types/utils/entityType.js");
/* harmony import */ var _actions__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./actions */ "./modules/catalog/dataServices/DataServicesView/actions.js");
/* provided dependency */ var React = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");


const _excluded = ["applyFilters", "isLoading", "hasFilters"];


function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } return t; }
















const FILTERS = [commons_components_filters_utils_filterDefinitions__WEBPACK_IMPORTED_MODULE_16__.HVD_FILTER];
const DataServicesListView = _ref => {
  let {
    listProps
  } = _ref;
  const nlsBundles = [(catalog_nls_escaServices_nls__WEBPACK_IMPORTED_MODULE_8___default()), (commons_nls_escoList_nls__WEBPACK_IMPORTED_MODULE_10___default())];
  const {
    context
  } = (0,commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_9__.useESContext)();
  const dataserviceEntityType = commons_types_Lookup__WEBPACK_IMPORTED_MODULE_6__["default"].getByName('dataService');
  const draftsEnabled = (0,commons_types_utils_entityType__WEBPACK_IMPORTED_MODULE_18__.getDraftsEnabled)(dataserviceEntityType);
  const _useSearchFilters = (0,commons_components_filters_hooks_useSearchFilters__WEBPACK_IMPORTED_MODULE_17__["default"])(FILTERS),
    {
      applyFilters,
      isLoading,
      hasFilters
    } = _useSearchFilters,
    filterProps = _objectWithoutProperties(_useSearchFilters, _excluded);
  const createQuery = (0,react__WEBPACK_IMPORTED_MODULE_4__.useCallback)(() => commons_store__WEBPACK_IMPORTED_MODULE_5__.entrystore.newSolrQuery().rdfType(commons_util_entry__WEBPACK_IMPORTED_MODULE_12__.RDF_TYPE_DATASERVICE).context(context), [context]);
  const queryResults = (0,commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.useSolrQuery)({
    createQuery,
    applyFilters,
    wait: isLoading
  });
  return /*#__PURE__*/React.createElement(commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.EntryListView, _extends({}, queryResults, listProps, {
    nlsBundles: nlsBundles,
    includeFilters: hasFilters,
    filtersProps: hasFilters ? filterProps : null,
    getListItemProps: _ref2 => {
      let {
        entry
      } = _ref2;
      return {
        to: (0,commons_util_site__WEBPACK_IMPORTED_MODULE_11__.getPathFromViewName)('catalog__dataservices__dataservice', {
          contextId: context.getId(),
          entryId: entry.getId()
        })
      };
    },
    columns: [_objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.STATUS_COLUMN), {}, {
      getProps: _ref3 => {
        let {
          entry,
          translate
        } = _ref3;
        return {
          entry,
          draftsEnabled,
          publicTooltip: translate('publicServiceTitle'),
          privateTooltip: translate('privateServiceTitle')
        };
      }
    }), _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.TITLE_COLUMN), {}, {
      xs: 7
    }), commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.MODIFIED_COLUMN, _objectSpread(_objectSpread({}, commons_components_EntryListView__WEBPACK_IMPORTED_MODULE_13__.ACTIONS_GROUP_COLUMN), {}, {
      actions: [commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_14__.LIST_ACTION_INFO, commons_components_EntryListView_actions__WEBPACK_IMPORTED_MODULE_14__.LIST_ACTION_EDIT]
    })],
    includeTableView: true,
    listActions: _actions__WEBPACK_IMPORTED_MODULE_19__.listActions,
    listActionsProps: {
      nlsBundles
    }
  }));
};
DataServicesListView.propTypes = {
  listProps: commons_components_ListView__WEBPACK_IMPORTED_MODULE_15__.listPropsPropType
};
const DataServicesView = _ref4 => {
  let {
    listProps
  } = _ref4;
  const [{
    showTableView
  }, dispatch] = (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_15__.useListModel)();
  return showTableView ? /*#__PURE__*/React.createElement(commons_components_TableView__WEBPACK_IMPORTED_MODULE_7__["default"], {
    setTableView: () => dispatch({
      type: commons_components_ListView__WEBPACK_IMPORTED_MODULE_15__.TOGGLE_TABLEVIEW
    }),
    rdfType: commons_util_entry__WEBPACK_IMPORTED_MODULE_12__.RDF_TYPE_DATASERVICE,
    templateId: commons_types_Lookup__WEBPACK_IMPORTED_MODULE_6__["default"].getByName('dataService').complementaryTemplateId(),
    filterScheme: FILTERS,
    nlsBundles: [(catalog_nls_escaServices_nls__WEBPACK_IMPORTED_MODULE_8___default())]
  }) : /*#__PURE__*/React.createElement(DataServicesListView, {
    listProps: listProps
  });
};
DataServicesView.propTypes = {
  listProps: commons_components_ListView__WEBPACK_IMPORTED_MODULE_15__.listPropsPropType
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_15__.withListModelProviderAndLocation)(DataServicesView));

/***/ }),

/***/ "./modules/catalog/dataServices/DataServicesView/actions.js":
/*!******************************************************************!*\
  !*** ./modules/catalog/dataServices/DataServicesView/actions.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   listActions: () => (/* binding */ listActions)
/* harmony export */ });
/* harmony import */ var commons_components_ListView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! commons/components/ListView */ "./modules/commons/components/ListView/index.js");
/* harmony import */ var _dialogs_CreateDataServiceDialog__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dialogs/CreateDataServiceDialog */ "./modules/catalog/dataServices/dialogs/CreateDataServiceDialog/index.js");


const listActions = [{
  id: 'create',
  Dialog: (0,commons_components_ListView__WEBPACK_IMPORTED_MODULE_0__.withListRefresh)(_dialogs_CreateDataServiceDialog__WEBPACK_IMPORTED_MODULE_1__["default"], 'onCreate'),
  labelNlsKey: 'createButtonLabel',
  tooltipNlsKey: 'actionTooltip',
  highlightId: 'listActionCreate'
}];

/***/ }),

/***/ "./modules/catalog/dataServices/DataServicesView/index.js":
/*!****************************************************************!*\
  !*** ./modules/catalog/dataServices/DataServicesView/index.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _DataServicesView__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _DataServicesView__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./DataServicesView */ "./modules/catalog/dataServices/DataServicesView/DataServicesView.js");


/***/ }),

/***/ "./modules/catalog/dataServices/dialogs/CreateDataServiceDialog/CreateDataServiceDialog.js":
/*!*************************************************************************************************!*\
  !*** ./modules/catalog/dataServices/dialogs/CreateDataServiceDialog/CreateDataServiceDialog.js ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! core-js/modules/es.array.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.array.iterator.js");
/* harmony import */ var core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_array_iterator_js__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! core-js/modules/es.object.assign.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.object.assign.js");
/* harmony import */ var core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_object_assign_js__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! core-js/modules/es.promise.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/es.promise.js");
/* harmony import */ var core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_es_promise_js__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! core-js/modules/web.dom-collections.iterator.js */ "./node_modules/.pnpm/core-js@3.45.1/node_modules/core-js/modules/web.dom-collections.iterator.js");
/* harmony import */ var core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(core_js_modules_web_dom_collections_iterator_js__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! prop-types */ "./node_modules/.pnpm/prop-types@15.8.1/node_modules/prop-types/index.js");
/* harmony import */ var prop_types__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(prop_types__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! react */ "./node_modules/.pnpm/react@18.3.1/node_modules/react/index.js");
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_5__);
/* harmony import */ var commons_hooks_useESContext__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! commons/hooks/useESContext */ "./modules/commons/hooks/useESContext.js");
/* harmony import */ var commons_hooks_useAsync__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! commons/hooks/useAsync */ "./modules/commons/hooks/useAsync.js");
/* harmony import */ var commons_util_entry__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! commons/util/entry */ "./modules/commons/util/entry.js");
/* harmony import */ var catalog_dataServices_utils__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! catalog/dataServices/utils */ "./modules/catalog/dataServices/utils.js");
/* harmony import */ var catalog_datasets_DatasetOverview_utils_dataServices__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! catalog/datasets/DatasetOverview/utils/dataServices */ "./modules/catalog/datasets/DatasetOverview/utils/dataServices.js");
/* harmony import */ var commons_components_rdforms_LevelSelector__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! commons/components/rdforms/LevelSelector */ "./modules/commons/components/rdforms/LevelSelector/index.js");
/* harmony import */ var commons_components_dialogs_create_CreateEntryByTemplateDialog__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! commons/components/dialogs/create/CreateEntryByTemplateDialog */ "./modules/commons/components/dialogs/create/CreateEntryByTemplateDialog/index.js");
/* harmony import */ var commons_errors_hooks_useErrorHandler__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! commons/errors/hooks/useErrorHandler */ "./modules/commons/errors/hooks/useErrorHandler.js");
/* harmony import */ var commons_hooks_useTranslation__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! commons/hooks/useTranslation */ "./modules/comm